/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.JavaBreakpointPropertiesAction;
import org.eclipse.jdt.internal.debug.ui.breakpoints.AddExceptionDialog;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class JavaExceptionHyperLink
extends JavaStackTraceHyperlink {
    private String fExceptionName = null;

    public JavaExceptionHyperLink(IConsole console, String exceptionName) {
        super(console);
        this.fExceptionName = exceptionName;
    }

    public void linkActivated() {
        try {
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(JDIDebugModel.getPluginIdentifier());
            int i = 0;
            while (i < breakpoints.length) {
                IJavaExceptionBreakpoint exceptionBreakpoint;
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IJavaExceptionBreakpoint && this.fExceptionName.equals((exceptionBreakpoint = (IJavaExceptionBreakpoint)breakpoint).getTypeName())) {
                    this.showProperties(exceptionBreakpoint);
                    return;
                }
                ++i;
            }
            Object sourceElement = this.getSourceElement(this.fExceptionName);
            if (sourceElement != null) {
                IJavaElement element;
                IWorkspaceRoot res = null;
                IType type = null;
                if (sourceElement instanceof IJavaElement && (res = (element = (IJavaElement)sourceElement).getResource()) == null) {
                    res = element.getJavaProject().getResource();
                }
                if (res == null) {
                    res = ResourcesPlugin.getWorkspace().getRoot();
                }
                if (sourceElement instanceof ICompilationUnit) {
                    type = ((ICompilationUnit)sourceElement).findPrimaryType();
                } else if (sourceElement instanceof IClassFile) {
                    type = ((IClassFile)sourceElement).getType();
                }
                boolean checked = false;
                if (type != null) {
                    checked = AddExceptionDialog.getExceptionType(type) == 0;
                }
                IJavaExceptionBreakpoint breakpoint = JDIDebugModel.createExceptionBreakpoint((IResource)res, (String)this.fExceptionName, (boolean)true, (boolean)true, (boolean)checked, (boolean)true, null);
                this.showProperties(breakpoint);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(ConsoleMessages.getString("JavaStackTraceHyperlink.An_exception_occurred_while_following_link._3"), e);
            return;
        }
    }

    private void showProperties(IJavaExceptionBreakpoint breakpoint) {
        JavaBreakpointPropertiesAction action = new JavaBreakpointPropertiesAction();
        action.selectionChanged(null, (ISelection)new StructuredSelection((Object)breakpoint));
        action.run(null);
    }
}

