/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class JREsUpdater {
    private VMDefinitionsContainer fOriginalVMs = new VMDefinitionsContainer();
    private Shell fShell;

    public JREsUpdater(Shell shell) {
        IVMInstall def = JavaRuntime.getDefaultVMInstall();
        if (def != null) {
            this.fOriginalVMs.setDefaultVMInstallCompositeID(JavaRuntime.getCompositeIdFromVM((IVMInstall)def));
        }
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] vms = types[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                this.fOriginalVMs.addVM(vms[j]);
                ++j;
            }
            ++i;
        }
        this.fShell = shell;
    }

    public boolean updateJRESettings(IVMInstall[] jres, IVMInstall defaultJRE) {
        VMDefinitionsContainer vmContainer = new VMDefinitionsContainer();
        String defaultVMId = JavaRuntime.getCompositeIdFromVM((IVMInstall)defaultJRE);
        vmContainer.setDefaultVMInstallCompositeID(defaultVMId);
        int i = 0;
        while (i < jres.length) {
            vmContainer.addVM(jres[i]);
            ++i;
        }
        this.saveVMDefinitions(vmContainer);
        return true;
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    private void saveVMDefinitions(final VMDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(JREMessages.getString("JREsUpdater.0"), 100);
                        String vmDefXML = container.getAsXML();
                        monitor.worked(40);
                        JavaRuntime.getPreferences().setValue(JavaRuntime.PREF_VM_XML, vmDefXML);
                        monitor.worked(30);
                        JavaRuntime.savePreferences();
                        monitor.worked(30);
                    }
                    catch (IOException ioe) {
                        JDIDebugUIPlugin.log(ioe);
                    }
                    catch (ParserConfigurationException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                    catch (TransformerException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_8 = null;
                }
                monitor.done();
            }
        };
        try {
            JDIDebugUIPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
        }
    }

    private Shell getShell() {
        if (this.fShell == null) {
            return JDIDebugUIPlugin.getActiveWorkbenchShell();
        }
        return this.fShell;
    }
}

