/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIImageDescriptor;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.monitors.DeadLocksViewContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorMessages;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorsViewContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.ThreadsViewContentProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class MonitorModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    protected ImageDescriptorRegistry fDebugImageRegistry = JDIDebugUIPlugin.getImageDescriptorRegistry();

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public String getText(Object item) {
        if (item instanceof DeadLocksViewContentProvider.ContentThreadWrapper) {
            return this.getThreadDeadLockText((DeadLocksViewContentProvider.ContentThreadWrapper)item);
        }
        if (item instanceof DeadLocksViewContentProvider.ContentMonitorWrapper) {
            StringBuffer res = new StringBuffer();
            res.append(((DeadLocksViewContentProvider.ContentMonitorWrapper)item).fMonitor.toString());
            res.append(MonitorMessages.getString("MonitorModelPresentation._owned_by..._1"));
            return res.toString();
        }
        if (item instanceof IJavaObject) {
            return this.getMonitorText((IJavaObject)item);
        }
        if (item instanceof IJavaThread) {
            return this.getThreadText((IJavaThread)item);
        }
        if (item instanceof ThreadsViewContentProvider.MonitorWrapper) {
            return this.getMonitorWrapperText((ThreadsViewContentProvider.MonitorWrapper)item);
        }
        if (item instanceof MonitorsViewContentProvider.ThreadWrapper) {
            return this.getThreadWrapperMonitorText((MonitorsViewContentProvider.ThreadWrapper)item);
        }
        if (item instanceof ThreadsViewContentProvider.ThreadWrapper) {
            return this.getThreadWrapperThreadText((ThreadsViewContentProvider.ThreadWrapper)item);
        }
        return MonitorMessages.getString("MonitorModelPresentation.unsuported_type_1");
    }

    protected String getThreadDeadLockText(DeadLocksViewContentProvider.ContentThreadWrapper thread) {
        StringBuffer res = new StringBuffer();
        try {
            res.append(thread.fThread.getName());
        }
        catch (DebugException debugException) {}
        if (thread.caughtInADeadLock) {
            res.append(MonitorMessages.getString("MonitorModelPresentation._(caught_in_the_deadlock)_2"));
        } else {
            res.append(MonitorMessages.getString("MonitorModelPresentation._waiting_for..._2"));
        }
        return res.toString();
    }

    protected String getMonitorText(IJavaObject monitor) {
        return monitor.toString();
    }

    protected String getMonitorWrapperText(ThreadsViewContentProvider.MonitorWrapper monitor) {
        StringBuffer res = new StringBuffer(monitor.monitor.toString());
        if (monitor.state == 1) {
            res.append(MonitorMessages.getString("MonitorModelPresentation._(owned)_4"));
        } else if (monitor.state == 2) {
            res.append(MonitorMessages.getString("MonitorModelPresentation._(contended)_5"));
        }
        return res.toString();
    }

    protected String getThreadWrapperThreadText(ThreadsViewContentProvider.ThreadWrapper thread) {
        StringBuffer res = new StringBuffer();
        try {
            res.append(thread.thread.getName());
        }
        catch (DebugException debugException) {}
        if (thread.isCaughtInDeadlock) {
            res.append(MonitorMessages.getString("MonitorModelPresentation._(caught_in_a_deadlock)_6"));
        }
        return res.toString();
    }

    protected String getThreadWrapperMonitorText(MonitorsViewContentProvider.ThreadWrapper thread) {
        StringBuffer res = new StringBuffer();
        try {
            res.append(thread.thread.getName());
        }
        catch (DebugException debugException) {}
        if (thread.state == 1) {
            res.append(MonitorMessages.getString("MonitorModelPresentation._(owning)_7"));
        } else if (thread.state == 2) {
            res.append(MonitorMessages.getString("MonitorModelPresentation._(contending)_8"));
        }
        return res.toString();
    }

    protected String getThreadText(IJavaThread thread) {
        StringBuffer res = new StringBuffer();
        try {
            res.append(thread.getName());
        }
        catch (DebugException debugException) {}
        return res.toString();
    }

    public Image getImage(Object item) {
        if (item instanceof ThreadsViewContentProvider.ThreadWrapper) {
            return this.getThreadWrapperThreadImage(((ThreadsViewContentProvider.ThreadWrapper)item).thread);
        }
        if (item instanceof ThreadsViewContentProvider.MonitorWrapper) {
            ThreadsViewContentProvider.MonitorWrapper monitorWrapper = (ThreadsViewContentProvider.MonitorWrapper)item;
            JDIImageDescriptor descriptor = null;
            int flags = this.computeMonitorAdornmentFlags(monitorWrapper);
            descriptor = new JDIImageDescriptor(JavaDebugImages.DESC_OBJ_MONITOR, flags);
            return this.fDebugImageRegistry.get((ImageDescriptor)descriptor);
        }
        if (item instanceof MonitorsViewContentProvider.ThreadWrapper) {
            MonitorsViewContentProvider.ThreadWrapper threadWrapper = (MonitorsViewContentProvider.ThreadWrapper)item;
            JDIImageDescriptor descriptor = null;
            int flags = this.computeThreadAdornmentFlags(threadWrapper);
            descriptor = threadWrapper.thread.isSuspended() ? new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED"), flags) : new JDIImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING"), flags);
            return this.fDebugImageRegistry.get((ImageDescriptor)descriptor);
        }
        if (item instanceof IJavaObject) {
            return this.getMonitorImage();
        }
        if (item instanceof DeadLocksViewContentProvider.ContentMonitorWrapper) {
            return this.getMonitorImage();
        }
        if (item instanceof DeadLocksViewContentProvider.ContentThreadWrapper) {
            return this.getThreadWrapperThreadImage(((DeadLocksViewContentProvider.ContentThreadWrapper)item).fThread);
        }
        return null;
    }

    private Image getThreadWrapperThreadImage(IJavaThread thread) {
        ImageDescriptor descriptor = null;
        descriptor = thread.isSuspended() ? DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_SUSPENDED") : DebugUITools.getImageDescriptor((String)"IMG_OBJS_THREAD_RUNNING");
        return this.fDebugImageRegistry.get(descriptor);
    }

    private Image getMonitorImage() {
        return this.fDebugImageRegistry.get(JavaDebugImages.DESC_OBJ_MONITOR);
    }

    public IEditorInput getEditorInput(Object item) {
        return null;
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        return null;
    }

    public void setAttribute(String id, Object value) {
    }

    private int computeMonitorAdornmentFlags(ThreadsViewContentProvider.MonitorWrapper wrapper) {
        int flags = 0;
        if (wrapper.state == 2) {
            flags |= 0x1000;
        }
        if (wrapper.state == 1) {
            flags |= 0x800;
        }
        return flags;
    }

    private int computeThreadAdornmentFlags(MonitorsViewContentProvider.ThreadWrapper wrapper) {
        int flags = 0;
        if (wrapper.state == 2) {
            flags |= 0x2000;
        }
        if (wrapper.state == 1) {
            flags |= 0x400;
        }
        return flags;
    }
}

