/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class MonitorsViewContentProvider
implements ITreeContentProvider {
    protected TreeViewer fViewer = null;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IJavaObject) {
            IJavaObject monitor = (IJavaObject)parentElement;
            IJavaThread owningThread = MonitorManager.getDefault().getOwningThread(monitor);
            List contendingThreads = MonitorManager.getDefault().getContendingThreads(monitor);
            if (owningThread == null && contendingThreads == null) {
                return null;
            }
            int size = 0;
            if (contendingThreads != null) {
                size = contendingThreads.size();
            }
            if (owningThread != null) {
                ++size;
            }
            Object[] children = new Object[size];
            if (contendingThreads != null) {
                ArrayList<ThreadWrapper> wrappedThreads = new ArrayList<ThreadWrapper>();
                int i = 0;
                while (i < contendingThreads.size()) {
                    ThreadWrapper tw = new ThreadWrapper();
                    tw.thread = (IJavaThread)contendingThreads.get(i);
                    tw.state = 2;
                    wrappedThreads.add(tw);
                    ++i;
                }
                wrappedThreads.toArray(children);
                wrappedThreads.toArray(children);
            }
            if (owningThread != null) {
                ThreadWrapper tw = new ThreadWrapper();
                tw.thread = owningThread;
                tw.state = 1;
                children[children.length - 1] = tw;
            }
            return children;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IJavaThread) {
            return MonitorManager.getDefault().getOwnedMonitors((IJavaThread)element);
        }
        if (element instanceof IJavaObject) {
            return MonitorManager.getDefault().getOwningThread((IJavaObject)element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IJavaObject) {
            IJavaObject monitor = (IJavaObject)element;
            IJavaThread owningThread = MonitorManager.getDefault().getOwningThread(monitor);
            List contendingThreads = MonitorManager.getDefault().getContendingThreads(monitor);
            return owningThread != null || contendingThreads != null;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return MonitorManager.getDefault().getMonitors();
    }

    public void dispose() {
        this.fViewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    public class ThreadWrapper {
        public static final int OWNING_THREAD = 1;
        public static final int IN_CONTENTION_FOR_MONITOR = 2;
        public IJavaThread thread;
        public int state;
    }
}

