/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.VersionedIdentifier;
import org.osgi.framework.BundleException;

public class BundleManifest
implements IConfigurationConstants {
    private File manifestFile;
    private PluginEntry pluginEntry;
    private IOException exception;
    private String bundleURL;

    /*
     * Exception decompiling
     */
    public BundleManifest(File manifest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 69->73)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BundleManifest(InputStream input, String bundleUrl) {
        this.bundleURL = bundleUrl;
        if (input != null) {
            this.parse(input);
        }
    }

    private void parse(InputStream in) {
        try {
            String id;
            Manifest m = new Manifest(in);
            Attributes a = m.getMainAttributes();
            String symbolicName = a.getValue("Bundle-SymbolicName");
            if (symbolicName == null) {
                return;
            }
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName);
                id = elements[0].getValue();
            }
            catch (BundleException be) {
                throw new IOException(be.getMessage());
            }
            String version = a.getValue("Bundle-Version");
            if (version == null) {
                Utils.log(Messages.getString("BundleManifest.noVersion", "Bundle-Version", id));
                return;
            }
            String hostPlugin = a.getValue("Fragment-Host");
            this.pluginEntry = new PluginEntry();
            this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(id, version));
            this.pluginEntry.isFragment(hostPlugin != null && hostPlugin.length() > 0);
            if (this.bundleURL != null) {
                this.pluginEntry.setURL(this.bundleURL);
            } else {
                File pluginDir = this.manifestFile.getParentFile();
                if (pluginDir != null) {
                    pluginDir = pluginDir.getParentFile();
                }
                if (pluginDir != null) {
                    this.pluginEntry.setURL("plugins/" + pluginDir.getName() + "/");
                }
            }
        }
        catch (IOException ioe) {
            this.exception = ioe;
        }
    }

    public boolean exists() {
        return this.exception != null || this.pluginEntry != null;
    }

    public PluginEntry getPluginEntry() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.pluginEntry;
    }
}

