/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DialogSettingsHelper;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.PixelConverter;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.CreateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeleteLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DuplicateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationView;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectivesTab;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class LaunchConfigurationsDialog
extends TitleAreaDialog
implements ILaunchConfigurationDialog {
    private static ILaunchConfigurationDialog fgCurrentlyVisibleLaunchConfigurationDialog;
    private Label fTreeLabel;
    private SashForm fSashForm;
    private static final int[] DEFAULT_SASH_WEIGHTS;
    private Composite fSelectionArea;
    private LaunchConfigurationView fLaunchConfigurationView;
    private LaunchConfigurationTabGroupViewer fTabViewer;
    private Composite fEditArea;
    private ButtonAction fButtonActionNew;
    private ButtonAction fButtonActionDelete;
    private Button fProgressMonitorCancelButton;
    private IStructuredSelection fInitialSelection;
    private IStatus fInitialStatus;
    private ProgressMonitorPart fProgressMonitorPart;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private long fActiveRunningOperations = 0L;
    private LaunchGroupExtension fGroup;
    private Image fBannerImage;
    private IAction fDoubleClickAction;
    protected static final int ID_LAUNCH_BUTTON = 1025;
    protected static final int ID_CLOSE_BUTTON = 1026;
    protected static final int ID_CANCEL_BUTTON = 1027;
    private static final String FOCUS_CONTROL = "focusControl";
    protected static final float MAX_DIALOG_WIDTH_PERCENT = 0.5f;
    protected static final float MAX_DIALOG_HEIGHT_PERCENT = 0.5f;
    protected static final Object[] EMPTY_ARRAY;
    protected static final Point DEFAULT_INITIAL_DIALOG_SIZE;
    public static final int LAUNCH_CONFIGURATION_DIALOG_OPEN_ON_LAST_LAUNCHED = 2;
    public static final int LAUNCH_CONFIGURATION_DIALOG_OPEN_ON_SELECTION = 3;
    public static final int LAUNCH_CONFIGURATION_DIALOG_REUSE_OPEN = 4;
    private int fOpenMode = 2;

    static {
        DEFAULT_SASH_WEIGHTS = new int[]{11, 30};
        EMPTY_ARRAY = new Object[0];
        DEFAULT_INITIAL_DIALOG_SIZE = new Point(620, 560);
    }

    public LaunchConfigurationsDialog(Shell shell, LaunchGroupExtension group) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setLaunchGroup(group);
    }

    public void setOpenMode(int mode) {
        this.fOpenMode = mode;
    }

    protected int getOpenMode() {
        return this.fOpenMode;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, this.getLaunchButtonText(), true);
        this.createButton(parent, 1026, LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Close_1"), false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.handleLaunchPressed();
        } else if (buttonId == 1026) {
            this.handleClosePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected String getLaunchButtonText() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.getMode()).getLabel();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeContent();
        return contents;
    }

    protected void initializeContent() {
        this.doInitialTreeSelection();
        IStatus status = this.getInitialStatus();
        if (status != null) {
            this.handleStatus(status);
        }
    }

    private void initializeSashForm() {
        if (this.getSashForm() != null) {
            int[] sashWeights;
            IDialogSettings settings = this.getDialogSettings();
            try {
                int w1 = settings.getInt(IDebugPreferenceConstants.DIALOG_SASH_WEIGHTS_1);
                int w2 = settings.getInt(IDebugPreferenceConstants.DIALOG_SASH_WEIGHTS_2);
                sashWeights = new int[]{w1, w2};
            }
            catch (NumberFormatException numberFormatException) {
                sashWeights = DEFAULT_SASH_WEIGHTS;
            }
            this.getSashForm().setWeights(sashWeights);
        }
    }

    private void ensureSelectionAreaWidth() {
        if (this.fLaunchConfigurationView != null) {
            Button newButton = this.getButtonActionNew().getButton();
            Button deleteButton = this.getButtonActionDelete().getButton();
            int requiredWidth = newButton.getBounds().width + deleteButton.getBounds().width;
            int marginWidth = ((GridLayout)this.getSelectionArea().getLayout()).marginWidth;
            int horizontalSpacing = ((GridLayout)this.getSelectionArea().getLayout()).horizontalSpacing;
            int currentWidth = this.getSelectionArea().getBounds().width;
            if ((requiredWidth += 2 * marginWidth + horizontalSpacing) > currentWidth) {
                int[] newSashWeights = new int[]{requiredWidth, this.getEditArea().getBounds().width};
                Shell shell = this.getShell();
                Point shellSize = shell.getSize();
                this.setShellSize(shellSize.x + (requiredWidth - currentWidth), shellSize.y);
                this.getSashForm().setWeights(newSashWeights);
            }
        }
    }

    public void doInitialTreeSelection() {
        this.fLaunchConfigurationView.getViewer().setSelection((ISelection)this.getInitialSelection());
    }

    protected void persistShellGeometry() {
        DialogSettingsHelper.persistShellGeometry(this.getShell(), this.getDialogSettingsSectionName());
    }

    protected void persistSashWeights() {
        IDialogSettings settings = this.getDialogSettings();
        SashForm sashForm = this.getSashForm();
        if (sashForm != null) {
            int[] sashWeights = this.getSashForm().getWeights();
            settings.put(IDebugPreferenceConstants.DIALOG_SASH_WEIGHTS_1, sashWeights[0]);
            settings.put(IDebugPreferenceConstants.DIALOG_SASH_WEIGHTS_2, sashWeights[1]);
        }
    }

    public boolean close() {
        this.persistShellGeometry();
        this.persistSashWeights();
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(null);
        this.getBannerImage().dispose();
        this.getTabViewer().dispose();
        if (this.fLaunchConfigurationView != null) {
            this.fLaunchConfigurationView.dispose();
        }
        return super.close();
    }

    public int open() {
        ILaunchConfiguration lastLaunchedConfig;
        int mode = this.getOpenMode();
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(this);
        if (mode == 2 && (lastLaunchedConfig = this.getLastLaunchedWorkbenchConfiguration()) != null) {
            this.setInitialSelection((IStructuredSelection)new StructuredSelection((Object)lastLaunchedConfig));
        }
        return super.open();
    }

    protected ILaunchConfiguration getLastLaunchedWorkbenchConfiguration() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch(this.getLaunchGroup().getIdentifier());
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComp = (Composite)super.createDialogArea(parent);
        this.addContent(dialogComp);
        return dialogComp;
    }

    protected void addContent(Composite dialogComp) {
        Composite topComp = new Composite(dialogComp, 0);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 5;
        topLayout.marginWidth = 0;
        topComp.setLayout((Layout)topLayout);
        this.setTitle(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Create,_manage,_and_run_launch_configurations_8"));
        this.setMessage(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Ready_to_launch_2"));
        this.setModeLabelState();
        this.setSashForm(new SashForm(topComp, 0));
        this.getSashForm().setOrientation(256);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.getSashForm().setLayoutData((Object)gd);
        this.getSashForm().setFont(dialogComp.getFont());
        Control launchConfigSelectionArea = this.createLaunchConfigurationSelectionArea((Composite)this.getSashForm());
        gd = new GridData(1040);
        launchConfigSelectionArea.setLayoutData((Object)gd);
        Composite editAreaComp = this.createLaunchConfigurationEditArea((Composite)this.getSashForm());
        this.setEditArea(editAreaComp);
        gd = new GridData(1808);
        editAreaComp.setLayoutData((Object)gd);
        Label separator = new Label(topComp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        dialogComp.layout(true);
        Dialog.applyDialogFont((Control)dialogComp);
    }

    protected void setModeLabelState() {
        this.setTitleImage(this.getBannerImage());
    }

    protected void refreshStatus() {
        this.updateMessage();
        this.updateButtons();
    }

    protected Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return Display.getDefault();
    }

    protected Control createLaunchConfigurationSelectionArea(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setSelectionArea(comp);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        this.setTreeLabel(new Label(comp, 0));
        this.getTreeLabel().setFont(font);
        this.getTreeLabel().setText(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Launch_Con&figurations__1"));
        this.fLaunchConfigurationView = new LaunchConfigurationView(this.getLaunchGroup());
        this.fLaunchConfigurationView.createLaunchDialogControl(comp);
        Viewer viewer = this.fLaunchConfigurationView.getViewer();
        Control control = viewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        control.setFont(font);
        this.fDoubleClickAction = new DoubleClickAction();
        this.fLaunchConfigurationView.setAction("Double_Click_ActionId", this.fDoubleClickAction);
        Composite buttonComposite = new Composite(comp, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        gd = new GridData(768);
        buttonComposite.setLayoutData((Object)gd);
        buttonComposite.setFont(comp.getFont());
        final Button newButton = SWTUtil.createPushButton(buttonComposite, LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Ne&w_13"), null);
        this.setButtonActionNew(new ButtonActionNew(newButton.getText(), newButton));
        final Button deleteButton = SWTUtil.createPushButton(buttonComposite, LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Dele&te_14"), null);
        gd = (GridData)deleteButton.getLayoutData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        this.setButtonActionDelete(new ButtonActionDelete(deleteButton.getText(), deleteButton));
        AbstractLaunchConfigurationAction.IConfirmationRequestor requestor = new AbstractLaunchConfigurationAction.IConfirmationRequestor(){

            public boolean getConfirmation() {
                return LaunchConfigurationsDialog.this.canDiscardCurrentConfig();
            }
        };
        this.getDuplicateAction().setConfirmationRequestor(requestor);
        this.getNewAction().setConfirmationRequestor(requestor);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchConfigurationsDialog.this.handleLaunchConfigurationSelectionChanged(event);
                newButton.setEnabled(LaunchConfigurationsDialog.this.getNewAction().isEnabled());
                deleteButton.setEnabled(LaunchConfigurationsDialog.this.getDeleteAction().isEnabled());
            }
        });
        return comp;
    }

    protected Composite createLaunchConfigurationEditArea(Composite parent) {
        this.setTabViewer(new LaunchConfigurationTabGroupViewer(parent, this));
        this.getTabViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchConfigurationsDialog.this.handleTabSelectionChanged();
            }
        });
        return (Composite)this.getTabViewer().getControl();
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        Composite monitorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        monitorComposite.setLayout((Layout)layout);
        monitorComposite.setLayoutData((Object)new GridData(768));
        GridLayout pmLayout = new GridLayout();
        this.setProgressMonitorPart(new ProgressMonitorPart(monitorComposite, (Layout)pmLayout));
        Button cancelButton = this.createButton(monitorComposite, 1027, LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Cancel_3"), true);
        this.setProgressMonitorCancelButton(cancelButton);
        this.getProgressMonitorCancelButton().setFont(font);
        this.getProgressMonitorPart().setLayoutData((Object)new GridData(768));
        this.getProgressMonitorPart().setFont(font);
        monitorComposite.setVisible(false);
        return super.createButtonBar(composite);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        WorkbenchHelp.setHelp((Control)shell, (String)this.getHelpContextId());
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG;
    }

    protected String getShellTitle() {
        String title = DebugUIPlugin.removeAccelerators(this.getLaunchGroup().getLabel());
        if (title == null) {
            title = LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Launch_Configurations_18");
        }
        return title;
    }

    protected Point getInitialLocation(Point initialSize) {
        IDialogSettings settings = this.getDialogSettings();
        try {
            int x = settings.getInt(IDebugPreferenceConstants.DIALOG_ORIGIN_X);
            int y = settings.getInt(IDebugPreferenceConstants.DIALOG_ORIGIN_Y);
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogSettings();
        try {
            int x = settings.getInt(IDebugPreferenceConstants.DIALOG_WIDTH);
            int y = settings.getInt(IDebugPreferenceConstants.DIALOG_HEIGHT);
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_INITIAL_DIALOG_SIZE;
        }
    }

    private void setSashForm(SashForm sashForm) {
        this.fSashForm = sashForm;
    }

    private SashForm getSashForm() {
        return this.fSashForm;
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private boolean isVisible() {
        return this.getShell() != null && this.getShell().isVisible();
    }

    protected void handleLaunchConfigurationSelectionChanged(SelectionChangedEvent event) {
        ILaunchConfiguration original;
        IStructuredSelection structuredSelection;
        Object input = this.getTabViewer().getInput();
        Object newInput = null;
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            newInput = structuredSelection.getFirstElement();
        }
        if ((original = this.getTabViewer().getOriginal()) != null && newInput == null && this.getLaunchManager().getMovedTo(original) != null) {
            return;
        }
        if (!this.isEqual(input, newInput)) {
            ILaunchConfigurationTabGroup newGroup;
            ILaunchConfigurationTabGroup group = this.getTabGroup();
            if (original != null) {
                boolean canReplace;
                boolean deleted = !original.exists();
                boolean renamed = false;
                if (newInput instanceof ILaunchConfiguration) {
                    ILaunchConfiguration lc = (ILaunchConfiguration)newInput;
                    boolean bl = renamed = this.getLaunchManager().getMovedFrom(lc) != null;
                }
                if (this.getTabViewer().isDirty() && !deleted && !renamed && !(canReplace = this.showUnsavedChangesDialog())) {
                    StructuredSelection sel = new StructuredSelection(input);
                    this.fLaunchConfigurationView.getViewer().setSelection((ISelection)sel);
                    return;
                }
            }
            this.getTabViewer().setInput(newInput);
            if (this.getTabViewer().isDirty()) {
                this.getTabViewer().handleApplyPressed();
            }
            if (!this.isEqual(group, newGroup = this.getTabGroup()) && this.isVisible()) {
                this.resize();
            }
        }
    }

    protected boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected void resize() {
        PixelConverter pixelConverter = new PixelConverter((Control)this.getEditArea());
        int runningTabWidth = 0;
        ILaunchConfigurationTabGroup group = this.getTabGroup();
        if (group == null) {
            return;
        }
        ILaunchConfigurationTab[] tabs = group.getTabs();
        Point contentSize = new Point(0, 0);
        int i = 0;
        while (i < tabs.length) {
            Control control;
            String name = tabs[i].getName();
            Image image = tabs[i].getImage();
            runningTabWidth += pixelConverter.convertWidthInCharsToPixels(name.length() + 5);
            if (image != null) {
                runningTabWidth += image.getBounds().width;
            }
            if ((control = tabs[i].getControl()) != null) {
                Point size = control.computeSize(-1, -1, true);
                if (size.x > contentSize.x) {
                    contentSize.x = size.x;
                }
                if (size.y > contentSize.y) {
                    contentSize.y = size.y;
                }
            }
            ++i;
        }
        if (runningTabWidth > contentSize.x) {
            int otherWidth = this.getSashForm().SASH_WIDTH + this.getSelectionArea().getBounds().width;
            int totalWidth = runningTabWidth + otherWidth;
            int maxAllowedWidth = (int)((float)this.getDisplay().getBounds().width * 0.5f);
            contentSize.x = totalWidth > maxAllowedWidth ? maxAllowedWidth - otherWidth : runningTabWidth;
        }
        int maxAllowedHeight = (int)((float)this.getDisplay().getBounds().height * 0.5f);
        contentSize.y = Math.min(contentSize.y, maxAllowedHeight);
        Rectangle tabFolderBoundingBox = this.getEditArea().computeTrim(0, 0, contentSize.x, contentSize.y);
        contentSize.x = tabFolderBoundingBox.width;
        contentSize.y = tabFolderBoundingBox.height;
        this.getEditArea().layout(true);
        Rectangle rect = this.getTabViewer().getTabFolder().getClientArea();
        Point containerSize = new Point(rect.width, rect.height);
        int hdiff = contentSize.x - containerSize.x;
        int vdiff = contentSize.y - containerSize.y;
        if (hdiff > 0 || vdiff > 0) {
            int[] newSashWeights = null;
            if (hdiff > 0) {
                newSashWeights = this.calculateNewSashWeights(hdiff);
            }
            hdiff = Math.max(0, hdiff);
            vdiff = Math.max(0, vdiff);
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + hdiff, shellSize.y + vdiff);
            if (newSashWeights != null) {
                this.getSashForm().setWeights(newSashWeights);
            }
        }
    }

    protected void handleTabSelectionChanged() {
        this.updateMessage();
    }

    private void setProgressMonitorPart(ProgressMonitorPart part) {
        this.fProgressMonitorPart = part;
    }

    private ProgressMonitorPart getProgressMonitorPart() {
        return this.fProgressMonitorPart;
    }

    private void setProgressMonitorCancelButton(Button button) {
        this.fProgressMonitorCancelButton = button;
    }

    private Button getProgressMonitorCancelButton() {
        return this.fProgressMonitorCancelButton;
    }

    private int[] calculateNewSashWeights(int widthIncrease) {
        int[] newWeights = new int[]{this.getSelectionArea().getBounds().width, this.getEditArea().getBounds().width + widthIncrease};
        return newWeights;
    }

    protected void setShellSize(int width, int height) {
        Rectangle bounds = this.getShell().getDisplay().getBounds();
        this.getShell().setSize(Math.min(width, bounds.width), Math.min(height, bounds.height));
    }

    public String getMode() {
        return this.getLaunchGroup().getMode();
    }

    public ILaunchConfigurationTabGroup getTabGroup() {
        if (this.getTabViewer() != null) {
            return this.getTabViewer().getTabGroup();
        }
        return null;
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.getTabGroup() == null) {
            return null;
        }
        return this.getTabGroup().getTabs();
    }

    private boolean canDiscardCurrentConfig() {
        if (this.getTabViewer().isDirty()) {
            return this.showUnsavedChangesDialog();
        }
        return true;
    }

    private boolean showUnsavedChangesDialog() {
        if (this.getTabViewer().canSave()) {
            return this.showSaveChangesDialog();
        }
        return this.showDiscardChangesDialog();
    }

    private boolean showSaveChangesDialog() {
        MessageDialog dialog;
        int selectedButton;
        String message = null;
        if (this.getActiveTab() instanceof PerspectivesTab) {
            try {
                message = MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationsDialog.45"), this.getTabViewer().getWorkingCopy().getType().getName());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        } else {
            message = MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.The_configuration___29"), this.getTabViewer().getWorkingCopy().getName());
        }
        if ((selectedButton = (dialog = new MessageDialog(this.getShell(), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Save_changes__31"), null, message, 3, new String[]{LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Yes_32"), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.No_33"), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Cancel_34")}, 0)).open()) < 0 || selectedButton == 2) {
            return false;
        }
        if (selectedButton == 0) {
            if (this.fLaunchConfigurationView != null) {
                this.fLaunchConfigurationView.setAutoSelect(false);
            }
            this.getTabViewer().handleApplyPressed();
            if (this.fLaunchConfigurationView != null) {
                this.fLaunchConfigurationView.setAutoSelect(true);
            }
        }
        return true;
    }

    private boolean showDiscardChangesDialog() {
        StringBuffer buffer = new StringBuffer(MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.The_configuration___35"), this.getTabViewer().getWorkingCopy().getName()));
        buffer.append(this.getTabViewer().getErrorMesssage());
        buffer.append(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Do_you_wish_to_discard_changes_37"));
        MessageDialog dialog = new MessageDialog(this.getShell(), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Discard_changes__38"), null, buffer.toString(), 3, new String[]{LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Yes_32"), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.No_33")}, 1);
        int selectedButton = dialog.open();
        return selectedButton == 0;
    }

    protected void handleClosePressed() {
        if (this.canDiscardCurrentConfig()) {
            this.cancelPressed();
        }
    }

    protected void handleLaunchPressed() {
        ILaunchConfiguration config = this.getTabViewer().getOriginal();
        if (this.getTabViewer().isDirty()) {
            this.getTabViewer().handleApplyPressed();
            config = this.getTabViewer().getOriginal();
        }
        String mode = this.getMode();
        this.close();
        DebugUITools.launch(config, mode);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (!this.isVisible()) {
            PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
            return;
        }
        Object state = this.aboutToStart();
        ++this.fActiveRunningOperations;
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            --this.fActiveRunningOperations;
            this.stopped(state);
            throw throwable;
        }
        {
            Object var5_7 = null;
            --this.fActiveRunningOperations;
            this.stopped(state);
            return;
        }
    }

    private Object aboutToStart() {
        Map savedState = null;
        if (this.getShell() != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(this.waitCursor);
            this.arrowCursor = new Cursor((Device)d, 0);
            this.getProgressMonitorCancelButton().setCursor(this.arrowCursor);
            savedState = this.saveUIState();
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
            this.getProgressMonitorCancelButton().setEnabled(true);
            this.getProgressMonitorPart().attachToCancelComponent((Control)this.getProgressMonitorCancelButton());
            this.getProgressMonitorPart().getParent().setVisible(true);
            this.getProgressMonitorCancelButton().setFocus();
        }
        return savedState;
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null) {
            this.getProgressMonitorPart().getParent().setVisible(false);
            this.getProgressMonitorPart().removeFromCancelComponent((Control)this.getProgressMonitorCancelButton());
            Map state = (Map)savedState;
            this.restoreUIState(state);
            this.setDisplayCursor(null);
            this.waitCursor.dispose();
            this.waitCursor = null;
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }

    private Map saveUIState() {
        HashMap<String, ControlEnableState> savedState = new HashMap<String, ControlEnableState>(4);
        this.saveEnableStateAndSet((Control)this.getButton(1025), savedState, "launch", false);
        this.saveEnableStateAndSet((Control)this.getButton(1026), savedState, "close", false);
        if (this.getSelectionArea() != null) {
            savedState.put("selectionarea", ControlEnableState.disable((Control)this.getSelectionArea()));
        }
        savedState.put("editarea", ControlEnableState.disable((Control)this.getEditArea()));
        return savedState;
    }

    private void saveEnableStateAndSet(Control w, Map h, String key, boolean enabled) {
        if (w != null) {
            h.put(key, new Boolean(w.isEnabled()));
            w.setEnabled(enabled);
        }
    }

    private void restoreUIState(Map state) {
        this.restoreEnableState((Control)this.getButton(1025), state, "launch");
        this.restoreEnableState((Control)this.getButton(1026), state, "close");
        ControlEnableState treeState = (ControlEnableState)state.get("selectionarea");
        if (treeState != null) {
            treeState.restore();
        }
        ControlEnableState tabState = (ControlEnableState)state.get("editarea");
        tabState.restore();
    }

    private void restoreEnableState(Control w, Map h, String key) {
        Boolean b;
        if (w != null && (b = (Boolean)h.get(key)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    private void setDisplayCursor(Cursor cursor) {
        Shell[] shells = this.getShell().getDisplay().getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(cursor);
            ++i;
        }
    }

    private boolean canLaunch() {
        return this.getTabViewer().canLaunch();
    }

    public void updateButtons() {
        this.getButtonActionNew().setEnabled(this.getNewAction().isEnabled());
        this.getButtonActionDelete().setEnabled(this.getDeleteAction().isEnabled());
        this.getTabViewer().refresh();
        this.getButton(1025).setEnabled(this.canLaunch());
    }

    public ILaunchConfigurationTab getActiveTab() {
        return this.getTabViewer().getActiveTab();
    }

    public void updateMessage() {
        this.setErrorMessage(this.getTabViewer().getErrorMesssage());
        this.setMessage(this.getTabViewer().getMessage());
    }

    private Composite getSelectionArea() {
        return this.fSelectionArea;
    }

    private void setSelectionArea(Composite selectionArea) {
        this.fSelectionArea = selectionArea;
    }

    protected Composite getEditArea() {
        return this.fEditArea;
    }

    protected void setEditArea(Composite editArea) {
        this.fEditArea = editArea;
    }

    public void setName(String name) {
        this.getTabViewer().setName(name);
    }

    public String generateName(String name) {
        if (name == null) {
            name = "";
        }
        return this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name);
    }

    private IStructuredSelection getInitialSelection() {
        return this.fInitialSelection;
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.fInitialSelection = selection;
    }

    protected void handleTreeViewerKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.getButtonActionDelete().isEnabled()) {
            this.getButtonActionDelete().run();
        }
    }

    private void setButtonActionNew(ButtonAction action) {
        this.fButtonActionNew = action;
    }

    private ButtonAction getButtonActionNew() {
        return this.fButtonActionNew;
    }

    private void setButtonActionDelete(ButtonAction action) {
        this.fButtonActionDelete = action;
    }

    private ButtonAction getButtonActionDelete() {
        return this.fButtonActionDelete;
    }

    private void setTreeLabel(Label treeLabel) {
        this.fTreeLabel = treeLabel;
    }

    private Label getTreeLabel() {
        return this.fTreeLabel;
    }

    public static void setCurrentlyVisibleLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        fgCurrentlyVisibleLaunchConfigurationDialog = dialog;
    }

    public static ILaunchConfigurationDialog getCurrentlyVisibleLaunchConfigurationDialog() {
        return fgCurrentlyVisibleLaunchConfigurationDialog;
    }

    protected Image getBannerImage() {
        ImageDescriptor descriptor;
        if (this.fBannerImage == null && (descriptor = this.getLaunchGroup().getBannerImageDescriptor()) != null) {
            this.fBannerImage = descriptor.createImage();
        }
        return this.fBannerImage;
    }

    protected void setLaunchGroup(LaunchGroupExtension group) {
        this.fGroup = group;
    }

    public LaunchGroupExtension getLaunchGroup() {
        return this.fGroup;
    }

    protected AbstractLaunchConfigurationAction getNewAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(CreateLaunchConfigurationAction.ID_CREATE_ACTION);
    }

    protected AbstractLaunchConfigurationAction getDeleteAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(DeleteLaunchConfigurationAction.ID_DELETE_ACTION);
    }

    protected AbstractLaunchConfigurationAction getDuplicateAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(DuplicateLaunchConfigurationAction.ID_DUPLICATE_ACTION);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected String getDialogSettingsSectionName() {
        return String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".LAUNCH_CONFIGURATIONS_DIALOG_SECTION";
    }

    protected void setTabViewer(LaunchConfigurationTabGroupViewer viewer) {
        this.fTabViewer = viewer;
    }

    protected LaunchConfigurationTabGroupViewer getTabViewer() {
        return this.fTabViewer;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.initializeSashForm();
        this.ensureSelectionAreaWidth();
        this.resize();
    }

    public void create() {
        super.create();
        if (this.getTabViewer().getInput() == null) {
            this.getTabViewer().inputChanged(null);
        }
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
        this.getTabViewer().setActiveTab(tab);
    }

    public void setActiveTab(int index) {
        this.getTabViewer().setActiveTab(index);
    }

    public void setInitialStatus(IStatus status) {
        this.fInitialStatus = status;
    }

    protected IStatus getInitialStatus() {
        return this.fInitialStatus;
    }

    public void handleStatus(IStatus status) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, (Object)this);
                return;
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
        }
        String title = null;
        switch (status.getSeverity()) {
            case 4: {
                title = LaunchConfigurationsMessages.getString("LaunchConfigurationsDialog.Error_1");
                break;
            }
            case 2: {
                title = LaunchConfigurationsMessages.getString("LaunchConfigurationsDialog.Warning_2");
                break;
            }
            default: {
                title = LaunchConfigurationsMessages.getString("LaunchConfigurationsDialog.Information_3");
            }
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
    }

    private abstract class ButtonAction
    extends Action {
        protected Button fButton;

        public ButtonAction(String text, Button button) {
            super(text);
            this.fButton = button;
            if (this.fButton != null) {
                this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ ButtonAction this$1;
                    {
                        this.this$1 = buttonAction;
                    }

                    public void widgetSelected(SelectionEvent evt) {
                        this.this$1.run();
                    }
                });
            }
        }

        public Button getButton() {
            return this.fButton;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.fButton != null) {
                this.fButton.setEnabled(enabled);
            }
        }
    }

    private class ButtonActionNew
    extends ButtonAction {
        public ButtonActionNew(String text, Button button) {
            super(text, button);
        }

        public void run() {
            LaunchConfigurationsDialog.this.getNewAction().run();
        }
    }

    private class ButtonActionDelete
    extends ButtonAction {
        public ButtonActionDelete(String text, Button button) {
            super(text, button);
        }

        public void run() {
            LaunchConfigurationsDialog.this.getDeleteAction().run();
        }
    }

    private class DoubleClickAction
    extends Action {
        DoubleClickAction() {
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)LaunchConfigurationsDialog.this.fLaunchConfigurationView.getViewer().getSelection();
            Object target = selection.getFirstElement();
            if (target instanceof ILaunchConfiguration) {
                if (LaunchConfigurationsDialog.this.canLaunch()) {
                    LaunchConfigurationsDialog.this.handleLaunchPressed();
                }
            } else {
                LaunchConfigurationsDialog.this.getNewAction().run();
            }
        }
    }
}

