/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.sourcelookup.ISourceContainerBrowser;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class SourceLookupUIUtils {
    public static final String CONTAINER_PRESENTATION_EXTENSION = "sourceContainerPresentations";
    public static final String ICON_ATTRIBUTE = "icon";
    public static final String BROWSER_CLASS_ATTRIBUTE = "browserClass";
    public static final String CONTAINER_ID_ATTRIBUTE = "containerTypeID";
    private static Hashtable fSourceContainerPresentationHashtable;

    public SourceLookupUIUtils() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), CONTAINER_PRESENTATION_EXTENSION);
        IConfigurationElement[] sourceContainerPresentationExtensions = extensionPoint.getConfigurationElements();
        fSourceContainerPresentationHashtable = new Hashtable();
        int i = 0;
        while (i < sourceContainerPresentationExtensions.length) {
            fSourceContainerPresentationHashtable.put(sourceContainerPresentationExtensions[i].getAttribute(CONTAINER_ID_ATTRIBUTE), sourceContainerPresentationExtensions[i]);
            this.registerContainerImages(sourceContainerPresentationExtensions[i]);
            ++i;
        }
    }

    public static Image getSourceContainerImage(String id) {
        if (fSourceContainerPresentationHashtable == null) {
            new SourceLookupUIUtils();
        }
        return DebugPluginImages.getImage(id);
    }

    public static ISourceContainerBrowser getSourceContainerBrowser(String typeID) {
        if (fSourceContainerPresentationHashtable == null) {
            new SourceLookupUIUtils();
        }
        IConfigurationElement element = (IConfigurationElement)fSourceContainerPresentationHashtable.get(typeID);
        ISourceContainerBrowser browser = null;
        try {
            if (element != null && element.getAttribute(BROWSER_CLASS_ATTRIBUTE) != null) {
                browser = (ISourceContainerBrowser)element.createExecutableExtension(BROWSER_CLASS_ATTRIBUTE);
            }
        }
        catch (CoreException coreException) {}
        return browser;
    }

    private void registerContainerImages(IConfigurationElement configElement) {
        Bundle bundle = Platform.getBundle((String)configElement.getDeclaringExtension().getNamespace());
        URL iconURL = bundle.getEntry("/");
        String iconPath = configElement.getAttribute(ICON_ATTRIBUTE);
        ImageDescriptor imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        String configTypeID = configElement.getAttribute(CONTAINER_ID_ATTRIBUTE);
        ImageRegistry imageRegistry = DebugPluginImages.getImageRegistry();
        DebugPluginImages.getImageRegistry();
        if (iconPath != null) {
            try {
                iconURL = new URL(iconURL, iconPath);
                imageDescriptor = ImageDescriptor.createFromURL((URL)iconURL);
            }
            catch (MalformedURLException mue) {
                DebugUIPlugin.log(mue);
            }
            imageRegistry.put(configTypeID, imageDescriptor);
        }
    }
}

