/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.views.expression.ExpressionViewContentProvider;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewEventHandler;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ExpressionViewEventHandler
extends VariablesViewEventHandler
implements IExpressionsListener {
    protected void doHandleTerminateEvent(DebugEvent event) {
        super.doHandleTerminateEvent(event);
        if (event.getSource() instanceof IDebugTarget) {
            IExpression[] expressions = DebugPlugin.getDefault().getExpressionManager().getExpressions();
            IAdaptable object = DebugUITools.getDebugContext();
            IDebugElement context = null;
            if (object instanceof IDebugElement) {
                context = (IDebugElement)object;
            } else if (object instanceof ILaunch) {
                context = ((ILaunch)object).getDebugTarget();
            }
            int i = 0;
            while (i < expressions.length) {
                IExpression expression = expressions[i];
                if (expression instanceof IWatchExpression) {
                    ((IWatchExpression)expression).setExpressionContext(context);
                }
                ++i;
            }
        }
    }

    public ExpressionViewEventHandler(AbstractDebugView view) {
        super(view);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getExpressionManager().addExpressionListener((IExpressionsListener)this);
    }

    public void dispose() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getExpressionManager().removeExpressionListener((IExpressionsListener)this);
        super.dispose();
    }

    public void expressionsAdded(final IExpression[] expressions) {
        Runnable r = new Runnable(){

            public void run() {
                if (ExpressionViewEventHandler.this.isAvailable()) {
                    ExpressionViewEventHandler.this.getTreeViewer().refresh();
                    if (expressions.length > 0) {
                        StructuredSelection selection = new StructuredSelection((Object)expressions[0]);
                        ExpressionViewEventHandler.this.getTreeViewer().setSelection((ISelection)selection, true);
                    }
                }
            }
        };
        this.getView().asyncExec(r);
    }

    public void expressionsRemoved(final IExpression[] expressions) {
        Runnable r = new Runnable(){

            public void run() {
                if (ExpressionViewEventHandler.this.isAvailable()) {
                    ExpressionViewEventHandler.this.getTreeViewer().getControl().setRedraw(false);
                    int i = 0;
                    while (i < expressions.length) {
                        IExpression expression = expressions[i];
                        ExpressionViewEventHandler.this.remove(expression);
                        IContentProvider provider = ExpressionViewEventHandler.this.getTreeViewer().getContentProvider();
                        if (provider instanceof ExpressionViewContentProvider) {
                            ExpressionViewContentProvider expressionProvider = (ExpressionViewContentProvider)provider;
                            List decendants = expressionProvider.getCachedDecendants(expression);
                            decendants.add(expression);
                            expressionProvider.removeCache(decendants.toArray());
                            IExpression[] allExpressions = DebugPlugin.getDefault().getExpressionManager().getExpressions();
                            if (allExpressions.length > 0) {
                                ExpressionViewEventHandler.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)allExpressions[0]), true);
                            }
                        }
                        ++i;
                    }
                    ExpressionViewEventHandler.this.getTreeViewer().getControl().setRedraw(true);
                }
            }
        };
        this.getView().asyncExec(r);
    }

    public void expressionsChanged(final IExpression[] expressions) {
        Runnable r = new Runnable(){

            public void run() {
                if (ExpressionViewEventHandler.this.isAvailable()) {
                    ExpressionViewEventHandler.this.getTreeViewer().getControl().setRedraw(false);
                    int i = 0;
                    while (i < expressions.length) {
                        IExpression expression = expressions[i];
                        ExpressionViewEventHandler.this.refresh(expression);
                        IStructuredSelection selection = (IStructuredSelection)ExpressionViewEventHandler.this.getViewer().getSelection();
                        if (selection.size() == 1 && selection.getFirstElement().equals(expression)) {
                            ExpressionViewEventHandler.this.getVariablesView().populateDetailPane();
                        }
                        ++i;
                    }
                    ExpressionViewEventHandler.this.getTreeViewer().getControl().setRedraw(true);
                }
            }
        };
        this.getView().asyncExec(r);
    }

    protected void doHandleResumeEvent(DebugEvent event) {
    }

    protected void doHandleChangeEvent(DebugEvent event) {
        if (event.getSource() instanceof IExpression) {
            this.refresh(event.getSource());
        } else if (event.getDetail() == 256) {
            if (event.getSource() instanceof IVariable) {
                this.refresh(event.getSource());
            }
        } else {
            this.refresh();
        }
    }
}

