/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;

public abstract class AbstractTextSearchResult
implements ISearchResult {
    private Map fElementsToMatches = new HashMap();
    private List fListeners = new ArrayList();
    private static final Match[] EMPTY_ARRAY = new Match[0];
    private MatchEvent fMatchEvent = new MatchEvent(this);

    protected AbstractTextSearchResult() {
    }

    public Match[] getMatches(Object element) {
        Map map = this.fElementsToMatches;
        synchronized (map) {
            return this.doGetMatches(element);
        }
    }

    private Match[] doGetMatches(Object element) {
        List matches = (List)this.fElementsToMatches.get(element);
        if (matches != null) {
            return matches.toArray(new Match[matches.size()]);
        }
        return EMPTY_ARRAY;
    }

    public void addMatch(Match match) {
        boolean hasAdded = false;
        Map map = this.fElementsToMatches;
        synchronized (map) {
            hasAdded = this.doAddMatch(match);
        }
        if (hasAdded) {
            this.fireChange(this.getSearchResultEvent(match, 1));
        }
    }

    public void addMatches(Match[] matches) {
        HashSet<Match> reallyAdded = new HashSet<Match>();
        Map map = this.fElementsToMatches;
        synchronized (map) {
            int i = 0;
            while (i < matches.length) {
                if (this.doAddMatch(matches[i])) {
                    reallyAdded.add(matches[i]);
                }
                ++i;
            }
        }
        if (reallyAdded.size() > 0) {
            this.fireChange(this.getSearchResultEvent(reallyAdded, 1));
        }
    }

    private MatchEvent getSearchResultEvent(Match match, int eventKind) {
        this.fMatchEvent.setKind(eventKind);
        this.fMatchEvent.setMatch(match);
        return this.fMatchEvent;
    }

    private MatchEvent getSearchResultEvent(Set matches, int eventKind) {
        this.fMatchEvent.setKind(eventKind);
        Match[] matchArray = new Match[matches.size()];
        matches.toArray(matchArray);
        this.fMatchEvent.setMatches(matchArray);
        return this.fMatchEvent;
    }

    private boolean doAddMatch(Match match) {
        ArrayList matches = (ArrayList)this.fElementsToMatches.get(match.getElement());
        if (matches == null) {
            matches = new ArrayList();
            this.fElementsToMatches.put(match.getElement(), matches);
        }
        if (!matches.contains(match)) {
            AbstractTextSearchResult.insertSorted(matches, match);
            return true;
        }
        return false;
    }

    private static void insertSorted(List matches, Match match) {
        if (matches.size() == 0) {
            matches.add(match);
            return;
        }
        int insertIndex = AbstractTextSearchResult.getInsertIndex(matches, match);
        matches.add(insertIndex, match);
    }

    private static int getInsertIndex(List matches, Match match) {
        int count = matches.size();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Match data = (Match)matches.get(mid);
            int compare = AbstractTextSearchResult.compare(match, data);
            if (compare > 0) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        return min;
    }

    private static int compare(Match match1, Match match2) {
        int diff = match2.getOffset() - match1.getOffset();
        if (diff != 0) {
            return diff;
        }
        return match2.getLength() - match1.getLength();
    }

    public void removeAll() {
        Map map = this.fElementsToMatches;
        synchronized (map) {
            this.doRemoveAll();
        }
        this.fireChange(new RemoveAllEvent(this));
    }

    private void doRemoveAll() {
        this.fElementsToMatches.clear();
    }

    public void removeMatch(Match match) {
        boolean existed = false;
        Map map = this.fElementsToMatches;
        synchronized (map) {
            existed = this.doRemoveMatch(match);
        }
        if (existed) {
            this.fireChange(this.getSearchResultEvent(match, 2));
        }
    }

    public void removeMatches(Match[] matches) {
        HashSet<Match> existing = new HashSet<Match>();
        Map map = this.fElementsToMatches;
        synchronized (map) {
            int i = 0;
            while (i < matches.length) {
                if (this.doRemoveMatch(matches[i])) {
                    existing.add(matches[i]);
                }
                ++i;
            }
        }
        if (existing.size() > 0) {
            this.fireChange(this.getSearchResultEvent(existing, 2));
        }
    }

    private boolean doRemoveMatch(Match match) {
        boolean existed = false;
        List matches = (List)this.fElementsToMatches.get(match.getElement());
        if (matches != null) {
            existed = matches.remove(match);
            if (matches.isEmpty()) {
                this.fElementsToMatches.remove(match.getElement());
            }
        }
        return existed;
    }

    public void addListener(ISearchResultListener l) {
        List list = this.fListeners;
        synchronized (list) {
            this.fListeners.add(l);
        }
    }

    public void removeListener(ISearchResultListener l) {
        List list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(l);
        }
    }

    protected void fireChange(SearchResultEvent e) {
        HashSet copiedListeners = new HashSet();
        List list = this.fListeners;
        synchronized (list) {
            copiedListeners.addAll(this.fListeners);
        }
        Iterator listeners = copiedListeners.iterator();
        while (listeners.hasNext()) {
            ((ISearchResultListener)listeners.next()).searchResultChanged(e);
        }
    }

    public int getMatchCount() {
        int count = 0;
        Map map = this.fElementsToMatches;
        synchronized (map) {
            Iterator elements = this.fElementsToMatches.values().iterator();
            while (elements.hasNext()) {
                List element = (List)elements.next();
                if (element == null) continue;
                count += element.size();
            }
        }
        return count;
    }

    public int getMatchCount(Object element) {
        List matches = (List)this.fElementsToMatches.get(element);
        if (matches != null) {
            return matches.size();
        }
        return 0;
    }

    public Object[] getElements() {
        Map map = this.fElementsToMatches;
        synchronized (map) {
            return this.fElementsToMatches.keySet().toArray();
        }
    }

    public abstract IEditorMatchAdapter getEditorMatchAdapter();

    public abstract IFileMatchAdapter getFileMatchAdapter();
}

