/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.ant.core.TargetInfo;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetContentProvider;
import org.eclipse.ant.internal.ui.launchConfigurations.TargetOrderDialog;
import org.eclipse.ant.internal.ui.launchConfigurations.TargetTableLabelProvider;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntTargetsTab
extends AbstractLaunchConfigurationTab {
    private TargetInfo fDefaultTarget = null;
    private TargetInfo[] fAllTargets = null;
    private List fOrderedTargets = null;
    private CheckboxTableViewer fTableViewer = null;
    private Label fSelectionCountLabel = null;
    private Text fTargetOrderText = null;
    private Button fOrderButton = null;
    private Button fFilterInternalTargets;
    private Button fSortButton;
    private ILaunchConfiguration fLaunchConfiguration;
    private AntTargetContentProvider fTargetContentProvider;
    private int fSortDirection = 0;
    private boolean fInitializing = false;
    public static int SORT_NONE = 0;
    public static int SORT_NAME = 1;
    public static int SORT_NAME_REVERSE = -1;
    public static int SORT_DESCRIPTION = 2;
    public static int SORT_DESCRIPTION_REVERSE = -2;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.ant.ui.ant_targets_tab_context");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        comp.setFont(font);
        this.createTargetsTable(comp);
        this.createSelectionCount(comp);
        Composite buttonComposite = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(font);
        this.createSortTargets(buttonComposite);
        this.createFilterInternalTargets(buttonComposite);
        this.createVerticalSpacer(comp, 1);
        this.createTargetOrder(comp);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createSelectionCount(Composite parent) {
        this.fSelectionCountLabel = new Label(parent, 0);
        this.fSelectionCountLabel.setFont(parent.getFont());
        this.fSelectionCountLabel.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.0_out_of_0_selected_2"));
        GridData gd = new GridData(768);
        this.fSelectionCountLabel.setLayoutData((Object)gd);
    }

    private void createTargetOrder(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 0);
        label.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.Target_execution_order__3"));
        label.setFont(font);
        Composite orderComposite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        orderComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        orderComposite.setLayout((Layout)layout);
        orderComposite.setFont(font);
        this.fTargetOrderText = new Text(orderComposite, 2634);
        this.fTargetOrderText.setFont(font);
        gd = new GridData(768);
        gd.heightHint = 40;
        gd.widthHint = 200;
        this.fTargetOrderText.setLayoutData((Object)gd);
        this.fOrderButton = this.createPushButton(orderComposite, AntLaunchConfigurationMessages.getString("AntTargetsTab.&Order..._4"), null);
        gd = (GridData)this.fOrderButton.getLayoutData();
        gd.verticalAlignment = 1;
        this.fOrderButton.setFont(font);
        this.fOrderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntTargetsTab.this.handleOrderPressed();
            }
        });
    }

    private void createFilterInternalTargets(Composite parent) {
        this.fFilterInternalTargets = this.createCheckButton(parent, AntLaunchConfigurationMessages.getString("AntTargetsTab.12"));
        this.fFilterInternalTargets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntTargetsTab.this.handleFilterTargetsSelected();
            }
        });
    }

    private void createSortTargets(Composite parent) {
        this.fSortButton = this.createCheckButton(parent, AntLaunchConfigurationMessages.getString("AntTargetsTab.14"));
        this.fSortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntTargetsTab.this.handleSortTargetsSelected();
            }
        });
    }

    private void handleFilterTargetsSelected() {
        boolean filter = this.fFilterInternalTargets.getSelection();
        this.fTargetContentProvider.setFilterInternalTargets(filter);
        if (filter) {
            ListIterator iter = this.fOrderedTargets.listIterator();
            while (iter.hasNext()) {
                TargetInfo target = (TargetInfo)iter.next();
                if (!this.fTargetContentProvider.isInternal(target)) continue;
                iter.remove();
            }
        }
        this.fTableViewer.refresh();
        this.updateSelectionCount();
        this.updateLaunchConfigurationDialog();
    }

    private void handleSortTargetsSelected() {
        this.setSort(this.fSortButton.getSelection() ? SORT_NAME : SORT_NONE);
    }

    private void setSort(int column) {
        this.fSortDirection = column;
        this.fTableViewer.refresh();
        if (!this.fInitializing) {
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleOrderPressed() {
        TargetOrderDialog dialog = new TargetOrderDialog(this.getShell(), this.fOrderedTargets.toArray());
        int ok = dialog.open();
        if (ok == 0) {
            this.fOrderedTargets.clear();
            Object[] targets = dialog.getTargets();
            int i = 0;
            while (i < targets.length) {
                this.fOrderedTargets.add(targets[i]);
                this.updateSelectionCount();
                this.updateLaunchConfigurationDialog();
                ++i;
            }
        }
    }

    private void createTargetsTable(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 0);
        label.setFont(font);
        label.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.Check_targets_to_e&xecute__1"));
        Table table = new Table(parent, 67632);
        GridData data = new GridData(1808);
        int availableRows = this.availableRows(parent);
        data.heightHint = table.getItemHeight() * (availableRows / 20);
        data.widthHint = 250;
        table.setLayoutData((Object)data);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        ColumnWeightData weightData = new ColumnWeightData(30, true);
        tableLayout.addColumnData((ColumnLayoutData)weightData);
        weightData = new ColumnWeightData(70, true);
        tableLayout.addColumnData((ColumnLayoutData)weightData);
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.Name_5"));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(AntLaunchConfigurationMessages.getString("AntTargetsTab.Description_6"));
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TargetTableLabelProvider());
        this.fTargetContentProvider = new AntTargetContentProvider();
        this.fTableViewer.setContentProvider((IContentProvider)this.fTargetContentProvider);
        this.fTableViewer.setSorter((ViewerSorter)new AntTargetsSorter());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    Object element = ss.getFirstElement();
                    boolean checked = !AntTargetsTab.this.fTableViewer.getChecked(element);
                    AntTargetsTab.this.fTableViewer.setChecked(element, checked);
                    AntTargetsTab.this.updateOrderedTargets(element, checked);
                }
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AntTargetsTab.this.updateOrderedTargets(event.getElement(), event.getChecked());
            }
        });
        TableColumn[] columns = this.fTableViewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            final int index = i++;
            columns[index].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AntTargetsTab.this.fSortButton.getSelection()) {
                        int column = index + 1;
                        if (column == AntTargetsTab.this.fSortDirection) {
                            column = -column;
                        }
                        AntTargetsTab.this.setSort(column);
                    }
                }
            });
        }
    }

    private int availableRows(Composite parent) {
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        int displayHeight = parent.getDisplay().getClientArea().height;
        return displayHeight / fontHeight;
    }

    private void updateOrderedTargets(Object element, boolean checked) {
        if (checked) {
            this.fOrderedTargets.add(element);
        } else {
            this.fOrderedTargets.remove(element);
        }
        this.updateSelectionCount();
        this.updateLaunchConfigurationDialog();
    }

    private void updateSelectionCount() {
        Object[] checked = this.fTableViewer.getCheckedElements();
        String numSelected = Integer.toString(checked.length);
        int length = this.fTargetContentProvider.getNumTargets();
        String total = Integer.toString(length);
        int numHidden = this.fTargetContentProvider.getNumFiltered();
        if (numHidden > 0) {
            this.fSelectionCountLabel.setText(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntTargetsTab.13"), numSelected, total, String.valueOf(numHidden)));
        } else {
            this.fSelectionCountLabel.setText(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntTargetsTab.{0}_out_of_{1}_selected_7"), numSelected, total));
        }
        this.fOrderButton.setEnabled(checked.length > 1);
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.fOrderedTargets.iterator();
        while (iter.hasNext()) {
            buffer.append(((TargetInfo)iter.next()).getName());
            buffer.append(", ");
        }
        if (buffer.length() > 2) {
            buffer.setLength(buffer.length() - 2);
        }
        this.fTargetOrderText.setText(buffer.toString());
    }

    private TargetInfo[] getTargets() {
        if (this.fAllTargets == null || this.isDirty()) {
            this.fAllTargets = null;
            this.setDirty(false);
            this.setErrorMessage(null);
            this.setMessage(null);
            final String expandedLocation = this.validateLocation();
            if (expandedLocation == null) {
                return this.fAllTargets;
            }
            final CoreException[] exceptions = new CoreException[1];
            try {
                final String[] arguments = AntUtil.parseString(this.fLaunchConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null), ",");
                IRunnableWithProgress operation = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            AntTargetsTab.this.fAllTargets = AntUtil.getTargets(expandedLocation, arguments, AntTargetsTab.this.fLaunchConfiguration);
                        }
                        catch (CoreException ce) {
                            exceptions[0] = ce;
                        }
                    }
                };
                IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (context == null) {
                    context = this.getLaunchConfigurationDialog();
                }
                IFile rule = null;
                if (!ResourcesPlugin.getWorkspace().isTreeLocked()) {
                    rule = AntUtil.getFileForLocation(expandedLocation, null);
                }
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, operation, (ISchedulingRule)rule);
            }
            catch (CoreException ce) {
                exceptions[0] = ce;
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            if (exceptions[0] != null) {
                IStatus exceptionStatus = exceptions[0].getStatus();
                IStatus[] children = exceptionStatus.getChildren();
                StringBuffer message = new StringBuffer(exceptions[0].getMessage());
                int i = 0;
                while (i < children.length) {
                    message.append(' ');
                    IStatus childStatus = children[i];
                    message.append(childStatus.getMessage());
                    ++i;
                }
                this.setErrorMessage(message.toString());
                this.fAllTargets = null;
                return this.fAllTargets;
            }
            int i = 0;
            while (i < this.fAllTargets.length) {
                if (this.fAllTargets[i].isDefault()) {
                    this.fDefaultTarget = this.fAllTargets[i];
                    break;
                }
                ++i;
            }
        }
        return this.fAllTargets;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        this.fLaunchConfiguration = configuration;
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setDirty(true);
        boolean hideInternal = false;
        try {
            hideInternal = this.fLaunchConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_HIDE_INTERNAL_TARGETS", false);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        this.fFilterInternalTargets.setSelection(hideInternal);
        this.fTargetContentProvider.setFilterInternalTargets(hideInternal);
        int sort = SORT_NONE;
        try {
            sort = this.fLaunchConfiguration.getAttribute("org.eclipse.ui.externaltoolsATTR_SORT_TARGETS", sort);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        this.fSortButton.setSelection(sort != SORT_NONE);
        this.setSort(sort);
        String configTargets = null;
        String newLocation = null;
        this.fOrderedTargets = new ArrayList();
        try {
            configTargets = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
            newLocation = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntLaunchConfigurationMessages.getString("AntTargetsTab.Error_reading_configuration_12"), ce);
        }
        if (newLocation == null) {
            this.fAllTargets = null;
            this.initializeForNoTargets();
            return;
        }
        TargetInfo[] allInfos = this.getTargets();
        if (allInfos == null) {
            this.initializeForNoTargets();
            return;
        }
        String[] targetNames = AntUtil.parseRunTargets(configTargets);
        if (targetNames.length == 0) {
            this.fOrderedTargets.add(this.fDefaultTarget);
            this.fTableViewer.setAllChecked(false);
            this.setExecuteInput(allInfos);
            if (this.fDefaultTarget != null) {
                this.fTableViewer.setChecked((Object)this.fDefaultTarget, true);
                this.updateSelectionCount();
                this.updateLaunchConfigurationDialog();
            }
            this.fInitializing = false;
            return;
        }
        this.setExecuteInput(allInfos);
        this.fTableViewer.setAllChecked(false);
        int i = 0;
        while (i < targetNames.length) {
            int j = 0;
            while (j < this.fAllTargets.length) {
                if (targetNames[i].equals(this.fAllTargets[j].getName())) {
                    this.fOrderedTargets.add(this.fAllTargets[j]);
                    this.fTableViewer.setChecked((Object)this.fAllTargets[j], true);
                }
                ++j;
            }
            ++i;
        }
        this.updateSelectionCount();
        this.fInitializing = false;
    }

    private void initializeForNoTargets() {
        this.setExecuteInput(new TargetInfo[0]);
        this.fTableViewer.setInput((Object)new TargetInfo[0]);
        this.fInitializing = false;
    }

    private void setExecuteInput(Object input) {
        this.fTableViewer.setInput(input);
        this.updateSelectionCount();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fFilterInternalTargets.getSelection()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_HIDE_INTERNAL_TARGETS", true);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_HIDE_INTERNAL_TARGETS", null);
        }
        if (this.fSortDirection != SORT_NONE) {
            configuration.setAttribute("org.eclipse.ui.externaltoolsATTR_SORT_TARGETS", this.fSortDirection);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltoolsATTR_SORT_TARGETS", null);
        }
        if (this.fOrderedTargets.size() == 1) {
            TargetInfo item = (TargetInfo)this.fOrderedTargets.get(0);
            if (item.isDefault()) {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
                return;
            }
        } else if (this.fOrderedTargets.size() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
            return;
        }
        StringBuffer buff = new StringBuffer();
        Iterator iter = this.fOrderedTargets.iterator();
        String targets = null;
        while (iter.hasNext()) {
            TargetInfo item = (TargetInfo)iter.next();
            buff.append(item.getName());
            buff.append(',');
        }
        if (buff.length() > 0) {
            targets = buff.toString();
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targets);
    }

    public String getName() {
        return AntLaunchConfigurationMessages.getString("AntTargetsTab.Tar&gets_14");
    }

    public Image getImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_TAB_ANT_TARGETS");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.fAllTargets == null || this.isDirty()) {
            if (this.getErrorMessage() != null && !this.isDirty()) {
                return false;
            }
            this.initializeFrom(launchConfig);
            if (this.getErrorMessage() != null) {
                return false;
            }
        }
        if (this.fAllTargets != null && this.fTableViewer.getCheckedElements().length == 0) {
            this.setErrorMessage(AntLaunchConfigurationMessages.getString("AntTargetsTab.No_targets"));
            return false;
        }
        this.setErrorMessage(null);
        return super.isValid(launchConfig);
    }

    protected void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (this.isDirty()) {
            super.activated(workingCopy);
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (this.fOrderedTargets.size() == 0) {
            this.setDirty(true);
        }
    }

    private String validateLocation() {
        String expandedLocation = null;
        String location = null;
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            location = this.fLaunchConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
            if (location == null) {
                return null;
            }
            expandedLocation = manager.performStringSubstitution(location);
            if (expandedLocation == null) {
                return null;
            }
            File file = new File(expandedLocation);
            if (!file.exists()) {
                this.setErrorMessage(AntLaunchConfigurationMessages.getString("AntTargetsTab.15"));
                return null;
            }
            if (!file.isFile()) {
                this.setErrorMessage(AntLaunchConfigurationMessages.getString("AntTargetsTab.16"));
                return null;
            }
            return expandedLocation;
        }
        catch (CoreException e1) {
            if (location != null) {
                try {
                    manager.validateStringVariables(location);
                    this.setMessage(AntLaunchConfigurationMessages.getString("AntTargetsTab.17"));
                    return null;
                }
                catch (CoreException e2) {
                    this.setErrorMessage(e2.getStatus().getMessage());
                    return null;
                }
            }
            this.setErrorMessage(e1.getStatus().getMessage());
            return null;
        }
    }

    private class AntTargetsSorter
    extends ViewerSorter {
        AntTargetsSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String string2;
            String string1;
            if (!(e1 instanceof TargetInfo) || !(e2 instanceof TargetInfo)) {
                return super.compare(viewer, e1, e2);
            }
            if (AntTargetsTab.this.fSortDirection == SORT_NONE) {
                return 0;
            }
            int result = 0;
            if (AntTargetsTab.this.fSortDirection == SORT_NAME || AntTargetsTab.this.fSortDirection == SORT_NAME_REVERSE) {
                string1 = ((TargetInfo)e1).getName();
                string2 = ((TargetInfo)e2).getName();
            } else {
                string1 = ((TargetInfo)e1).getDescription();
                string2 = ((TargetInfo)e2).getDescription();
            }
            if (string1 != null && string2 != null) {
                result = this.getCollator().compare(string1, string2);
            } else if (string1 == null) {
                result = 1;
            } else if (string2 == null) {
                result = -1;
            }
            if (AntTargetsTab.this.fSortDirection < 0) {
                result = result == 0 ? -1 : -result;
            }
            return result;
        }
    }
}

