/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views;

import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.ant.internal.ui.views.elements.ProjectNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;

public class AntViewDropAdapter
extends DropTargetAdapter {
    private AntView view;

    public AntViewDropAdapter(AntView view) {
        this.view = view;
    }

    public void drop(DropTargetEvent event) {
        Object data = event.data;
        if (data instanceof String[]) {
            final String[] strings = (String[])data;
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < strings.length) {
                        AntViewDropAdapter.this.processString(strings[i]);
                        ++i;
                    }
                }
            });
        }
    }

    private void processString(String buildFileName) {
        IFile buildFile = AntUtil.getFileForLocation(buildFileName, null);
        if (buildFile == null || !buildFileName.toLowerCase().endsWith(".xml")) {
            return;
        }
        buildFileName = buildFile.getFullPath().toString();
        ProjectNode[] existingProjects = this.view.getProjects();
        int j = 0;
        while (j < existingProjects.length) {
            ProjectNode existingProject = existingProjects[j];
            if (existingProject.getBuildFileName().equals(buildFileName)) {
                return;
            }
            ++j;
        }
        ProjectNode project = new ProjectNode(buildFileName);
        this.view.addProject(project);
    }
}

