/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.WorkspaceTracker;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DynamicValidationStateChange
extends CompositeChange
implements WorkspaceTracker.Listener {
    private RefactoringStatus fValidationState = null;

    public DynamicValidationStateChange(Change change) {
        super(change.getName());
        this.add(change);
        this.markAsSynthetic();
    }

    public DynamicValidationStateChange(String name) {
        super(name);
        this.markAsSynthetic();
    }

    public DynamicValidationStateChange(String name, Change[] changes) {
        super(name, changes);
        this.markAsSynthetic();
    }

    public void initializeValidationData(IProgressMonitor pm) {
        super.initializeValidationData(pm);
        WorkspaceTracker.INSTANCE.addListener(this);
    }

    public void dispose() {
        WorkspaceTracker.INSTANCE.removeListener(this);
        super.dispose();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fValidationState == null) {
            return super.isValid(pm);
        }
        return this.fValidationState;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        final Change[] result = new Change[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                result[0] = DynamicValidationStateChange.super.perform(monitor);
            }
        };
        JavaCore.run((IWorkspaceRunnable)runnable, (IProgressMonitor)pm);
        return result[0];
    }

    protected Change createUndoChange(Change[] childUndos) {
        DynamicValidationStateChange result = new DynamicValidationStateChange(this.getName());
        int i = 0;
        while (i < childUndos.length) {
            result.add(childUndos[i]);
            ++i;
        }
        return result;
    }

    public void workspaceChanged() {
        this.fValidationState = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("DynamicValidationStateChange.workspace_changed"));
        RefactoringCore.getUndoManager().flush();
    }
}

