/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameJavaProjectChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameJavaProjectProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private IJavaProject fProject;
    private boolean fUpdateReferences;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameJavaProjectProcessor";

    public RenameJavaProjectProcessor(IJavaProject project) {
        this.fProject = project;
        this.setNewElementName(this.fProject.getElementName());
        this.fUpdateReferences = true;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fProject == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)this.fProject)) {
            return false;
        }
        return this.fProject.isConsistent();
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameJavaProjectRefactoring.rename", new String[]{this.getCurrentElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fProject);
    }

    public Object[] getElements() {
        return new Object[]{this.fProject};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        this.loadDerivedParticipants(status, result, null, null, this.computeResourceModifications(), natures, shared);
    }

    private ResourceModifications computeResourceModifications() {
        ResourceModifications result = new ResourceModifications();
        result.setRename((IResource)this.fProject.getProject(), new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    public Object getNewElement() throws CoreException {
        IPath newPath = this.fProject.getPath().removeLastSegments(1).append(this.getNewElementName());
        return JavaCore.create((IResource)ResourcesPlugin.getWorkspace().getRoot().findMember(newPath));
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public String getCurrentElementName() {
        return this.fProject.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = RefactoringStatus.create((IStatus)ResourcesPlugin.getWorkspace().validateName(newName, 4));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.projectNameAlreadyExists(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameJavaProjectRefactoring.already_exists"));
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            pm.beginTask("", 1);
            try {
                if (!this.isReadOnly()) break block3;
                String message = RefactoringCoreMessages.getFormattedString("RenameJavaProjectRefactoring.read_only", this.fProject.getElementName());
                refactoringStatus = RefactoringStatus.createErrorStatus((String)message);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Object var4_7 = null;
        pm.done();
        return refactoringStatus;
    }

    private boolean isReadOnly() {
        return this.fProject.getResource().isReadOnly();
    }

    private boolean projectNameAlreadyExists(String newName) {
        return this.fProject.getJavaModel().getJavaProject(newName).exists();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameJavaProjectChange(this.fProject, this.getNewElementName(), this.fUpdateReferences));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }
}

