/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameResourceProcessor
extends RenameProcessor
implements INameUpdating {
    private IResource fResource;
    private String fNewElementName;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameResourceProcessor";

    public RenameResourceProcessor(IResource resource) {
        this.fResource = resource;
        if (this.fResource != null) {
            this.setNewElementName(this.fResource.getName());
        }
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull(newName);
        this.fNewElementName = newName;
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws JavaModelException {
        if (this.fResource == null) {
            return false;
        }
        if (!this.fResource.exists()) {
            return false;
        }
        return this.fResource.isAccessible();
    }

    public String getProcessorName() {
        String message = RefactoringCoreMessages.getFormattedString("RenameResourceProcessor.name", new String[]{this.getCurrentElementName(), this.getNewElementName()});
        return message;
    }

    public Object[] getElements() {
        return new Object[]{this.fResource};
    }

    public String getCurrentElementName() {
        return this.fResource.getName();
    }

    public String[] getAffectedProjectNatures() throws CoreException {
        return ResourceProcessors.computeAffectedNatures(this.fResource);
    }

    public Object getNewElement() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.createNewPath(this.getNewElementName()));
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        Object[] elements = this.getElements();
        String[] natures = this.getAffectedProjectNatures();
        ArrayList<RenameParticipant> result = new ArrayList<RenameParticipant>();
        RenameArguments arguments = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        int i = 0;
        while (i < elements.length) {
            result.addAll(Arrays.asList(ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)elements[i], (RenameArguments)arguments, (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws JavaModelException {
        Assert.isNotNull(newName, "new name");
        IContainer c = this.fResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameResourceRefactoring.Internal_Error"));
        }
        if (c.findMember(newName) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameResourceRefactoring.alread_exists"));
        }
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("RenameResourceRefactoring.invalidName"));
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, this.fResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), this.fResource.getType())));
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            refactoringStatus = new RefactoringStatus();
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private String createNewPath(String newName) {
        return this.fResource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    public Change createChange(IProgressMonitor pm) throws JavaModelException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameResourceChange(this.fResource, this.getNewElementName()));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }
}

