/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public final class TypeBindings {
    private TypeBindings() {
    }

    private static boolean isNullBinding(ITypeBinding binding) {
        return binding == null;
    }

    public static boolean isEqualTo(ITypeBinding binding, ITypeBinding otherBinding) {
        if (TypeBindings.isNullBinding(binding)) {
            return false;
        }
        return Bindings.equals((IBinding)binding, (IBinding)otherBinding);
    }

    public static boolean isSubtypeBindingOf(ITypeBinding binding, ITypeBinding otherBinding) {
        if (TypeBindings.isNullBinding(binding) || TypeBindings.isNullBinding(otherBinding)) {
            return false;
        }
        return TypeBindings.isSubtypeOf(binding, otherBinding);
    }

    private static boolean isSubtypeOf(ITypeBinding b1, ITypeBinding b2) {
        if (b1.isNullType()) {
            return true;
        }
        if (b1.isPrimitive() || b2.isPrimitive()) {
            return false;
        }
        if (TypeBindings.isThisType(b2, "java.lang.Object")) {
            return true;
        }
        if (Modifier.isFinal((int)b2.getModifiers())) {
            return false;
        }
        if (b1.isArray()) {
            if (b2.isArray()) {
                return TypeBindings.isSubtypeOf(b1.getElementType(), b2.getElementType());
            }
            return TypeBindings.isThisType(b2, "java.lang.Cloneable") || TypeBindings.isThisType(b2, "java.io.Serializable");
        }
        if (b2.isArray()) {
            return false;
        }
        return TypeBindings.getSuperTypes(b1).contains(b2);
    }

    private static boolean isThisType(ITypeBinding binding, String qualifiedName) {
        return binding.getQualifiedName().equals(qualifiedName);
    }

    public static Set getSuperTypes(ITypeBinding type) {
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null) {
            result.add(superClass);
            result.addAll(TypeBindings.getSuperTypes(superClass));
        }
        ITypeBinding[] superInterfaces = type.getInterfaces();
        result.addAll(Arrays.asList(superInterfaces));
        int i = 0;
        while (i < superInterfaces.length) {
            result.addAll(TypeBindings.getSuperTypes(superInterfaces[i]));
            ++i;
        }
        return result;
    }

    public static String toString(ITypeBinding binding) {
        if (TypeBindings.isNullBinding(binding)) {
            return "<NULL BINDING>";
        }
        return Bindings.asString((IBinding)binding);
    }

    public static boolean isClassBinding(ITypeBinding typeBinding) {
        return typeBinding != null && typeBinding.isClass();
    }
}

