/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

class FiltersDialog
extends StatusDialog {
    private Label fNamesHelpText;
    private Button fFilterOnNames;
    private Text fNames;
    private Text fMaxCallDepth;

    protected FiltersDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CallHierarchyMessages.getString("FiltersDialog.filter"));
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.call_hierarchy_filters_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite superComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(superComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        this.createNamesArea(composite);
        new Label(composite, 0);
        this.createMaxCallDepthArea(composite);
        Dialog.applyDialogFont((Control)parent);
        this.updateUIFromFilter();
        return composite;
    }

    private void createMaxCallDepthArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText(CallHierarchyMessages.getString("FiltersDialog.maxCallDepth"));
        this.fMaxCallDepth = new Text(composite, 2052);
        this.fMaxCallDepth.setTextLimit(6);
        this.fMaxCallDepth.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FiltersDialog.this.validateInput();
            }
        });
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        this.fMaxCallDepth.setLayoutData((Object)gridData);
    }

    private void createNamesArea(Composite parent) {
        this.fFilterOnNames = this.createCheckbox(parent, CallHierarchyMessages.getString("FiltersDialog.filterOnNames"), true);
        this.fNames = new Text(parent, 2052);
        this.fNames.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FiltersDialog.this.validateInput();
            }
        });
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.fNames.setLayoutData((Object)gridData);
        this.fNamesHelpText = new Label(parent, 16384);
        this.fNamesHelpText.setText(CallHierarchyMessages.getString("FiltersDialog.filterOnNamesSubCaption"));
    }

    private Button createCheckbox(Composite parent, String text, boolean grabRow) {
        Button button = new Button(parent, 32);
        if (grabRow) {
            GridData gridData = new GridData(768);
            button.setLayoutData((Object)gridData);
        }
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersDialog.this.validateInput();
                FiltersDialog.this.updateEnabledState();
            }
        });
        return button;
    }

    private void updateEnabledState() {
        this.fNames.setEnabled(this.fFilterOnNames.getSelection());
        this.fNamesHelpText.setEnabled(this.fFilterOnNames.getSelection());
    }

    private void updateFilterFromUI() {
        int maxCallDepth = Integer.parseInt(this.fMaxCallDepth.getText());
        CallHierarchyUI.getDefault().setMaxCallDepth(maxCallDepth);
        CallHierarchy.getDefault().setFilters(this.fNames.getText());
        CallHierarchy.getDefault().setFilterEnabled(this.fFilterOnNames.getSelection());
    }

    private void updateUIFromFilter() {
        this.fMaxCallDepth.setText(String.valueOf(CallHierarchyUI.getDefault().getMaxCallDepth()));
        this.fNames.setText(CallHierarchy.getDefault().getFilters());
        this.fFilterOnNames.setSelection(CallHierarchy.getDefault().isFilterEnabled());
        this.updateEnabledState();
    }

    protected void okPressed() {
        if (!this.isMaxCallDepthValid() && this.fMaxCallDepth.forceFocus()) {
            this.fMaxCallDepth.setSelection(0, this.fMaxCallDepth.getCharCount());
            this.fMaxCallDepth.showSelection();
        }
        this.updateFilterFromUI();
        super.okPressed();
    }

    private boolean isMaxCallDepthValid() {
        String text = this.fMaxCallDepth.getText();
        if (text.length() == 0) {
            return false;
        }
        try {
            int maxCallDepth = Integer.parseInt(text);
            return maxCallDepth >= 1 && maxCallDepth <= 99;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void validateInput() {
        StatusInfo status = new StatusInfo();
        if (!this.isMaxCallDepthValid()) {
            status.setError(CallHierarchyMessages.getString("FiltersDialog.messageMaxCallDepthInvalid"));
        }
        this.updateStatus(status);
    }
}

