/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public final class ClipboardOperationAction
extends TextEditorAction {
    private static final ClipboardTransfer fgTransferInstance = new ClipboardTransfer();
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ClipboardOperationAction(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode) {
        super(bundle, prefix, editor);
        this.fOperationCode = operationCode;
        if (operationCode == 3) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        } else if (operationCode == 4) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        } else if (operationCode == 5) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        } else {
            Assert.isTrue((boolean)false, (String)"Invalid operation code");
        }
        this.update();
    }

    private boolean isReadOnlyOperation() {
        return this.fOperationCode == 4;
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.isReadOnlyOperation() && !this.validateEditorInputState()) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ClipboardOperationAction.this.internalDoOperation();
            }
        });
    }

    private Shell getShell() {
        IWorkbenchPartSite site;
        Shell shell;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (shell = (site = editor.getSite()).getShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return null;
    }

    protected final void internalDoOperation() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("importsOnPaste")) {
            if (this.fOperationCode == 5) {
                this.doPasteWithImportsOperation();
            } else {
                this.doCutCopyWithImportsOperation();
            }
        } else {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    public void update() {
        super.update();
        if (!this.isReadOnlyOperation() && !this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter((Class)clazz);
        }
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(isEnabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCutCopyWithImportsOperation() {
        ITextSelection textSelection;
        ITextEditor editor = this.getTextEditor();
        IEditorInput iEditorInput = editor.getEditorInput();
        Class<?> clazz = class$1;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$1 = clazz2;
        }
        IJavaElement inputElement = (IJavaElement)iEditorInput.getAdapter((Class)clazz);
        ISelection selection = editor.getSelectionProvider().getSelection();
        ClipboardData clipboardData = null;
        if (inputElement != null && selection instanceof ITextSelection && !selection.isEmpty() && this.isNonTrivialSelection(textSelection = (ITextSelection)selection)) {
            clipboardData = this.getClipboardData(inputElement, textSelection.getOffset(), textSelection.getLength());
        }
        this.fOperationTarget.doOperation(this.fOperationCode);
        if (clipboardData == null) return;
        Clipboard clipboard = new Clipboard(this.getDisplay());
        try {
            Object textData = clipboard.getContents((Transfer)TextTransfer.getInstance());
            Object rtfData = clipboard.getContents((Transfer)RTFTransfer.getInstance());
            ArrayList<Object> datas = new ArrayList<Object>(3);
            ArrayList<Object> transfers = new ArrayList<Object>(3);
            if (textData != null) {
                datas.add(textData);
                transfers.add(TextTransfer.getInstance());
            }
            if (rtfData != null) {
                datas.add(rtfData);
                transfers.add(RTFTransfer.getInstance());
            }
            datas.add(clipboardData);
            transfers.add((Object)fgTransferInstance);
            Transfer[] dataTypes = transfers.toArray(new Transfer[transfers.size()]);
            Object[] data = datas.toArray();
            this.setClipboardContents(clipboard, data, dataTypes);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            clipboard.dispose();
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        clipboard.dispose();
    }

    private void setClipboardContents(Clipboard clipboard, Object[] datas, Transfer[] transfers) {
        try {
            clipboard.setContents(datas, transfers);
            return;
        }
        catch (SWTError e) {
            if (e.code != 2002) {
                throw e;
            }
            return;
        }
    }

    private boolean isNonTrivialSelection(ITextSelection selection) {
        if (selection.getLength() < 30) {
            String text = selection.getText();
            int i = 0;
            while (i < text.length()) {
                if (!Character.isJavaIdentifierPart(text.charAt(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    private ClipboardData getClipboardData(IJavaElement inputElement, int offset, int length) {
        CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST(inputElement, true, null);
        if (astRoot == null) {
            return null;
        }
        List list = astRoot.imports();
        if (!list.isEmpty() ? offset < ((ASTNode)list.get(list.size() - 1)).getStartPosition() : astRoot.getPackage() != null && offset < astRoot.getPackage().getStartPosition()) {
            return null;
        }
        ArrayList res = new ArrayList();
        ImportReferencesCollector collector = new ImportReferencesCollector(new Region(offset, length), res);
        astRoot.accept((ASTVisitor)collector);
        HashSet<String> namesToImport = new HashSet<String>(res.size());
        int i = 0;
        while (i < res.size()) {
            SimpleName curr = (SimpleName)res.get(i);
            IBinding binding = curr.resolveBinding();
            if (binding != null && binding.getKind() == 2) {
                String name;
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getElementType();
                }
                if ((typeBinding.isMember() || typeBinding.isTopLevel()) && (name = typeBinding.getQualifiedName()).length() > 0) {
                    namesToImport.add(name);
                }
            }
            ++i;
        }
        if (namesToImport.isEmpty()) {
            return null;
        }
        return new ClipboardData(inputElement, namesToImport.toArray(new String[namesToImport.size()]));
    }

    /*
     * Exception decompiling
     */
    private void doPasteWithImportsOperation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 221->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addImports(ICompilationUnit unit, ClipboardData data) throws CoreException {
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        ImportsStructure importsStructure = new ImportsStructure(unit, settings.importOrder, settings.importThreshold, true);
        importsStructure.setFindAmbiguousImports(false);
        String[] imports = data.getImports();
        int i = 0;
        while (i < imports.length) {
            importsStructure.addImport(imports[i]);
            ++i;
        }
        importsStructure.create(false, null);
    }

    public static class ClipboardData {
        private String fOriginHandle;
        private String[] fImports;

        public ClipboardData(IJavaElement origin, String[] imports) {
            this.fImports = imports;
            this.fOriginHandle = origin.getHandleIdentifier();
        }

        public ClipboardData(byte[] bytes) throws IOException {
            DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(bytes));
            this.fOriginHandle = dataIn.readUTF();
            int count = dataIn.readInt();
            this.fImports = new String[count];
            int i = 0;
            while (i < count) {
                this.fImports[i] = dataIn.readUTF();
                ++i;
            }
            dataIn.close();
        }

        public String[] getImports() {
            return this.fImports;
        }

        public boolean isFromSame(IJavaElement elem) {
            return this.fOriginHandle.equals(elem.getHandleIdentifier());
        }

        public byte[] serialize() throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeUTF(this.fOriginHandle);
            dataOut.writeInt(this.fImports.length);
            int i = 0;
            while (i < this.fImports.length) {
                dataOut.writeUTF(this.fImports[i]);
                ++i;
            }
            dataOut.close();
            out.close();
            return out.toByteArray();
        }
    }

    private static class ClipboardTransfer
    extends ByteArrayTransfer {
        private static final String TYPE_NAME = "source-with-imports-transfer-format" + System.currentTimeMillis();
        private static final int TYPEID = Transfer.registerType((String)TYPE_NAME);

        ClipboardTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        protected void javaToNative(Object data, TransferData transferData) {
            if (data instanceof ClipboardData) {
                try {
                    super.javaToNative((Object)((ClipboardData)data).serialize(), transferData);
                }
                catch (IOException iOException) {}
            }
        }

        protected Object nativeToJava(TransferData transferData) {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            if (bytes != null) {
                try {
                    return new ClipboardData(bytes);
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

