/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.selectionactions;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.StructureSelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class StructureSelectNextAction
extends StructureSelectionAction {
    public StructureSelectNextAction(JavaEditor editor, SelectionHistory history) {
        super(JavaEditorMessages.getString("StructureSelectNext.label"), editor, history);
        this.setToolTipText(JavaEditorMessages.getString("StructureSelectNext.tooltip"));
        this.setDescription(JavaEditorMessages.getString("StructureSelectNext.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.structured_select_next_action");
    }

    public StructureSelectNextAction() {
    }

    ISourceRange internalGetNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws JavaModelException {
        ASTNode previousNode;
        if (oldSourceRange.getLength() == 0 && selAnalyzer.getLastCoveringNode() != null && (previousNode = NextNodeAnalyzer.perform(oldSourceRange.getOffset(), selAnalyzer.getLastCoveringNode())) != null) {
            return StructureSelectionAction.getSelectedNodeSourceRange(sr, previousNode);
        }
        ASTNode first = selAnalyzer.getFirstSelectedNode();
        if (first == null) {
            return StructureSelectionAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode parent = first.getParent();
        if (parent == null) {
            return StructureSelectionAction.getLastCoveringNodeRange(oldSourceRange, sr, selAnalyzer);
        }
        ASTNode lastSelectedNode = selAnalyzer.getSelectedNodes()[selAnalyzer.getSelectedNodes().length - 1];
        ASTNode nextNode = StructureSelectNextAction.getNextNode(parent, lastSelectedNode);
        if (nextNode == parent) {
            return StructureSelectionAction.getSelectedNodeSourceRange(sr, first.getParent());
        }
        int offset = oldSourceRange.getOffset();
        int end = Math.min(sr.getSourceRange().getLength(), nextNode.getStartPosition() + nextNode.getLength() - 1);
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ASTNode getNextNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectionAction.getChildNodes(parent);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[siblingNodes.length - 1]) {
            return parent;
        }
        return siblingNodes[StructureSelectionAction.findIndex(siblingNodes, node) + 1];
    }

    private static class NextNodeAnalyzer
    extends GenericVisitor {
        private final int fOffset;
        private ASTNode fNextNode;

        NextNodeAnalyzer(int offset) {
            super(true);
            this.fOffset = offset;
        }

        public static ASTNode perform(int offset, ASTNode lastCoveringNode) {
            NextNodeAnalyzer analyzer = new NextNodeAnalyzer(offset);
            lastCoveringNode.accept((ASTVisitor)analyzer);
            return analyzer.fNextNode;
        }

        protected boolean visitNode(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            if (start == this.fOffset) {
                this.fNextNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }
    }
}

