/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor.selectionactions;

import java.util.Collection;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public abstract class StructureSelectionAction
extends Action {
    public static final String NEXT = "SelectNextElement";
    public static final String PREVIOUS = "SelectPreviousElement";
    public static final String ENCLOSING = "SelectEnclosingElement";
    public static final String HISTORY = "RestoreLastSelection";
    private JavaEditor fEditor;
    private SelectionHistory fSelectionHistory;

    protected StructureSelectionAction(String text, JavaEditor editor, SelectionHistory history) {
        super(text);
        Assert.isNotNull((Object)editor);
        Assert.isNotNull((Object)history);
        this.fEditor = editor;
        this.fSelectionHistory = history;
    }

    protected StructureSelectionAction() {
        super("");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        if (!ActionUtil.isProcessable(this.fEditor.getEditorSite().getShell(), this.fEditor)) {
            return;
        }
        ITextSelection selection = this.getTextSelection();
        ISourceReference source = this.getSourceReference();
        try {
            ISourceRange sourceRange = source.getSourceRange();
            if (sourceRange == null || sourceRange.getLength() == 0) {
                MessageDialog.openInformation((Shell)this.fEditor.getEditorSite().getShell(), (String)JavaEditorMessages.getString("StructureSelect.error.title"), (String)JavaEditorMessages.getString("StructureSelect.error.message"));
                return;
            }
        }
        catch (JavaModelException javaModelException) {}
        ISourceRange newRange = this.getNewSelectionRange(StructureSelectionAction.createSourceRange(selection), source);
        if (selection.getOffset() == newRange.getOffset() && selection.getLength() == newRange.getLength()) {
            return;
        }
        this.fSelectionHistory.remember(new SourceRange(selection.getOffset(), selection.getLength()));
        try {
            this.fSelectionHistory.ignoreSelectionChanges();
            this.fEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fSelectionHistory.listenToSelectionChanges();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.fSelectionHistory.listenToSelectionChanges();
            return;
        }
    }

    public final ISourceRange getNewSelectionRange(ISourceRange oldSourceRange, ISourceReference sr) {
        try {
            if (!this.isStructureKnown(sr)) {
                return oldSourceRange;
            }
            CompilationUnit root = this.getAST(sr);
            if (root == null) {
                return oldSourceRange;
            }
            Selection selection = Selection.createFromStartLength(oldSourceRange.getOffset(), oldSourceRange.getLength());
            SelectionAnalyzer selAnalyzer = new SelectionAnalyzer(selection, true);
            root.accept((ASTVisitor)selAnalyzer);
            return this.internalGetNewSelectionRange(oldSourceRange, sr, selAnalyzer);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new SourceRange(oldSourceRange.getOffset(), oldSourceRange.getLength());
        }
    }

    abstract ISourceRange internalGetNewSelectionRange(ISourceRange var1, ISourceReference var2, SelectionAnalyzer var3) throws JavaModelException;

    protected final ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    protected static ISourceRange getLastCoveringNodeRange(ISourceRange oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws JavaModelException {
        if (selAnalyzer.getLastCoveringNode() == null) {
            return oldSourceRange;
        }
        return StructureSelectionAction.getSelectedNodeSourceRange(sr, selAnalyzer.getLastCoveringNode());
    }

    protected static ISourceRange getSelectedNodeSourceRange(ISourceReference sr, ASTNode nodeToSelect) throws JavaModelException {
        int offset = nodeToSelect.getStartPosition();
        int end = Math.min(sr.getSourceRange().getLength(), nodeToSelect.getStartPosition() + nodeToSelect.getLength() - 1);
        return StructureSelectionAction.createSourceRange(offset, end);
    }

    private static ISourceRange createSourceRange(ITextSelection ts) {
        return new SourceRange(ts.getOffset(), ts.getLength());
    }

    private ISourceReference getSourceReference() {
        IEditorInput input = this.fEditor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private boolean isStructureKnown(ISourceReference sr) throws JavaModelException {
        if (sr instanceof ICompilationUnit) {
            return ((ICompilationUnit)sr).isStructureKnown();
        }
        return true;
    }

    private CompilationUnit getAST(ISourceReference sr) {
        if (sr instanceof ICompilationUnit) {
            ASTParser p = ASTParser.newParser((int)2);
            p.setSource((ICompilationUnit)sr);
            return (CompilationUnit)p.createAST(null);
        }
        if (sr instanceof IClassFile) {
            ASTParser p = ASTParser.newParser((int)2);
            p.setSource((IClassFile)sr);
            return (CompilationUnit)p.createAST(null);
        }
        return null;
    }

    static ISourceRange createSourceRange(int offset, int end) {
        int length = end - offset + 1;
        if (length == 0) {
            length = 1;
        }
        return new SourceRange(Math.max(0, offset), length);
    }

    static ASTNode[] getChildNodes(ASTNode node) {
        if (node instanceof Block) {
            return StructureSelectionAction.convertToNodeArray(((Block)node).statements());
        }
        if (node instanceof TypeDeclaration) {
            return StructureSelectionAction.convertToNodeArray(((TypeDeclaration)node).bodyDeclarations());
        }
        if (node instanceof CompilationUnit) {
            return StructureSelectionAction.convertToNodeArray(((CompilationUnit)node).types());
        }
        return null;
    }

    private static ASTNode[] convertToNodeArray(Collection statements) {
        return statements.toArray(new ASTNode[statements.size()]);
    }

    static int findIndex(Object[] array, Object o) {
        int i = 0;
        while (i < array.length) {
            Object object = array[i];
            if (object == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

