/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightings;
import org.eclipse.jdt.internal.ui.preferences.ColorEditor;
import org.eclipse.jdt.internal.ui.preferences.FoldingConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.JavaEditorHoverConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.jdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchViewerSorter;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class JavaEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String COMPILER_TASK_TAGS = "org.eclipse.jdt.core.compiler.taskTags";
    private static final String DELIMITER = PreferencesMessages.getString("JavaEditorPreferencePage.navigation.delimiter");
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.getString("JavaEditorPreferencePage.multiLineComment"), "java_multi_line_comment"}, {PreferencesMessages.getString("JavaEditorPreferencePage.singleLineComment"), "java_single_line_comment"}, {PreferencesMessages.getString("JavaEditorPreferencePage.returnKeyword"), "java_keyword_return"}, {PreferencesMessages.getString("JavaEditorPreferencePage.keywords"), "java_keyword"}, {PreferencesMessages.getString("JavaEditorPreferencePage.strings"), "java_string"}, {PreferencesMessages.getString("JavaEditorPreferencePage.methodNames"), "java_method_name"}, {PreferencesMessages.getString("JavaEditorPreferencePage.operators"), "java_operator"}, {PreferencesMessages.getString("JavaEditorPreferencePage.others"), "java_default"}, {PreferencesMessages.getString("JavaEditorPreferencePage.javaCommentTaskTags"), "java_comment_task_tag"}, {PreferencesMessages.getString("JavaEditorPreferencePage.javaDocKeywords"), "java_doc_keyword"}, {PreferencesMessages.getString("JavaEditorPreferencePage.javaDocHtmlTags"), "java_doc_tag"}, {PreferencesMessages.getString("JavaEditorPreferencePage.javaDocLinks"), "java_doc_link"}, {PreferencesMessages.getString("JavaEditorPreferencePage.javaDocOthers"), "java_doc_default"}};
    private final String[][] fAppearanceColorListModel;
    private OverlayPreferenceStore fOverlayStore;
    private JavaEditorHoverConfigurationBlock fJavaEditorHoverConfigurationBlock;
    private FoldingConfigurationBlock fFoldingConfigurationBlock;
    private Map fColorButtons;
    private Map fCheckBoxes;
    private SelectionListener fCheckBoxListener;
    private Map fTextFields;
    private ModifyListener fTextFieldListener;
    private ArrayList fNumberFields;
    private ModifyListener fNumberFieldListener;
    private org.eclipse.swt.widgets.List fAppearanceColorList;
    private ColorEditor fSyntaxForegroundColorEditor;
    private ColorEditor fAppearanceColorEditor;
    private Button fAppearanceColorDefault;
    private ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    private Button fBackgroundCustomRadioButton;
    private Button fBackgroundColorButton;
    private Button fBoldCheckBox;
    private Button fEnableCheckbox;
    private Button fItalicCheckBox;
    private JavaSourceViewer fPreviewViewer;
    private Color fBackgroundColor;
    private Text fBrowserLikeLinksKeyModifierText;
    private Button fBrowserLikeLinksCheckBox;
    private StatusInfo fBrowserLikeLinksKeyModifierStatus;
    private boolean fFieldsInitialized;
    private ArrayList fMasterSlaveListeners;
    private final List fHighlightingColorList;
    private TableViewer fHighlightingColorListViewer;
    private static final int[] SEMANTIC_HIGHLIGHTING_ITEM_COLOR;
    private List fSemanticHighlightingColorList;
    private SemanticHighlightingManager fSemanticHighlightingManager;
    private boolean fIsSemanticHighlightingEnabled;

    static {
        int[] nArray = new int[3];
        nArray[2] = 128;
        SEMANTIC_HIGHLIGHTING_ITEM_COLOR = nArray;
    }

    public JavaEditorPreferencePage() {
        String[][] stringArrayArray = new String[8][];
        String[] stringArray = new String[3];
        stringArray[0] = PreferencesMessages.getString("JavaEditorPreferencePage.lineNumberForegroundColor");
        stringArray[1] = "lineNumberColor";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = PreferencesMessages.getString("JavaEditorPreferencePage.matchingBracketsHighlightColor2");
        stringArray2[1] = "matchingBracketsColor";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = PreferencesMessages.getString("JavaEditorPreferencePage.currentLineHighlighColor");
        stringArray3[1] = "currentLineColor";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = PreferencesMessages.getString("JavaEditorPreferencePage.printMarginColor2");
        stringArray4[1] = "printMarginColor";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = PreferencesMessages.getString("JavaEditorPreferencePage.findScopeColor2");
        stringArray5[1] = "AbstractTextEditor.Color.FindScope";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[0] = PreferencesMessages.getString("JavaEditorPreferencePage.linkColor2");
        stringArray6[1] = "linkColor";
        stringArrayArray[5] = stringArray6;
        stringArrayArray[6] = new String[]{PreferencesMessages.getString("JavaEditorPreferencePage.selectionForegroundColor"), "AbstractTextEditor.Color.SelectionForeground", "AbstractTextEditor.Color.SelectionForeground.SystemDefault"};
        stringArrayArray[7] = new String[]{PreferencesMessages.getString("JavaEditorPreferencePage.selectionBackgroundColor"), "AbstractTextEditor.Color.SelectionBackground", "AbstractTextEditor.Color.SelectionBackground.SystemDefault"};
        this.fAppearanceColorListModel = stringArrayArray;
        this.fColorButtons = new HashMap();
        this.fCheckBoxes = new HashMap();
        this.fCheckBoxListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                JavaEditorPreferencePage.this.fOverlayStore.setValue((String)JavaEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
            }
        };
        this.fTextFields = new HashMap();
        this.fTextFieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                JavaEditorPreferencePage.this.fOverlayStore.setValue((String)JavaEditorPreferencePage.this.fTextFields.get(text), text.getText());
            }
        };
        this.fNumberFields = new ArrayList();
        this.fNumberFieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaEditorPreferencePage.this.numberFieldChanged((Text)e.widget);
            }
        };
        this.fFieldsInitialized = false;
        this.fMasterSlaveListeners = new ArrayList();
        this.fHighlightingColorList = new ArrayList();
        this.fSemanticHighlightingColorList = new ArrayList();
        this.setDescription(PreferencesMessages.getString("JavaEditorPreferencePage.description"));
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        Color itemColor = JavaPlugin.getDefault().getJavaTextTools().getColorManager().getColor(new RGB(SEMANTIC_HIGHLIGHTING_ITEM_COLOR[0], SEMANTIC_HIGHLIGHTING_ITEM_COLOR[1], SEMANTIC_HIGHLIGHTING_ITEM_COLOR[2]));
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        int n = semanticHighlightings.length;
        while (i < n) {
            this.fSemanticHighlightingColorList.add(new SemanticHighlightingColorListItem(semanticHighlightings[i].getDisplayName(), SemanticHighlightings.getColorPreferenceKey(semanticHighlightings[i]), SemanticHighlightings.getBoldPreferenceKey(semanticHighlightings[i]), SemanticHighlightings.getItalicPreferenceKey(semanticHighlightings[i]), SemanticHighlightings.getEnabledPreferenceKey(semanticHighlightings[i]), itemColor));
            ++i;
        }
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Foreground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionForeground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionForeground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.SelectionBackground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.SelectionBackground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "tabWidth"));
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            String colorKey = this.fSyntaxColorListModel[i][1];
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, colorKey));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(colorKey) + BOLD));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, String.valueOf(colorKey) + ITALIC));
            ++i;
        }
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "matchingBracketsColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "matchingBrackets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Accessibility.UseCustomCarets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Accessibility.WideCaret"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.jdt.quickassist.lightbulb"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.FindScope"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "linkColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "JavaEditor.ShowTemporaryProblem"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "handleTemporaryProblems"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spacesForTabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smartPaste"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "importsOnPaste"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeStrings"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBrackets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeBraces"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "closeJavaDocs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "wrapStrings"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "escapeStrings"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "addJavaDocTags"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "subWordNavigation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "disable_overwrite_mode"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "browserLikeLinks"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "browserLikeLinksKeyModifier"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "browserLikeLinksKeyModifierMask"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_semicolon"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_tab"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "smart_opening_brace"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "semanticHighlighting.enabled"));
        i = 0;
        int n = this.fSemanticHighlightingColorList.size();
        while (i < n) {
            SemanticHighlightingColorListItem item = (SemanticHighlightingColorListItem)this.fSemanticHighlightingColorList.get(i);
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.getColorKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getBoldKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getItalicKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getEnableKey()));
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.java_editor_preference_page_context");
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.fOverlayStore.getBoolean(item.getItalicKey()));
        if (item instanceof SemanticHighlightingColorListItem) {
            this.fEnableCheckbox.setEnabled(true);
            boolean enable = this.fOverlayStore.getBoolean(((SemanticHighlightingColorListItem)item).getEnableKey());
            this.fEnableCheckbox.setSelection(enable);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
            this.fBoldCheckBox.setEnabled(enable);
            this.fItalicCheckBox.setEnabled(enable);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
        }
    }

    private void handleSemanticHighlightingEnabled() {
        boolean shouldBeEnabled = this.fOverlayStore.getBoolean("semanticHighlighting.enabled");
        if (shouldBeEnabled && !this.fIsSemanticHighlightingEnabled) {
            this.fHighlightingColorListViewer.getControl().setRedraw(false);
            this.fHighlightingColorList.addAll(this.fSemanticHighlightingColorList);
            this.fHighlightingColorListViewer.add(this.fSemanticHighlightingColorList.toArray());
            this.fHighlightingColorListViewer.getControl().setRedraw(true);
            this.fHighlightingColorListViewer.reveal((Object)this.getHighlightingColorListItem());
            this.fIsSemanticHighlightingEnabled = true;
        }
        if (!shouldBeEnabled && this.fIsSemanticHighlightingEnabled) {
            this.fHighlightingColorListViewer.getControl().setRedraw(false);
            int fullSize = this.fHighlightingColorList.size();
            this.fHighlightingColorList.removeAll(this.fSemanticHighlightingColorList);
            HighlightingColorListItem item = this.getHighlightingColorListItem();
            if (!this.fHighlightingColorList.contains(item)) {
                int i = 0;
                while (item != this.fHighlightingColorListViewer.getElementAt(i)) {
                    ++i;
                }
                while (!this.fHighlightingColorList.contains(this.fHighlightingColorListViewer.getElementAt(i)) && i < fullSize) {
                    ++i;
                }
                while (!this.fHighlightingColorList.contains(this.fHighlightingColorListViewer.getElementAt(i)) && i >= 0) {
                    --i;
                }
                this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(i)));
            }
            this.fHighlightingColorListViewer.remove(this.fSemanticHighlightingColorList.toArray());
            this.fHighlightingColorListViewer.getControl().setRedraw(true);
            this.fHighlightingColorListViewer.reveal((Object)this.getHighlightingColorListItem());
            this.fIsSemanticHighlightingEnabled = false;
        }
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[i][2]);
    }

    private void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.fOverlayStore.getBoolean(systemDefaultKey);
            this.fAppearanceColorDefault.setSelection(systemDefault);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
        }
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Group backgroundComposite = new Group(colorComposite, 16);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        backgroundComposite.setLayout((Layout)layout);
        backgroundComposite.setText(PreferencesMessages.getString("JavaEditorPreferencePage.backgroundColor"));
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = JavaEditorPreferencePage.this.fBackgroundCustomRadioButton.getSelection();
                JavaEditorPreferencePage.this.fBackgroundColorButton.setEnabled(custom);
                JavaEditorPreferencePage.this.fOverlayStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundDefaultRadioButton.setText(PreferencesMessages.getString("JavaEditorPreferencePage.systemDefault"));
        this.fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundCustomRadioButton = new Button((Composite)backgroundComposite, 16400);
        this.fBackgroundCustomRadioButton.setText(PreferencesMessages.getString("JavaEditorPreferencePage.custom"));
        this.fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundColorEditor = new ColorEditor((Composite)backgroundComposite);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        this.addCheckBox(colorComposite, PreferencesMessages.getString("JavaEditorPreferencePage.semanticHighlighting.option"), "semanticHighlighting.enabled", 0);
        Label label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.getString("JavaEditorPreferencePage.foreground"));
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer = new TableViewer(editorComposite, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fEnableCheckbox = new Button(stylesComposite, 32);
        this.fEnableCheckbox.setText(PreferencesMessages.getString("JavaEditorPreferencePage.enable"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fEnableCheckbox.setLayoutData((Object)gd);
        label = new Label(stylesComposite, 16384);
        label.setText(PreferencesMessages.getString("JavaEditorPreferencePage.color"));
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(32);
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.getString("JavaEditorPreferencePage.bold"));
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.getString("JavaEditorPreferencePage.italic"));
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.getString("JavaEditorPreferencePage.preview"));
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JavaEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorPreferencePage.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorPreferencePage.this.fOverlayStore, (String)item.getColorKey(), (RGB)JavaEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBackgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorPreferencePage.this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)JavaEditorPreferencePage.this.fBackgroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorPreferencePage.this.getHighlightingColorListItem();
                JavaEditorPreferencePage.this.fOverlayStore.setValue(item.getBoldKey(), JavaEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorPreferencePage.this.getHighlightingColorListItem();
                JavaEditorPreferencePage.this.fOverlayStore.setValue(item.getItalicKey(), JavaEditorPreferencePage.this.fItalicCheckBox.getSelection());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = JavaEditorPreferencePage.this.getHighlightingColorListItem();
                if (item instanceof SemanticHighlightingColorListItem) {
                    boolean enable = JavaEditorPreferencePage.this.fEnableCheckbox.getSelection();
                    JavaEditorPreferencePage.this.fOverlayStore.setValue(((SemanticHighlightingColorListItem)item).getEnableKey(), enable);
                    JavaEditorPreferencePage.this.fEnableCheckbox.setSelection(enable);
                    JavaEditorPreferencePage.this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
                    JavaEditorPreferencePage.this.fBoldCheckBox.setEnabled(enable);
                    JavaEditorPreferencePage.this.fItalicCheckBox.setEnabled(enable);
                    JavaEditorPreferencePage.this.uninstallSemanticHighlighting();
                    JavaEditorPreferencePage.this.installSemanticHighlighting();
                }
            }
        });
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.fOverlayStore, new PreferencesAdapter(this.createTemporaryCorePreferenceStore()), generalTextStore});
        this.fPreviewViewer = new JavaSourceViewer(parent, null, null, false, 2816, (IPreferenceStore)store);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        JavaSourceViewerConfiguration configuration = new JavaSourceViewerConfiguration(tools.getColorManager(), (IPreferenceStore)store, null, "___java_partitioning");
        this.fPreviewViewer.configure(configuration);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)store);
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(content);
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fPreviewViewer.setDocument((IDocument)document);
        this.installSemanticHighlighting();
        return this.fPreviewViewer.getControl();
    }

    private Preferences createTemporaryCorePreferenceStore() {
        Preferences result = new Preferences();
        result.setValue(COMPILER_TASK_TAGS, "TASK,TODO");
        return result;
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("JavaEditorPreferencePage.displayedTabWidth");
        this.addTextField(appearanceComposite, label, "tabWidth", 3, 0, true);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.printMarginColumn");
        this.addTextField(appearanceComposite, label, "printMarginColumn", 3, 0, true);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.showOverviewRuler");
        this.addCheckBox(appearanceComposite, label, "overviewRuler", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.showLineNumbers");
        this.addCheckBox(appearanceComposite, label, "lineNumberRuler", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.highlightMatchingBrackets");
        this.addCheckBox(appearanceComposite, label, "matchingBrackets", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.highlightCurrentLine");
        this.addCheckBox(appearanceComposite, label, "currentLine", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.showPrintMargin");
        this.addCheckBox(appearanceComposite, label, "printMargin", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.quickassist.lightbulb");
        this.addCheckBox(appearanceComposite, label, "org.eclipse.jdt.quickassist.lightbulb", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.showQuickFixables");
        this.addCheckBox(appearanceComposite, label, "JavaEditor.ShowTemporaryProblem", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.accessibility.disableCustomCarets");
        Button master = this.addCheckBox(appearanceComposite, label, "AbstractTextEditor.Accessibility.UseCustomCarets", 0);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.accessibility.wideCaret");
        Button slave = this.addCheckBox(appearanceComposite, label, "AbstractTextEditor.Accessibility.WideCaret", 0);
        this.createDependency(master, "AbstractTextEditor.Accessibility.UseCustomCarets", (Control)slave);
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(PreferencesMessages.getString("JavaEditorPreferencePage.appearanceOptions"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new org.eclipse.swt.widgets.List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText(PreferencesMessages.getString("JavaEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = JavaEditorPreferencePage.this.fAppearanceColorDefault.getSelection();
                JavaEditorPreferencePage.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = JavaEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = JavaEditorPreferencePage.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    JavaEditorPreferencePage.this.fOverlayStore.setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText(PreferencesMessages.getString("JavaEditorPreferencePage.systemDefault"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(colorDefaultSelectionListener);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JavaEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = JavaEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = JavaEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)JavaEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)JavaEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        return appearanceComposite;
    }

    private Control createTypingPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("JavaEditorPreferencePage.analyseAnnotationsWhileTyping");
        this.addCheckBox(composite, label, "handleTemporaryProblems", 0);
        this.addFiller(composite);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.overwriteMode");
        this.addCheckBox(composite, label, "disable_overwrite_mode", 1);
        this.addFiller(composite);
        Group group = new Group(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(PreferencesMessages.getString("JavaEditorPreferencePage.typing.description"));
        label = PreferencesMessages.getString("JavaEditorPreferencePage.wrapStrings");
        Button master = this.addCheckBox((Composite)group, label, "wrapStrings", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.escapeStrings");
        Button slave = this.addCheckBox((Composite)group, label, "escapeStrings", 1);
        this.createDependency(master, "wrapStrings", (Control)slave);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.smartPaste");
        this.addCheckBox((Composite)group, label, "smartPaste", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.importsOnPaste");
        this.addCheckBox((Composite)group, label, "importsOnPaste", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.insertSpaceForTabs");
        this.addCheckBox((Composite)group, label, "spacesForTabs", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.closeStrings");
        this.addCheckBox((Composite)group, label, "closeStrings", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.closeBrackets");
        this.addCheckBox((Composite)group, label, "closeBrackets", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.closeBraces");
        this.addCheckBox((Composite)group, label, "closeBraces", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.closeJavaDocs");
        master = this.addCheckBox((Composite)group, label, "closeJavaDocs", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.addJavaDocTags");
        slave = this.addCheckBox((Composite)group, label, "addJavaDocTags", 1);
        this.createDependency(master, "closeJavaDocs", (Control)slave);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.typing.smartSemicolon");
        this.addCheckBox((Composite)group, label, "smart_semicolon", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.typing.smartOpeningBrace");
        this.addCheckBox((Composite)group, label, "smart_opening_brace", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.typing.smartTab");
        this.addCheckBox((Composite)group, label, "smart_tab", 1);
        return composite;
    }

    private void addFiller(Composite composite) {
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    private void createDependency(final Button master, String masterKey, final Control slave) {
        JavaEditorPreferencePage.indent(slave);
        boolean masterState = this.fOverlayStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    private Control createNavigationPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("JavaEditorPreferencePage.smartHomeEnd");
        this.addCheckBox(composite, label, "AbstractTextEditor.Navigation.SmartHomeEnd", 1);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.subWordNavigation");
        this.addCheckBox(composite, label, "subWordNavigation", 1);
        this.addFiller(composite);
        label = PreferencesMessages.getString("JavaEditorPreferencePage.navigation.browserLikeLinks");
        this.fBrowserLikeLinksCheckBox = this.addCheckBox(composite, label, "browserLikeLinks", 0);
        this.fBrowserLikeLinksCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = JavaEditorPreferencePage.this.fBrowserLikeLinksCheckBox.getSelection();
                JavaEditorPreferencePage.this.fBrowserLikeLinksKeyModifierText.setEnabled(state);
                JavaEditorPreferencePage.this.handleBrowserLikeLinksKeyModifierModified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = PreferencesMessages.getString("JavaEditorPreferencePage.navigation.browserLikeLinksKeyModifier");
        this.fBrowserLikeLinksKeyModifierText = this.addTextField(composite, label, "browserLikeLinksKeyModifier", 20, 0, false);
        this.fBrowserLikeLinksKeyModifierText.setTextLimit(Text.LIMIT);
        if (this.computeStateMask(this.fOverlayStore.getString("browserLikeLinksKeyModifier")) == -1) {
            int stateMask = this.fOverlayStore.getInt("browserLikeLinksKeyModifierMask");
            if (stateMask == -1) {
                this.fBrowserLikeLinksKeyModifierText.setText("");
            } else {
                this.fBrowserLikeLinksKeyModifierText.setText(EditorUtility.getModifierString(stateMask));
            }
        }
        this.fBrowserLikeLinksKeyModifierText.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent e) {
                this.isModifierCandidate = e.keyCode > 0 && e.character == '\u0000' && e.stateMask == 0;
            }

            public void keyReleased(KeyEvent e) {
                if (this.isModifierCandidate && e.stateMask > 0 && e.stateMask == e.stateMask && e.character == '\u0000') {
                    boolean needsPostfixDelimiter;
                    String modifierString = JavaEditorPreferencePage.this.fBrowserLikeLinksKeyModifierText.getText();
                    Point selection = JavaEditorPreferencePage.this.fBrowserLikeLinksKeyModifierText.getSelection();
                    int i = selection.x - 1;
                    while (i > -1 && Character.isWhitespace(modifierString.charAt(i))) {
                        --i;
                    }
                    boolean needsPrefixDelimiter = i > -1 && !String.valueOf(modifierString.charAt(i)).equals(DELIMITER);
                    i = selection.y;
                    while (i < modifierString.length() && Character.isWhitespace(modifierString.charAt(i))) {
                        ++i;
                    }
                    boolean bl = needsPostfixDelimiter = i < modifierString.length() && !String.valueOf(modifierString.charAt(i)).equals(DELIMITER);
                    String insertString = needsPrefixDelimiter && needsPostfixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorPreferencePage.navigation.insertDelimiterAndModifierAndDelimiter", new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPrefixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorPreferencePage.navigation.insertDelimiterAndModifier", new String[]{Action.findModifierString((int)e.stateMask)}) : (needsPostfixDelimiter ? PreferencesMessages.getFormattedString("JavaEditorPreferencePage.navigation.insertModifierAndDelimiter", new String[]{Action.findModifierString((int)e.stateMask)}) : Action.findModifierString((int)e.stateMask)));
                    JavaEditorPreferencePage.this.fBrowserLikeLinksKeyModifierText.insert(insertString);
                }
            }
        });
        this.fBrowserLikeLinksKeyModifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaEditorPreferencePage.this.handleBrowserLikeLinksKeyModifierModified();
            }
        });
        return composite;
    }

    private void handleBrowserLikeLinksKeyModifierModified() {
        String modifiers = this.fBrowserLikeLinksKeyModifierText.getText();
        int stateMask = this.computeStateMask(modifiers);
        if (this.fBrowserLikeLinksCheckBox.getSelection() && (stateMask == -1 || (stateMask & 0x20000) != 0)) {
            this.fBrowserLikeLinksKeyModifierStatus = stateMask == -1 ? new StatusInfo(4, PreferencesMessages.getFormattedString("JavaEditorPreferencePage.navigation.modifierIsNotValid", modifiers)) : new StatusInfo(4, PreferencesMessages.getString("JavaEditorPreferencePage.navigation.shiftIsDisabled"));
            this.setValid(false);
            StatusUtil.applyToStatusLine((DialogPage)this, this.fBrowserLikeLinksKeyModifierStatus);
        } else {
            this.fBrowserLikeLinksKeyModifierStatus = new StatusInfo();
            this.updateStatus(this.fBrowserLikeLinksKeyModifierStatus);
        }
    }

    private IStatus getBrowserLikeLinksKeyModifierStatus() {
        if (this.fBrowserLikeLinksKeyModifierStatus == null) {
            this.fBrowserLikeLinksKeyModifierStatus = new StatusInfo();
        }
        return this.fBrowserLikeLinksKeyModifierStatus;
    }

    private int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = EditorUtility.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaultColors();
        this.fJavaEditorHoverConfigurationBlock = new JavaEditorHoverConfigurationBlock(this, this.fOverlayStore);
        this.fFoldingConfigurationBlock = new FoldingConfigurationBlock(this.fOverlayStore);
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.general"));
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.colors"));
        item.setControl(this.createSyntaxPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.typing.tabTitle"));
        item.setControl(this.createTypingPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.hoverTab.title"));
        item.setControl(this.fJavaEditorHoverConfigurationBlock.createControl((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.navigationTab.title"));
        item.setControl(this.createNavigationPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("JavaEditorPreferencePage.folding.title"));
        item.setControl(this.fFoldingConfigurationBlock.createControl((Composite)folder));
        this.initialize();
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fHighlightingColorList.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[i][1]) + ITALIC, null));
            ++i;
        }
        if (this.fOverlayStore.getBoolean("semanticHighlighting.enabled")) {
            this.fHighlightingColorList.addAll(this.fSemanticHighlightingColorList);
            this.fIsSemanticHighlightingEnabled = true;
        }
        this.fHighlightingColorListViewer.setInput((Object)this.fHighlightingColorList);
        this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(0)));
        this.fOverlayStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("semanticHighlighting.enabled".equals(event.getProperty())) {
                    JavaEditorPreferencePage.this.handleSemanticHighlightingEnabled();
                }
            }
        });
        i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (JavaEditorPreferencePage.this.fAppearanceColorList != null && !JavaEditorPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    JavaEditorPreferencePage.this.fAppearanceColorList.select(0);
                    JavaEditorPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
        this.fFoldingConfigurationBlock.initialize();
    }

    private void initializeFields() {
        String key;
        Iterator e = this.fColorButtons.keySet().iterator();
        while (e.hasNext()) {
            ColorEditor c = (ColorEditor)e.next();
            key = (String)this.fColorButtons.get(c);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            c.setColorValue(rgb);
        }
        e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean default_ = this.fOverlayStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundDefaultRadioButton.setSelection(default_);
        this.fBackgroundCustomRadioButton.setSelection(!default_);
        this.fBackgroundColorButton.setEnabled(!default_);
        this.fBrowserLikeLinksKeyModifierText.setEnabled(this.fBrowserLikeLinksCheckBox.getSelection());
        this.fFieldsInitialized = true;
        this.updateStatus(this.validatePositiveNumber("0"));
        Iterator iter = this.fMasterSlaveListeners.iterator();
        while (iter.hasNext()) {
            SelectionListener listener = (SelectionListener)iter.next();
            listener.widgetSelected(null);
        }
    }

    private void initializeDefaultColors() {
        RGB rgb;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Background")) {
            rgb = this.getControl().getDisplay().getSystemColor(25).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Background", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.Foreground")) {
            rgb = this.getControl().getDisplay().getSystemColor(24).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.Foreground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionBackground")) {
            rgb = this.getControl().getDisplay().getSystemColor(26).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionForeground")) {
            rgb = this.getControl().getDisplay().getSystemColor(27).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
        }
    }

    public boolean performOk() {
        this.fJavaEditorHoverConfigurationBlock.performOk();
        this.fFoldingConfigurationBlock.performOk();
        this.fOverlayStore.setValue("browserLikeLinksKeyModifierMask", this.computeStateMask(this.fBrowserLikeLinksKeyModifierText.getText()));
        this.fOverlayStore.propagate();
        JavaPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleSyntaxColorListSelection();
        this.handleAppearanceColorListSelection();
        this.fJavaEditorHoverConfigurationBlock.performDefaults();
        this.fFoldingConfigurationBlock.performDefaults();
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        this.uninstallSemanticHighlighting();
        this.fFoldingConfigurationBlock.dispose();
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        if (this.fBackgroundColor != null && !this.fBackgroundColor.isDisposed()) {
            this.fBackgroundColor.dispose();
        }
        super.dispose();
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Text addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        return JavaEditorPreferencePage.getTextControl(this.addLabelledTextField(composite, label, key, textLimit, indentation, isNumber));
    }

    private static Text getTextControl(Control[] labelledTextField) {
        return (Text)labelledTextField[1];
    }

    private Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    /*
     * Exception decompiling
     */
    private String loadPreviewContentFromFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 112->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("JavaEditorPreferencePage.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(PreferencesMessages.getFormattedString("JavaEditorPreferencePage.invalid_input", number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(PreferencesMessages.getFormattedString("JavaEditorPreferencePage.invalid_input", number));
            }
        }
        return status;
    }

    void updateStatus(IStatus status) {
        if (!this.fFieldsInitialized) {
            return;
        }
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = StatusUtil.getMoreSevere(s, status);
                ++i;
            }
        }
        status = StatusUtil.getMoreSevere(this.fJavaEditorHoverConfigurationBlock.getStatus(), status);
        status = StatusUtil.getMoreSevere(this.getBrowserLikeLinksKeyModifierStatus(), status);
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    private void installSemanticHighlighting() {
        if (this.fSemanticHighlightingManager == null) {
            this.fSemanticHighlightingManager = new SemanticHighlightingManager();
            this.fSemanticHighlightingManager.install(this.fPreviewViewer, JavaPlugin.getDefault().getJavaTextTools().getColorManager(), this.fOverlayStore, this.createPreviewerRanges());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticHighlightingManager != null) {
            this.fSemanticHighlightingManager.uninstall();
            this.fSemanticHighlightingManager = null;
        }
    }

    private SemanticHighlightingManager.HighlightedRange[][] createPreviewerRanges() {
        return new SemanticHighlightingManager.HighlightedRange[][]{{this.createHighlightedRange(6, 26, 8, "staticFinalField"), this.createHighlightedRange(6, 26, 8, "staticField"), this.createHighlightedRange(6, 26, 8, "field"), this.createHighlightedRange(6, 26, 8, "localVariableDeclaration")}, {this.createHighlightedRange(8, 20, 11, "staticField"), this.createHighlightedRange(8, 20, 11, "field"), this.createHighlightedRange(8, 20, 11, "localVariableDeclaration")}, {this.createHighlightedRange(10, 16, 5, "field"), this.createHighlightedRange(10, 16, 5, "localVariableDeclaration")}, {this.createHighlightedRange(12, 12, 3, "methodDeclarationName")}, {this.createHighlightedRange(12, 20, 9, "parameterVariable")}, {this.createHighlightedRange(13, 2, 14, "abstractMethodInvocation")}, {this.createHighlightedRange(14, 6, 5, "localVariableDeclaration")}, {this.createHighlightedRange(14, 16, 8, "inheritedMethodInvocation")}, {this.createHighlightedRange(15, 2, 12, "staticMethodInvocation")}, {this.createHighlightedRange(16, 13, 5, "localVariable")}};
    }

    private SemanticHighlightingManager.HighlightedRange createHighlightedRange(int line, int column, int length, String key) {
        try {
            IDocument document = this.fPreviewViewer.getDocument();
            int offset = document.getLineOffset(line) + column;
            return new SemanticHighlightingManager.HighlightedRange(offset, length, key);
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
            return null;
        }
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (HighlightingColorListItem)selection.getFirstElement();
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private Color fItemColor;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, Color itemColor) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fItemColor = itemColor;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public Color getItemColor() {
            return this.fItemColor;
        }
    }

    private static class SemanticHighlightingColorListItem
    extends HighlightingColorListItem {
        private final String fEnableKey;

        public SemanticHighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String enableKey, Color itemColor) {
            super(displayName, colorKey, boldKey, italicKey, itemColor);
            this.fEnableKey = enableKey;
        }

        public String getEnableKey() {
            return this.fEnableKey;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        ColorListLabelProvider() {
        }

        public String getText(Object element) {
            return ((HighlightingColorListItem)element).getDisplayName();
        }

        public Color getForeground(Object element) {
            return ((HighlightingColorListItem)element).getItemColor();
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class ColorListContentProvider
    implements IStructuredContentProvider {
        ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

