/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TodoTaskConfigurationBlock;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class TodoTaskInputDialog
extends StatusDialog {
    private StringDialogField fNameDialogField;
    private ComboDialogField fPriorityDialogField;
    private List fExistingNames;

    public TodoTaskInputDialog(Shell parent, TodoTaskConfigurationBlock.TodoTask task, List existingEntries) {
        super(parent);
        this.fExistingNames = new ArrayList(existingEntries.size());
        int i = 0;
        while (i < existingEntries.size()) {
            TodoTaskConfigurationBlock.TodoTask curr = (TodoTaskConfigurationBlock.TodoTask)existingEntries.get(i);
            if (!curr.equals(task)) {
                this.fExistingNames.add(curr.name);
            }
            ++i;
        }
        if (task == null) {
            this.setTitle(PreferencesMessages.getString("TodoTaskInputDialog.new.title"));
        } else {
            this.setTitle(PreferencesMessages.getString("TodoTaskInputDialog.edit.title"));
        }
        CompilerTodoTaskInputAdapter adapter = new CompilerTodoTaskInputAdapter();
        this.fNameDialogField = new StringDialogField();
        this.fNameDialogField.setLabelText(PreferencesMessages.getString("TodoTaskInputDialog.name.label"));
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText(task != null ? task.name : "");
        String[] items = new String[]{PreferencesMessages.getString("TodoTaskInputDialog.priority.high"), PreferencesMessages.getString("TodoTaskInputDialog.priority.normal"), PreferencesMessages.getString("TodoTaskInputDialog.priority.low")};
        this.fPriorityDialogField = new ComboDialogField(8);
        this.fPriorityDialogField.setLabelText(PreferencesMessages.getString("TodoTaskInputDialog.priority.label"));
        this.fPriorityDialogField.setItems(items);
        if (task != null) {
            if ("HIGH".equals(task.priority)) {
                this.fPriorityDialogField.selectItem(0);
            } else if ("NORMAL".equals(task.priority)) {
                this.fPriorityDialogField.selectItem(1);
            } else {
                this.fPriorityDialogField.selectItem(2);
            }
        } else {
            this.fPriorityDialogField.selectItem(1);
        }
    }

    public TodoTaskConfigurationBlock.TodoTask getResult() {
        TodoTaskConfigurationBlock.TodoTask task = new TodoTaskConfigurationBlock.TodoTask();
        task.name = this.fNameDialogField.getText().trim();
        switch (this.fPriorityDialogField.getSelectionIndex()) {
            case 0: {
                task.priority = "HIGH";
                break;
            }
            case 1: {
                task.priority = "NORMAL";
                break;
            }
            default: {
                task.priority = "LOW";
            }
        }
        return task;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fNameDialogField.doFillIntoGrid(inner, 2);
        this.fPriorityDialogField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), this.convertWidthInCharsToPixels(45));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status.setError(PreferencesMessages.getString("TodoTaskInputDialog.error.enterName"));
        } else if (newText.indexOf(44) != -1) {
            status.setError(PreferencesMessages.getString("TodoTaskInputDialog.error.comma"));
        } else if (this.fExistingNames.contains(newText)) {
            status.setError(PreferencesMessages.getString("TodoTaskInputDialog.error.entryExists"));
        } else if (Character.isWhitespace(newText.charAt(0)) || Character.isWhitespace(newText.charAt(newText.length() - 1))) {
            status.setError(PreferencesMessages.getString("TodoTaskInputDialog.error.noSpace"));
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.todo_task_input_dialog_context");
    }

    private class CompilerTodoTaskInputAdapter
    implements IDialogFieldListener {
        CompilerTodoTaskInputAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            TodoTaskInputDialog.this.doValidation();
        }
    }
}

