/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.progress.IProgressService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserLibraryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage";
    private IDialogSettings fDialogSettings;
    private TreeListDialogField fLibraryList;
    private IJavaProject fDummyProject;
    private static final int IDX_NEW = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_ADD = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_LOAD = 5;
    private static final int IDX_SAVE = 6;

    public UserLibraryPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fDummyProject = UserLibraryPreferencePage.getPlaceholderProject();
        this.setTitle(PreferencesMessages.getString("UserLibraryPreferencePage.title"));
        this.setDescription(PreferencesMessages.getString("UserLibraryPreferencePage.description"));
        this.noDefaultAndApplyButton();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        UserLibraryAdapter adapter = new UserLibraryAdapter();
        String[] stringArray = new String[7];
        stringArray[0] = PreferencesMessages.getString("UserLibraryPreferencePage.libraries.new.button");
        stringArray[1] = PreferencesMessages.getString("UserLibraryPreferencePage.libraries.edit.button");
        stringArray[2] = PreferencesMessages.getString("UserLibraryPreferencePage.libraries.addjar.button");
        stringArray[3] = PreferencesMessages.getString("UserLibraryPreferencePage.libraries.remove.button");
        stringArray[5] = PreferencesMessages.getString("UserLibraryPreferencePage.libraries.load.button");
        stringArray[6] = PreferencesMessages.getString("UserLibraryPreferencePage.libraries.save.button");
        String[] buttonLabels = stringArray;
        this.fLibraryList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibraryList.setLabelText(PreferencesMessages.getString("UserLibraryPreferencePage.libraries.label"));
        String[] names = JavaCore.getUserLibraryNames();
        ArrayList<CPUserLibraryElement> elements = new ArrayList<CPUserLibraryElement>();
        int i = 0;
        while (i < names.length) {
            IPath path = new Path("org.eclipse.jdt.USER_LIBRARY").append(names[i]);
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)this.fDummyProject);
                elements.add(new CPUserLibraryElement(names[i], container));
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
        this.fLibraryList.setElements(elements);
        this.fLibraryList.setViewerSorter(new CPListElementSorter());
        this.doSelectionChanged(this.fLibraryList);
    }

    public static IJavaProject getPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return JavaCore.create((IProject)project);
    }

    public UserLibraryPreferencePage(String selectedLibrary, boolean createIfNotFound) {
        this();
        if (selectedLibrary != null) {
            int nElements = this.fLibraryList.getSize();
            int i = 0;
            while (i < nElements) {
                CPUserLibraryElement curr = (CPUserLibraryElement)this.fLibraryList.getElement(i);
                if (curr.getName().equals(selectedLibrary)) {
                    this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)curr));
                    this.fLibraryList.expandElement(curr, -1);
                    break;
                }
                ++i;
            }
            if (createIfNotFound) {
                CPUserLibraryElement elem = new CPUserLibraryElement(selectedLibrary, null);
                this.fLibraryList.addElement(elem);
                this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)elem));
            }
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.cp_userlibraries_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibraryList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fLibraryList.getTreeControl(null));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            if (monitor != null) {
                                monitor = new NullProgressMonitor();
                            }
                            UserLibraryPreferencePage.this.updateUserLibararies(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String title = PreferencesMessages.getString("UserLibraryPreferencePage.config.error.title");
            String message = PreferencesMessages.getString("UserLibraryPreferencePage.config.error.message");
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        return true;
    }

    private void updateUserLibararies(IProgressMonitor monitor) throws CoreException {
        IPath path;
        List list = this.fLibraryList.getElements();
        HashSet<String> oldNames = new HashSet<String>(Arrays.asList(JavaCore.getUserLibraryNames()));
        int nExisting = list.size();
        HashSet<CPUserLibraryElement> newEntries = new HashSet<CPUserLibraryElement>(list.size());
        int i = 0;
        while (i < nExisting) {
            CPUserLibraryElement element = (CPUserLibraryElement)list.get(i);
            boolean contained = oldNames.remove(element.getName());
            if (!contained) {
                newEntries.add(element);
            }
            ++i;
        }
        int len = nExisting + oldNames.size();
        monitor.beginTask(PreferencesMessages.getString("UserLibraryPreferencePage.operation"), len);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.jdt.ui", 0, PreferencesMessages.getString("UserLibraryPreferencePage.operation.error"), null);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jdt.USER_LIBRARY");
        IJavaProject jproject = this.fDummyProject;
        IJavaProject[] projectInit = new IJavaProject[]{jproject};
        IClasspathContainer[] containerInit = new IClasspathContainer[1];
        ArrayList paths = new ArrayList();
        ArrayList urls = new ArrayList();
        int i2 = 0;
        while (i2 < nExisting) {
            CPUserLibraryElement element = (CPUserLibraryElement)list.get(i2);
            path = element.getPath();
            if (newEntries.contains(element) || element.hasChanges(JavaCore.getClasspathContainer((IPath)path, (IJavaProject)jproject))) {
                IClasspathContainer updatedContainer = element.getUpdatedContainer();
                try {
                    initializer.requestClasspathContainerUpdate(path, jproject, updatedContainer);
                    containerInit[0] = updatedContainer;
                    JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])projectInit, (IClasspathContainer[])containerInit, null);
                }
                catch (CoreException e) {
                    multiStatus.add(e.getStatus());
                }
            }
            element.collectJavaDocLocations(paths, urls);
            monitor.worked(1);
            ++i2;
        }
        containerInit[0] = null;
        Iterator<String> iter = oldNames.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            path = new Path("org.eclipse.jdt.USER_LIBRARY").append(name);
            try {
                initializer.requestClasspathContainerUpdate(path, jproject, null);
                JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])projectInit, (IClasspathContainer[])containerInit, null);
            }
            catch (CoreException e) {
                multiStatus.add(e.getStatus());
            }
            monitor.worked(1);
        }
        JavaUI.setLibraryJavadocLocations(paths.toArray(new IPath[paths.size()]), urls.toArray(new URL[paths.size()]));
        if (!multiStatus.isOK()) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private CPUserLibraryElement getSingleSelectedLibrary(List selected) {
        if (selected.size() == 1 && selected.get(0) instanceof CPUserLibraryElement) {
            return (CPUserLibraryElement)selected.get(0);
        }
        return null;
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("sourcepath")) {
            CPListElement selElement = elem.getParent();
            IClasspathEntry result = BuildPathDialogAccess.configureSourceAttachment(this.getShell(), selElement.getClasspathEntry());
            if (result != null) {
                selElement.setAttribute("sourcepath", result.getSourceAttachmentPath());
                this.fLibraryList.refresh();
            }
        } else if (key.equals("javadoc")) {
            CPListElement selElement = elem.getParent();
            URL initialLocation = (URL)selElement.getAttribute("javadoc");
            String elementName = new CPListLabelProvider().getText(selElement);
            URL[] result = BuildPathDialogAccess.configureJavadocLocation(this.getShell(), elementName, initialLocation);
            if (result != null) {
                selElement.setAttribute("javadoc", result[0]);
                this.fLibraryList.refresh();
            }
        }
    }

    protected void doSelectionChanged(TreeListDialogField field) {
        List list = field.getSelectedElements();
        field.enableButton(3, this.canRemove(list));
        field.enableButton(1, this.canEdit(list));
        field.enableButton(2, this.canAdd(list));
        field.enableButton(6, field.getSize() > 0);
    }

    protected void doCustomButtonPressed(TreeListDialogField field, int index) {
        if (index == 0) {
            this.editUserLibraryElement(null);
        } else if (index == 2) {
            this.doAdd(field.getSelectedElements());
        } else if (index == 3) {
            this.doRemove(field.getSelectedElements());
        } else if (index == 1) {
            this.doEdit(field.getSelectedElements());
        } else if (index == 6) {
            this.doSave();
        } else if (index == 5) {
            this.doLoad();
        }
    }

    protected void doDoubleClicked(TreeListDialogField field) {
        List selected = field.getSelectedElements();
        if (this.canEdit(selected)) {
            this.doEdit(field.getSelectedElements());
        }
    }

    protected void doKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.doRemove(selection);
        }
    }

    private void doEdit(List selected) {
        if (selected.size() == 1) {
            Object curr = selected.get(0);
            if (curr instanceof CPListElementAttribute) {
                this.editAttributeEntry((CPListElementAttribute)curr);
            } else if (curr instanceof CPUserLibraryElement) {
                this.editUserLibraryElement((CPUserLibraryElement)curr);
            } else if (curr instanceof CPListElement) {
                CPListElement elem = (CPListElement)curr;
                this.openExtJarFileDialog(elem, elem.getParentContainer());
            }
        }
    }

    private void editUserLibraryElement(CPUserLibraryElement element) {
        LibraryNameDialog dialog = new LibraryNameDialog(this.getShell(), element, this.fLibraryList.getElements());
        if (dialog.open() == 0) {
            CPUserLibraryElement newLibrary = dialog.getNewLibrary();
            if (element != null) {
                this.fLibraryList.replaceElement(element, newLibrary);
            } else {
                this.fLibraryList.addElement(newLibrary);
            }
            this.fLibraryList.expandElement(newLibrary, -1);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)newLibrary));
        }
    }

    private void editArchiveElement(CPListElement existingElement, CPUserLibraryElement parent) {
        CPListElement[] elements = this.openExtJarFileDialog(existingElement, parent);
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                if (existingElement != null) {
                    parent.replace(existingElement, elements[i]);
                } else {
                    parent.add(elements[i]);
                }
                ++i;
            }
            this.fLibraryList.refresh(parent);
            this.fLibraryList.expandElement(parent, -1);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)parent));
        }
    }

    private void doRemove(List selected) {
        Object selectionAfter = null;
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof CPUserLibraryElement) {
                this.fLibraryList.removeElement(curr);
            } else if (curr instanceof CPListElement) {
                Object parent = ((CPListElement)curr).getParentContainer();
                if (parent instanceof CPUserLibraryElement) {
                    CPUserLibraryElement elem = (CPUserLibraryElement)parent;
                    elem.remove((CPListElement)curr);
                    this.fLibraryList.refresh(elem);
                    selectionAfter = parent;
                }
            } else if (curr instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)curr;
                attrib.getParent().setAttribute(attrib.getKey(), null);
                this.fLibraryList.refresh(attrib);
            }
            ++i;
        }
        if (this.fLibraryList.getSelectedElements().isEmpty()) {
            if (selectionAfter != null) {
                this.fLibraryList.selectElements((ISelection)new StructuredSelection(selectionAfter));
            } else {
                this.fLibraryList.selectFirstElement();
            }
        }
    }

    private void doAdd(List list) {
        if (this.canAdd(list)) {
            CPUserLibraryElement element = this.getSingleSelectedLibrary(list);
            this.editArchiveElement(null, element);
        }
    }

    private void doLoad() {
        List existing = this.fLibraryList.getElements();
        LoadSaveDialog dialog = new LoadSaveDialog(this.getShell(), false, existing, this.fDialogSettings);
        if (dialog.open() == 0) {
            HashMap<String, CPUserLibraryElement> map = new HashMap<String, CPUserLibraryElement>(existing.size());
            int k = 0;
            while (k < existing.size()) {
                CPUserLibraryElement elem = (CPUserLibraryElement)existing.get(k);
                map.put(elem.getName(), elem);
                ++k;
            }
            List list = dialog.getLoadedLibraries();
            int i = 0;
            while (i < list.size()) {
                CPUserLibraryElement elem = (CPUserLibraryElement)list.get(i);
                CPUserLibraryElement found = (CPUserLibraryElement)map.get(elem.getName());
                if (found == null) {
                    existing.add(elem);
                    map.put(elem.getName(), elem);
                } else {
                    existing.set(existing.indexOf(found), elem);
                }
                ++i;
            }
            this.fLibraryList.setElements(existing);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(list));
        }
    }

    private void doSave() {
        LoadSaveDialog dialog = new LoadSaveDialog(this.getShell(), true, this.fLibraryList.getElements(), this.fDialogSettings);
        dialog.open();
    }

    private boolean canAdd(List list) {
        return this.getSingleSelectedLibrary(list) != null;
    }

    private boolean canEdit(List list) {
        return list.size() == 1;
    }

    private boolean canRemove(List list) {
        return !list.isEmpty();
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing, Object parent) {
        String res;
        String lastUsedPath;
        if (existing != null) {
            lastUsedPath = existing.getPath().removeLastSegments(1).toOSString();
        } else {
            lastUsedPath = this.fDialogSettings.get("org.eclipse.jdt.ui.lastextjar");
            if (lastUsedPath == null) {
                lastUsedPath = "";
            }
        }
        String title = existing == null ? PreferencesMessages.getString("UserLibraryPreferencePage.browsejar.new.title") : PreferencesMessages.getString("UserLibraryPreferencePage.browsejar.edit.title");
        FileDialog dialog = new FileDialog(this.getShell(), existing == null ? 2 : 4);
        dialog.setText(title);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        if (existing != null) {
            dialog.setFileName(existing.getPath().lastSegment());
        }
        if ((res = dialog.open()) == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        CPListElement[] elems = new CPListElement[nChosen];
        int i = 0;
        while (i < nChosen) {
            IPath path = filterPath.append(fileNames[i]).makeAbsolute();
            CPListElement curr = new CPListElement(parent, null, 1, path, null);
            curr.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(curr));
            curr.setAttribute("javadoc", JavaUI.getLibraryJavadocLocation(curr.getPath()));
            elems[i] = curr;
            ++i;
        }
        this.fDialogSettings.put("org.eclipse.jdt.ui.lastextjar", filterPath.toOSString());
        return elems;
    }

    public static class LibraryNameDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fNameField;
        private SelectionButtonDialogField fIsSystemField;
        private CPUserLibraryElement fElementToEdit;
        private List fExistingLibraries;

        public LibraryNameDialog(Shell parent, CPUserLibraryElement elementToEdit, List existingLibraries) {
            super(parent);
            if (elementToEdit == null) {
                this.setTitle(PreferencesMessages.getString("UserLibraryPreferencePage.LibraryNameDialog.new.title"));
            } else {
                this.setTitle(PreferencesMessages.getString("UserLibraryPreferencePage.LibraryNameDialog.edit.title"));
            }
            this.fElementToEdit = elementToEdit;
            this.fExistingLibraries = existingLibraries;
            this.fNameField = new StringDialogField();
            this.fNameField.setDialogFieldListener(this);
            this.fNameField.setLabelText(PreferencesMessages.getString("UserLibraryPreferencePage.LibraryNameDialog.name.label"));
            this.fIsSystemField = new SelectionButtonDialogField(32);
            this.fIsSystemField.setLabelText(PreferencesMessages.getString("UserLibraryPreferencePage.LibraryNameDialog.issystem.label"));
            if (elementToEdit != null) {
                this.fNameField.setText(elementToEdit.getName());
                this.fIsSystemField.setSelection(elementToEdit.isSystemLibrary());
            } else {
                this.fNameField.setText("");
                this.fIsSystemField.setSelection(false);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fNameField, this.fIsSystemField}, true, -1, -1);
            this.fNameField.postSetFocusOnDialogField(parent.getDisplay());
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fNameField) {
                this.updateStatus(this.validateSettings());
            }
        }

        private IStatus validateSettings() {
            String name = this.fNameField.getText();
            if (name.length() == 0) {
                return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LibraryNameDialog.name.error.entername"));
            }
            int i = 0;
            while (i < this.fExistingLibraries.size()) {
                CPUserLibraryElement curr = (CPUserLibraryElement)this.fExistingLibraries.get(i);
                if (curr != this.fElementToEdit && name.equals(curr.getName())) {
                    return new StatusInfo(4, PreferencesMessages.getFormattedString("UserLibraryPreferencePage.LibraryNameDialog.name.error.exists", name));
                }
                ++i;
            }
            IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (status.matches(4)) {
                return new StatusInfo(4, "Name contains invalid characters.");
            }
            return StatusInfo.OK_STATUS;
        }

        public CPUserLibraryElement getNewLibrary() {
            CPListElement[] entries = null;
            if (this.fElementToEdit != null) {
                entries = this.fElementToEdit.getChildren();
            }
            return new CPUserLibraryElement(this.fNameField.getText(), this.fIsSystemField.isSelected(), entries);
        }
    }

    public static class LoadSaveDialog
    extends StatusDialog
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private static final String CURRENT_VERSION = "1";
        private static final String TAG_ROOT = "eclipse-userlibraries";
        private static final String TAG_VERSION = "version";
        private static final String TAG_LIBRARY = "library";
        private static final String TAG_SOURCEATTACHMENT = "source";
        private static final String TAG_ARCHIVE_PATH = "path";
        private static final String TAG_ARCHIVE = "archive";
        private static final String TAG_SYSTEMLIBRARY = "systemlibrary";
        private static final String TAG_NAME = "name";
        private static final String TAG_JAVADOC = "javadoc";
        private static final String PREF_LASTPATH = "org.eclipse.jdt.ui.lastuserlibrary";
        private static final String PREF_USER_LIBRARY_LOADSAVE_SIZE = "UserLibraryLoadSaveDialog.size";
        private List fExistingLibraries;
        private IDialogSettings fSettings;
        private File fLastFile;
        private StringButtonDialogField fLocationField;
        private CheckedListDialogField fExportImportList;
        private Point fInitialSize;
        private final boolean fIsSave;

        public LoadSaveDialog(Shell shell, boolean isSave, List existingLibraries, IDialogSettings dialogSettings) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
            PixelConverter converter = new PixelConverter((Control)shell);
            this.fExistingLibraries = existingLibraries;
            this.fSettings = dialogSettings;
            this.fLastFile = null;
            this.fIsSave = isSave;
            int defaultWidth = converter.convertWidthInCharsToPixels(80);
            int defaultHeigth = converter.convertHeightInCharsToPixels(34);
            String lastSize = this.fSettings.get(PREF_USER_LIBRARY_LOADSAVE_SIZE);
            this.fInitialSize = lastSize != null ? StringConverter.asPoint((String)lastSize, (Point)new Point(defaultWidth, defaultHeigth)) : new Point(defaultWidth, defaultHeigth);
            if (this.isSave()) {
                this.setTitle(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.save.title"));
            } else {
                this.setTitle(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.load.title"));
            }
            this.fLocationField = new StringButtonDialogField(this);
            this.fLocationField.setLabelText(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.location.label"));
            this.fLocationField.setButtonLabel(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.location.button"));
            this.fLocationField.setDialogFieldListener(this);
            String[] buttonNames = new String[]{PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.list.selectall.button"), PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.list.deselectall.button")};
            this.fExportImportList = new CheckedListDialogField(this, buttonNames, (ILabelProvider)new CPListLabelProvider());
            this.fExportImportList.setCheckAllButtonIndex(0);
            this.fExportImportList.setUncheckAllButtonIndex(1);
            this.fExportImportList.setViewerSorter(new CPListElementSorter());
            if (this.isSave()) {
                this.fExportImportList.setLabelText(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.list.save.label"));
                this.fExportImportList.setElements(this.fExistingLibraries);
                this.fExportImportList.checkAll(true);
            } else {
                this.fExportImportList.setLabelText(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.list.load.label"));
            }
            String lastPath = this.fSettings.get(PREF_LASTPATH);
            if (lastPath != null) {
                this.fLocationField.setText(lastPath);
            } else {
                this.fLocationField.setText("");
            }
        }

        protected Point getInitialSize() {
            return this.fInitialSize;
        }

        private boolean isSave() {
            return this.fIsSave;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            DialogField[] fields = this.isSave() ? new DialogField[]{this.fExportImportList, this.fLocationField} : new DialogField[]{this.fLocationField, this.fExportImportList};
            LayoutUtil.doDefaultLayout(composite, fields, true, -1, -1);
            this.fExportImportList.getListControl(null).setLayoutData((Object)new GridData(1808));
            this.fLocationField.postSetFocusOnDialogField(parent.getDisplay());
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void changeControlPressed(DialogField field) {
            String fileName;
            String label = this.isSave() ? PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.filedialog.save.title") : PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.filedialog.load.title");
            FileDialog dialog = new FileDialog(this.getShell(), this.isSave() ? 8192 : 4096);
            dialog.setText(label);
            dialog.setFilterExtensions(new String[]{"*.userlibraries", "*.*"});
            String lastPath = this.fLocationField.getText();
            if (lastPath.length() == 0 || !new File(lastPath).exists()) {
                lastPath = this.fSettings.get(PREF_LASTPATH);
            }
            if (lastPath != null) {
                dialog.setFileName(lastPath);
            }
            if ((fileName = dialog.open()) != null) {
                this.fSettings.put(PREF_LASTPATH, fileName);
                this.fLocationField.setText(fileName);
            }
        }

        private IStatus updateShownLibraries(IStatus status) {
            if (!status.isOK()) {
                this.fExportImportList.removeAllElements();
                this.fExportImportList.setEnabled(false);
                this.fLastFile = null;
            } else {
                File file = new File(this.fLocationField.getText());
                if (!file.equals(this.fLastFile)) {
                    this.fLastFile = file;
                    try {
                        List elements = LoadSaveDialog.loadLibraries(file);
                        this.fExportImportList.setElements(elements);
                        this.fExportImportList.checkAll(true);
                        this.fExportImportList.setEnabled(true);
                        if (elements.isEmpty()) {
                            return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.error.empty"));
                        }
                    }
                    catch (IOException iOException) {
                        this.fExportImportList.removeAllElements();
                        this.fExportImportList.setEnabled(false);
                        return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.error.invalidfile"));
                    }
                }
            }
            return status;
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fLocationField) {
                IStatus status = this.validateSettings();
                if (!this.isSave()) {
                    status = this.updateShownLibraries(status);
                }
                this.updateStatus(status);
            } else if (field == this.fExportImportList) {
                this.updateStatus(this.validateSettings());
            }
        }

        public void customButtonPressed(ListDialogField field, int index) {
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void doubleClicked(ListDialogField field) {
            List selectedElements = this.fExportImportList.getSelectedElements();
            if (selectedElements.size() == 1) {
                Object elem;
                this.fExportImportList.setChecked(elem, !this.fExportImportList.isChecked(elem = selectedElements.get(0)));
            }
        }

        protected void okPressed() {
            if (this.isSave()) {
                File file = new File(this.fLocationField.getText());
                if (file.exists()) {
                    String title = PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.overwrite.title");
                    String message = PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.overwrite.message");
                    if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
                        return;
                    }
                }
                List elements = this.fExportImportList.getCheckedElements();
                IProgressService context = PlatformUI.getWorkbench().getProgressService();
                try {
                    context.run(true, true, new IRunnableWithProgress(this, elements, file){
                        final /* synthetic */ LoadSaveDialog this$1;
                        private final /* synthetic */ List val$elements;
                        private final /* synthetic */ File val$file;
                        {
                            this.this$1 = loadSaveDialog;
                            this.val$elements = list;
                            this.val$file = file;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                LoadSaveDialog.saveLibraries(this.val$elements, this.val$file, monitor);
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                    this.fSettings.put(PREF_LASTPATH, file.getPath());
                }
                catch (InvocationTargetException e) {
                    String errorTitle = PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.save.errordialog.title");
                    String errorMessage = PreferencesMessages.getFormattedString("UserLibraryPreferencePage.LoadSaveDialog.save.errordialog.message", e.getMessage());
                    ExceptionHandler.handle(e, this.getShell(), errorTitle, errorMessage);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                String savedTitle = PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.save.ok.title");
                String savedMessage = PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.save.ok.message");
                MessageDialog.openInformation((Shell)this.getShell(), (String)savedTitle, (String)savedMessage);
            } else {
                HashSet<String> map = new HashSet<String>(this.fExistingLibraries.size());
                int k = 0;
                while (k < this.fExistingLibraries.size()) {
                    CPUserLibraryElement elem = (CPUserLibraryElement)this.fExistingLibraries.get(k);
                    map.add(elem.getName());
                    ++k;
                }
                int nReplaced = 0;
                List elements = this.getLoadedLibraries();
                int i = 0;
                while (i < elements.size()) {
                    CPUserLibraryElement curr = (CPUserLibraryElement)elements.get(i);
                    if (map.contains(curr.getName())) {
                        ++nReplaced;
                    }
                    ++i;
                }
                if (nReplaced > 0) {
                    String replaceTitle = PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.load.replace.title");
                    String replaceMessage = nReplaced == 1 ? PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.load.replace.message") : PreferencesMessages.getFormattedString("UserLibraryPreferencePage.LoadSaveDialog.load.replace.multiple.message", String.valueOf(nReplaced));
                    if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)replaceTitle, (String)replaceMessage)) {
                        return;
                    }
                }
            }
            super.okPressed();
        }

        public boolean close() {
            Point point = this.getShell().getSize();
            this.fSettings.put(PREF_USER_LIBRARY_LOADSAVE_SIZE, StringConverter.asString((Point)point));
            return super.close();
        }

        private IStatus validateSettings() {
            String name = this.fLocationField.getText();
            this.fLastFile = null;
            if (this.isSave()) {
                if (name.length() == 0) {
                    return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.location.error.save.enterlocation"));
                }
                File file = new File(name);
                if (file.isDirectory()) {
                    return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.location.error.save.invalid"));
                }
                if (this.fExportImportList.getCheckedSize() == 0) {
                    return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.list.error.save.nothingselected"));
                }
                this.fLastFile = file;
            } else {
                if (name.length() == 0) {
                    return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.location.error.load.enterlocation"));
                }
                if (!new File(name).isFile()) {
                    return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.location.error.load.invalid"));
                }
                if (this.fExportImportList.getSize() > 0 && this.fExportImportList.getCheckedSize() == 0) {
                    return new StatusInfo(4, PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.list.error.load.nothingselected"));
                }
            }
            return new StatusInfo();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected static void saveLibraries(List libraries, File file, IProgressMonitor monitor) throws IOException {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                try {
                    DocumentBuilder docBuilder = null;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    docBuilder = factory.newDocumentBuilder();
                    Document document = docBuilder.newDocument();
                    Element rootElement = document.createElement(TAG_ROOT);
                    document.appendChild(rootElement);
                    rootElement.setAttribute(TAG_VERSION, CURRENT_VERSION);
                    int i = 0;
                    block9: while (true) {
                        block15: {
                            if (i < libraries.size()) break block15;
                            Transformer transformer = TransformerFactory.newInstance().newTransformer();
                            transformer.setOutputProperty("method", "xml");
                            transformer.setOutputProperty("encoding", "UTF-8");
                            transformer.setOutputProperty("indent", "yes");
                            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                            DOMSource source = new DOMSource(document);
                            StreamResult result = new StreamResult(stream);
                            transformer.transform(source, result);
                            break;
                        }
                        Element libraryElement = document.createElement(TAG_LIBRARY);
                        rootElement.appendChild(libraryElement);
                        CPUserLibraryElement curr = (CPUserLibraryElement)libraries.get(i);
                        libraryElement.setAttribute(TAG_NAME, curr.getName());
                        libraryElement.setAttribute(TAG_SYSTEMLIBRARY, String.valueOf(curr.isSystemLibrary()));
                        CPListElement[] children = curr.getChildren();
                        int k = 0;
                        while (true) {
                            URL javadocLocation;
                            if (k >= children.length) {
                                ++i;
                                continue block9;
                            }
                            CPListElement child = children[k];
                            Element childElement = document.createElement(TAG_ARCHIVE);
                            libraryElement.appendChild(childElement);
                            childElement.setAttribute(TAG_ARCHIVE_PATH, child.getPath().toOSString());
                            IPath sourceAttachment = (IPath)child.getAttribute("sourcepath");
                            if (sourceAttachment != null) {
                                childElement.setAttribute(TAG_SOURCEATTACHMENT, sourceAttachment.toOSString());
                            }
                            if ((javadocLocation = (URL)child.getAttribute(TAG_JAVADOC)) != null) {
                                childElement.setAttribute(TAG_JAVADOC, javadocLocation.toExternalForm());
                            }
                            ++k;
                        }
                        break;
                    }
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
                catch (TransformerException e) {
                    throw new IOException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var17_21 = null;
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
                if (monitor == null) throw throwable;
                monitor.done();
                throw throwable;
            }
            {
                Object var17_22 = null;
            }
            try {}
            catch (IOException iOException) {}
            ((OutputStream)stream).close();
            if (monitor == null) return;
            monitor.done();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static List loadLibraries(File file) throws IOException {
            Element cpElement;
            FileInputStream stream = new FileInputStream(file);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(stream)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.load.badformat"));
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.load.badformat"));
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                ((InputStream)stream).close();
                throw throwable;
            }
            {
                Object var4_7 = null;
            }
            ((InputStream)stream).close();
            if (!cpElement.getNodeName().equalsIgnoreCase(TAG_ROOT)) {
                throw new IOException(PreferencesMessages.getString("UserLibraryPreferencePage.LoadSaveDialog.load.badformat"));
            }
            NodeList libList = cpElement.getElementsByTagName(TAG_LIBRARY);
            int length = libList.getLength();
            ArrayList<CPUserLibraryElement> result = new ArrayList<CPUserLibraryElement>(length);
            int i = 0;
            while (i < length) {
                Node lib = libList.item(i);
                if (lib instanceof Element) {
                    Element libElement = (Element)lib;
                    String name = libElement.getAttribute(TAG_NAME);
                    boolean isSystem = Boolean.valueOf(libElement.getAttribute(TAG_SYSTEMLIBRARY));
                    CPUserLibraryElement newLibrary = new CPUserLibraryElement(name, isSystem, null);
                    result.add(newLibrary);
                    NodeList archiveList = libElement.getElementsByTagName(TAG_ARCHIVE);
                    int k = 0;
                    while (k < archiveList.getLength()) {
                        Node archiveNode = archiveList.item(k);
                        if (archiveNode instanceof Element) {
                            Element archiveElement = (Element)archiveNode;
                            String path = archiveElement.getAttribute(TAG_ARCHIVE_PATH);
                            CPListElement newArchive = new CPListElement(newLibrary, null, 1, (IPath)new Path(path), null);
                            newLibrary.add(newArchive);
                            if (archiveElement.hasAttribute(TAG_SOURCEATTACHMENT)) {
                                Path sourceAttach = new Path(archiveElement.getAttribute(TAG_SOURCEATTACHMENT));
                                newArchive.setAttribute("sourcepath", sourceAttach);
                            }
                            if (archiveElement.hasAttribute(TAG_JAVADOC)) {
                                try {
                                    URL javadoc = new URL(archiveElement.getAttribute(TAG_JAVADOC));
                                    newArchive.setAttribute(TAG_JAVADOC, javadoc);
                                }
                                catch (MalformedURLException malformedURLException) {}
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            return result;
        }

        public List getLoadedLibraries() {
            return this.fExportImportList.getCheckedElements();
        }
    }

    private class UserLibraryAdapter
    implements ITreeListAdapter {
        private final Object[] EMPTY = new Object[0];

        UserLibraryAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            UserLibraryPreferencePage.this.doCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            UserLibraryPreferencePage.this.doSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            UserLibraryPreferencePage.this.doDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            UserLibraryPreferencePage.this.doKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPUserLibraryElement) {
                CPUserLibraryElement elem = (CPUserLibraryElement)element;
                return elem.getChildren();
            }
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            return this.EMPTY;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getParentContainer();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }
    }
}

