/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.search.JavaSearchOperation;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultCollector;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.internal.ui.search.PrettySignature;
import org.eclipse.jdt.internal.ui.search.ReferenceScopeFactory;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jdt.ui.search.ElementQuerySpecification;
import org.eclipse.jdt.ui.search.PatternQuerySpecification;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaSearchPage
extends DialogPage
implements ISearchPage,
IJavaSearchConstants {
    public static final String PARTICIPANT_EXTENSION_POINT = "org.eclipse.jdt.ui.queryParticipants";
    public static final String EXTENSION_POINT_ID = "org.eclipse.jdt.ui.JavaSearchPage";
    public static final String PREF_SEARCH_JRE = "org.eclipse.jdt.ui.searchJRE";
    private static final String PAGE_NAME = "JavaSearchPage";
    private static final String STORE_CASE_SENSITIVE = "JavaSearchPageCASE_SENSITIVE";
    private static List fgPreviousSearchPatterns = new ArrayList(20);
    private SearchPatternData fInitialData;
    private IStructuredSelection fStructuredSelection;
    private IJavaElement fJavaElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private Button[] fSearchFor;
    private String[] fSearchForText = new String[]{SearchMessages.getString("SearchPage.searchFor.type"), SearchMessages.getString("SearchPage.searchFor.method"), SearchMessages.getString("SearchPage.searchFor.package"), SearchMessages.getString("SearchPage.searchFor.constructor"), SearchMessages.getString("SearchPage.searchFor.field")};
    private Button[] fLimitTo;
    private String[] fLimitToText = new String[]{SearchMessages.getString("SearchPage.limitTo.declarations"), SearchMessages.getString("SearchPage.limitTo.implementors"), SearchMessages.getString("SearchPage.limitTo.references"), SearchMessages.getString("SearchPage.limitTo.allOccurrences"), SearchMessages.getString("SearchPage.limitTo.readReferences"), SearchMessages.getString("SearchPage.limitTo.writeReferences")};
    private Button fSearchJRE;
    private static final int INDEX_REFERENCES = 2;
    private static final int INDEX_ALL = 3;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean performAction() {
        if (JavaPlugin.useNewSearch()) {
            return this.performNewSearch();
        }
        return this.performOldSearch();
    }

    private boolean performOldSearch() {
        SearchUI.activateSearchResultView();
        SearchPatternData data = this.getPatternData();
        IWorkspace workspace = JavaPlugin.getWorkspace();
        IJavaSearchScope scope = null;
        String scopeDescription = "";
        boolean includeJRE = false;
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scopeDescription = SearchMessages.getString("WorkspaceScope");
                scope = SearchEngine.createWorkspaceScope();
                break;
            }
            case 1: {
                scopeDescription = SearchMessages.getString("SelectionScope");
                scope = JavaSearchScopeFactory.getInstance().createJavaSearchScope((ISelection)this.fStructuredSelection, includeJRE);
                break;
            }
            case 3: {
                scope = JavaSearchScopeFactory.getInstance().createJavaProjectSearchScope((ISelection)this.fStructuredSelection, includeJRE);
                IProject[] projects = JavaSearchScopeFactory.getInstance().getProjects(scope);
                if (projects.length > 1) {
                    scopeDescription = SearchMessages.getFormattedString("EnclosingProjectsScope", projects[0].getName());
                    break;
                }
                if (projects.length == 1) {
                    scopeDescription = SearchMessages.getFormattedString("EnclosingProjectScope", projects[0].getName());
                    break;
                }
                scopeDescription = SearchMessages.getFormattedString("EnclosingProjectScope", "");
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = SearchMessages.getFormattedString("WorkingSetScope", SearchUtil.toString(workingSets));
                scope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(this.getContainer().getSelectedWorkingSets(), includeJRE);
                SearchUtil.updateLRUWorkingSets(this.getContainer().getSelectedWorkingSets());
            }
        }
        JavaSearchResultCollector collector = new JavaSearchResultCollector();
        JavaSearchOperation op = null;
        if (data.getJavaElement() != null && this.getPattern().equals(this.fInitialData.getPattern())) {
            op = new JavaSearchOperation(workspace, data.getJavaElement(), data.getLimitTo(), scope, scopeDescription, collector);
            if (data.getLimitTo() == 2) {
                SearchUtil.warnIfBinaryConstant(data.getJavaElement(), this.getShell());
            }
        } else {
            data.setJavaElement(null);
            op = new JavaSearchOperation(workspace, data.getPattern(), data.isCaseSensitive(), data.getSearchFor(), data.getLimitTo(), scope, scopeDescription, collector);
        }
        Shell shell = this.getControl().getShell();
        try {
            this.getContainer().getRunnableContext().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ex) {
            ExceptionHandler.handle(ex, shell, SearchMessages.getString("Search.Error.search.title"), SearchMessages.getString("Search.Error.search.message"));
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private boolean performNewSearch() {
        SearchPatternData data = this.getPatternData();
        IJavaSearchScope scope = null;
        String scopeDescription = "";
        boolean includeJRE = JavaSearchPage.getSearchJRE() || !this.mayExcludeJRE();
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scopeDescription = SearchMessages.getString("WorkspaceScope");
                scope = ReferenceScopeFactory.createWorkspaceScope(includeJRE);
                break;
            }
            case 1: {
                scopeDescription = SearchMessages.getString("SelectionScope");
                scope = JavaSearchScopeFactory.getInstance().createJavaSearchScope((ISelection)this.fStructuredSelection, includeJRE);
                break;
            }
            case 3: {
                scope = JavaSearchScopeFactory.getInstance().createJavaProjectSearchScope((ISelection)this.fStructuredSelection, includeJRE);
                IProject[] projects = JavaSearchScopeFactory.getInstance().getProjects(scope);
                if (projects.length >= 1) {
                    if (projects.length == 1) {
                        scopeDescription = SearchMessages.getFormattedString("EnclosingProjectScope", projects[0].getName());
                        break;
                    }
                    scopeDescription = SearchMessages.getFormattedString("EnclosingProjectsScope", projects[0].getName());
                    break;
                }
                scopeDescription = SearchMessages.getFormattedString("EnclosingProjectScope", "");
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = SearchMessages.getFormattedString("WorkingSetScope", SearchUtil.toString(workingSets));
                scope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(this.getContainer().getSelectedWorkingSets(), includeJRE);
                SearchUtil.updateLRUWorkingSets(this.getContainer().getSelectedWorkingSets());
            }
        }
        JavaSearchQuery textSearchJob = null;
        QuerySpecification querySpec = null;
        if (data.getJavaElement() != null && this.getPattern().equals(this.fInitialData.getPattern())) {
            if (data.getLimitTo() == 2) {
                SearchUtil.warnIfBinaryConstant(data.getJavaElement(), this.getShell());
            }
            querySpec = new ElementQuerySpecification(data.getJavaElement(), data.getLimitTo(), scope, scopeDescription);
        } else {
            querySpec = new PatternQuerySpecification(data.getPattern(), data.getSearchFor(), data.isCaseSensitive(), data.getLimitTo(), scope, scopeDescription);
            data.setJavaElement(null);
        }
        textSearchJob = new JavaSearchQuery(querySpec);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQuery((ISearchQuery)textSearchJob);
        return true;
    }

    private int getLimitTo() {
        int i = 0;
        while (i < this.fLimitTo.length) {
            if (this.fLimitTo[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setLimitTo(int searchFor) {
        this.fLimitTo[0].setEnabled(true);
        this.fLimitTo[1].setEnabled(false);
        this.fLimitTo[2].setEnabled(true);
        this.fLimitTo[3].setEnabled(true);
        this.fLimitTo[4].setEnabled(false);
        this.fLimitTo[5].setEnabled(false);
        if (searchFor != 0 && searchFor != 6 && this.fLimitTo[1].getSelection()) {
            this.fLimitTo[1].setSelection(false);
            this.fLimitTo[2].setSelection(true);
        }
        if (searchFor != 4 && (this.getLimitTo() == 4 || this.getLimitTo() == 5)) {
            this.fLimitTo[this.getLimitTo()].setSelection(false);
            this.fLimitTo[2].setSelection(true);
        }
        switch (searchFor) {
            case 0: 
            case 6: {
                this.fLimitTo[1].setEnabled(true);
                break;
            }
            case 4: {
                this.fLimitTo[4].setEnabled(true);
                this.fLimitTo[5].setEnabled(true);
                break;
            }
        }
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = fgPreviousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = ((SearchPatternData)fgPreviousSearchPatterns.get(patternCount - 1 - i)).getPattern();
            ++i;
        }
        return patterns;
    }

    private int getSearchFor() {
        int i = 0;
        while (i < this.fSearchFor.length) {
            if (this.fSearchFor[i].getSelection()) {
                return i;
            }
            ++i;
        }
        Assert.isTrue((boolean)false, (String)"shouldNeverHappen");
        return -1;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getPattern();
        SearchPatternData match = null;
        int i = 0;
        int size = fgPreviousSearchPatterns.size();
        while (match == null && i < size) {
            match = (SearchPatternData)fgPreviousSearchPatterns.get(i);
            ++i;
            if (pattern.equals(match.getPattern())) continue;
            match = null;
        }
        if (match == null) {
            match = new SearchPatternData(this.getSearchFor(), this.getLimitTo(), pattern, this.fCaseSensitive.getSelection(), this.fJavaElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
            fgPreviousSearchPatterns.add(match);
        } else {
            match.setSearchFor(this.getSearchFor());
            match.setLimitTo(this.getLimitTo());
            match.setCaseSensitive(this.fCaseSensitive.getSelection());
            match.setJavaElement(this.fJavaElement);
            match.setScope(this.getContainer().getSelectedScope());
            match.setWorkingSets(this.getContainer().getSelectedWorkingSets());
        }
        return match;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
            this.getContainer().setPerformActionEnabled(this.fPattern.getText().length() > 0);
        }
        super.setVisible(visible);
    }

    public boolean isValid() {
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        RowLayouter layouter = new RowLayouter(layout.numColumns);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        layouter.setDefaultGridData(gd, 0);
        layouter.setDefaultGridData(gd, 1);
        layouter.setDefaultSpan();
        layouter.perform(this.createExpression(result));
        Control searchFor = this.createSearchFor(result);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        searchFor.setLayoutData((Object)gd);
        Control limitTo = this.createLimitTo(result);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        limitTo.setLayoutData((Object)gd);
        SelectionAdapter javaElementInitializer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (JavaSearchPage.this.getSearchFor() == JavaSearchPage.this.fInitialData.getSearchFor()) {
                    JavaSearchPage.this.fJavaElement = JavaSearchPage.this.fInitialData.getJavaElement();
                } else {
                    JavaSearchPage.this.fJavaElement = null;
                }
                JavaSearchPage.this.setLimitTo(JavaSearchPage.this.getSearchFor());
                JavaSearchPage.this.updateCaseSensitiveCheckbox();
            }
        };
        this.fSearchFor[0].addSelectionListener((SelectionListener)javaElementInitializer);
        this.fSearchFor[1].addSelectionListener((SelectionListener)javaElementInitializer);
        this.fSearchFor[4].addSelectionListener((SelectionListener)javaElementInitializer);
        this.fSearchFor[3].addSelectionListener((SelectionListener)javaElementInitializer);
        this.fSearchFor[2].addSelectionListener((SelectionListener)javaElementInitializer);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        WorkbenchHelp.setHelp((Control)result, (String)"org.eclipse.jdt.ui.java_search_page_context");
        this.initSelections();
    }

    private Control createSearchJRE(Composite result) {
        this.fSearchJRE = new Button(result, 32);
        this.fSearchJRE.setText(SearchMessages.getString("SearchPage.searchJRE.label"));
        this.fSearchJRE.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSearchPage.setSearchJRE(JavaSearchPage.this.fSearchJRE.getSelection());
            }
        });
        return this.fSearchJRE;
    }

    public static boolean getSearchJRE() {
        return JavaPlugin.getDefault().getPreferenceStore().getBoolean(PREF_SEARCH_JRE);
    }

    public static void setSearchJRE(boolean value) {
        JavaPlugin.getDefault().getPreferenceStore().setValue(PREF_SEARCH_JRE, value);
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 0;
        result.setLayoutData((Object)gd);
        Label label = new Label(result, 16384);
        label.setText(SearchMessages.getString("SearchPage.expression.label"));
        gd = new GridData(1);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fPattern = new Combo(result, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSearchPage.this.handlePatternSelected();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaSearchPage.this.getContainer().setPerformActionEnabled(JavaSearchPage.this.getPattern().length() > 0);
                JavaSearchPage.this.updateCaseSensitiveCheckbox();
            }
        });
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        gd.horizontalIndent = -gd.horizontalIndent;
        this.fPattern.setLayoutData((Object)gd);
        this.fCaseSensitive = new Button(result, 32);
        this.fCaseSensitive.setText(SearchMessages.getString("SearchPage.expression.caseSensitive"));
        gd = new GridData();
        this.fCaseSensitive.setLayoutData((Object)gd);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSearchPage.this.fIsCaseSensitive = JavaSearchPage.this.fCaseSensitive.getSelection();
                JavaSearchPage.this.writeConfiguration();
            }
        });
        return result;
    }

    private void updateCaseSensitiveCheckbox() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.getPattern()) && this.fJavaElement != null) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
        }
    }

    private void handlePatternSelected() {
        if (this.fPattern.getSelectionIndex() < 0) {
            return;
        }
        int index = fgPreviousSearchPatterns.size() - 1 - this.fPattern.getSelectionIndex();
        this.fInitialData = (SearchPatternData)fgPreviousSearchPatterns.get(index);
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].setSelection(false);
            ++i;
        }
        i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].setSelection(false);
            ++i;
        }
        this.fSearchFor[this.fInitialData.getSearchFor()].setSelection(true);
        this.setLimitTo(this.fInitialData.getSearchFor());
        this.fLimitTo[this.fInitialData.getLimitTo()].setSelection(true);
        this.fPattern.setText(this.fInitialData.getPattern());
        this.fIsCaseSensitive = this.fInitialData.isCaseSensitive();
        this.fJavaElement = this.fInitialData.getJavaElement();
        this.fCaseSensitive.setEnabled(this.fJavaElement == null);
        this.fCaseSensitive.setSelection(this.fInitialData.isCaseSensitive());
        if (this.fInitialData.getWorkingSets() != null) {
            this.getContainer().setSelectedWorkingSets(this.fInitialData.getWorkingSets());
        } else {
            this.getContainer().setSelectedScope(this.fInitialData.getScope());
        }
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.getString("SearchPage.searchFor.label"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        result.setLayout((Layout)layout);
        this.fSearchFor = new Button[this.fSearchForText.length];
        int i = 0;
        while (i < this.fSearchForText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fSearchForText[i]);
            this.fSearchFor[i] = button;
            ++i;
        }
        Button filler = new Button((Composite)result, 16);
        filler.setVisible(false);
        filler = new Button((Composite)result, 16);
        filler.setVisible(false);
        return result;
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.getString("SearchPage.limitTo.label"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaSearchPage.this.updateUseJRE();
            }
        };
        this.fLimitTo = new Button[this.fLimitToText.length];
        int i = 0;
        while (i < this.fLimitToText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fLimitToText[i]);
            this.fLimitTo[i] = button;
            button.addSelectionListener((SelectionListener)listener);
            ++i;
        }
        this.createSearchJRE((Composite)result);
        return result;
    }

    private void initSelections() {
        this.fStructuredSelection = this.asStructuredSelection();
        this.fInitialData = this.tryStructuredSelection(this.fStructuredSelection);
        if (this.fInitialData == null) {
            this.fInitialData = this.trySimpleTextSelection(this.getContainer().getSelection());
        }
        if (this.fInitialData == null) {
            this.fInitialData = this.getDefaultInitValues();
        }
        this.fJavaElement = this.fInitialData.getJavaElement();
        this.fCaseSensitive.setSelection(this.fInitialData.isCaseSensitive());
        this.fCaseSensitive.setEnabled(this.fInitialData.getJavaElement() == null);
        this.fSearchFor[this.fInitialData.getSearchFor()].setSelection(true);
        this.setLimitTo(this.fInitialData.getSearchFor());
        this.fLimitTo[this.fInitialData.getLimitTo()].setSelection(true);
        this.fPattern.setText(this.fInitialData.getPattern());
        this.updateUseJRE();
    }

    private void updateUseJRE() {
        boolean shouldEnable = this.mayExcludeJRE();
        if (shouldEnable) {
            this.fSearchJRE.setSelection(JavaSearchPage.getSearchJRE());
            this.fSearchJRE.setEnabled(true);
        } else {
            this.fSearchJRE.setEnabled(false);
            this.fSearchJRE.setSelection(true);
        }
    }

    private boolean mayExcludeJRE() {
        return this.getLimitTo() == 2 || this.getLimitTo() == 3;
    }

    private SearchPatternData tryStructuredSelection(IStructuredSelection selection) {
        if (selection == null || selection.size() > 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IJavaElement) {
            return this.determineInitValuesFrom((IJavaElement)o);
        }
        if (o instanceof ISearchResultViewEntry) {
            IJavaElement element = SearchUtil.getJavaElement(((ISearchResultViewEntry)o).getSelectedMarker());
            return this.determineInitValuesFrom(element);
        }
        if (o instanceof LogicalPackage) {
            LogicalPackage lp = (LogicalPackage)((Object)o);
            return new SearchPatternData(2, 2, this.fIsCaseSensitive, lp.getElementName(), null);
        }
        if (o instanceof IAdaptable) {
            IWorkbenchAdapter adapter;
            IJavaElement element;
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                return this.determineInitValuesFrom(element);
            }
            IAdaptable iAdaptable2 = (IAdaptable)o;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IWorkbenchAdapter)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                return new SearchPatternData(0, 2, this.fIsCaseSensitive, adapter.getLabel(o), null);
            }
        }
        return null;
    }

    private SearchPatternData determineInitValuesFrom(IJavaElement element) {
        if (element == null) {
            return null;
        }
        int searchFor = -1;
        int limitTo = -1;
        String pattern = null;
        switch (element.getElementType()) {
            case 4: {
                searchFor = 2;
                limitTo = 2;
                pattern = element.getElementName();
                break;
            }
            case 3: {
                searchFor = 2;
                limitTo = 2;
                pattern = element.getElementName();
                break;
            }
            case 11: {
                searchFor = 2;
                limitTo = 2;
                pattern = element.getElementName();
                break;
            }
            case 13: {
                pattern = element.getElementName();
                IImportDeclaration declaration = (IImportDeclaration)element;
                if (declaration.isOnDemand()) {
                    searchFor = 2;
                    int index = pattern.lastIndexOf(46);
                    pattern = pattern.substring(0, index);
                } else {
                    searchFor = 0;
                }
                limitTo = 0;
                break;
            }
            case 7: {
                searchFor = 0;
                limitTo = 2;
                pattern = JavaModelUtil.getFullyQualifiedName((IType)element);
                break;
            }
            case 5: {
                ICompilationUnit cu = (ICompilationUnit)element;
                String mainTypeName = element.getElementName().substring(0, element.getElementName().indexOf("."));
                IType mainType = cu.getType(mainTypeName);
                mainTypeName = JavaModelUtil.getTypeQualifiedName(mainType);
                try {
                    mainType = JavaModelUtil.findTypeInCompilationUnit(cu, mainTypeName);
                    if (mainType == null) {
                        IType[] types = cu.getTypes();
                        if (types.length <= 0) break;
                        mainType = types[0];
                    }
                }
                catch (JavaModelException ex) {
                    ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.javaElementAccess.title"), SearchMessages.getString("Search.Error.javaElementAccess.message"));
                    break;
                }
                searchFor = 0;
                element = mainType;
                limitTo = 2;
                pattern = JavaModelUtil.getFullyQualifiedName(mainType);
                break;
            }
            case 6: {
                IType mainType;
                IClassFile cf = (IClassFile)element;
                try {
                    mainType = cf.getType();
                }
                catch (JavaModelException ex) {
                    ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.javaElementAccess.title"), SearchMessages.getString("Search.Error.javaElementAccess.message"));
                    break;
                }
                if (mainType == null) break;
                element = mainType;
                searchFor = 0;
                limitTo = 2;
                pattern = JavaModelUtil.getFullyQualifiedName(mainType);
                break;
            }
            case 8: {
                searchFor = 4;
                limitTo = 2;
                IType type = ((IField)element).getDeclaringType();
                StringBuffer buffer = new StringBuffer();
                buffer.append(JavaModelUtil.getFullyQualifiedName(type));
                buffer.append('.');
                buffer.append(element.getElementName());
                pattern = buffer.toString();
                break;
            }
            case 9: {
                searchFor = 1;
                try {
                    IMethod method = (IMethod)element;
                    if (method.isConstructor()) {
                        searchFor = 3;
                    }
                }
                catch (JavaModelException ex) {
                    ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.javaElementAccess.title"), SearchMessages.getString("Search.Error.javaElementAccess.message"));
                    break;
                }
                limitTo = 2;
                pattern = PrettySignature.getMethodSignature((IMethod)element);
            }
        }
        if (searchFor != -1 && limitTo != -1 && pattern != null) {
            return new SearchPatternData(searchFor, limitTo, true, pattern, element);
        }
        return null;
    }

    private SearchPatternData trySimpleTextSelection(ISelection selection) {
        String selectedText;
        SearchPatternData result = null;
        if (selection instanceof ITextSelection && (selectedText = ((ITextSelection)selection).getText()) != null) {
            String text;
            BufferedReader reader = new BufferedReader(new StringReader(selectedText));
            try {
                text = reader.readLine();
                if (text == null) {
                    text = "";
                }
            }
            catch (IOException iOException) {
                text = "";
            }
            result = new SearchPatternData(0, 2, this.fIsCaseSensitive, text, null);
        }
        return result;
    }

    private SearchPatternData getDefaultInitValues() {
        return new SearchPatternData(0, 2, this.fIsCaseSensitive, "", null);
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IStructuredSelection asStructuredSelection() {
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wbWindow != null && (page = wbWindow.getActivePage()) != null && (part = page.getActivePart()) != null) {
            try {
                return SelectionConverter.getStructuredSelection(part);
            }
            catch (JavaModelException javaModelException) {}
        }
        return StructuredSelection.EMPTY;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
    }

    private static class SearchPatternData {
        private int searchFor;
        private int limitTo;
        private String pattern;
        private boolean isCaseSensitive;
        private IJavaElement javaElement;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchPatternData(int searchFor, int limitTo, boolean isCaseSensitive, String pattern, IJavaElement element) {
            this(searchFor, limitTo, pattern, isCaseSensitive, element, 0, null);
        }

        public SearchPatternData(int s, int l, String p, boolean i, IJavaElement element, int scope, IWorkingSet[] workingSets) {
            this.setSearchFor(s);
            this.setLimitTo(l);
            this.setPattern(p);
            this.setCaseSensitive(i);
            this.setJavaElement(element);
            this.setScope(scope);
            this.setWorkingSets(workingSets);
        }

        public void setCaseSensitive(boolean isCaseSensitive) {
            this.isCaseSensitive = isCaseSensitive;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public void setJavaElement(IJavaElement javaElement) {
            this.javaElement = javaElement;
        }

        public IJavaElement getJavaElement() {
            return this.javaElement;
        }

        public void setLimitTo(int limitTo) {
            this.limitTo = limitTo;
        }

        public int getLimitTo() {
            return this.limitTo;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setScope(int scope) {
            this.scope = scope;
        }

        public int getScope() {
            return this.scope;
        }

        public void setSearchFor(int searchFor) {
            this.searchFor = searchFor;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public void setWorkingSets(IWorkingSet[] workingSets) {
            this.workingSets = workingSets;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }
    }
}

