/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.AbstractMethodCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class NewMethodCompletionProposal
extends AbstractMethodCompletionProposal {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private List fArguments;

    public NewMethodCompletionProposal(String label, ICompilationUnit targetCU, ASTNode invocationNode, List arguments, ITypeBinding binding, int relevance, Image image) {
        super(label, targetCU, invocationNode, binding, relevance, image);
        this.fArguments = arguments;
    }

    protected int evaluateModifiers(ASTNode targetTypeDecl) {
        if (this.getSenderBinding().isInterface()) {
            MethodDeclaration[] methodDecls = ((TypeDeclaration)targetTypeDecl).getMethods();
            if (methodDecls.length > 0) {
                return methodDecls[0].getModifiers();
            }
            return 0;
        }
        ASTNode invocationNode = this.getInvocationNode();
        if (invocationNode instanceof MethodInvocation) {
            ASTNode node;
            int modifiers = 0;
            Expression expression = ((MethodInvocation)invocationNode).getExpression();
            if (expression != null) {
                if (expression instanceof Name && ((Name)expression).resolveBinding().getKind() == 2) {
                    modifiers |= 8;
                }
            } else if (ASTResolving.isInStaticContext(invocationNode)) {
                modifiers |= 8;
            }
            modifiers = targetTypeDecl.equals((Object)(node = ASTResolving.findParentType(invocationNode))) ? (modifiers |= 2) : (node instanceof AnonymousClassDeclaration && ASTNodes.isParent(node, targetTypeDecl) ? (modifiers |= 4) : (modifiers |= 1));
            return modifiers;
        }
        return 1;
    }

    protected boolean isConstructor() {
        ASTNode node = this.getInvocationNode();
        return node.getNodeType() != 32 && node.getNodeType() != 48;
    }

    protected SimpleName getNewName(ASTRewrite rewrite) {
        ASTNode invocationNode = this.getInvocationNode();
        String name = invocationNode instanceof MethodInvocation ? ((MethodInvocation)invocationNode).getName().getIdentifier() : (invocationNode instanceof SuperMethodInvocation ? ((SuperMethodInvocation)invocationNode).getName().getIdentifier() : this.getSenderBinding().getName());
        AST ast = rewrite.getAST();
        SimpleName newNameNode = ast.newSimpleName(name);
        this.addLinkedPosition(rewrite.track((ASTNode)newNameNode), false, KEY_NAME);
        Name invocationName = this.getInvocationNameNode();
        if (invocationName != null && invocationName.getAST() == ast) {
            this.addLinkedPosition(rewrite.track((ASTNode)invocationName), true, KEY_NAME);
        }
        return newNameNode;
    }

    private Name getInvocationNameNode() {
        ASTNode node = this.getInvocationNode();
        if (node instanceof MethodInvocation) {
            return ((MethodInvocation)node).getName();
        }
        if (node instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)node).getName();
        }
        if (node instanceof ClassInstanceCreation) {
            return ((ClassInstanceCreation)node).getName();
        }
        return null;
    }

    protected Type getNewMethodType(ASTRewrite rewrite) throws CoreException {
        ITypeBinding[] bindings;
        MethodInvocation parent;
        ASTNode node = this.getInvocationNode();
        AST ast = rewrite.getAST();
        Type newTypeNode = null;
        ITypeBinding[] otherProposals = null;
        if (node.getParent() instanceof MethodInvocation && (parent = (MethodInvocation)node.getParent()).getExpression() == node && (bindings = ASTResolving.getQualifierGuess(node.getRoot(), parent.getName().getIdentifier(), parent.arguments())).length > 0) {
            String typeName = this.getImportRewrite().addImport(bindings[0]);
            newTypeNode = ASTNodeFactory.newType(ast, typeName);
            otherProposals = bindings;
        }
        if (newTypeNode == null) {
            ITypeBinding binding = ASTResolving.guessBindingForReference(node);
            if (binding != null) {
                String typeName = this.getImportRewrite().addImport(binding);
                newTypeNode = ASTNodeFactory.newType(ast, typeName);
            } else {
                ASTNode parent2 = node.getParent();
                if (parent2 instanceof ExpressionStatement) {
                    return null;
                }
                newTypeNode = ASTResolving.guessTypeForReference(ast, node);
                if (newTypeNode == null) {
                    newTypeNode = ast.newSimpleType((Name)ast.newSimpleName("Object"));
                }
            }
        }
        this.addLinkedPosition(rewrite.track(newTypeNode), false, KEY_TYPE);
        if (otherProposals != null) {
            int i = 0;
            while (i < otherProposals.length) {
                this.addLinkedPositionProposal(KEY_TYPE, otherProposals[i]);
                ++i;
            }
        }
        return newTypeNode;
    }

    protected void addNewParameters(ASTRewrite rewrite, List takenNames, List params) throws CoreException {
        AST ast = rewrite.getAST();
        List arguments = this.fArguments;
        int i = 0;
        while (i < arguments.size()) {
            Expression elem = (Expression)arguments.get(i);
            SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
            String argTypeKey = "arg_type_" + i;
            Type type = this.evaluateParameterTypes(ast, elem, argTypeKey);
            param.setType(type);
            String argNameKey = "arg_name_" + i;
            String name = this.evaluateParameterNames(takenNames, elem, type, argNameKey);
            param.setName(ast.newSimpleName(name));
            params.add(param);
            this.addLinkedPosition(rewrite.track((ASTNode)param.getType()), false, argTypeKey);
            this.addLinkedPosition(rewrite.track((ASTNode)param.getName()), false, argNameKey);
            ++i;
        }
    }

    private Type evaluateParameterTypes(AST ast, Expression elem, String key) throws CoreException {
        ITypeBinding binding = Bindings.normalizeTypeBinding(elem.resolveTypeBinding());
        if (binding != null) {
            ITypeBinding[] typeProposals = ASTResolving.getRelaxingTypes(ast, binding);
            int i = 0;
            while (i < typeProposals.length) {
                this.addLinkedPositionProposal(key, typeProposals[i]);
                ++i;
            }
            String typeName = this.getImportRewrite().addImport(binding);
            return ASTNodeFactory.newType(ast, typeName);
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private String evaluateParameterNames(List takenNames, Expression argNode, Type type, String key) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[] excludedNames = takenNames.toArray(new String[takenNames.size()]);
        String favourite = null;
        HashSet namesTaken = new HashSet();
        String baseName = ASTResolving.getBaseNameFromExpression(project, argNode);
        if (baseName != null) {
            String[] suggestions = StubUtility.getArgumentNameSuggestions(project, baseName, 0, excludedNames);
            if (suggestions.length > 0) {
                favourite = suggestions[0];
            }
            this.addNameProposals(key, suggestions, namesTaken);
        }
        int dim = 0;
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            dim = arrayType.getDimensions();
            type = arrayType.getElementType();
        }
        String typeName = ASTNodes.asString((ASTNode)type);
        String packName = Signature.getQualifier((String)typeName);
        String[] names = NamingConventions.suggestArgumentNames((IJavaProject)project, (String)packName, (String)typeName, (int)dim, (String[])excludedNames);
        if (favourite == null) {
            favourite = names[0];
        }
        this.addNameProposals(key, names, namesTaken);
        takenNames.add(favourite);
        return favourite;
    }

    private void addNameProposals(String key, String[] names, Set namesTaken) {
        int i = 0;
        while (i < names.length) {
            String curr = names[i];
            if (namesTaken.add(curr)) {
                this.addLinkedPositionProposal(key, curr, null);
            }
            ++i;
        }
    }

    protected void addNewExceptions(ASTRewrite rewrite, List exceptions) throws CoreException {
    }
}

