/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewContainerDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LibrariesWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IJavaProject fCurrJProject;
    private TreeListDialogField fLibrariesList;
    private IWorkspaceRoot fWorkspaceRoot;
    private Control fSWTControl;
    private final int IDX_ADDJAR = 0;
    private final int IDX_ADDEXT = 1;
    private final int IDX_ADDVAR = 2;
    private final int IDX_ADDLIB = 3;
    private final int IDX_ADDFOL = 4;
    private final int IDX_EDIT = 6;
    private final int IDX_REMOVE = 7;

    public LibrariesWorkbookPage(IWorkspaceRoot root, ListDialogField classPathList) {
        this.fClassPathList = classPathList;
        this.fWorkspaceRoot = root;
        this.fSWTControl = null;
        String[] stringArray = new String[8];
        stringArray[0] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addjar.button");
        stringArray[1] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addextjar.button");
        stringArray[2] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addvariable.button");
        stringArray[3] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addlibrary.button");
        stringArray[4] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.addclassfolder.button");
        stringArray[6] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.edit.button");
        stringArray[7] = NewWizardMessages.getString("LibrariesWorkbookPage.libraries.remove.button");
        String[] buttonLabels = stringArray;
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(NewWizardMessages.getString("LibrariesWorkbookPage.libraries.label"));
        this.fLibrariesList.enableButton(7, false);
        this.fLibrariesList.enableButton(6, false);
        this.fLibrariesList.setViewerSorter(new CPListElementSorter());
    }

    public void init(IJavaProject jproject) {
        this.fCurrJProject = jproject;
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List cpelements = this.fClassPathList.getElements();
        ArrayList<CPListElement> libelements = new ArrayList<CPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new CPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openJarFileDialog(null);
                break;
            }
            case 1: {
                libentries = this.openExtJarFileDialog(null);
                break;
            }
            case 2: {
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 3: {
                libentries = this.openContainerSelectionDialog(null);
                break;
            }
            case 4: {
                libentries = this.openClassFolderDialog(null);
                break;
            }
            case 6: {
                this.editEntry();
                return;
            }
            case 7: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                    curr.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(curr));
                    curr.setAttribute("javadoc", JavaUI.getLibraryJavadocLocation(curr.getPath()));
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty() && index == 4) {
                this.askForAddingExclusionPatternsDialog(elementsToAdd);
            }
            this.fLibrariesList.addElements(elementsToAdd);
            if (index == 3) {
                this.fLibrariesList.refresh();
            }
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    private void askForAddingExclusionPatternsDialog(List newEntries) {
        HashSet modified = new HashSet();
        this.fixNestingConflicts(newEntries, this.fClassPathList.getElements(), modified);
        if (!modified.isEmpty()) {
            String title = NewWizardMessages.getString("LibrariesWorkbookPage.exclusion_added.title");
            String message = NewWizardMessages.getString("LibrariesWorkbookPage.exclusion_added.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                attrib.getParent().setAttribute(attrib.getKey(), null);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            CPListElement curr;
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute ? ((CPListElementAttribute)elem).getValue() == null : elem instanceof CPListElement && (curr = (CPListElement)elem).getParentContainer() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else if (elem instanceof CPListElementAttribute) {
            this.editAttributeEntry((CPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        String key = elem.getKey();
        if (key.equals("sourcepath")) {
            Shell shell;
            IClasspathEntry result;
            CPListElement selElement = elem.getParent();
            IPath containerPath = null;
            boolean applyChanges = false;
            Object parentContainer = selElement.getParentContainer();
            if (parentContainer instanceof CPListElement) {
                containerPath = ((CPListElement)parentContainer).getPath();
                applyChanges = true;
            }
            if ((result = BuildPathDialogAccess.configureSourceAttachment(shell = this.getShell(), selElement.getClasspathEntry())) != null) {
                if (applyChanges) {
                    try {
                        IRunnableWithProgress runnable = SourceAttachmentBlock.getRunnable(shell, result, this.fCurrJProject, containerPath);
                        PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
                    }
                    catch (InvocationTargetException e) {
                        String title = NewWizardMessages.getString("LibrariesWorkbookPage.configurecontainer.error.title");
                        String message = NewWizardMessages.getString("LibrariesWorkbookPage.configurecontainer.error.message");
                        ExceptionHandler.handle(e, shell, title, message);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                selElement.setAttribute("sourcepath", result.getSourceAttachmentPath());
                this.fLibrariesList.refresh();
                this.fClassPathList.refresh();
            }
        } else if (key.equals("javadoc")) {
            CPListElement selElement = elem.getParent();
            URL initialLocation = (URL)selElement.getAttribute("javadoc");
            String elementName = new CPListLabelProvider().getText(selElement);
            URL[] result = BuildPathDialogAccess.configureJavadocLocation(this.getShell(), elementName, initialLocation);
            if (result != null) {
                selElement.setAttribute("javadoc", result[0]);
                this.fLibrariesList.refresh();
            }
        }
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 5: {
                res = this.openContainerSelectionDialog(elem);
                break;
            }
            case 1: {
                IResource resource = elem.getResource();
                if (resource == null) {
                    res = this.openExtJarFileDialog(elem);
                    break;
                }
                if (resource.getType() == 2) {
                    if (resource.exists()) {
                        res = this.openClassFolderDialog(elem);
                        break;
                    }
                    res = this.openNewClassFolderDialog(elem);
                    break;
                }
                if (resource.getType() != 1) break;
                res = this.openJarFileDialog(elem);
                break;
            }
            case 4: {
                res = this.openVariableSelectionDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            CPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fLibrariesList.replaceElement(elem, curr);
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(6, this.canEdit(selElements));
        this.fLibrariesList.enableButton(7, this.canRemove(selElements));
        boolean noAttributes = !this.hasAttributes(selElements);
        this.fLibrariesList.enableButton(1, noAttributes);
        this.fLibrariesList.enableButton(4, noAttributes);
        this.fLibrariesList.enableButton(0, noAttributes);
        this.fLibrariesList.enableButton(3, noAttributes);
        this.fLibrariesList.enableButton(2, noAttributes);
    }

    private boolean hasAttributes(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            if (selElements.get(i) instanceof CPListElementAttribute) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            CPListElement curr = (CPListElement)elem;
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        return elem instanceof CPListElementAttribute;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateClasspathList();
        }
    }

    private void updateClasspathList() {
        int nEntries;
        List projelements = this.fLibrariesList.getElements();
        List cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement[] openNewClassFolderDialog(CPListElement existing) {
        String title = existing == null ? NewWizardMessages.getString("LibrariesWorkbookPage.NewClassFolderDialog.new.title") : NewWizardMessages.getString("LibrariesWorkbookPage.NewClassFolderDialog.edit.title");
        IProject currProject = this.fCurrJProject.getProject();
        NewContainerDialog dialog = new NewContainerDialog(this.getShell(), title, currProject, this.getUsedContainers(existing), existing);
        IPath projpath = currProject.getFullPath();
        dialog.setMessage(NewWizardMessages.getFormattedString("LibrariesWorkbookPage.NewClassFolderDialog.description", projpath.toString()));
        if (dialog.open() == 0) {
            IFolder folder = dialog.getFolder();
            return new CPListElement[]{this.newCPLibraryElement((IResource)folder)};
        }
        return null;
    }

    private CPListElement[] openClassFolderDialog(CPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseClassFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(existing))) != null) {
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = this.fWorkspaceRoot.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private CPListElement[] openJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseJAREntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedJARFiles(existing));
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    IPath curr = selected[i];
                    IResource resource = this.fWorkspaceRoot.findMember(curr);
                    if (resource instanceof IFile) {
                        res.add(this.newCPLibraryElement(resource));
                    }
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IResource resource;
            IPath configured = BuildPathDialogAccess.configureJAREntry(this.getShell(), existing.getPath(), this.getUsedJARFiles(existing));
            if (configured != null && (resource = this.fWorkspaceRoot.findMember(configured)) instanceof IFile) {
                return new CPListElement[]{this.newCPLibraryElement(resource)};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        if (this.fCurrJProject.exists()) {
            try {
                IPath outputLocation = this.fCurrJProject.getOutputLocation();
                if (outputLocation != null && outputLocation.segmentCount() > 1) {
                    res.add(outputLocation);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e.getStatus());
            }
        }
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getUsedJARFiles(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IFile) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    private CPListElement[] openExtJarFileDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalJAREntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new CPListElement(this.fCurrJProject, 1, selected[i], null));
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalJAREntry(this.getShell(), existing.getPath());
            if (configured != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, configured, null)};
            }
        }
        return null;
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement existing) {
        List existingElements = this.fLibrariesList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            CPListElement elem = (CPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = BuildPathDialogAccess.chooseVariableEntries(this.getShell(), existingPathsArray);
            if (paths != null) {
                ArrayList<CPListElement> result = new ArrayList<CPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    CPListElement elem = new CPListElement(this.fCurrJProject, 4, paths[i2], null);
                    IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)paths[i2]);
                    elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new CPListElement[result.size()]);
            }
        } else {
            IPath path = BuildPathDialogAccess.configureVariableEntry(this.getShell(), existing.getPath(), existingPathsArray);
            if (path != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 4, path, null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private CPListElement[] openContainerSelectionDialog(CPListElement existing) {
        if (existing == null) {
            IClasspathEntry[] created = BuildPathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement[] res = new CPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = new CPListElement(this.fCurrJProject, 5, created[i].getPath(), null);
                    ++i;
                }
                return res;
            }
        } else {
            IClasspathEntry created = BuildPathDialogAccess.configureContainerEntry(this.getShell(), existing.getClasspathEntry(), this.fCurrJProject, this.getRawClasspath());
            if (created != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 5, created.getPath(), null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] currEntries = new IClasspathEntry[this.fClassPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPListElement curr = (CPListElement)this.fClassPathList.getElement(i);
            currEntries[i] = curr.getClasspathEntry();
            ++i;
        }
        return currEntries;
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }
}

