/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class FeatureInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "feature-context";

    public FeatureInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return this.createResourceModel((IFileEditorInput)input);
        }
        if (input instanceof IStorageEditorInput) {
            return this.createStorageModel((IStorageEditorInput)input);
        }
        return null;
    }

    private IBaseModel createResourceModel(IFileEditorInput input) throws CoreException {
        IFile file = input.getFile();
        WorkspaceFeatureModel model = new WorkspaceFeatureModel(file);
        model.load();
        return model;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IBaseModel createStorageModel(IStorageEditorInput input) throws CoreException {
        InputStream stream = null;
        IStorage storage = input.getStorage();
        try {
            stream = storage.getContents();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation("");
        try {
            try {
                model.load(stream, false);
            }
            catch (CoreException coreException) {
                IBaseModel iBaseModel = null;
                Object var5_7 = null;
                try {
                    stream.close();
                    return iBaseModel;
                }
                catch (IOException iOException) {}
                return iBaseModel;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {}
            catch (IOException iOException) {}
            stream.close();
            throw throwable;
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return model;
        }
        stream.close();
        return model;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            doc.set(swriter.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean synchronizeModel(IDocument doc) {
        IFeatureModel model = (IFeatureModel)this.getModel();
        boolean cleanModel = true;
        String text = doc.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    protected void reorderInsertEdits(ArrayList ops) {
    }
}

