/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.InstalledJREsPreferenceNode;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class BasicLauncherTab
extends AbstractLauncherTab
implements ILauncherSettings {
    private static final String KEY_NAME = "BasicLauncherTab.name";
    private Combo fWorkspaceCombo;
    private Button fBrowseButton;
    private Button fClearWorkspaceCheck;
    private Button fAskClearCheck;
    private Combo fJreCombo;
    private Text fVmArgsText;
    private Text fProgArgsText;
    private Button fDefaultsButton;
    private Image fImage;
    private IStatus fJreSelectionStatus = AbstractLauncherTab.createStatus(0, "");
    private IStatus fWorkspaceSelectionStatus = AbstractLauncherTab.createStatus(0, "");
    private boolean fBlockChanges = false;
    protected Combo fApplicationCombo;
    private Text fBootstrap;
    private Combo fProductCombo;
    private Button fProductButton;
    private Button fApplicationButton;

    public BasicLauncherTab() {
        this.fImage = PDEPluginImages.DESC_ARGUMENT_TAB.createImage();
    }

    public void dispose() {
        super.dispose();
        this.fImage.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.createWorkspaceDataSection(composite);
        this.createProgramSection(composite);
        this.createCommandLineSettingsSection(composite);
        this.createDefaultsButton(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.launcher_basic");
    }

    private void createProgramSection(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(PDEPlugin.getResourceString("BasicLauncherTab.programToRun"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.createApplicationSection((Composite)group);
        this.createProductSection((Composite)group);
    }

    protected void createDefaultsButton(Composite parent) {
        this.fDefaultsButton = new Button(parent, 8);
        this.fDefaultsButton.setText(PDEPlugin.getResourceString("BasicLauncherTab.restore"));
        this.fDefaultsButton.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.fDefaultsButton);
        this.fDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.doRestoreDefaults();
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createWorkspaceDataSection(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(PDEPlugin.getResourceString("BasicLauncherTab.workspace"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(PDEPlugin.getResourceString("BasicLauncherTab.location"));
        this.fWorkspaceCombo = new Combo((Composite)group, 4);
        GridData gd = new GridData(768);
        this.fWorkspaceCombo.setLayoutData((Object)gd);
        this.fWorkspaceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.fWorkspaceSelectionStatus = BasicLauncherTab.this.validateWorkspaceSelection();
                if (!BasicLauncherTab.this.fBlockChanges) {
                    BasicLauncherTab.this.updateStatus();
                }
            }
        });
        this.fWorkspaceCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicLauncherTab.this.fWorkspaceSelectionStatus = BasicLauncherTab.this.validateWorkspaceSelection();
                if (!BasicLauncherTab.this.fBlockChanges) {
                    BasicLauncherTab.this.updateStatus();
                }
            }
        });
        this.fBrowseButton = new Button((Composite)group, 8);
        this.fBrowseButton.setText(PDEPlugin.getResourceString("BasicLauncherTab.browse"));
        this.fBrowseButton.setLayoutData((Object)new GridData(128));
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath chosen = BasicLauncherTab.this.chooseWorkspaceLocation();
                if (chosen != null) {
                    String destination = chosen.toOSString();
                    if (BasicLauncherTab.this.fWorkspaceCombo.indexOf(destination) == -1) {
                        BasicLauncherTab.this.fWorkspaceCombo.add(destination, 0);
                    }
                    BasicLauncherTab.this.fWorkspaceCombo.setText(destination);
                    BasicLauncherTab.this.updateStatus();
                }
            }
        });
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.fClearWorkspaceCheck = new Button((Composite)group, 32);
        this.fClearWorkspaceCheck.setText(PDEPlugin.getResourceString("BasicLauncherTab.clear"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fClearWorkspaceCheck.setLayoutData((Object)gd);
        this.fClearWorkspaceCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.fAskClearCheck.setEnabled(BasicLauncherTab.this.fClearWorkspaceCheck.getSelection());
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAskClearCheck = new Button((Composite)group, 32);
        this.fAskClearCheck.setText(PDEPlugin.getResourceString("BasicLauncherTab.askClear"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fAskClearCheck.setLayoutData((Object)gd);
        this.fAskClearCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createCommandLineSettingsSection(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(PDEPlugin.getResourceString("BasicLauncherTab.commandLineSettings"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.createJRESection((Composite)group);
        this.createVMArgsSection((Composite)group);
        this.createProgArgsSection((Composite)group);
        this.createBootstrapEntriesSection((Composite)group);
    }

    protected void createProductSection(Composite parent) {
        this.fProductButton = new Button(parent, 16);
        this.fProductButton.setText(PDEPlugin.getResourceString("BasicLauncherTab.runProduct"));
        this.fProductButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = BasicLauncherTab.this.fProductButton.getSelection();
                BasicLauncherTab.this.fApplicationCombo.setEnabled(!selected);
                BasicLauncherTab.this.fProductCombo.setEnabled(selected);
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProductCombo = new Combo(parent, 12);
        this.fProductCombo.setItems(this.getProductNames());
        this.fProductCombo.setLayoutData((Object)new GridData(768));
        this.fProductCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createApplicationSection(Composite parent) {
        this.fApplicationButton = new Button(parent, 16);
        this.fApplicationButton.setText(PDEPlugin.getResourceString("BasicLauncherTab.runApplication"));
        this.fApplicationCombo = new Combo(parent, 12);
        this.fApplicationCombo.setItems(this.getApplicationNames());
        this.fApplicationCombo.setLayoutData((Object)new GridData(768));
        this.fApplicationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected String[] getApplicationNames() {
        TreeSet<String> result = new TreeSet<String>();
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                String id;
                String point = extensions[j].getPoint();
                if (point != null && point.equals("org.eclipse.core.runtime.applications") && (id = extensions[j].getPluginBase().getId()) != null && id.trim().length() != 0 && !id.startsWith("org.eclipse.pde.junit.runtime") && extensions[j].getId() != null) {
                    result.add(String.valueOf(id) + "." + extensions[j].getId());
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    protected String[] getProductNames() {
        TreeSet<String> result = new TreeSet<String>();
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                String id;
                IPluginObject[] children;
                String point = extensions[j].getPoint();
                if (point != null && point.equals("org.eclipse.core.runtime.products") && (children = extensions[j].getChildren()).length == 1 && "product".equals(children[0].getName()) && (id = extensions[j].getPluginBase().getId()) != null && id.trim().length() != 0 && extensions[j].getId() != null) {
                    result.add(String.valueOf(id) + "." + extensions[j].getId());
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    protected String getApplicationAttribute() {
        return "application";
    }

    protected void createJRESection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEPlugin.getResourceString("BasicLauncherTab.jre"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fJreCombo = new Combo(composite, 12);
        this.fJreCombo.setLayoutData((Object)new GridData(768));
        this.fJreCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicLauncherTab.this.fJreSelectionStatus = BasicLauncherTab.this.validateJRESelection();
                BasicLauncherTab.this.updateStatus();
            }
        });
        Button button = new Button(composite, 8);
        button.setText(PDEPlugin.getResourceString("BasicLauncherTab.installedJREs"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = BasicLauncherTab.this.fJreCombo.getText();
                InstalledJREsPreferenceNode node = new InstalledJREsPreferenceNode();
                if (this.showPreferencePage(node)) {
                    BasicLauncherTab.this.fJreCombo.setItems(LauncherUtils.getVMInstallNames());
                    BasicLauncherTab.this.fJreCombo.setText(currentVM);
                    if (BasicLauncherTab.this.fJreCombo.getSelectionIndex() == -1) {
                        BasicLauncherTab.this.fJreCombo.setText(LauncherUtils.getDefaultVMInstallName());
                    }
                }
            }

            private boolean showPreferencePage(IPreferenceNode targetNode) {
                PreferenceManager manager = new PreferenceManager();
                manager.addToRoot(targetNode);
                PreferenceDialog dialog = new PreferenceDialog(BasicLauncherTab.this.getControl().getShell(), manager);
                boolean[] result = new boolean[1];
                BusyIndicator.showWhile((Display)BasicLauncherTab.this.getControl().getDisplay(), (Runnable)new Runnable(this, dialog, targetNode, result){
                    final /* synthetic */ 11 this$1;
                    private final /* synthetic */ PreferenceDialog val$dialog;
                    private final /* synthetic */ IPreferenceNode val$targetNode;
                    private final /* synthetic */ boolean[] val$result;
                    {
                        this.this$1 = var1_1;
                        this.val$dialog = preferenceDialog;
                        this.val$targetNode = iPreferenceNode;
                        this.val$result = blArray;
                    }

                    public void run() {
                        this.val$dialog.create();
                        this.val$dialog.setMessage(this.val$targetNode.getLabelText());
                        if (this.val$dialog.open() == 0) {
                            this.val$result[0] = true;
                        }
                    }
                });
                return result[0];
            }
        });
        button.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(button);
    }

    protected void createVMArgsSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEPlugin.getResourceString("BasicLauncherTab.vmArgs"));
        this.fVmArgsText = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.fVmArgsText.setLayoutData((Object)gd);
        this.fVmArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BasicLauncherTab.this.fBlockChanges) {
                    BasicLauncherTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    protected void createProgArgsSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEPlugin.getResourceString("BasicLauncherTab.programArgs"));
        this.fProgArgsText = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.fProgArgsText.setLayoutData((Object)gd);
        this.fProgArgsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BasicLauncherTab.this.fBlockChanges) {
                    BasicLauncherTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    private void createBootstrapEntriesSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEPlugin.getResourceString("BasicLauncherTab.bootstrap"));
        this.fBootstrap = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.fBootstrap.setLayoutData((Object)gd);
        this.fBootstrap.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!BasicLauncherTab.this.fBlockChanges) {
                    BasicLauncherTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initializeFrom(ILaunchConfiguration config) {
        try {
            try {
                this.fBlockChanges = true;
                this.initializeWorkspaceDataSection(config);
                this.initializeJRESection(config);
                this.initializeProgramToRunSection(config);
                this.initializeVMArgsSection(config);
                this.initializeProgArgsSection(config);
                this.initializeBootstrapEntriesSection(config);
                this.fWorkspaceSelectionStatus = this.validateWorkspaceSelection();
                this.fJreSelectionStatus = this.validateJRESelection();
                this.updateStatus();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fBlockChanges = false;
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.fBlockChanges = false;
            return;
        }
    }

    protected void initializeProgramToRunSection(ILaunchConfiguration config) throws CoreException {
        this.initializeApplicationSection(config);
        this.initializeProductSection(config);
        boolean useProduct = config.getAttribute("useProduct", false) && PDECore.getDefault().getModelManager().isOSGiRuntime() && this.fProductCombo.getItemCount() > 0;
        this.fApplicationButton.setSelection(!useProduct);
        this.fApplicationCombo.setEnabled(!useProduct);
        this.fProductButton.setSelection(useProduct);
        this.fProductButton.setEnabled(this.fProductCombo.getItemCount() > 0);
        this.fProductCombo.setEnabled(useProduct);
    }

    protected void initializeProductSection(ILaunchConfiguration config) throws CoreException {
        if (this.fProductCombo.getItemCount() > 0) {
            int index;
            String productName = config.getAttribute("product", null);
            int n = index = productName == null ? -1 : this.fProductCombo.indexOf(productName);
            if (index == -1) {
                index = 0;
            }
            this.fProductCombo.setText(this.fProductCombo.getItem(index));
        }
    }

    protected void initializeApplicationSection(ILaunchConfiguration config) throws CoreException {
        String attribute = this.getApplicationAttribute();
        String application = config.getAttribute(attribute, null);
        if (application == null || this.fApplicationCombo.indexOf(application) == -1) {
            application = null;
            StringTokenizer tokenizer = new StringTokenizer(config.getAttribute("progargs", ""));
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equals("-application") || !tokenizer.hasMoreTokens()) continue;
                application = tokenizer.nextToken();
                break;
            }
            int index = -1;
            if (application != null) {
                index = this.fApplicationCombo.indexOf(application);
            }
            if (index == -1) {
                index = this.fApplicationCombo.indexOf(LauncherUtils.getDefaultApplicationName());
            }
            if (index != -1) {
                this.fApplicationCombo.setText(this.fApplicationCombo.getItem(index));
            } else if (this.fApplicationCombo.getItemCount() > 0) {
                this.fApplicationCombo.setText(this.fApplicationCombo.getItem(0));
            }
        } else {
            this.fApplicationCombo.setText(application);
        }
    }

    protected void initializeWorkspaceDataSection(ILaunchConfiguration config) throws CoreException {
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < 6) {
            String curr = config.getAttribute("location" + String.valueOf(i), null);
            if (curr != null && !items.contains(curr)) {
                items.add(curr);
            }
            ++i;
        }
        this.fWorkspaceCombo.setItems(items.toArray(new String[items.size()]));
        if (this.fWorkspaceCombo.getItemCount() > 0) {
            this.fWorkspaceCombo.setText(items.get(0).toString());
        }
        this.fClearWorkspaceCheck.setSelection(config.getAttribute("clearws", false));
        this.fAskClearCheck.setSelection(config.getAttribute("askclear", true));
        this.fAskClearCheck.setEnabled(this.fClearWorkspaceCheck.getSelection());
    }

    protected void initializeJRESection(ILaunchConfiguration config) throws CoreException {
        this.fJreCombo.setItems(LauncherUtils.getVMInstallNames());
        String vmInstallName = config.getAttribute("vminstall", LauncherUtils.getDefaultVMInstallName());
        this.fJreCombo.setText(vmInstallName);
        if (this.fJreCombo.getSelectionIndex() == -1) {
            this.fJreCombo.setText(LauncherUtils.getDefaultVMInstallName());
        }
    }

    protected void initializeVMArgsSection(ILaunchConfiguration config) throws CoreException {
        this.fVmArgsText.setText(config.getAttribute("vmargs", ""));
    }

    protected void initializeProgArgsSection(ILaunchConfiguration config) throws CoreException {
        this.fProgArgsText.setText(config.getAttribute("progargs", LauncherUtils.getDefaultProgramArguments()));
    }

    private void initializeBootstrapEntriesSection(ILaunchConfiguration config) throws CoreException {
        this.fBootstrap.setText(config.getAttribute("bootstrap", ""));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("location0", LauncherUtils.getDefaultWorkspace());
        config.setAttribute("clearws", false);
        config.setAttribute("askclear", true);
        config.setAttribute("progargs", LauncherUtils.getDefaultProgramArguments());
        config.setAttribute("vmargs", "");
        config.setAttribute("bootstrap", "");
    }

    protected void doRestoreDefaults() {
        this.fProgArgsText.setText(LauncherUtils.getDefaultProgramArguments());
        this.fVmArgsText.setText("");
        this.fWorkspaceCombo.setText(LauncherUtils.getDefaultWorkspace());
        this.fClearWorkspaceCheck.setSelection(false);
        this.fAskClearCheck.setSelection(true);
        this.fAskClearCheck.setEnabled(false);
        this.fJreCombo.setText(LauncherUtils.getDefaultVMInstallName());
        this.fApplicationButton.setSelection(true);
        this.fApplicationCombo.setText(LauncherUtils.getDefaultApplicationName());
        this.fApplicationCombo.setEnabled(true);
        this.fProductButton.setSelection(false);
        this.fProductCombo.setEnabled(false);
        this.fProductCombo.setEnabled(false);
        this.updateLaunchConfigurationDialog();
    }

    private void updateStatus() {
        this.updateStatus(AbstractLauncherTab.getMoreSevere(this.fWorkspaceSelectionStatus, this.fJreSelectionStatus));
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        try {
            this.saveWorkspaceDataSection(config);
            this.saveApplicationSection(config);
            this.saveProductSection(config);
            this.saveJRESection(config);
            this.saveVMArgsSection(config);
            this.saveProgArgsSection(config);
            this.saveBootstrapEntriesSection(config);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void saveWorkspaceDataSection(ILaunchConfigurationWorkingCopy config) throws CoreException {
        config.setAttribute("location" + String.valueOf(0), this.fWorkspaceCombo.getText());
        String[] items = this.fWorkspaceCombo.getItems();
        int nEntries = Math.min(items.length, 5);
        int i = 0;
        while (i < nEntries) {
            config.setAttribute("location" + String.valueOf(i + 1), items[i]);
            ++i;
        }
        config.setAttribute("clearws", this.fClearWorkspaceCheck.getSelection());
        config.setAttribute("askclear", this.fAskClearCheck.getSelection());
    }

    protected void saveJRESection(ILaunchConfigurationWorkingCopy config) throws CoreException {
        if (this.fJreCombo.getSelectionIndex() == -1) {
            return;
        }
        String jre = this.fJreCombo.getText();
        if (config.getAttribute("vminstall", null) != null) {
            config.setAttribute("vminstall", jre);
        } else {
            config.setAttribute("vminstall", jre.equals(LauncherUtils.getDefaultVMInstallName()) ? null : jre);
        }
    }

    protected void saveVMArgsSection(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("vmargs", this.fVmArgsText.getText().trim());
    }

    protected void saveProgArgsSection(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("progargs", this.fProgArgsText.getText().trim());
    }

    protected void saveBootstrapEntriesSection(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("bootstrap", this.fBootstrap.getText().trim());
    }

    protected void saveProductSection(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("useProduct", this.fProductButton.getSelection());
        config.setAttribute("product", this.fProductCombo.getText());
    }

    protected void saveApplicationSection(ILaunchConfigurationWorkingCopy config) {
        String text = this.fApplicationCombo.getText();
        String attribute = this.getApplicationAttribute();
        if (text.length() == 0 || text.equals(LauncherUtils.getDefaultApplicationName())) {
            config.setAttribute(attribute, null);
        } else {
            config.setAttribute(attribute, text);
        }
    }

    private IPath chooseWorkspaceLocation() {
        DirectoryDialog dialog = new DirectoryDialog(this.getControl().getShell());
        dialog.setFilterPath(this.fWorkspaceCombo.getText());
        dialog.setText(PDEPlugin.getResourceString("BasicLauncherTab.workspace.title"));
        dialog.setMessage(PDEPlugin.getResourceString("BasicLauncherTab.workspace.message"));
        String res = dialog.open();
        if (res != null) {
            return new Path(res);
        }
        return null;
    }

    private IStatus validateJRESelection() {
        if (this.fJreCombo.getSelectionIndex() == -1) {
            return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString("BasicLauncherTab.noJRE"));
        }
        return AbstractLauncherTab.createStatus(0, "");
    }

    private IStatus validateWorkspaceSelection() {
        String location = this.fWorkspaceCombo.getText().trim();
        if (!Path.ROOT.isValidPath(location)) {
            return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString("BasicLauncherTab.invalidWorkspace"));
        }
        Path curr = new Path(location);
        if (curr.segmentCount() == 0 && curr.getDevice() == null) {
            return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString("BasicLauncherTab.noWorkspace"));
        }
        return AbstractLauncherTab.createStatus(0, "");
    }

    public String getName() {
        return PDEPlugin.getResourceString(KEY_NAME);
    }

    public Image getImage() {
        return this.fImage;
    }
}

