/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.preferences.ExternalPluginsBlock;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TargetPlatformPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Label fHomeLabel;
    private Combo fHomeText;
    private Button fBrowseButton;
    private ExternalPluginsBlock fPluginsBlock;
    private Preferences fPreferences = null;
    private boolean fNeedsReload = false;
    private String fOriginalText;

    public TargetPlatformPreferencePage() {
        this.setDescription(PDEPlugin.getResourceString("Preferences.TargetPlatformPage.Description"));
        this.fPreferences = PDECore.getDefault().getPluginPreferences();
        this.fPluginsBlock = new ExternalPluginsBlock(this);
    }

    public void dispose() {
        this.fPluginsBlock.dispose();
        super.dispose();
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        this.fHomeLabel = new Label(container, 0);
        this.fHomeLabel.setText(PDEPlugin.getResourceString("Preferences.TargetPlatformPage.PlatformHome"));
        this.fHomeText = new Combo(container, 0);
        this.fHomeText.setLayoutData((Object)new GridData(768));
        ArrayList<String> locations = new ArrayList<String>();
        int i = 0;
        while (i < 5) {
            String value = this.fPreferences.getString("saved_platform" + i);
            if (value.equals("")) break;
            locations.add(value);
            ++i;
        }
        String homeLocation = this.fPreferences.getString("platform_path");
        if (!locations.contains(homeLocation)) {
            locations.add(0, homeLocation);
        }
        this.fHomeText.setItems(locations.toArray(new String[locations.size()]));
        this.fHomeText.setText(homeLocation);
        this.fOriginalText = this.fHomeText.getText();
        this.fHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetPlatformPreferencePage.this.fNeedsReload = true;
            }
        });
        this.fHomeText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.fPluginsBlock.handleReload();
                TargetPlatformPreferencePage.this.fNeedsReload = false;
            }
        });
        this.fBrowseButton = new Button(container, 8);
        this.fBrowseButton.setText(PDEPlugin.getResourceString("Preferences.TargetPlatformPage.PlatformHome.Button"));
        this.fBrowseButton.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetPlatformPreferencePage.this.handleBrowse();
            }
        });
        Control block = this.fPluginsBlock.createContents(container);
        GridData gd = new GridData(1296);
        gd.horizontalSpan = 3;
        block.setLayoutData((Object)gd);
        this.fPluginsBlock.initialize();
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.target_platform_preference_page");
        return container;
    }

    String getPlatformPath() {
        return this.fHomeText.getText();
    }

    private void handleBrowse() {
        String newPath;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        if (this.fHomeText.getText().length() > 0) {
            dialog.setFilterPath(this.fHomeText.getText());
        }
        if ((newPath = dialog.open()) != null && !ExternalModelManager.arePathsEqual((IPath)new Path(this.fHomeText.getText()), (IPath)new Path(newPath))) {
            if (this.fHomeText.indexOf(newPath) == -1) {
                this.fHomeText.add(newPath, 0);
            }
            this.fHomeText.setText(newPath);
            this.fPluginsBlock.handleReload();
            this.fNeedsReload = false;
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        this.fHomeText.setText(ExternalModelManager.computeDefaultPlatformPath());
        this.fPluginsBlock.handleReload();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fNeedsReload && !ExternalModelManager.arePathsEqual((IPath)new Path(this.fOriginalText), (IPath)new Path(this.fHomeText.getText()))) {
            MessageDialog dialog = new MessageDialog(this.getShell(), PDEPlugin.getResourceString("Preferences.TargetPlatformPage.title"), null, PDEPlugin.getResourceString("Preferences.TargetPlatformPage.question"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
            if (dialog.open() == 1) {
                return false;
            }
            this.fPluginsBlock.handleReload();
        }
        this.fPluginsBlock.save();
        return super.performOk();
    }

    public String[] getPlatformLocations() {
        return this.fHomeText.getItems();
    }

    public void resetNeedsReload() {
        this.fNeedsReload = false;
        String location = this.fHomeText.getText();
        if (this.fHomeText.indexOf(location) == -1) {
            this.fHomeText.add(location, 0);
        }
    }
}

