/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;

public class PluginJavaSearchUtil {
    public static void collectAllPrerequisites(IPlugin plugin, HashSet set) {
        int i;
        if (!set.add(plugin)) {
            return;
        }
        if (plugin.getModel() instanceof WorkspacePluginModelBase) {
            IFragment[] fragments = PDECore.getDefault().getWorkspaceModelManager().getFragmentsFor(plugin.getId(), plugin.getVersion());
            i = 0;
            while (i < fragments.length) {
                set.add(fragments[i]);
                ++i;
            }
        }
        IPluginImport[] imports = plugin.getImports();
        i = 0;
        while (i < imports.length) {
            IPlugin child;
            if (imports[i].isReexported() && (child = PDECore.getDefault().findPlugin(imports[i].getId())) != null) {
                PluginJavaSearchUtil.collectAllPrerequisites(child, set);
            }
            ++i;
        }
    }

    public static IPackageFragment[] collectPackageFragments(IPluginBase[] models, IProject parentProject) throws JavaModelException {
        ArrayList result = new ArrayList();
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)parentProject).getAllPackageFragmentRoots();
        int i = 0;
        while (i < models.length) {
            int j;
            IPluginBase preReq = models[i];
            IResource resource = preReq.getModel().getUnderlyingResource();
            if (resource == null) {
                ArrayList libraryPaths = PluginJavaSearchUtil.getLibraryPaths(preReq);
                j = 0;
                while (j < roots.length) {
                    if (libraryPaths.contains(roots[j].getPath())) {
                        PluginJavaSearchUtil.extractFragments(roots[j], result);
                    }
                    ++j;
                }
            } else {
                IProject project = resource.getProject();
                j = 0;
                while (j < roots.length) {
                    IJavaProject jProject = (IJavaProject)roots[j].getParent();
                    if (jProject.getProject().equals((Object)project)) {
                        PluginJavaSearchUtil.extractFragments(roots[j], result);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IPackageFragment[result.size()]);
    }

    private static void extractFragments(IPackageFragmentRoot root, ArrayList result) {
        try {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                IPackageFragment fragment = (IPackageFragment)children[i];
                if (fragment.getChildren().length > 0) {
                    result.add(fragment);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private static ArrayList getLibraryPaths(IPluginBase plugin) {
        ArrayList<Path> libraryPaths = new ArrayList<Path>();
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(plugin.getId(), plugin.getVersion());
        IPluginLibrary[] libraries = plugin.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            String libraryName = ClasspathUtilCore.expandLibraryName((String)libraries[i].getName());
            String path = String.valueOf(plugin.getModel().getInstallLocation()) + '/' + libraryName;
            if (new File(path).exists()) {
                libraryPaths.add(new Path(path));
            } else {
                PluginJavaSearchUtil.findLibraryInFragments(fragments, libraryName, libraryPaths);
            }
            ++i;
        }
        return libraryPaths;
    }

    private static void findLibraryInFragments(IFragment[] fragments, String libraryName, ArrayList libraryPaths) {
        int i = 0;
        while (i < fragments.length) {
            String path = String.valueOf(fragments[i].getModel().getInstallLocation()) + '/' + libraryName;
            if (new File(path).exists()) {
                libraryPaths.add(new Path(path));
                break;
            }
            ++i;
        }
    }
}

