/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchScope;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.JavaSearchOperation;
import org.eclipse.pde.internal.ui.search.PluginSearchResultCollector;
import org.eclipse.pde.internal.ui.search.PluginSearchUIOperation;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;

public class ReferencesInPluginAction
extends Action {
    private static final String KEY_REFERENCES = "DependencyExtent.references";
    ISearchResultViewEntry entry;

    public ReferencesInPluginAction(ISearchResultViewEntry entry) {
        this.entry = entry;
        this.setText(String.valueOf(PDEPlugin.getResourceString(KEY_REFERENCES)) + " " + entry.getResource().getName());
    }

    public void run() {
        try {
            SearchUI.activateSearchResultView();
            IWorkspaceRunnable operation = null;
            Object object = this.entry.getGroupByKey();
            operation = object instanceof IJavaElement ? new JavaSearchOperation((IJavaElement)object, (IProject)this.entry.getResource()) : new PluginSearchUIOperation(this.getPluginSearchInput((IPluginExtensionPoint)object), new PluginSearchResultCollector());
            PDEPlugin.getWorkspace().run(operation, null, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    private PluginSearchInput getPluginSearchInput(IPluginExtensionPoint object) {
        PluginSearchInput input = new PluginSearchInput();
        input.setSearchElement(3);
        input.setSearchString(String.valueOf(object.getPluginBase().getId()) + "." + object.getId());
        input.setSearchLimit(2);
        HashSet<IFile> set = new HashSet<IFile>();
        IFile resource = ((IProject)this.entry.getResource()).getFile("plugin.xml");
        if (!resource.exists()) {
            resource = ((IProject)this.entry.getResource()).getFile("fragment.xml");
        }
        set.add(resource);
        input.setSearchScope(new PluginSearchScope(1, 0, set));
        return input;
    }
}

