/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchShortcut;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public abstract class BaseExportWizard
extends Wizard
implements IExportWizard,
IPreferenceConstants {
    private IStructuredSelection selection;
    protected BaseExportWizardPage page1;

    public BaseExportWizard() {
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(this.getSettingsSection(masterSettings));
    }

    public void addPages() {
        this.page1 = this.createPage1();
        this.addPage((IWizardPage)this.page1);
    }

    protected abstract BaseExportWizardPage createPage1();

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected abstract IDialogSettings getSettingsSection(IDialogSettings var1);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        File zipFile;
        this.page1.saveSettings();
        if (this.page1.doGenerateAntFile()) {
            this.generateAntBuildFile(this.page1.getAntBuildFileName());
        }
        if (this.page1.doExportAsZip() && (zipFile = new File(this.page1.getDestination(), this.page1.getFileName())).exists()) {
            if (!MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)PDEPlugin.getResourceString("BaseExportWizard.confirmReplace.title"), (String)PDEPlugin.getFormattedMessage("BaseExportWizard.confirmReplace.desc", zipFile.getAbsolutePath()))) {
                return false;
            }
            zipFile.delete();
        }
        this.scheduleExportJob();
        return true;
    }

    private void generateAntBuildFile(String filename) {
        File dir;
        String parent = new Path(filename).removeLastSegments(1).toOSString();
        String buildFilename = new Path(filename).lastSegment();
        if (!buildFilename.endsWith(".xml")) {
            buildFilename = String.valueOf(buildFilename) + ".xml";
        }
        if (!(dir = new File(new File(parent).getAbsolutePath())).exists()) {
            dir.mkdirs();
        }
        try {
            File buildFile = new File(dir, buildFilename);
            PrintWriter writer = new PrintWriter(new FileWriter(buildFile));
            this.generateAntTask(writer);
            writer.close();
            this.setDefaultValues(dir, buildFilename);
        }
        catch (IOException iOException) {}
    }

    private void setDefaultValues(File dir, String buildFilename) {
        try {
            IContainer container = PDEPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(dir.toString()));
            if (container != null && container.exists()) {
                ILaunchConfigurationWorkingCopy launchCopy;
                container.getProject().refreshLocal(2, null);
                IFile file = container.getFile((IPath)new Path(buildFilename));
                List configs = AntLaunchShortcut.findExistingLaunchConfigurations((IFile)file);
                if (configs.size() == 0) {
                    ILaunchConfiguration config = AntLaunchShortcut.createDefaultLaunchConfiguration((IFile)file);
                    launchCopy = config.getWorkingCopy();
                } else {
                    launchCopy = ((ILaunchConfiguration)configs.get(0)).getWorkingCopy();
                }
                if (launchCopy != null) {
                    launchCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
                    launchCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
                    launchCopy.doSave();
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected abstract void generateAntTask(PrintWriter var1);

    protected abstract void scheduleExportJob();

    protected String getExportOperation() {
        int exportType = this.page1.getExportType();
        switch (exportType) {
            case 0: {
                return "zip";
            }
            case 1: {
                return "directory";
            }
            case 2: {
                return "update";
            }
        }
        return "zip";
    }
}

