/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.PrintWriter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizard;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportJob;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportWizardPage;
import org.eclipse.ui.progress.IProgressConstants;

public class FeatureExportWizard
extends BaseExportWizard {
    private static final String KEY_WTITLE = "ExportWizard.Feature.wtitle";
    private static final String STORE_SECTION = "FeatureExportWizard";

    public FeatureExportWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_FEATURE_EXPORT_WIZ);
        this.setWindowTitle(PDEPlugin.getResourceString(KEY_WTITLE));
    }

    protected BaseExportWizardPage createPage1() {
        return new FeatureExportWizardPage(this.getSelection());
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    protected void scheduleExportJob() {
        FeatureExportJob job = new FeatureExportJob(this.page1.getExportType(), this.page1.doExportSource(), this.page1.getDestination(), this.page1.getFileName(), this.page1.getSelectedItems());
        job.setUser(true);
        job.schedule();
        job.setProperty(IProgressConstants.ICON_PROPERTY, PDEPluginImages.DESC_FEATURE_OBJ);
    }

    protected void generateAntTask(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<project name=\"build\" default=\"feature_export\">");
        writer.println("\t<target name=\"feature_export\">");
        writer.print("\t\t<pde.exportFeatures features=\"" + this.getFeatureIDs() + "\" destination=\"" + this.page1.getDestination() + "\" ");
        String filename = this.page1.getFileName();
        if (filename != null) {
            writer.print("filename=\"" + filename + "\" ");
        }
        writer.print("exportType=\"" + this.getExportOperation() + "\" ");
        writer.println("exportSource=\"" + (this.page1.doExportSource() ? "true" : "false") + "\"/>");
        writer.println("\t</target>");
        writer.println("</project>");
    }

    private String getFeatureIDs() {
        StringBuffer buffer = new StringBuffer();
        Object[] objects = this.page1.getSelectedItems();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IFeatureModel) {
                buffer.append(((IFeatureModel)object).getFeature().getId());
                if (i < objects.length - 1) {
                    buffer.append(",");
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

