/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagConfigurationDialog;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.merge.ProjectElement;
import org.eclipse.team.internal.ccvs.ui.merge.TagElement;
import org.eclipse.team.internal.ccvs.ui.repo.NewDateTagAction;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.repo.RepositorySorter;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TagSelectionDialog
extends Dialog {
    private ICVSFolder[] folders;
    private int includeFlags;
    private CVSTag result;
    private String helpContext;
    private IStructuredSelection selection;
    public static final int INCLUDE_HEAD_TAG = 1;
    public static final int INCLUDE_BASE_TAG = 2;
    public static final int INCLUDE_BRANCHES = 4;
    public static final int INCLUDE_VERSIONS = 8;
    public static final int INCLUDE_DATES = 16;
    public static final int INCLUDE_ALL_TAGS = 31;
    private TreeViewer tagTree;
    private Button okButton;
    private String title;
    private String message;
    private boolean recurse = true;
    private boolean showRecurse;
    private static final int SIZING_DIALOG_WIDTH = 400;
    private static final int SIZING_DIALOG_HEIGHT = 250;
    static /* synthetic */ Class class$0;

    public static CVSTag getTagToCompareWith(Shell shell, IProject[] projects) {
        return TagSelectionDialog.getTagToCompareWith(shell, TagSelectionDialog.getCVSFoldersFor(projects));
    }

    public static CVSTag getTagToCompareWith(Shell shell, ICVSFolder[] folders) {
        TagSelectionDialog dialog = new TagSelectionDialog(shell, folders, Policy.bind("CompareWithTagAction.message"), Policy.bind("TagSelectionDialog.Select_a_Tag_1"), 31, false, "org.eclipse.team.cvs.ui.compare_tag_selection_dialog_context");
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 1) {
            return null;
        }
        return dialog.getResult();
    }

    public TagSelectionDialog(Shell parentShell, IProject[] projects, String title, String message, int includeFlags, boolean showRecurse, String helpContext) {
        this(parentShell, TagSelectionDialog.getCVSFoldersFor(projects), title, message, includeFlags, showRecurse, helpContext);
    }

    private static ICVSFolder[] getCVSFoldersFor(IProject[] projects) {
        ICVSFolder[] folders = new ICVSFolder[projects.length];
        int i = 0;
        while (i < projects.length) {
            folders[i] = CVSWorkspaceRoot.getCVSFolderFor((IContainer)projects[i]);
            ++i;
        }
        return folders;
    }

    public TagSelectionDialog(Shell parentShell, ICVSFolder[] folders, String title, String message, int includeFlags, boolean showRecurse, String helpContext) {
        super(parentShell);
        this.folders = folders;
        this.title = title;
        this.message = message;
        this.includeFlags = includeFlags;
        this.showRecurse = showRecurse;
        this.helpContext = helpContext;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void create() {
        super.create();
        this.initialize();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        if (this.helpContext != null) {
            WorkbenchHelp.setHelp((Control)top, (String)this.helpContext);
        }
        Composite inner = new Composite(top, 0);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        data.heightHint = 250;
        inner.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        inner.setLayout((Layout)layout);
        Label l = new Label(inner, 0);
        l.setText(this.message);
        this.tagTree = this.createTree(inner);
        this.tagTree.setInput((Object)new ProjectElement(this.folders[0], this.includeFlags));
        this.tagTree.setSorter((ViewerSorter)new ProjectElement.ProjectElementSorter());
        Runnable refresh = new Runnable(){

            public void run() {
                TagSelectionDialog.this.getShell().getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        TagSelectionDialog.access$0(1.access$0(this.this$1)).refresh();
                    }
                });
            }

            static /* synthetic */ TagSelectionDialog access$0(1 var0) {
                return var0.TagSelectionDialog.this;
            }
        };
        MenuManager menuMgr = new MenuManager();
        Tree tree = this.tagTree.getTree();
        Menu menu = menuMgr.createContextMenu((Control)tree);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TagSelectionDialog.this.addMenuItemActions(manager);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menu);
        if (this.showRecurse) {
            final Button recurseCheck = new Button(top, 32);
            recurseCheck.setText(Policy.bind("TagSelectionDialog.recurseOption"));
            recurseCheck.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TagSelectionDialog.this.recurse = recurseCheck.getSelection();
                }
            });
            recurseCheck.setSelection(true);
        }
        TagConfigurationDialog.createTagDefinitionButtons(this.getShell(), top, this.folders, this.convertVerticalDLUsToPixels(14), this.convertHorizontalDLUsToPixels(61), refresh, refresh);
        Label seperator = new Label(top, 258);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        seperator.setLayoutData((Object)data);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
        return top;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 2050);
        tree.setLayoutData((Object)new GridData(1808));
        TreeViewer result = new TreeViewer(tree);
        result.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagSelectionDialog.this.updateEnablement();
            }
        });
        result.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TagSelectionDialog.this.tagTree.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof TagElement) {
                    TagSelectionDialog.this.okPressed();
                }
            }
        });
        result.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                TagSelectionDialog.this.handleKeyPressed(event);
            }

            public void keyReleased(KeyEvent event) {
                TagSelectionDialog.this.handleKeyReleased(event);
            }
        });
        result.setSorter((ViewerSorter)new RepositorySorter());
        return result;
    }

    public CVSTag getResult() {
        return this.result;
    }

    public boolean getRecursive() {
        return this.recurse;
    }

    protected void initialize() {
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.tagTree.getSelection();
        Object o = selection.getFirstElement();
        TagElement element = (TagElement)o;
        this.result = element.getTag();
        super.okPressed();
    }

    protected void updateEnablement() {
        this.selection = (IStructuredSelection)this.tagTree.getSelection();
        if (this.okButton != null) {
            if (this.selection.isEmpty() || this.selection.size() != 1 || !(this.selection.getFirstElement() instanceof TagElement)) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            this.deleteDateTag();
        }
    }

    private void deleteDateTag() {
        TagElement[] selectedDateTagElements = this.getSelectedDateTagElement();
        if (selectedDateTagElements.length == 0) {
            return;
        }
        int i = 0;
        while (i < selectedDateTagElements.length) {
            RepositoryManager mgr = CVSUIPlugin.getPlugin().getRepositoryManager();
            CVSTag tag = selectedDateTagElements[i].getTag();
            if (tag.getType() == 3) {
                mgr.removeDateTag(this.getLocation(), tag);
            }
            ++i;
        }
        this.tagTree.refresh();
        this.updateEnablement();
    }

    protected void handleKeyReleased(KeyEvent event) {
    }

    private ICVSRepositoryLocation getLocation() {
        RepositoryManager mgr = CVSUIPlugin.getPlugin().getRepositoryManager();
        ICVSRepositoryLocation location = mgr.getRepositoryLocationFor((ICVSResource)this.folders[0]);
        return location;
    }

    private TagElement[] getSelectedDateTagElement() {
        ArrayList<Object> dateTagElements = null;
        if (this.selection != null && !this.selection.isEmpty()) {
            dateTagElements = new ArrayList<Object>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next;
                Object e = elements.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.team.internal.ccvs.ui.merge.TagElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((next = CVSAction.getAdapter(e, (Class)clazz)) instanceof TagElement) || ((TagElement)next).getTag().getType() != 3) continue;
                dateTagElements.add(next);
            }
        }
        if (dateTagElements != null && !dateTagElements.isEmpty()) {
            TagElement[] result = new TagElement[dateTagElements.size()];
            dateTagElements.toArray(result);
            return result;
        }
        return new TagElement[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addDateTag(CVSTag tag) {
        if (tag == null) {
            return;
        }
        ArrayList<CVSTag> dateTags = new ArrayList<CVSTag>();
        dateTags.addAll(Arrays.asList(CVSUIPlugin.getPlugin().getRepositoryManager().getKnownTags(this.folders[0], 3)));
        if (!dateTags.contains(tag)) {
            CVSUIPlugin.getPlugin().getRepositoryManager().addDateTag(this.getLocation(), tag);
        }
        try {
            this.tagTree.getControl().setRedraw(false);
            this.tagTree.refresh();
            Object[] expanded = this.tagTree.getExpandedElements();
            this.tagTree.expandToLevel(2);
            this.tagTree.collapseAll();
            int i = 0;
            while (true) {
                block6: {
                    if (i < expanded.length) break block6;
                    this.tagTree.reveal((Object)new TagElement(tag));
                    this.tagTree.setSelection((ISelection)new StructuredSelection((Object)new TagElement(tag)));
                    break;
                }
                Object object = expanded[i];
                this.tagTree.expandToLevel(object, 1);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.tagTree.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.tagTree.getControl().setRedraw(true);
        this.updateEnablement();
    }

    private void addMenuItemActions(IMenuManager manager) {
        manager.add((IAction)new Action(Policy.bind("TagSelectionDialog.0")){

            public void run() {
                CVSTag dateTag = NewDateTagAction.getDateTag(TagSelectionDialog.this.getShell(), CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryLocationFor((ICVSResource)TagSelectionDialog.this.folders[0]));
                TagSelectionDialog.this.addDateTag(dateTag);
            }
        });
        if (this.getSelectedDateTagElement().length > 0) {
            manager.add((IAction)new Action(Policy.bind("TagSelectionDialog.1")){

                public void run() {
                    TagSelectionDialog.this.deleteDateTag();
                }
            });
        }
    }
}

