/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.BranchPromptDialog;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.ui.IWorkbenchPart;

public class BranchOperation
extends RepositoryProviderOperation {
    private boolean update;
    private CVSTag rootVersionTag;
    private CVSTag branchTag;

    public BranchOperation(IWorkbenchPart part, IResource[] resources) {
        super(part, resources);
    }

    public void setTags(CVSTag rootVersionTag, CVSTag branchTag, boolean updateToBranch) {
        this.rootVersionTag = rootVersionTag;
        this.branchTag = branchTag;
        this.update = updateToBranch;
    }

    protected boolean shouldRun() {
        IResource[] resources = this.getResources();
        boolean allSticky = this.areAllResourcesSticky(resources);
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resources[0].getProject());
        BranchPromptDialog dialog = new BranchPromptDialog(this.getShell(), Policy.bind("BranchWizard.title"), folder, allSticky, this.calculateInitialVersionName(resources, allSticky));
        if (dialog.open() != 0) {
            return false;
        }
        String tagString = dialog.getBranchTagName();
        this.update = dialog.getUpdate();
        String versionString = dialog.getVersionTagName();
        this.rootVersionTag = versionString == null ? null : new CVSTag(versionString, 2);
        this.branchTag = new CVSTag(tagString, 1);
        if (this.update) {
            try {
                if (!CVSAction.checkForMixingTags(this.getShell(), resources, this.branchTag)) {
                    return false;
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return super.shouldRun();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(CVSTeamProvider provider, IResource[] providerResources, IProgressMonitor monitor) throws CVSException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, 100);
                this.makeBranch(provider, providerResources, this.rootVersionTag, this.branchTag, this.update, Policy.subMonitorFor(monitor, 90));
                this.updateRememberedTags(providerResources);
                if (this.update) {
                    this.updateWorkspaceSubscriber(provider, this.getCVSArguments(providerResources), Policy.subMonitorFor(monitor, 10));
                }
                this.collectStatus(Status.OK_STATUS);
            }
            catch (TeamException e) {
                this.collectStatus(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void makeBranch(CVSTeamProvider provider, IResource[] resources, CVSTag versionTag, CVSTag branchTag, boolean moveToBranch, IProgressMonitor monitor) throws TeamException {
        int totalWork = (versionTag != null ? 60 : 40) + (moveToBranch ? 20 : 0);
        monitor.beginTask(Policy.bind("CVSTeamProvider.makeBranch"), totalWork);
        try {
            IStatus status;
            block14: {
                ICVSResource[] arguments;
                block15: {
                    Object var11_16;
                    arguments = this.getCVSArguments(resources);
                    status = null;
                    if (versionTag == null) break block15;
                    Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                    session.open(Policy.subMonitorFor(monitor, 5), true);
                    try {
                        status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, versionTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        session.close();
                        throw throwable;
                    }
                    {
                        var11_16 = null;
                    }
                    session.close();
                    if (!status.isOK()) break block14;
                    session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                    session.open(Policy.subMonitorFor(monitor, 5), true);
                    try {
                        status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, branchTag, arguments, null, Policy.subMonitorFor(monitor, 15));
                    }
                    catch (Throwable throwable) {
                        var11_16 = null;
                        session.close();
                        throw throwable;
                    }
                    {
                        var11_16 = null;
                        session.close();
                        break block14;
                    }
                }
                Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                session.open(Policy.subMonitorFor(monitor, 5), true);
                try {
                    status = Command.CUSTOM_TAG.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, branchTag, arguments, null, Policy.subMonitorFor(monitor, 35));
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    session.close();
                    throw throwable;
                }
                {
                    Object var11_18 = null;
                }
                session.close();
            }
            if (!status.isOK()) {
                throw new CVSServerException(status);
            }
            if (moveToBranch) {
                this.setTag(provider, resources, branchTag, Policy.subMonitorFor(monitor, 20));
            }
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var13_21 = null;
        }
        monitor.done();
    }

    private void setTag(final CVSTeamProvider provider, final IResource[] resources, final CVSTag tag, IProgressMonitor monitor) throws TeamException {
        this.getLocalRoot(provider).run(new ICVSRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor progress) throws CVSException {
                try {
                    progress.beginTask(null, 100);
                    IProgressMonitor monitor = Policy.infiniteSubMonitorFor(progress, 100);
                    monitor.beginTask(Policy.bind("CVSTeamProvider.folderInfo", provider.getProject().getName()), 512);
                    int i = 0;
                    while (i < resources.length) {
                        CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]).accept(new ICVSResourceVisitor(this, monitor, tag){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IProgressMonitor val$monitor;
                            private final /* synthetic */ CVSTag val$tag;
                            {
                                this.this$1 = var1_1;
                                this.val$monitor = iProgressMonitor;
                                this.val$tag = cVSTag;
                            }

                            public void visitFile(ICVSFile file) throws CVSException {
                                this.val$monitor.worked(1);
                                byte[] syncBytes = file.getSyncBytes();
                                if (syncBytes != null) {
                                    this.val$monitor.subTask(Policy.bind("CVSTeamProvider.updatingFile", file.getName()));
                                    file.setSyncBytes(ResourceSyncInfo.setTag((byte[])syncBytes, (CVSTag)this.val$tag), 0);
                                }
                            }

                            public void visitFolder(ICVSFolder folder) throws CVSException {
                                this.val$monitor.worked(1);
                                FolderSyncInfo info = folder.getFolderSyncInfo();
                                if (info != null) {
                                    this.val$monitor.subTask(Policy.bind("CVSTeamProvider.updatingFolder", info.getRepository()));
                                    folder.setFolderSyncInfo(new FolderSyncInfo(info.getRepository(), info.getRoot(), this.val$tag, info.getIsStatic()));
                                    folder.acceptChildren((ICVSResourceVisitor)this);
                                }
                            }
                        });
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    progress.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                progress.done();
            }
        }, monitor);
    }

    private void updateRememberedTags(IResource[] providerResources) throws CVSException {
        if (this.rootVersionTag != null || this.update) {
            int i = 0;
            while (i < providerResources.length) {
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)providerResources[i]);
                RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
                if (this.rootVersionTag != null) {
                    manager.addTags(cvsResource, new CVSTag[]{this.rootVersionTag});
                }
                if (this.update) {
                    manager.addTags(cvsResource, new CVSTag[]{this.branchTag});
                }
                ++i;
            }
        }
    }

    protected String getTaskName() {
        return Policy.bind("BranchOperation.0");
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return Policy.bind("BranchOperation.1", provider.getProject().getName());
    }

    private boolean areAllResourcesSticky(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (!this.hasStickyTag(resources[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasStickyTag(IResource resource) {
        try {
            int tagType;
            CVSTag tag;
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            if (cvsResource.isFolder()) {
                FolderSyncInfo folderInfo = ((ICVSFolder)cvsResource).getFolderSyncInfo();
                tag = folderInfo.getTag();
            } else {
                ResourceSyncInfo info = cvsResource.getSyncInfo();
                tag = info.getTag();
            }
            if (tag != null && (tagType = tag.getType()) == 2) {
                return true;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            return false;
        }
        return false;
    }

    private String calculateInitialVersionName(IResource[] resources, boolean allSticky) {
        String versionName = "";
        try {
            if (allSticky) {
                IResource stickyResource = resources[0];
                if (stickyResource.getType() == 1) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)stickyResource));
                    versionName = cvsFile.getSyncInfo().getTag().getName();
                } else {
                    ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)stickyResource));
                    versionName = cvsFolder.getFolderSyncInfo().getTag().getName();
                }
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
            versionName = "";
        }
        return versionName;
    }
}

