/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.ReplaceOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.SafeUpdateOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class WorkspaceUpdateOperation
extends SafeUpdateOperation {
    protected WorkspaceUpdateOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, boolean promptBeforeUpdate) {
        super(configuration, elements, promptBeforeUpdate);
    }

    protected void runUpdateDeletions(SyncInfo[] nodes, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask(null, nodes.length * 100);
        int i = 0;
        while (i < nodes.length) {
            SyncInfo node = nodes[i];
            this.unmanage(node, Policy.subMonitorFor(monitor, 50));
            this.deleteAndKeepHistory(node.getLocal(), Policy.subMonitorFor(monitor, 50));
            ++i;
        }
        this.pruneEmptyParents(nodes);
        monitor.done();
    }

    protected void runSafeUpdate(SyncInfo[] nodes, IProgressMonitor monitor) throws TeamException {
        this.safeUpdate(this.getIResourcesFrom(nodes), new Command.LocalOption[]{Command.DO_NOT_RECURSE}, monitor);
    }

    protected void overwriteUpdate(SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        try {
            new ReplaceOperation(this.getPart(), syncSet.getResources(), null, false).run(monitor);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            Policy.cancelOperation();
        }
    }

    protected void updated(IResource[] resources) throws TeamException {
    }

    private void unmanage(SyncInfo element, IProgressMonitor monitor) throws CVSException {
        CVSWorkspaceRoot.getCVSResourceFor((IResource)element.getLocal()).unmanage(monitor);
    }

    private void deleteAndKeepHistory(IResource resource, IProgressMonitor monitor) throws CVSException {
        try {
            if (!resource.exists()) {
                return;
            }
            if (resource.getType() == 1) {
                ((IFile)resource).delete(false, true, monitor);
            } else if (resource.getType() == 2) {
                ((IFolder)resource).delete(false, true, monitor);
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException((CoreException)e);
        }
    }
}

