/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagConfigurationDialog;
import org.eclipse.team.internal.ccvs.ui.merge.ProjectElement;
import org.eclipse.team.internal.ccvs.ui.merge.TagElement;
import org.eclipse.team.internal.ccvs.ui.repo.RepositorySorter;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TagSelectionWizardPage
extends CVSWizardPage {
    private TreeViewer tagTree;
    private ICVSFolder[] remoteFolders;
    private CVSTag selectedTag;
    private Composite composite;
    private Control buttons;
    private String label;
    private int includeFlags;
    boolean allowNoTag = false;
    private Button useResourceTagButton;
    private Button selectTagButton;
    private boolean useResourceTag = false;
    private String helpContextId;

    public TagSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage, String description, String label, int includeFlags) {
        super(pageName, title, titleImage, description);
        this.label = label;
        this.includeFlags = includeFlags;
    }

    public void setHelpContxtId(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite parent) {
        this.composite = this.createComposite(parent, 1);
        this.setControl((Control)this.composite);
        if (this.helpContextId != null) {
            WorkbenchHelp.setHelp((Control)this.composite, (String)this.helpContextId);
        }
        if (this.allowNoTag) {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TagSelectionWizardPage.this.useResourceTag = TagSelectionWizardPage.this.useResourceTagButton.getSelection();
                    TagSelectionWizardPage.this.updateEnablement();
                }
            };
            this.useResourceTag = true;
            this.useResourceTagButton = this.createRadioButton(this.composite, Policy.bind("TagSelectionWizardPage.0"), 1);
            this.selectTagButton = this.createRadioButton(this.composite, Policy.bind("TagSelectionWizardPage.1"), 1);
            this.useResourceTagButton.setSelection(this.useResourceTag);
            this.selectTagButton.setSelection(!this.useResourceTag);
            this.useResourceTagButton.addSelectionListener((SelectionListener)listener);
            this.selectTagButton.addSelectionListener((SelectionListener)listener);
        } else if (this.label != null) {
            this.createWrappingLabel(this.composite, this.label, 0);
        }
        this.tagTree = this.createTree(this.composite);
        this.tagTree.setSorter((ViewerSorter)new ProjectElement.ProjectElementSorter());
        this.setInput();
        Dialog.applyDialogFont((Control)parent);
    }

    private void setInput() {
        if (this.remoteFolders != null && this.remoteFolders.length > 0 && this.tagTree != null && !this.tagTree.getControl().isDisposed()) {
            this.tagTree.setInput((Object)new ProjectElement(this.remoteFolders[0], this.includeFlags));
            try {
                this.selectedTag = this.remoteFolders[0].getFolderSyncInfo().getTag();
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            if (this.selectedTag == null) {
                this.selectedTag = CVSTag.DEFAULT;
            }
            this.tagTree.expandToLevel(2);
            this.tagTree.collapseAll();
            this.tagTree.reveal((Object)new TagElement(this.selectedTag));
            this.tagTree.setSelection((ISelection)new StructuredSelection((Object)new TagElement(this.selectedTag)));
            if (this.buttons != null) {
                this.buttons.dispose();
                this.buttons = null;
            }
            Runnable refresh = new Runnable(){

                public void run() {
                    TagSelectionWizardPage.this.getShell().getDisplay().syncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            TagSelectionWizardPage.access$3(2.access$0(this.this$1)).refresh();
                        }
                    });
                }

                static /* synthetic */ TagSelectionWizardPage access$0(2 var0) {
                    return var0.TagSelectionWizardPage.this;
                }
            };
            this.buttons = TagConfigurationDialog.createTagDefinitionButtons(this.getShell(), this.composite, this.remoteFolders, this.convertVerticalDLUsToPixels(14), this.convertHorizontalDLUsToPixels(61), refresh, refresh);
            this.composite.layout();
        }
    }

    private TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 2052);
        GridData gridData = new GridData(1808);
        tree.setLayoutData((Object)gridData);
        gridData.heightHint = 150;
        TreeViewer result = new TreeViewer(tree);
        result.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty() || !(selection.getFirstElement() instanceof TagElement)) {
                    TagSelectionWizardPage.this.selectedTag = null;
                } else {
                    TagSelectionWizardPage.this.selectedTag = ((TagElement)selection.getFirstElement()).getTag();
                }
                TagSelectionWizardPage.this.updateEnablement();
            }
        });
        result.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TagSelectionWizardPage.this.tagTree.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof TagElement) {
                    TagSelectionWizardPage.this.gotoNextPage();
                }
            }
        });
        result.setSorter((ViewerSorter)new RepositorySorter());
        return result;
    }

    private void updateEnablement() {
        this.tagTree.getControl().setEnabled(!this.useResourceTag);
        this.setPageComplete(this.useResourceTag || this.selectedTag != null);
    }

    public ICVSFolder getFolder() {
        return this.remoteFolders[0];
    }

    public void setFolder(ICVSFolder remote) {
        this.setFolders(new ICVSFolder[]{remote});
    }

    public CVSTag getSelectedTag() {
        if (this.useResourceTag) {
            return null;
        }
        return this.selectedTag;
    }

    protected void gotoNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public void setFolders(ICVSFolder[] remoteFolders) {
        this.remoteFolders = remoteFolders;
        this.setInput();
    }

    public void setAllowNoTag(boolean b) {
        this.allowNoTag = b;
    }
}

