/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.log;

import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ShortFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public String format(LogRecord logRecord) {
        Object[] objectArray = new String[]{this.getLevelName(logRecord), this.getSourceName(logRecord), this.formatMessage(logRecord), LINE_SEPARATOR};
        return MessageFormat.format("{0} {1}> {2}{3}", objectArray);
    }

    private String getLevelName(LogRecord logRecord) {
        String string = logRecord.getLevel().getLocalizedName();
        string = string.replaceFirst("(..).*", "$1");
        return string;
    }

    private String getSourceName(LogRecord logRecord) {
        String string = logRecord.getSourceClassName();
        if (string != null) {
            string = string.replaceFirst(".+\\.", "");
        }
        Object[] objectArray = new String[]{string, logRecord.getSourceMethodName()};
        return MessageFormat.format("{0}#{1}", objectArray);
    }
}

