/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.ui;

import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileFilter;
import mergedoc.ui.ComponentFactory;

public class FileChooserField
extends JPanel {
    private final JLabel label = new JLabel();
    private final JTextField textField = new JTextField();
    private final JButton button = new JButton();
    private final JComboBox combo = new JComboBox();
    private JFileChooser chooser;
    private ActionListener chooseListener;
    public static final String ENCODING_DEFAULT = System.getProperty("file.encoding");
    public static final String ENCODING_AUTO = "JISAutoDetect";

    public FileChooserField() {
        this.setLayout(new BoxLayout(this, 0));
        int n = (int)ComponentFactory.createMaxDimension().getWidth();
        this.textField.setMaximumSize(new Dimension(n, 20));
        this.textField.setTransferHandler(new FileDropHandler());
        ComponentFactory.ensureSize(this.button, 20, 18);
        this.button.setText("...");
        CharsetSortedModel charsetSortedModel = new CharsetSortedModel();
        charsetSortedModel.add("EUC-JP");
        charsetSortedModel.add("EUC-JP-LINUX");
        charsetSortedModel.add("ISO-2022-JP");
        charsetSortedModel.add("MS932");
        charsetSortedModel.add("Shift_JIS");
        charsetSortedModel.add("UTF-16");
        charsetSortedModel.add("UTF-16BE");
        charsetSortedModel.add("UTF-16LE");
        charsetSortedModel.add("UTF-8");
        charsetSortedModel.add(FileChooserField.ENCODING_DEFAULT);
        charsetSortedModel.fireAdded();
        this.add(this.label);
        this.add(ComponentFactory.createSpacer(10, 0));
        this.add(this.textField);
        this.add(this.button);
        this.add(ComponentFactory.createSpacer(5, 0));
        this.add(this.combo);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FileChooserField.this.chooser.showOpenDialog(FileChooserField.this);
                if (n == 0) {
                    FileChooserField.this.setFile(FileChooserField.this.chooser.getSelectedFile());
                    if (FileChooserField.this.chooseListener != null) {
                        FileChooserField.this.chooseListener.actionPerformed(actionEvent);
                    }
                }
            }
        });
        this.setDirectoriesOnly(false);
    }

    public void setDirectoriesOnly(boolean bl) {
        this.chooser = new JFileChooser();
        if (bl) {
            this.chooser.setFileSelectionMode(1);
            final FileFilter fileFilter = this.chooser.getFileFilter();
            this.chooser.removeChoosableFileFilter(fileFilter);
            this.chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return fileFilter.accept(file);
                }

                public String getDescription() {
                    return "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u307f";
                }
            });
        } else {
            this.chooser.setFileSelectionMode(0);
            this.chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".zip") || file.getName().endsWith(".jar");
                }

                public String getDescription() {
                    return "*.zip, *.jar";
                }
            });
        }
    }

    public void setChooseListener(ActionListener actionListener) {
        this.chooseListener = actionListener;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setFile(File file) {
        this.textField.setText(file.getPath());
        this.chooser.setSelectedFile(file);
    }

    public File getFile() {
        return new File(this.textField.getText());
    }

    public JComboBox getComboBox() {
        return this.combo;
    }

    private class FileDropHandler
    extends TransferHandler {
        TransferHandler originHandler;

        private FileDropHandler() {
            this.originHandler = FileChooserField.this.textField.getTransferHandler();
        }

        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            this.originHandler.exportToClipboard(jComponent, clipboard, n);
        }

        public int getSourceActions(JComponent jComponent) {
            return this.originHandler.getSourceActions(jComponent);
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].isFlavorJavaFileListType()) continue;
                return true;
            }
            return this.originHandler.canImport(jComponent, dataFlavorArray);
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            boolean bl = false;
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    File file = (File)list.get(0);
                    FileChooserField.this.setFile(file);
                    FileChooserField.this.textField.repaint();
                    bl = true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {}
            } else {
                bl = this.originHandler.importData(jComponent, transferable);
            }
            if (bl && FileChooserField.this.chooseListener != null && FileChooserField.this.getFile().exists()) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ FileDropHandler this$1;
                    {
                        this.this$1 = fileDropHandler;
                    }

                    public void run() {
                        FileChooserField.access$500(FileDropHandler.access$800(this.this$1)).actionPerformed(null);
                    }
                });
            }
            return bl;
        }

        static /* synthetic */ FileChooserField access$800(FileDropHandler fileDropHandler) {
            return fileDropHandler.FileChooserField.this;
        }
    }

    private class CharsetSortedModel
    extends DefaultComboBoxModel {
        private final SortedSet names;

        private CharsetSortedModel() {
            this.names = new TreeSet();
        }

        private CharsetSortedModel(SortedSet sortedSet) {
            super(sortedSet.toArray());
            this.names = sortedSet;
        }

        private boolean isSupported(Object object) {
            try {
                new String(new byte[0], object.toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return false;
            }
            return true;
        }

        private void add(Object object) {
            if (this.isSupported(object)) {
                this.names.add(object);
            }
        }

        private void fireAdded() {
            FileChooserField.this.combo.setModel(new CharsetSortedModel(this.names));
        }

        public void addElement(Object object) {
            if (this.isSupported(object) && !this.names.contains(object)) {
                this.names.add(object);
                this.fireAdded();
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                if (!this.names.contains(object)) {
                    this.addElement(object);
                }
                super.setSelectedItem(object);
            }
        }
    }
}

