/*
 * Copyright (c) 2003 Shinji Kashihara. All rights reserved.
 * 
 * This program and the accompanying materials are made available under
 * the terms of the Common Public License v1.0 which accompanies
 * this distribution, and is available at cpl-v10.html.
 */
package mergedoc.log;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * トレースロガーです。
 * @author Shinji Kashihara
 */
public class TraceLogger {

    /** ロガーの名前 */
    private static final String LOGGER_NAME =
        TraceLogger.class.getPackage().getName(); 

    // ロガー初期設定
    static {
        Logger logger = getLogger();
        logger.setUseParentHandlers(false);

        // コンソールハンドラ設定
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new ShortFormatter());
        handler.setLevel(Level.ALL);
        logger.addHandler(handler);

        // ログレベル設定
        Level level = null;
        try {
            level = Level.parse(System.getProperty("logging.level"));
        } catch (RuntimeException e) {
            level = Level.SEVERE;
        }
        logger.setLevel(level);
    }

    /**
     * コンストラクタです。
     * 外部生成不可。 
     */
    private TraceLogger() {
    }

    /**
     * ロガーを取得します。
     * @return ロガー  
     */
    public static Logger getLogger() {
        return Logger.getLogger(LOGGER_NAME);
    }
}
