/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.core;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mergedoc.core.FastStringUtils;
import mergedoc.core.PatternCache;
import mergedoc.core.Signature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comment {
    private static final Log log = LogFactory.getLog(Comment.class);
    private static final int DEFAULT_WIDTH = 80;
    private final Signature sig;
    private String docBody;
    private String deprecate;
    private List<String> sees;
    private List<String> sinces;
    private List<String> params;
    private List<String> returns;
    private List<String> throwses;
    private String srcBody;
    private List<String> srcAuthors;
    private List<String> srcVersions;
    private List<String> srcSerials;
    private List<String> srcSerialFields;
    private List<String> srcSerialDatas;
    private List<String> srcSpecs;

    public Comment(Signature sig) {
        this.sig = sig;
    }

    public void setDocumentBody(String docBody) {
        this.docBody = this.formatHTML(docBody);
    }

    private String formatHTML(String comment) {
        boolean hasHtmlTag = comment.contains("<");
        if (hasHtmlTag) {
            Pattern pat = PatternCache.getPattern("</?\\w+");
            Matcher mat = pat.matcher(comment);
            StringBuffer sb = new StringBuffer();
            while (mat.find()) {
                String tag = mat.group().toLowerCase();
                mat.appendReplacement(sb, tag);
            }
            mat.appendTail(sb);
            comment = sb.toString();
        }
        if (!hasHtmlTag || !comment.contains("<pre>")) {
            comment = FastStringUtils.replaceAll(comment, "(?m)^ +", "");
        }
        if (hasHtmlTag) {
            comment = FastStringUtils.replace(comment, "</p>", "");
            if ((comment = FastStringUtils.replaceAll(comment, "\\s*(</?blockquote>)\\s*", "\n$1\n")).contains("<pre>")) {
                comment = FastStringUtils.replaceAll(comment, "\\s*(</?pre>)\\s*", "\n$1\n");
                comment = FastStringUtils.replaceAll(comment, "(<blockquote>)\n(<pre>)", "$1$2");
                comment = FastStringUtils.replaceAll(comment, "(</pre>)\n(</blockquote>)", "$1$2");
            }
            if (comment.contains("<table")) {
                comment = FastStringUtils.replaceAll(comment, "\\s*(</?table|</?tr>)", "\n$1");
                comment = FastStringUtils.replaceAll(comment, "\\s*(<(th|td))", "\n  $1");
                comment = FastStringUtils.replaceAll(comment, "\\s*(<blockquote>)\n(<table)", "\n\n$1$2");
                comment = FastStringUtils.replaceAll(comment, "(</table>)\n(</blockquote>)", "$1$2");
            }
            if ((comment = FastStringUtils.replaceAll(comment, "\\s*(</?(ol|ul|li)>)", "\n$1")).contains("<p>")) {
                comment = FastStringUtils.replaceAll(comment, "\\s*(<p>)\\s*", "\n\n$1");
                comment = FastStringUtils.replaceAll(comment, "(\\s*<p>)+$", "");
            }
            if (comment.contains("<br")) {
                comment = FastStringUtils.replaceAll(comment, "<br\\s*/>", "<br>");
            }
        }
        comment = comment.trim();
        return comment;
    }

    public void addDeprecated(String comment) {
        this.deprecate = comment = this.formatHTML(comment);
    }

    public void addSee(String comment) {
        if (this.sees == null) {
            this.sees = new LinkedList<String>();
        }
        this.sees.add(comment);
    }

    public void addSince(String comment) {
        if (this.sinces == null) {
            this.sinces = new LinkedList<String>();
        }
        this.sinces.add(comment);
    }

    public void addParam(String comment) {
        if (this.params == null) {
            this.params = new LinkedList<String>();
        }
        comment = this.formatHTML(comment);
        this.params.add(comment);
    }

    public void addReturn(String comment) {
        if (this.returns == null) {
            this.returns = new LinkedList<String>();
        }
        comment = this.formatHTML(comment);
        this.returns.add(comment);
    }

    public void addThrows(String comment) {
        if (this.throwses == null) {
            this.throwses = new LinkedList<String>();
        }
        comment = this.formatHTML(comment);
        this.throwses.add(comment);
    }

    public void setSourceBody(String srcBody) {
        this.srcBody = FastStringUtils.replaceAll(srcBody, "\\s@exception\\s", " @throws ");
        this.srcAuthors = this.createWrapTagList("@author");
        List<String> srcThrowses = this.createWrapTagList("@throws");
        if (srcThrowses != null && this.throwses != null) {
            for (String src : srcThrowses) {
                Pattern pat = PatternCache.getPattern("(?s)(\\w+)\\s+(.*)");
                Matcher mat = pat.matcher(src);
                if (!mat.find() || !mat.group(2).contains("@inheritDoc")) continue;
                String exceptionClassName = mat.group(1);
                for (int i = 0; i < this.throwses.size(); ++i) {
                    String doc = this.throwses.get(i);
                    if (!doc.startsWith(exceptionClassName)) continue;
                    this.throwses.set(i, exceptionClassName + " {@inheritDoc}");
                }
            }
        }
        this.srcVersions = this.createTagList("@version");
        this.srcSerials = this.createTagList("@serial");
        this.srcSerialFields = this.createTagList("@serialField");
        this.srcSerialDatas = this.createTagList("@serialData");
        this.srcSpecs = this.createTagList("@spec");
    }

    private List<String> createWrapTagList(String tagName) {
        LinkedList<String> tagValues = null;
        if (this.srcBody.contains(tagName)) {
            String undeco = FastStringUtils.replaceAll(this.srcBody, "(?m)^ *\\* *", "");
            Pattern pat = PatternCache.getPattern("(?s)" + tagName + " *(.*?)([^\\{]@\\w+|/\\s*$)");
            Matcher mat = pat.matcher(undeco);
            int start = 0;
            while (mat.find(start)) {
                if (tagValues == null) {
                    tagValues = new LinkedList<String>();
                }
                tagValues.add(mat.group(1));
                start = mat.end(1);
            }
        }
        return tagValues;
    }

    private List<String> createTagList(String tagName) {
        LinkedList<String> tagValues = null;
        if (this.srcBody.contains(tagName)) {
            Pattern pat = PatternCache.getPattern(" +" + tagName + " *(.*)\n");
            Matcher mat = pat.matcher(this.srcBody);
            while (mat.find()) {
                if (tagValues == null) {
                    tagValues = new LinkedList<String>();
                }
                tagValues.add(mat.group(1));
            }
        }
        return tagValues;
    }

    public String buildComment() {
        if (this.srcBody == null) {
            throw new IllegalStateException("Source comment is null. require #setSourceComment.");
        }
        if (!this.srcBody.contains("@deprecated")) {
            this.deprecate = null;
        }
        if (FastStringUtils.matches(this.srcBody, "(?s)\\s*/\\*\\*[\\s\\*]*@.*")) {
            this.docBody = null;
            this.params = this.omitTags(this.params, "@param");
            this.returns = this.omitTag(this.returns, "@return");
            this.throwses = this.omitTags(this.throwses, "@throws");
            this.sees = this.omitTags(this.sees, "@see");
        }
        int decoSize = 2;
        int originDecoHeight = FastStringUtils.heightOf(this.srcBody);
        if (originDecoHeight <= 0) {
            throw new IllegalStateException("Illegal comment height " + originDecoHeight + "\n" + this.srcBody);
        }
        int originHeight = originDecoHeight;
        if (originDecoHeight > decoSize) {
            originHeight = originDecoHeight - decoSize;
        }
        String indent = FastStringUtils.replaceFirst(this.srcBody, "(?s)^( *?)/\\*\\*.*", "$1");
        if (this.docBody != null) {
            this.replacePreBody();
        }
        if (originDecoHeight <= 2) {
            StringBuilder sb = new StringBuilder();
            sb.append(indent);
            sb.append("/** ");
            if (this.docBody != null && this.docBody.length() > 0) {
                String str = FastStringUtils.replaceAll(this.docBody, "\n", "");
                sb.append(str);
            } else if (this.sinces != null && this.sinces.size() > 0) {
                sb.append("@since ");
                String str = this.sinces.get(0);
                str = FastStringUtils.replace(str, "\n", "");
                sb.append(str);
            }
            if (originDecoHeight == 2) {
                sb.append("\n");
                sb.append(indent);
            }
            sb.append(" */\n");
            return sb.toString();
        }
        int width = 80 - indent.length() - " * ".length();
        OutputComment o = new OutputComment(originHeight, width);
        String decoComment = o.toString();
        if (decoComment.length() > 0) {
            if (o.resultHeight() != o.originHeight) {
                decoComment = this.resizeComment(o, decoComment);
            }
            decoComment = FastStringUtils.replaceAll(decoComment, "(?m)^", indent);
            decoComment = FastStringUtils.replaceAll(decoComment, "(?m)^ +$", "");
        }
        return decoComment;
    }

    private List<String> omitTag(List<String> docTagList, String tagName) {
        List<String> srcTagList;
        if (docTagList != null && docTagList.size() > 0 && ((srcTagList = this.createWrapTagList(tagName)) == null || srcTagList.size() == 0)) {
            return null;
        }
        return docTagList;
    }

    private List<String> omitTags(List<String> docTagList, String tagName) {
        if (docTagList != null && docTagList.size() > 0) {
            List<String> srcTagList = this.createWrapTagList(tagName);
            if (srcTagList == null || srcTagList.size() == 0) {
                return null;
            }
            if (docTagList.size() > srcTagList.size()) {
                ArrayList<String> names = new ArrayList<String>();
                for (String src : srcTagList) {
                    String name = FastStringUtils.replaceFirst(src, "(?s)^(\\S+)\\s.*$", "$1");
                    names.add(name);
                }
                ArrayList<String> newTagList = new ArrayList<String>();
                for (String doc : docTagList) {
                    String name = FastStringUtils.replaceFirst(doc, "(?s)^(\\S+)\\s.*$", "$1");
                    if (!names.contains(name)) continue;
                    newTagList.add(doc);
                }
                return newTagList;
            }
        }
        return docTagList;
    }

    private void replacePreBody() {
        if (!this.docBody.contains("<pre>")) {
            return;
        }
        LinkedList<String> pres = null;
        String commentBody = FastStringUtils.replaceAll(this.srcBody, "(?m)^\\s*\\*( |)", "");
        Pattern pat = PatternCache.getPattern("(?s)(<pre>\n)(.+?)(\n</pre>)");
        Matcher mat = pat.matcher(commentBody);
        while (mat.find()) {
            if (pres == null) {
                pres = new LinkedList<String>();
            }
            pres.add(mat.group(2));
        }
        if (pres == null) {
            return;
        }
        Matcher descMatcher = pat.matcher(this.docBody);
        StringBuffer sb = new StringBuffer();
        while (descMatcher.find()) {
            if (pres.size() == 0) {
                return;
            }
            String value = FastStringUtils.quoteReplacement((String)pres.removeFirst());
            descMatcher.appendReplacement(sb, "$1" + value + "$3");
        }
        descMatcher.appendTail(sb);
        if (pres.size() == 0) {
            this.docBody = sb.toString();
        }
    }

    private String resizeComment(OutputComment o, String decoComment) {
        int i;
        if (o.resultHeight() > o.originHeight) {
            int pos;
            this.shrinkComment(o);
            if (this.docBody != null && o.resultHeight() > o.originHeight && this.docBody.contains("\n")) {
                StringBuilder sb = new StringBuilder();
                boolean inPreTag = false;
                for (i = 0; i < this.docBody.length(); ++i) {
                    char c = this.docBody.charAt(i);
                    sb.append(c);
                    String buf = sb.toString();
                    if (buf.endsWith("<pre>")) {
                        inPreTag = true;
                        sb.insert(sb.length() - 5, '\n');
                    } else if (buf.endsWith("</pre>")) {
                        inPreTag = false;
                        sb.append('\n');
                    }
                    if (c != '\n' || inPreTag) continue;
                    sb.deleteCharAt(sb.length() - 1);
                }
                this.docBody = sb.toString();
                o.rebuild();
                if (o.resultHeight() > o.originHeight) {
                    this.shrinkComment(o);
                }
            }
            if (this.docBody != null && o.resultHeight() > o.originHeight && (pos = this.docBody.indexOf(12290)) != -1) {
                this.docBody = this.docBody.substring(0, pos + 1);
                o.rebuild();
                if (o.resultHeight() > o.originHeight) {
                    this.shrinkComment(o);
                }
            }
            if (o.resultHeight() > o.originHeight) {
                log.warn(this.sig + " \u884c\u6570\u8abf\u6574\u4e0d\u53ef\u306e\u305f\u3081\u30de\u30fc\u30b8\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + "-------------------------------------------------\n" + "\u82f1\u8a9e\u30b3\u30e1\u30f3\u30c8:\n" + this.srcBody + "\n\u65e5\u672c\u8a9e\u30b3\u30e1\u30f3\u30c8:\n" + o.toString() + "-------------------------------------------------\n");
                return this.srcBody;
            }
            decoComment = o.toString();
        }
        if (o.resultHeight() < o.originHeight) {
            this.expandComment(o);
            decoComment = o.toString();
        }
        if (o.resultHeight() < o.originHeight) {
            int sub = o.originHeight - o.resultHeight();
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < sub; ++i) {
                sb.append("\n");
            }
            decoComment = sb + decoComment;
        }
        return decoComment;
    }

    private void shrinkComment(OutputComment o) {
        int height;
        String emptyDescRegex = "(?s)\\s*/\\*\\*\\s*\\*\\s*@.*";
        if (FastStringUtils.matches(this.srcBody, emptyDescRegex)) {
            this.docBody = null;
            o.build();
            if (o.resultHeight() <= o.originHeight) {
                return;
            }
        }
        boolean b1 = this.shrinkTagList("@see", this.sees);
        boolean b2 = this.shrinkTagList("@throws", this.throwses);
        boolean b3 = this.shrinkTagList("@param", this.params);
        boolean b4 = this.shrinkTagList("@return", this.returns);
        if (b1 || b2 || b3 || b4) {
            o.build();
            if (o.resultHeight() <= o.originHeight) {
                return;
            }
        }
        Pattern pTagPat = PatternCache.getPattern("<p>\n\n(<p>)");
        if (o.comment.contains("<p>\n\n<p>")) {
            StringBuffer sb = new StringBuffer();
            Matcher pTagMat = pTagPat.matcher(o.comment);
            for (height = o.resultHeight(); height > o.originHeight && pTagMat.find(); height -= 2) {
                pTagMat.appendReplacement(sb, "$1");
            }
            pTagMat.appendTail(sb);
            o.comment = sb.toString();
            if (height <= o.originHeight) {
                return;
            }
        }
        Pattern tdTagPat = PatternCache.getPattern("\\s+(<(t[hd]|/tr))");
        if (o.comment.contains("<table")) {
            StringBuffer sb = new StringBuffer();
            Matcher tdTagMat = tdTagPat.matcher(o.comment);
            while (height > o.originHeight && tdTagMat.find()) {
                tdTagMat.appendReplacement(sb, "$1");
                --height;
            }
            tdTagMat.appendTail(sb);
            o.comment = sb.toString();
            if (height <= o.originHeight) {
                return;
            }
        }
        Pattern liTagPat = PatternCache.getPattern("\\s+(<(li|/[uo]l))");
        if (o.comment.contains("<li")) {
            StringBuffer sb = new StringBuffer();
            Matcher liTagMat = liTagPat.matcher(o.comment);
            while (height > o.originHeight && liTagMat.find()) {
                liTagMat.appendReplacement(sb, "$1");
                --height;
            }
            liTagMat.appendTail(sb);
            o.comment = sb.toString();
            if (height <= o.originHeight) {
                return;
            }
        }
        Pattern emptyLinePat = PatternCache.getPattern("(?m)^\\s*?\n");
        Matcher emptyLineMat = emptyLinePat.matcher(o.comment);
        StringBuffer sb = new StringBuffer();
        while (height > o.originHeight && emptyLineMat.find()) {
            emptyLineMat.appendReplacement(sb, "");
            --height;
        }
        emptyLineMat.appendTail(sb);
        o.comment = sb.toString();
        if (height <= o.originHeight) {
            return;
        }
        String firstLineRegex = "(?s)\\s*/\\*\\*\\s*\n.*";
        if (!FastStringUtils.matches(this.srcBody, firstLineRegex)) {
            o.enabledFirstLine = true;
            if (o.resultHeight() <= o.originHeight) {
                return;
            }
        }
        int maxWidth = 160;
        while (o.resultHeight() > o.originHeight && o.width < 160) {
            o.build();
            if (o.resultHeight() <= o.originHeight) {
                return;
            }
            if (o.comment.contains("<")) {
                o.comment = pTagPat.matcher(o.comment).replaceAll("$1");
                if (o.resultHeight() <= o.originHeight) {
                    return;
                }
                o.comment = tdTagPat.matcher(o.comment).replaceAll("$1");
                if (o.resultHeight() <= o.originHeight) {
                    return;
                }
                o.comment = liTagPat.matcher(o.comment).replaceAll("$1");
                if (o.resultHeight() <= o.originHeight) {
                    return;
                }
            }
            o.comment = emptyLinePat.matcher(o.comment).replaceAll("");
            if (o.resultHeight() <= o.originHeight) {
                return;
            }
            if (o.width < 100) {
                o.width += 4;
                continue;
            }
            o.width += 8;
        }
    }

    private boolean shrinkTagList(String tagRegex, List<String> tagList) {
        int tagCount;
        if (tagList != null && (tagCount = FastStringUtils.split(this.srcBody, "\\s" + tagRegex + "\\s", -1).length - 1) == 0) {
            tagList.clear();
            return true;
        }
        return false;
    }

    private void expandComment(OutputComment o) {
        int height;
        if (!o.comment.contains("<")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Pattern pat = PatternCache.getPattern("([^\n])(\n(<blockquote>)?<pre>|\n<(blockquote|ol|ul)>)");
        Matcher mat = pat.matcher(o.comment);
        for (height = o.resultHeight(); height < o.originHeight && mat.find(); ++height) {
            mat.appendReplacement(sb, "$1\n$2");
        }
        mat.appendTail(sb);
        o.comment = sb.toString();
        if (height == o.originHeight) {
            return;
        }
        sb = new StringBuffer();
        pat = PatternCache.getPattern("(</pre>(</blockquote>)?\n|</(blockquote|ol|ul)>\n)([^\n])");
        mat = pat.matcher(o.comment);
        while (height < o.originHeight && mat.find()) {
            mat.appendReplacement(sb, "$1\n$4");
            ++height;
        }
        mat.appendTail(sb);
        o.comment = sb.toString();
        if (height == o.originHeight) {
            return;
        }
    }

    private String formatComment(int width, int originHeight) {
        StringBuilder sb = new StringBuilder();
        if (this.docBody != null && this.docBody.length() > 0) {
            if (originHeight == 1) {
                sb.append(FastStringUtils.replaceAll(this.docBody, "\n", ""));
                sb.append("\n");
                return sb.toString();
            }
            sb.append(this.adjustWidth(this.docBody, width));
            sb.append("\n");
        }
        if (this.deprecate != null && this.deprecate.length() > 0) {
            String depre = "@deprecated " + this.deprecate;
            sb.append(this.adjustWidth(depre, width));
            sb.append("\n");
        }
        this.appendTo("@author  ", this.srcAuthors, sb, width);
        this.appendTo("@version ", this.srcVersions, sb, width);
        if (this.params != null && this.params.size() > 0) {
            int indentCnt;
            int paramsSize = this.params.size();
            int[] nameLens = new int[paramsSize];
            int nameLenMax = 3;
            int nameLenLimit = 12;
            for (int i = 0; i < paramsSize; ++i) {
                String comment = this.params.get(i);
                String name = FastStringUtils.replaceFirst(comment, "(?s)(\\w+)\\s.*", "$1");
                nameLens[i] = name.length();
                if (nameLens[i] <= nameLenMax || nameLens[i] >= 12) continue;
                nameLenMax = nameLens[i];
            }
            String tag = "@param   ";
            StringBuilder indent = new StringBuilder(indentCnt);
            for (indentCnt = tag.length() + nameLenMax + 1; indentCnt > 0; --indentCnt) {
                indent.append(' ');
            }
            for (int i = 0; i < paramsSize; ++i) {
                StringBuilder space = new StringBuilder();
                for (int spaceCnt = nameLenMax - nameLens[i]; spaceCnt > 0; --spaceCnt) {
                    space.append(' ');
                }
                String comment = this.params.get(i);
                comment = FastStringUtils.replaceFirst(comment, "(?s)(\\w+)\\s+(.*)", "$1" + space + " $2");
                comment = this.adjustWidth(comment, width - tag.length());
                StringTokenizer st = new StringTokenizer(comment, "\n");
                sb.append(tag);
                if (st.hasMoreTokens()) {
                    sb.append(st.nextToken());
                }
                sb.append("\n");
                while (st.hasMoreTokens()) {
                    sb.append((CharSequence)indent);
                    sb.append(st.nextToken());
                    sb.append("\n");
                }
            }
        }
        this.appendTo("@return  ", this.returns, sb, width);
        this.appendTo("@throws  ", this.throwses, sb, width);
        this.appendTo("@serialField", this.srcSerialFields, sb, width);
        this.appendTo("@serialData", this.srcSerialDatas, sb, width);
        this.appendTo("@see     ", this.sees, sb, width);
        this.appendTo("@since   ", this.sinces, sb, width);
        this.appendTo("@serial  ", this.srcSerials, sb, width);
        this.appendTo("@spec    ", this.srcSpecs, sb, width);
        String str = sb.toString();
        str = FastStringUtils.replaceFirst(str, "\n\n$", "\n");
        return str;
    }

    private void appendTo(String tag, List<String> tagList, StringBuilder sb, int width) {
        if (tagList == null) {
            return;
        }
        for (String comment : tagList) {
            comment = this.adjustWidth(comment, width - tag.length());
            StringTokenizer st = new StringTokenizer(comment, "\n");
            sb.append(tag);
            if (st.hasMoreTokens()) {
                sb.append(st.nextToken());
            }
            sb.append("\n");
            while (st.hasMoreTokens()) {
                sb.append(FastStringUtils.replaceAll(tag, ".", " "));
                sb.append(st.nextToken());
                sb.append("\n");
            }
        }
    }

    private String adjustWidth(String value, int width) {
        if (value.getBytes().length < width) {
            return value + "\n";
        }
        List<String> lineValues = FastStringUtils.splitLine(value);
        StringBuilder resultBuf = new StringBuilder();
        boolean preTagArea = false;
        int longWordWidth = width - 20;
        for (String lineValue : lineValues) {
            if (lineValue.equals("")) {
                resultBuf.append("\n");
                continue;
            }
            if (lineValue.startsWith("</pre>")) {
                preTagArea = false;
            } else if (lineValue.startsWith("<pre>")) {
                preTagArea = true;
            }
            if (preTagArea) {
                resultBuf.append(lineValue);
                resultBuf.append("\n");
                if (!lineValue.endsWith("</pre>")) continue;
                preTagArea = false;
                continue;
            }
            if (lineValue.endsWith("<pre>")) {
                preTagArea = true;
            }
            if (lineValue.getBytes().length < width) {
                resultBuf.append(lineValue);
                resultBuf.append("\n");
                continue;
            }
            if (lineValue.contains("<table")) {
                String s = FastStringUtils.replaceFirst(lineValue, "(?i)\\s(summary=)", "\n$1");
                resultBuf.append(s);
                resultBuf.append("\n");
                continue;
            }
            String multiLineValue = FastStringUtils.replaceAll(lineValue, "\\s?(\\p{Graph}{" + longWordWidth + ",})", "\n$1");
            StringTokenizer st = new StringTokenizer(multiLineValue, "\n");
            while (st.hasMoreTokens()) {
                lineValue = st.nextToken();
                this.wrap(lineValue, resultBuf, width);
            }
        }
        return resultBuf.toString();
    }

    private void wrap(String lineValue, StringBuilder resultBuf, int width) {
        int minWidth = width - 10;
        int maxWidth = width + 10;
        int ADJUST_SKIP_WIDTH = width + 4;
        int lastPos = lineValue.length() - 1;
        String PUNCTS = "\u3002\u3001\u300d\u30fb)}";
        String PARTICLES = "\u306f\u304c\u306e\u3092\u306b\u3078\u3068\u3089\u3066\u308b\u3084";
        StringBuilder buf = new StringBuilder();
        int bufLen = 0;
        for (int pos = 0; pos < lastPos; ++pos) {
            boolean isChangeLine;
            char c;
            block9: {
                int cLen;
                block11: {
                    block10: {
                        String after;
                        int afterLen;
                        if (bufLen == 0 && (afterLen = (after = lineValue.substring(pos, lastPos)).getBytes().length) <= ADJUST_SKIP_WIDTH) {
                            buf.append(after);
                            break;
                        }
                        c = lineValue.charAt(pos);
                        cLen = String.valueOf(c).getBytes().length;
                        isChangeLine = false;
                        if ((bufLen += cLen) <= minWidth) break block9;
                        if (c != ' ') break block10;
                        isChangeLine = true;
                        buf.append('\n');
                        break block9;
                    }
                    if ("\u3002\u3001\u300d\u30fb)}".indexOf(c) == -1 && "\u306f\u304c\u306e\u3092\u306b\u3078\u3068\u3089\u3066\u308b\u3084".indexOf(c) == -1) break block11;
                    char next = lineValue.charAt(pos + 1);
                    if ("\u3002\u3001\u300d\u30fb)}".indexOf(next) != -1 || next == ' ' || next == '.') break block9;
                    isChangeLine = true;
                    buf.append(c);
                    buf.append('\n');
                    break block9;
                }
                if (bufLen > width) {
                    if (c == '<' || cLen > 1) {
                        isChangeLine = true;
                        buf.append('\n');
                        buf.append(c);
                    } else if (bufLen > maxWidth) {
                        for (int bPos = buf.length() - 1; bPos > 0; --bPos) {
                            char bc = buf.charAt(bPos);
                            if (bc == ' ') {
                                buf.replace(bPos, bPos + 1, "\n");
                                bufLen = buf.substring(bPos + 1).getBytes().length;
                                break;
                            }
                            int bcLen = String.valueOf(bc).getBytes().length;
                            if (bcLen <= 1) continue;
                            buf.insert(bPos + 1, '\n');
                            bufLen = buf.substring(bPos + 2).getBytes().length;
                            break;
                        }
                    }
                }
            }
            if (isChangeLine) {
                resultBuf.append((CharSequence)buf);
                buf = new StringBuilder();
                bufLen = 0;
                continue;
            }
            buf.append(c);
        }
        buf.append(lineValue.charAt(lastPos));
        resultBuf.append((CharSequence)buf);
        resultBuf.append('\n');
    }

    private class OutputComment {
        static final String LINE_PREFIX = " * ";
        final int originHeight;
        final int initWidth;
        int width;
        String comment;
        boolean enabledFirstLine;

        OutputComment(int originHeight, int width) {
            this.originHeight = originHeight;
            this.initWidth = width;
            this.width = width;
            this.build();
        }

        void build() {
            this.comment = Comment.this.formatComment(this.width, this.originHeight);
        }

        void rebuild() {
            this.resetWidth();
            this.build();
        }

        int resultHeight() {
            if (this.enabledFirstLine) {
                return FastStringUtils.heightOf(this.comment) - 1;
            }
            return FastStringUtils.heightOf(this.comment);
        }

        void resetWidth() {
            this.width = this.initWidth;
        }

        public String toString() {
            String str = this.comment;
            if (str.length() > 0) {
                StringBuilder sb = new StringBuilder();
                str = FastStringUtils.replaceAll(str, "(?m)^", LINE_PREFIX);
                if (this.enabledFirstLine) {
                    sb.append("/**");
                    str = FastStringUtils.replaceFirst(str, "^ \\*", "");
                } else {
                    sb.append("/**\n");
                }
                sb.append(str);
                sb.append(" */\n");
                str = sb.toString();
            }
            return str;
        }
    }
}

