/*
 * Decompiled with CFR 0.152.
 */
package mergedoc.xml;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mergedoc.core.FastStringUtils;
import mergedoc.core.PatternCache;

public class ReplaceEntry {
    private String description = "";
    private String before = "";
    private String after = "";
    private String target = "";
    private List<ReplaceEntry> entries;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public String getBefore() {
        return this.before;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public String getAfter() {
        return this.after;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        return this.target;
    }

    public void addChild(ReplaceEntry entry) {
        if (this.entries == null) {
            this.entries = new LinkedList<ReplaceEntry>();
        }
        this.entries.add(entry);
    }

    public String replace(String source) {
        if (this.before.length() > 0) {
            try {
                source = this.replaceSelf(source);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalStateException("\u7f6e\u63db\u30a8\u30f3\u30c8\u30ea\u306e\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\n\u539f\u56e0: " + e.getMessage() + "\n" + "\u524d: " + this.before + "\n" + "\u5f8c: " + this.after);
            }
        }
        if (this.entries != null) {
            for (ReplaceEntry entry : this.entries) {
                source = entry.replace(source);
            }
        }
        return source;
    }

    private String replaceSelf(String source) {
        if ("Javadoc\u30b3\u30e1\u30f3\u30c8".equalsIgnoreCase(this.target)) {
            Pattern pat = PatternCache.getPattern("(?s)/\\*\\*.+?\\*/");
            Matcher mat = pat.matcher(source);
            StringBuffer sb = new StringBuffer(source.length());
            while (mat.find()) {
                String str = mat.group();
                str = FastStringUtils.replaceAll(str, this.before, this.after);
                str = FastStringUtils.quoteReplacement(str);
                mat.appendReplacement(sb, str);
            }
            mat.appendTail(sb);
            source = sb.toString();
        } else {
            source = FastStringUtils.replaceAll(source, this.before, this.after);
        }
        return source;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\u8aac\u660e [");
        sb.append(this.description);
        sb.append("]\n\u524d [");
        sb.append(this.before);
        sb.append("]\n\u5f8c [");
        sb.append(this.after);
        sb.append("]\n");
        if (this.entries != null) {
            for (ReplaceEntry entry : this.entries) {
                sb.append(entry);
            }
        }
        return sb.toString();
    }
}

