/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationExcludeProperties {
    private static final Logger log = Logger.getLogger(TranslationExcludeProperties.class);
    public static final String PROP_FILE_NAME = "translation-exclude.properties";
    private static final TranslationExcludeProperties singleton = new TranslationExcludeProperties();
    private final Map<String, Set<String>> map = new HashMap<String, Set<String>>();

    public static TranslationExcludeProperties getInstance() {
        return singleton;
    }

    private TranslationExcludeProperties() {
        File file = FileSystem.getResourceFile(PROP_FILE_NAME);
        if (!file.exists()) {
            String msg = "\u7ffb\u8a33\u9664\u5916\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002";
            FileNotFoundException e = new FileNotFoundException(file.getPath());
            IllegalStateException ise = new IllegalStateException(msg, e);
            Pleiades.abort(ise);
        }
        Properties prop = FileSystem.loadProperties(file);
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            this.map.put((String)entry.getKey(), new HashSet(Arrays.asList(entry.getValue().toString().split("\\s*,\\s*"))));
        }
        log.info("\u7ffb\u8a33\u9664\u5916\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.map.size());
    }

    public Set<String> getPathEntries(String enValue) {
        Set<String> pathEntries = this.map.get(enValue);
        if (pathEntries != null && pathEntries.contains("")) {
            log.info("[" + enValue + "] \u306e\u7ffb\u8a33\u547c\u3073\u51fa\u3057\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u3002", new IllegalStateException());
            return null;
        }
        return pathEntries;
    }
}

