/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import jp.sourceforge.mergedoc.pleiades.resource.TranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationResult;
import junit.framework.TestCase;

public class TranslationDictionaryTest
extends TestCase {
    private final TranslationDictionary target = new TranslationDictionary();

    public void testLookup() {
        TranslationResult result = null;
        String input = null;
        input = "... undefined string in dictionary ...";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)input, (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)false, (boolean)result.isFound());
        input = "Label";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "L&abel";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb(&A)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&Left";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u5de6(&L)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Search results for {0}:";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"{0} \u306e\u691c\u7d22\u7d50\u679c:", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Remo&ve Buildfile";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30d3\u30eb\u30c9\u30fb\u30d5\u30a1\u30a4\u30eb\u306e\u9664\u53bb(&V)", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "Error reading configuration";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u69cb\u6210\u306e\u8aad\u307f\u53d6\u308a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "&Extension....";
        result = this.target.lookup(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u62e1\u5f35(&E)....", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        result = this.target.lookupIgnoreMnemonic("Label");
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)"\u30e9\u30d9\u30eb", (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)true, (boolean)result.isFound());
        input = "L&abel";
        result = this.target.lookupIgnoreMnemonic(input);
        System.out.println(String.valueOf(input) + "=" + result.getValue());
        TranslationDictionaryTest.assertEquals((String)input, (String)result.getValue());
        TranslationDictionaryTest.assertEquals((boolean)false, (boolean)result.isFound());
    }
}

