/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout {
    Device device;
    Font font;
    String text;
    String segmentsText;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void breakRun(StyleItem run) {
        if (run.psla != 0) {
            return;
        }
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        int hHeap = OS.GetProcessHeap();
        run.psla = OS.HeapAlloc(hHeap, 8, 1 * chars.length);
        OS.ScriptBreak(chars, chars.length, run.analysis, run.psla);
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gc) {
        if (this.runs != null) {
            return;
        }
        int hDC = gc != null ? gc.handle : this.device.internal_new_GC(null);
        int srcHdc = OS.CreateCompatibleDC(hDC);
        this.allRuns = this.itemize();
        int i = 0;
        while (i < this.allRuns.length - 1) {
            StyleItem run = this.allRuns[i];
            OS.SelectObject(srcHdc, this.getItemFont(run));
            this.shape(srcHdc, run);
            ++i;
        }
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int lineWidth = 0;
        int lineStart = 0;
        int lineCount = 1;
        int i2 = 0;
        while (i2 < this.allRuns.length - 1) {
            StyleItem run = this.allRuns[i2];
            if (run.length == 1) {
                char ch = this.segmentsText.charAt(run.start);
                switch (ch) {
                    case '\t': {
                        int lastTabWidth;
                        run.tab = true;
                        if (this.tabs == null) break;
                        int tabsLength = this.tabs.length;
                        int j = 0;
                        while (j < tabsLength) {
                            if (this.tabs[j] > lineWidth) {
                                run.width = this.tabs[j] - lineWidth;
                                break;
                            }
                            ++j;
                        }
                        if (j != tabsLength) break;
                        int tabX = this.tabs[tabsLength - 1];
                        int n = lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                        if (lastTabWidth <= 0) break;
                        while (tabX <= lineWidth) {
                            tabX += lastTabWidth;
                        }
                        run.width = tabX - lineWidth;
                        break;
                    }
                    case '\n': {
                        run.lineBreak = true;
                        break;
                    }
                    case '\r': {
                        run.lineBreak = true;
                        StyleItem next = this.allRuns[i2 + 1];
                        if (next.length == 0 || this.segmentsText.charAt(next.start) != '\n') break;
                        ++run.length;
                        next.free();
                        ++i2;
                    }
                }
            }
            if (this.wrapWidth != -1 && lineWidth + run.width > this.wrapWidth && !run.tab) {
                int start = 0;
                int[] piDx = new int[run.length];
                OS.ScriptGetLogicalWidths(run.analysis, run.length, run.glyphCount, run.advances, run.clusters, run.visAttrs, piDx);
                int width = 0;
                int maxWidth = this.wrapWidth - lineWidth;
                while (width + piDx[start] < maxWidth) {
                    width += piDx[start++];
                }
                int firstStart = start;
                int firstIndice = i2;
                while (i2 >= lineStart) {
                    this.breakRun(run);
                    while (start >= 0) {
                        OS.MoveMemory(logAttr, run.psla + start * 1, 1);
                        if (logAttr.fSoftBreak || logAttr.fWhiteSpace) break;
                        --start;
                    }
                    if (start == 0 && i2 != lineStart && !run.tab && logAttr.fSoftBreak && !logAttr.fWhiteSpace) {
                        OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], 8);
                        short langID = properties.langid;
                        StyleItem pRun = this.allRuns[i2 - 1];
                        OS.MoveMemory(properties, this.device.scripts[pRun.analysis.eScript], 8);
                        if (properties.langid == langID || langID == 0 || properties.langid == 0) {
                            this.breakRun(pRun);
                            OS.MoveMemory(logAttr, pRun.psla + (pRun.length - 1) * 1, 1);
                            if (!logAttr.fWhiteSpace) {
                                start = -1;
                            }
                        }
                    }
                    if (start >= 0 || i2 == lineStart) break;
                    run = this.allRuns[--i2];
                    start = run.length - 1;
                }
                if (start == 0 && i2 != lineStart && !run.tab) {
                    run = this.allRuns[--i2];
                } else if (start <= 0 && i2 == lineStart) {
                    i2 = firstIndice;
                    run = this.allRuns[i2];
                    start = Math.max(1, firstStart);
                }
                this.breakRun(run);
                while (start < run.length) {
                    OS.MoveMemory(logAttr, run.psla + start * 1, 1);
                    if (!logAttr.fWhiteSpace) break;
                    ++start;
                }
                if (start > 0 && start < run.length) {
                    StyleItem newRun = new StyleItem();
                    newRun.start = run.start + start;
                    newRun.length = run.length - start;
                    newRun.style = run.style;
                    newRun.analysis = run.analysis;
                    run.free();
                    run.length = start;
                    OS.SelectObject(srcHdc, this.getItemFont(run));
                    this.shape(srcHdc, run);
                    this.shape(srcHdc, newRun);
                    StyleItem[] newAllRuns = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, newAllRuns, 0, i2 + 1);
                    System.arraycopy(this.allRuns, i2 + 1, newAllRuns, i2 + 2, this.allRuns.length - i2 - 1);
                    this.allRuns = newAllRuns;
                    this.allRuns[i2 + 1] = newRun;
                }
                if (i2 != this.allRuns.length - 2) {
                    run.lineBreak = true;
                    run.softBreak = true;
                }
            }
            lineWidth += run.width;
            if (run.lineBreak) {
                lineStart = i2 + 1;
                lineWidth = 0;
                ++lineCount;
            }
            ++i2;
        }
        lineWidth = 0;
        this.runs = new StyleItem[lineCount][];
        this.lineOffset = new int[lineCount + 1];
        this.lineY = new int[lineCount + 1];
        this.lineWidth = new int[lineCount];
        int lineRunCount = 0;
        int line = 0;
        int ascent = Math.max(0, this.ascent);
        int descent = Math.max(0, this.descent);
        StyleItem[] lineRuns = new StyleItem[this.allRuns.length];
        int i3 = 0;
        while (i3 < this.allRuns.length) {
            StyleItem run = this.allRuns[i3];
            lineRuns[lineRunCount++] = run;
            lineWidth += run.width;
            ascent = Math.max(ascent, run.ascent);
            descent = Math.max(descent, run.descent);
            if (run.lineBreak || i3 == this.allRuns.length - 1) {
                if (lineRunCount == 1 && i3 == this.allRuns.length - 1) {
                    TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.SelectObject(srcHdc, this.getItemFont(run));
                    OS.GetTextMetrics(srcHdc, lptm);
                    run.ascent = lptm.tmAscent;
                    run.descent = lptm.tmDescent;
                    ascent = Math.max(ascent, run.ascent);
                    descent = Math.max(descent, run.descent);
                }
                this.runs[line] = new StyleItem[lineRunCount];
                System.arraycopy(lineRuns, 0, this.runs[line], 0, lineRunCount);
                StyleItem lastRun = this.runs[line][lineRunCount - 1];
                this.runs[line] = this.reorder(this.runs[line]);
                this.lineWidth[line] = lineWidth;
                this.lineY[++line] = this.lineY[line - 1] + ascent + descent + this.lineSpacing;
                this.lineOffset[line] = lastRun.start + lastRun.length;
                lineWidth = 0;
                lineRunCount = 0;
                ascent = Math.max(0, this.ascent);
                descent = Math.max(0, this.descent);
            }
            ++i3;
        }
        if (srcHdc != 0) {
            OS.DeleteDC(srcHdc);
        }
        if (gc == null) {
            this.device.internal_dispose_GC(hDC, null);
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gc, int x, int y, ControlCharRenderer ccRender) {
        this.draw(gc, x, y, ccRender, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, ControlCharRenderer ccRender, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        boolean hasSelection;
        this.checkLayout();
        this.computeRuns(gc);
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        int length = this.text.length();
        ccRender.init(gc, this.device);
        if (ccRender.isDrawLineBreak() && this.runs.length > 0 && this.lineY.length > 1) {
            int drawX = x;
            StyleItem[] lineRuns = this.runs[0];
            int i = 0;
            while (i < lineRuns.length) {
                StyleItem run = lineRuns[i];
                if (run.length != 0) {
                    drawX += run.width;
                }
                ++i;
            }
            int lineHeight = this.lineY[1] - this.lineY[0];
            ccRender.drawLineBreak(drawX, y, lineHeight);
        }
        if (length == 0) {
            return;
        }
        int hdc = gc.handle;
        boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        if (hasSelection) {
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
        }
        int foreground = OS.GetTextColor(hdc);
        int state = OS.SaveDC(hdc);
        RECT rect = new RECT();
        int selBrush = 0;
        if (hasSelection) {
            selBrush = OS.CreateSolidBrush(selectionBackground.handle);
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(hdc, 13);
            OS.SetROP2(hdc, rop2);
        } else {
            rop2 = OS.GetROP2(hdc);
        }
        int dwRop = rop2 == 7 ? 5898313 : 15728673;
        OS.SetBkMode(hdc, 1);
        Rectangle clip = gc.getClipping();
        int line = 0;
        while (line < this.runs.length) {
            int drawX = x;
            int drawY = y + this.lineY[line];
            if (this.wrapWidth != -1) {
                switch (this.alignment) {
                    case 0x1000000: {
                        drawX += (this.wrapWidth - this.lineWidth[line]) / 2;
                        break;
                    }
                    case 131072: {
                        drawX += this.wrapWidth - this.lineWidth[line];
                    }
                }
            }
            if (drawX <= clip.x + clip.width && drawX + this.lineWidth[line] >= clip.x) {
                int drawRunY;
                int end;
                StyleItem run;
                StyleItem[] lineRuns = this.runs[line];
                int baseline = Math.max(0, this.ascent);
                int i = 0;
                while (i < lineRuns.length) {
                    baseline = Math.max(baseline, lineRuns[i].ascent);
                    ++i;
                }
                int lineHeight = this.lineY[line + 1] - this.lineY[line];
                int alignmentX = drawX;
                int i2 = 0;
                while (i2 < lineRuns.length) {
                    run = lineRuns[i2];
                    if (run.length != 0) {
                        if (drawX > clip.x + clip.width) break;
                        if (drawX + run.width >= clip.x && (!run.lineBreak || run.softBreak)) {
                            boolean fullSelection;
                            end = run.start + run.length - 1;
                            boolean bl2 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                            if (fullSelection) {
                                OS.SelectObject(hdc, selBrush);
                                OS.PatBlt(hdc, drawX, drawY, run.width, lineHeight, dwRop);
                            } else {
                                boolean partialSelection;
                                if (run.style != null && run.style.background != null) {
                                    int bg = run.style.background.handle;
                                    drawRunY = drawY + (baseline - run.ascent);
                                    int hBrush = OS.CreateSolidBrush(bg);
                                    int oldBrush = OS.SelectObject(hdc, hBrush);
                                    OS.PatBlt(hdc, drawX, drawRunY, run.width, run.ascent + run.descent, dwRop);
                                    OS.SelectObject(hdc, oldBrush);
                                    OS.DeleteObject(hBrush);
                                }
                                boolean bl3 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                                if (partialSelection) {
                                    OS.SelectObject(hdc, selBrush);
                                    int selStart = Math.max(selectionStart, run.start) - run.start;
                                    int selEnd = Math.min(selectionEnd, end) - run.start;
                                    int cChars = run.length;
                                    int gGlyphs = run.glyphCount;
                                    int[] piX = new int[1];
                                    OS.ScriptCPtoX(selStart, false, cChars, gGlyphs, run.clusters, run.visAttrs, run.advances, run.analysis, piX);
                                    int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                                    rect.left = drawX + runX;
                                    rect.top = drawY;
                                    OS.ScriptCPtoX(selEnd, true, cChars, gGlyphs, run.clusters, run.visAttrs, run.advances, run.analysis, piX);
                                    runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                                    rect.right = drawX + runX;
                                    rect.bottom = drawY + lineHeight;
                                    OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, dwRop);
                                }
                            }
                        }
                        drawX += run.width;
                    }
                    ++i2;
                }
                drawX = alignmentX;
                i2 = 0;
                while (i2 < lineRuns.length) {
                    run = lineRuns[i2];
                    if (run.length != 0) {
                        if (drawX > clip.x + clip.width) break;
                        if (drawX + run.width >= clip.x) {
                            if (!(run.tab || run.lineBreak && !run.softBreak)) {
                                int spaceWidth;
                                int k;
                                int leftX;
                                char c;
                                boolean partialSelection;
                                boolean fullSelection;
                                end = run.start + run.length - 1;
                                int fg = foreground;
                                boolean bl4 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                                if (fullSelection) {
                                    fg = selectionForeground.handle;
                                } else if (run.style != null && run.style.foreground != null) {
                                    fg = run.style.foreground.handle;
                                }
                                OS.SetTextColor(hdc, fg);
                                OS.SelectObject(hdc, this.getItemFont(run));
                                drawRunY = drawY + (baseline - run.ascent);
                                OS.ScriptTextOut(hdc, run.psc, drawX, drawRunY, 0, null, run.analysis, 0, 0, run.glyphs, run.glyphCount, run.advances, null, run.goffsets);
                                boolean bl5 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                                if (!fullSelection && partialSelection && fg != selectionForeground.handle) {
                                    OS.SetTextColor(hdc, selectionForeground.handle);
                                    int selStart = Math.max(selectionStart, run.start) - run.start;
                                    int selEnd = Math.min(selectionEnd, end) - run.start;
                                    int cChars = run.length;
                                    int gGlyphs = run.glyphCount;
                                    int[] piX = new int[1];
                                    OS.ScriptCPtoX(selStart, false, cChars, gGlyphs, run.clusters, run.visAttrs, run.advances, run.analysis, piX);
                                    int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                                    rect.left = drawX + runX;
                                    rect.top = drawY;
                                    OS.ScriptCPtoX(selEnd, true, cChars, gGlyphs, run.clusters, run.visAttrs, run.advances, run.analysis, piX);
                                    runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                                    rect.right = drawX + runX;
                                    rect.bottom = drawY + lineHeight;
                                    OS.ScriptTextOut(hdc, run.psc, drawX, drawRunY, 4, rect, run.analysis, 0, 0, run.glyphs, run.glyphCount, run.advances, null, run.goffsets);
                                }
                                if (ccRender.isDrawFullWidthSpace()) {
                                    String runText = this.segmentsText.substring(run.start, run.start + run.length);
                                    int fullSpace = 12288;
                                    if (runText.indexOf(12288) != -1) {
                                        int[] charWidths = new int[run.length];
                                        OS.ScriptGetLogicalWidths(run.analysis, run.length, run.glyphCount, run.advances, run.clusters, run.visAttrs, charWidths);
                                        char[] chars = runText.toCharArray();
                                        int j = 0;
                                        while (j < chars.length) {
                                            c = chars[j];
                                            if (c == '\u3000') {
                                                leftX = drawX;
                                                k = 0;
                                                while (k < j) {
                                                    leftX += charWidths[k];
                                                    ++k;
                                                }
                                                spaceWidth = charWidths[j];
                                                ccRender.drawFullWidthSpace(leftX, drawY, lineHeight, spaceWidth);
                                            }
                                            ++j;
                                        }
                                    }
                                }
                                if (ccRender.isDrawHalfWidthSpace()) {
                                    String runText = this.segmentsText.substring(run.start, run.start + run.length);
                                    int halfSpace = 32;
                                    if (runText.indexOf(32) != -1) {
                                        int[] charWidths = new int[run.length];
                                        OS.ScriptGetLogicalWidths(run.analysis, run.length, run.glyphCount, run.advances, run.clusters, run.visAttrs, charWidths);
                                        char[] chars = runText.toCharArray();
                                        int j = 0;
                                        while (j < chars.length) {
                                            c = chars[j];
                                            if (c == ' ') {
                                                leftX = drawX;
                                                k = 0;
                                                while (k < j) {
                                                    leftX += charWidths[k];
                                                    ++k;
                                                }
                                                spaceWidth = charWidths[j];
                                                ccRender.drawHalfWidthSpace(leftX, drawY, lineHeight, spaceWidth);
                                            }
                                            ++j;
                                        }
                                    }
                                }
                            } else if (run.tab && ccRender.isDrawTab()) {
                                ccRender.drawTab(drawX, drawY, lineHeight);
                            }
                        }
                        drawX += run.width;
                    }
                    ++i2;
                }
            }
            ++line;
        }
        OS.RestoreDC(hdc, state);
        if (selBrush != 0) {
            OS.DeleteObject(selBrush);
        }
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        int i = 0;
        while (i < this.allRuns.length) {
            StyleItem run = this.allRuns[i];
            run.free();
            ++i;
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int width = 0;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        } else {
            int line = 0;
            while (line < this.runs.length) {
                width = Math.max(width, this.lineWidth[line]);
                ++line;
            }
        }
        return new Rectangle(0, 0, width, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int start, int end) {
        int endX;
        int[] piX;
        int gGlyphs;
        int cChars;
        int runOffset;
        int startX;
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int startLine = this.getLineIndex(start);
        int endLine = this.getLineIndex(end);
        length = this.segmentsText.length();
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        if (startLine != endLine) {
            int width = 0;
            int y = this.lineY[startLine];
            while (startLine <= endLine) {
                width = Math.max(width, this.lineWidth[startLine++]);
            }
            return new Rectangle(0, y, width, this.lineY[endLine + 1] - y);
        }
        int x = 0;
        int startRunX = 0;
        int endRunX = 0;
        int i = 0;
        StyleItem startRun = null;
        StyleItem endRun = null;
        StyleItem[] lineRuns = this.runs[startLine];
        while (i < lineRuns.length) {
            StyleItem run = lineRuns[i];
            int runEnd = run.start + run.length;
            if (runEnd == length) {
                ++runEnd;
            }
            if (run.start <= start && start < runEnd) {
                startRun = run;
                startRunX = x;
                break;
            }
            x += run.width;
            ++i;
        }
        boolean reordered = false;
        StyleItem lastRun = startRun;
        boolean isRTL = (this.orientation & 0x4000000) != 0 ^ (lastRun.analysis.s.uBidiLevel & 1) != 0;
        while (i < lineRuns.length) {
            StyleItem run = lineRuns[i];
            if (run != lastRun) {
                if (isRTL) {
                    reordered = run.start + run.length != lastRun.start;
                } else {
                    boolean bl = reordered = lastRun.start + lastRun.length != run.start;
                }
            }
            if (reordered) break;
            lastRun = run;
            int runEnd = run.start + run.length;
            if (runEnd == length) {
                ++runEnd;
            }
            if (run.start <= end && end < runEnd) {
                endRun = run;
                endRunX = x;
                break;
            }
            x += run.width;
            ++i;
        }
        if (reordered || endRun == null) {
            int y = this.lineY[startLine];
            return new Rectangle(0, y, this.lineWidth[startLine], this.lineY[startLine + 1] - y);
        }
        if ((startRun.analysis.s.uBidiLevel & 1) != 0 ^ (endRun.analysis.s.uBidiLevel & 1) != 0) {
            int y = this.lineY[startLine];
            return new Rectangle(startRunX, y, endRunX + endRun.width, this.lineY[startLine + 1] - y);
        }
        if (startRun.tab) {
            startX = startRunX;
        } else {
            runOffset = start - startRun.start;
            cChars = startRun.length;
            gGlyphs = startRun.glyphCount;
            piX = new int[1];
            OS.ScriptCPtoX(runOffset, false, cChars, gGlyphs, startRun.clusters, startRun.visAttrs, startRun.advances, startRun.analysis, piX);
            if ((this.orientation & 0x4000000) != 0) {
                piX[0] = startRun.width - piX[0];
            }
            startX = startRunX + piX[0];
        }
        if (endRun.tab) {
            endX = endRunX + endRun.width;
        } else {
            runOffset = end - endRun.start;
            cChars = endRun.length;
            gGlyphs = endRun.glyphCount;
            piX = new int[1];
            OS.ScriptCPtoX(runOffset, true, cChars, gGlyphs, endRun.clusters, endRun.visAttrs, endRun.advances, endRun.analysis, piX);
            if ((this.orientation & 0x4000000) != 0) {
                piX[0] = endRun.width - piX[0];
            }
            endX = endRunX + piX[0];
        }
        if (startX > endX) {
            int tmp = startX;
            startX = endX;
            endX = tmp;
        }
        int width = endX - startX;
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    startX += (this.wrapWidth - this.lineWidth[startLine]) / 2;
                    break;
                }
                case 131072: {
                    startX += this.wrapWidth - this.lineWidth[startLine];
                }
            }
        }
        int y = this.lineY[startLine];
        return new Rectangle(startX, y, width, this.lineY[startLine + 1] - y);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    int getItemFont(StyleItem item) {
        if (item.fallbackFont != 0) {
            return item.fallbackFont;
        }
        if (item.style != null && item.style.font != null) {
            return item.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.getSystemFont().handle;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int i = 1;
        while (i < this.allRuns.length) {
            if (this.allRuns[i].start > offset) {
                return this.allRuns[i - 1].analysis.s.uBidiLevel;
            }
            ++i;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns(null);
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int x = 0;
        int y = this.lineY[lineIndex];
        int width = this.lineWidth[lineIndex];
        int height = this.lineY[lineIndex + 1] - y;
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    x = (this.wrapWidth - width) / 2;
                    break;
                }
                case 131072: {
                    x = this.wrapWidth - width;
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int line = 0;
        while (line < this.runs.length) {
            if (this.lineOffset[line + 1] > offset) {
                return line;
            }
            ++line;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        TEXTMETRIC lptm;
        this.checkLayout();
        this.computeRuns(null);
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int hDC = this.device.internal_new_GC(null);
        int srcHdc = OS.CreateCompatibleDC(hDC);
        TEXTMETRIC tEXTMETRIC = lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        if (this.text.length() == 0) {
            Font font = this.font != null ? this.font : this.device.getSystemFont();
            OS.SelectObject(srcHdc, font.handle);
            OS.GetTextMetrics(srcHdc, lptm);
            lptm.tmAscent = Math.max(lptm.tmAscent, this.ascent);
            lptm.tmDescent = Math.max(lptm.tmDescent, this.descent);
        } else {
            int ascent = this.ascent;
            int descent = this.descent;
            int leading = 0;
            int aveCharWidth = 0;
            int height = 0;
            StyleItem[] lineRuns = this.runs[lineIndex];
            int i = 0;
            while (i < lineRuns.length) {
                StyleItem run = lineRuns[i];
                OS.SelectObject(srcHdc, this.getItemFont(run));
                OS.GetTextMetrics(srcHdc, lptm);
                ascent = Math.max(ascent, lptm.tmAscent);
                descent = Math.max(descent, lptm.tmDescent);
                height = Math.max(height, lptm.tmHeight);
                leading = Math.max(leading, lptm.tmInternalLeading);
                aveCharWidth += lptm.tmAveCharWidth;
                ++i;
            }
            lptm.tmAscent = ascent;
            lptm.tmDescent = descent;
            lptm.tmHeight = height;
            lptm.tmInternalLeading = leading;
            lptm.tmAveCharWidth = aveCharWidth / lineRuns.length;
        }
        if (srcHdc != 0) {
            OS.DeleteDC(srcHdc);
        }
        this.device.internal_dispose_GC(hDC, null);
        return FontMetrics.win32_new(lptm);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] offsets = new int[this.lineOffset.length];
        int i = 0;
        while (i < offsets.length) {
            offsets[i] = this.untranslateOffset(this.lineOffset[i]);
            ++i;
        }
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        int line = 0;
        while (line < this.runs.length) {
            if (this.lineOffset[line + 1] > offset) break;
            ++line;
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        Point result = null;
        if (offset == length) {
            result = new Point(this.lineWidth[line], this.lineY[line]);
        } else {
            int width = 0;
            int i = 0;
            while (i < lineRuns.length) {
                StyleItem run = lineRuns[i];
                int end = run.start + run.length;
                if (run.start <= offset && offset < end) {
                    if (run.tab) {
                        if (trailing || offset == length) {
                            width += run.width;
                        }
                        result = new Point(width, this.lineY[line]);
                        break;
                    }
                    int runOffset = offset - run.start;
                    int cChars = run.length;
                    int gGlyphs = run.glyphCount;
                    int[] piX = new int[1];
                    OS.ScriptCPtoX(runOffset, trailing, cChars, gGlyphs, run.clusters, run.visAttrs, run.advances, run.analysis, piX);
                    if ((this.orientation & 0x4000000) != 0) {
                        result = new Point(width + (run.width - piX[0]), this.lineY[line]);
                        break;
                    }
                    result = new Point(width + piX[0], this.lineY[line]);
                    break;
                }
                width += run.width;
                ++i;
            }
        }
        if (result == null) {
            result = new Point(0, 0);
        }
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    result.x += (this.wrapWidth - this.lineWidth[line]) / 2;
                    break;
                }
                case 131072: {
                    result.x += this.wrapWidth - this.lineWidth[line];
                }
            }
        }
        return result;
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int i = forward ? 0 : this.allRuns.length - 1;
        offset = this.validadeOffset(offset, step);
        do {
            boolean isComplex;
            StyleItem run = this.allRuns[i];
            if (run.start > offset || offset >= run.start + run.length) continue;
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (run.tab) {
                return this.untranslateOffset(run.start);
            }
            OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], 8);
            boolean bl = isComplex = properties.fNeedsCaretInfo || properties.fNeedsWordBreaking;
            if (isComplex) {
                this.breakRun(run);
            }
            while (run.start <= offset && offset < run.start + run.length) {
                if (isComplex) {
                    OS.MoveMemory(logAttr, run.psla + (offset - run.start) * 1, 1);
                }
                switch (movement) {
                    case 2: {
                        if (properties.fNeedsCaretInfo) {
                            if (logAttr.fInvalid || !logAttr.fCharStop) break;
                            return this.untranslateOffset(offset);
                        }
                        return this.untranslateOffset(offset);
                    }
                    case 4: {
                        boolean previousLetterOrDigit;
                        boolean letterOrDigit;
                        if (!(properties.fNeedsWordBreaking ? !logAttr.fInvalid && logAttr.fWordStop : offset > 0 && ((letterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset))) != (previousLetterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset - 1))) || !letterOrDigit) && !Compatibility.isWhitespace(this.segmentsText.charAt(offset)))) break;
                        return this.untranslateOffset(offset);
                    }
                }
                offset = this.validadeOffset(offset, step);
            }
        } while ((i += step) >= 0 && i < this.allRuns.length - 1 && offset >= 0 && offset < length);
        return forward ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        boolean isRTL;
        this.checkLayout();
        this.computeRuns(null);
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        int lineCount = this.runs.length;
        int line = 0;
        while (line < lineCount) {
            if (this.lineY[line + 1] > y) break;
            ++line;
        }
        line = Math.min(line, this.runs.length - 1);
        if (this.wrapWidth != -1) {
            switch (this.alignment) {
                case 0x1000000: {
                    x -= (this.wrapWidth - this.lineWidth[line]) / 2;
                    break;
                }
                case 131072: {
                    x -= this.wrapWidth - this.lineWidth[line];
                }
            }
        }
        StyleItem[] lineRuns = this.runs[line];
        boolean bl = isRTL = (this.orientation & 0x4000000) != 0;
        if (x < 0) {
            StyleItem firstRun = lineRuns[0];
            if (firstRun.analysis.fRTL ^ isRTL) {
                if (trailing != null) {
                    trailing[0] = 1;
                }
                return this.untranslateOffset(firstRun.start + firstRun.length - 1);
            }
            if (trailing != null) {
                trailing[0] = 0;
            }
            return this.untranslateOffset(firstRun.start);
        }
        if (x > this.lineWidth[line]) {
            int index = lineRuns.length - 1;
            if (line == lineCount - 1 && lineRuns.length > 1) {
                --index;
            }
            StyleItem lastRun = lineRuns[index];
            if (lastRun.analysis.fRTL ^ isRTL) {
                if (trailing != null) {
                    trailing[0] = 0;
                }
                return this.untranslateOffset(lastRun.start);
            }
            if (trailing != null) {
                trailing[0] = 1;
            }
            return this.untranslateOffset(lastRun.start + lastRun.length - 1);
        }
        int width = 0;
        int i = 0;
        while (i < lineRuns.length) {
            StyleItem run = lineRuns[i];
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (width + run.width > x) {
                if (run.tab) {
                    if (trailing != null) {
                        trailing[0] = x < width + run.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(run.start);
                }
                int cChars = run.length;
                int cGlyphs = run.glyphCount;
                int xRun = x - width;
                int[] piCP = new int[1];
                int[] piTrailing = new int[1];
                if ((this.orientation & 0x4000000) != 0) {
                    xRun = run.width - xRun;
                }
                OS.ScriptXtoCP(xRun, cChars, cGlyphs, run.clusters, run.visAttrs, run.advances, run.analysis, piCP, piTrailing);
                if (trailing != null) {
                    trailing[0] = piTrailing[0];
                }
                return this.untranslateOffset(run.start + piCP[0]);
            }
            width += run.width;
            ++i;
        }
        if (trailing != null) {
            trailing[0] = 0;
        }
        return this.untranslateOffset(this.lineOffset[line + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, false);
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return this.text;
        }
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return this.text;
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int separator = this.orientation == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        if (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, Math.min(charCount + segmentCount, newChars.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            if (this.styles[i].start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int length = this.segmentsText.length();
        SCRIPT_CONTROL scriptControl = new SCRIPT_CONTROL();
        SCRIPT_STATE scriptState = new SCRIPT_STATE();
        int MAX_ITEM = length + 1;
        if ((this.orientation & 0x4000000) != 0) {
            scriptState.uBidiLevel = 1;
            scriptState.fArabicNumContext = true;
        }
        int hHeap = OS.GetProcessHeap();
        int pItems = OS.HeapAlloc(hHeap, 8, MAX_ITEM * 8);
        int[] pcItems = new int[1];
        char[] chars = new char[length];
        this.segmentsText.getChars(0, length, chars, 0);
        OS.ScriptItemize(chars, length, MAX_ITEM, scriptControl, scriptState, pItems, pcItems);
        StyleItem[] runs = this.merge(pItems, pcItems[0]);
        OS.HeapFree(hHeap, 0, pItems);
        return runs;
    }

    StyleItem[] merge(int items, int itemCount) {
        StyleItem item;
        int count = 0;
        int start = 0;
        int end = this.segmentsText.length();
        int itemIndex = 0;
        int styleIndex = 0;
        StyleItem[] runs = new StyleItem[itemCount + this.styles.length];
        SCRIPT_ITEM scriptItem = new SCRIPT_ITEM();
        while (start < end) {
            item = new StyleItem();
            item.start = start;
            item.style = this.styles[styleIndex].style;
            runs[count++] = item;
            OS.MoveMemory(scriptItem, items + itemIndex * 8, 8);
            item.analysis = scriptItem.a;
            scriptItem.a = new SCRIPT_ANALYSIS();
            OS.MoveMemory(scriptItem, items + (itemIndex + 1) * 8, 8);
            int itemLimit = scriptItem.iCharPos;
            int styleLimit = this.translateOffset(this.styles[styleIndex + 1].start);
            if (styleLimit <= itemLimit) {
                ++styleIndex;
                start = styleLimit;
            }
            if (itemLimit <= styleLimit) {
                ++itemIndex;
                start = itemLimit;
            }
            item.length = start - item.start;
        }
        item = new StyleItem();
        item.start = end;
        OS.MoveMemory(scriptItem, items + itemCount * 8, 8);
        item.analysis = scriptItem.a;
        runs[count++] = item;
        if (runs.length != count) {
            StyleItem[] result = new StyleItem[count];
            System.arraycopy(runs, 0, result, 0, count);
            return result;
        }
        return runs;
    }

    StyleItem[] reorder(StyleItem[] runs) {
        byte[] bidiLevels = new byte[runs.length];
        int i = 0;
        while (i < runs.length) {
            bidiLevels[i] = (byte)(runs[i].analysis.s.uBidiLevel & 0x1F);
            ++i;
        }
        int[] log2vis = new int[runs.length];
        OS.ScriptLayout(runs.length, bidiLevels, null, log2vis);
        StyleItem[] result = new StyleItem[runs.length];
        int i2 = 0;
        while (i2 < runs.length) {
            result[log2vis[i2]] = runs[i2];
            ++i2;
        }
        if ((this.orientation & 0x4000000) != 0) {
            i2 = 0;
            while (i2 < (result.length - 1) / 2) {
                StyleItem tmp = result[i2];
                result[i2] = result[result.length - i2 - 2];
                result[result.length - i2 - 2] = tmp;
                ++i2;
            }
        }
        return result;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.freeRuns();
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = spacing;
    }

    /*
     * Unable to fully structure code
     */
    public void setStyle(TextStyle style, int start, int end) {
        block13: {
            this.checkLayout();
            length = this.text.length();
            if (length == 0) {
                return;
            }
            if (start > end) {
                return;
            }
            start = Math.min(Math.max(0, start), length - 1);
            end = Math.min(Math.max(0, end), length - 1);
            low = -1;
            high = this.styles.length;
            while (high - low > 1) {
                index = (high + low) / 2;
                if (start <= this.styles[index].start) {
                    high = index;
                    continue;
                }
                low = index;
            }
            if (high >= 0 && high < this.styles.length) {
                item = this.styles[high];
                if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style) != false)) {
                    return;
                }
            }
            this.freeRuns();
            count = 0;
            newStyles = new StyleItem[this.styles.length + 2];
            i = 0;
            while (i < this.styles.length) {
                item = this.styles[i];
                if (item.start >= start) break;
                newStyles[count++] = item;
                ++i;
            }
            newItem = new StyleItem();
            newItem.start = start;
            newItem.style = style;
            newStyles[count++] = newItem;
            if (this.styles[i].start <= end) ** GOTO lbl45
            newItem = new StyleItem();
            newItem.start = end + 1;
            newItem.style = this.styles[i - 1].style;
            newStyles[count++] = newItem;
            break block13;
lbl-1000:
            // 1 sources

            {
                item = this.styles[i];
                if (item.start > end) break;
                ++i;
lbl45:
                // 2 sources

                ** while (i < this.styles.length)
            }
lbl46:
            // 2 sources

            if (end != this.styles[i].start - 1) {
                this.styles[--i].start = end + 1;
            }
        }
        while (i < this.styles.length) {
            item = this.styles[i];
            if (item.start > end) {
                newStyles[count++] = item;
            }
            ++i;
        }
        if (newStyles.length != count) {
            this.styles = new StyleItem[count];
            System.arraycopy(newStyles, 0, this.styles, 0, count);
        } else {
            this.styles = newStyles;
        }
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    boolean shape(int hdc, StyleItem run, char[] chars, int[] glyphCount, int maxGlyphs) {
        int hr = OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, glyphCount);
        run.glyphCount = glyphCount[0];
        if (hr != -2147220992) {
            SCRIPT_FONTPROPERTIES fp = new SCRIPT_FONTPROPERTIES();
            fp.cBytes = 16;
            OS.ScriptGetFontProperties(hdc, run.psc, fp);
            short[] glyphs = new short[glyphCount[0]];
            OS.MoveMemory(glyphs, run.glyphs, glyphs.length * 2);
            int i = 0;
            while (i < glyphs.length) {
                if (glyphs[i] == fp.wgDefault) break;
                ++i;
            }
            if (i == glyphs.length) {
                return true;
            }
        }
        if (run.psc != 0) {
            OS.ScriptFreeCache(run.psc);
            glyphCount[0] = 0;
            OS.MoveMemory(run.psc, glyphCount, 4);
        }
        run.glyphCount = 0;
        return false;
    }

    void shape(final int hdc, final StyleItem run) {
        final int[] buffer = new int[1];
        final char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        final int maxGlyphs = chars.length * 3 / 2 + 16;
        int hHeap = OS.GetProcessHeap();
        run.glyphs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        run.clusters = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        run.visAttrs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        run.psc = OS.HeapAlloc(hHeap, 8, 4);
        if (!this.shape(hdc, run, chars, buffer, maxGlyphs)) {
            LOGFONT cachedLogFont;
            final short script = run.analysis.eScript;
            final int hFont = OS.GetCurrentObject(hdc, 6);
            final LOGFONT logFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.GetObject(hFont, LOGFONT.sizeof, logFont);
            LOGFONT lOGFONT = cachedLogFont = this.device.logFontsCache != null ? this.device.logFontsCache[script] : null;
            if (cachedLogFont != null) {
                cachedLogFont.lfHeight = logFont.lfHeight;
                cachedLogFont.lfWeight = logFont.lfWeight;
                cachedLogFont.lfItalic = logFont.lfItalic;
                cachedLogFont.lfWidth = logFont.lfWidth;
                int newFont = OS.CreateFontIndirect(cachedLogFont);
                OS.SelectObject(hdc, newFont);
                OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, buffer);
                run.glyphCount = buffer[0];
                run.fallbackFont = newFont;
            } else {
                LOGFONT newLogFont;
                LOGFONT lOGFONT2 = newLogFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                if (this.device.logFontsCache == null) {
                    this.device.logFontsCache = new LOGFONT[this.device.scripts.length];
                }
                SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
                OS.MoveMemory(properties, this.device.scripts[script], 8);
                byte charSet = properties.fAmbiguousCharSet ? (byte)1 : properties.bCharSet;
                Object object = new Object(){

                    public int EnumFontFamExProc(int lpelfe, int lpntme, int FontType, int lParam) {
                        OS.MoveMemory(newLogFont, lpelfe, LOGFONT.sizeof);
                        if (FontType == 1) {
                            return 1;
                        }
                        newLogFont.lfHeight = logFont.lfHeight;
                        newLogFont.lfWeight = logFont.lfWeight;
                        newLogFont.lfItalic = logFont.lfItalic;
                        newLogFont.lfWidth = logFont.lfWidth;
                        int newFont = OS.CreateFontIndirect(newLogFont);
                        OS.SelectObject(hdc, newFont);
                        if (TextLayout.this.shape(hdc, run, chars, buffer, maxGlyphs)) {
                            run.fallbackFont = newFont;
                            LOGFONT cacheLogFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                            OS.MoveMemory(cacheLogFont, lpelfe, LOGFONT.sizeof);
                            TextLayout.this.device.logFontsCache[script] = cacheLogFont;
                            return 0;
                        }
                        OS.SelectObject(hdc, hFont);
                        OS.DeleteObject(newFont);
                        return 1;
                    }
                };
                Callback callback = new Callback(object, "EnumFontFamExProc", 4);
                int address = callback.getAddress();
                if (address == 0) {
                    SWT.error(3);
                }
                newLogFont.lfCharSet = charSet;
                OS.EnumFontFamiliesEx(hdc, newLogFont, address, 0, 0);
                callback.dispose();
                if (run.fallbackFont == 0) {
                    OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, buffer);
                    this.device.logFontsCache[script] = logFont;
                    run.glyphCount = buffer[0];
                }
            }
        }
        int[] abc = new int[3];
        run.advances = OS.HeapAlloc(hHeap, 8, run.glyphCount * 4);
        run.goffsets = OS.HeapAlloc(hHeap, 8, run.glyphCount * 8);
        OS.ScriptPlace(hdc, run.psc, run.glyphs, run.glyphCount, run.visAttrs, run.analysis, run.advances, run.goffsets, abc);
        run.width = abc[0] + abc[1] + abc[2];
        TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(hdc, lptm);
        run.ascent = lptm.tmAscent;
        run.descent = lptm.tmDescent;
    }

    int validadeOffset(int offset, int step) {
        offset += step;
        if (this.segments != null && this.segments.length > 2) {
            int i = 0;
            while (i < this.segments.length) {
                if (this.translateOffset(this.segments[i]) - 1 == offset) {
                    offset += step;
                    break;
                }
                ++i;
            }
        }
        return offset;
    }

    int translateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        int i = 0;
        while (i < nSegments && offset - i >= this.segments[i]) {
            ++offset;
            ++i;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        int i = 0;
        while (i < nSegments && offset > this.segments[i]) {
            --offset;
            ++i;
        }
        return offset;
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        int psc = 0;
        int glyphs;
        int glyphCount;
        int clusters;
        int visAttrs;
        int advances;
        int goffsets;
        int width;
        int ascent;
        int descent;
        int psla;
        int fallbackFont;

        StyleItem() {
        }

        void free() {
            int hHeap = OS.GetProcessHeap();
            if (this.psc != 0) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(hHeap, 0, this.psc);
                this.psc = 0;
            }
            if (this.glyphs != 0) {
                OS.HeapFree(hHeap, 0, this.glyphs);
                this.glyphs = 0;
                this.glyphCount = 0;
            }
            if (this.clusters != 0) {
                OS.HeapFree(hHeap, 0, this.clusters);
                this.clusters = 0;
            }
            if (this.visAttrs != 0) {
                OS.HeapFree(hHeap, 0, this.visAttrs);
                this.visAttrs = 0;
            }
            if (this.advances != 0) {
                OS.HeapFree(hHeap, 0, this.advances);
                this.advances = 0;
            }
            if (this.goffsets != 0) {
                OS.HeapFree(hHeap, 0, this.goffsets);
                this.goffsets = 0;
            }
            if (this.psla != 0) {
                OS.HeapFree(hHeap, 0, this.psla);
                this.psla = 0;
            }
            if (this.fallbackFont != 0) {
                OS.DeleteObject(this.fallbackFont);
                this.fallbackFont = 0;
            }
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }
    }

    public static class ControlCharRenderer {
        private static final JStyleProperties prop = new JStyleProperties();
        private static final boolean showLineBreak = prop.is("show.line.break");
        private static final boolean showTab = prop.is("show.tab");
        private static final boolean showFullWidthSpace = prop.is("show.full.width.space");
        private static final boolean showHalfWidthSpace = prop.is("show.half.width.space");
        private static final int lineBreakColorId = prop.getColorId("line.break.color");
        private static final int tabColorId = prop.getColorId("tab.color");
        private static final int fullWidthSpaceColorId = prop.getColorId("full.width.space.color");
        private static final int halfWidthSpaceColorId = prop.getColorId("half.width.space.color");
        private final boolean isScreen;
        private String lineDelimiter;
        private GC gc;
        private Device device;
        private Color originColor;
        private Color lineBreakColor;
        private Color tabColor;
        private Color fullWidthSpaceColor;
        private Color halfWidthSpaceColor;

        public ControlCharRenderer(boolean isScreen) {
            this.isScreen = isScreen;
        }

        public void setLineDelimiter(String lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
        }

        void init(GC gc, Device device) {
            if (!this.isScreen) {
                return;
            }
            this.gc = gc;
            this.device = device;
            this.originColor = gc.getForeground();
            if (showLineBreak) {
                this.lineBreakColor = device.getSystemColor(lineBreakColorId);
            }
            if (showTab) {
                this.tabColor = device.getSystemColor(tabColorId);
            }
            if (showFullWidthSpace) {
                this.fullWidthSpaceColor = device.getSystemColor(fullWidthSpaceColorId);
            }
            if (showHalfWidthSpace) {
                this.halfWidthSpaceColor = device.getSystemColor(halfWidthSpaceColorId);
            }
        }

        boolean isDrawLineBreak() {
            return this.isScreen && showLineBreak;
        }

        boolean isDrawTab() {
            return this.isScreen && showTab;
        }

        boolean isDrawFullWidthSpace() {
            return this.isScreen && showFullWidthSpace;
        }

        boolean isDrawHalfWidthSpace() {
            return this.isScreen && showHalfWidthSpace;
        }

        void drawLineBreak(int x, int y, int lineHeight) {
            if (this.lineDelimiter == null || this.lineDelimiter.length() == 0) {
                return;
            }
            int lastX = x + 1;
            int underY = y + lineHeight - 1;
            int pt = lineHeight / 8;
            this.gc.setForeground(this.lineBreakColor);
            if (this.lineDelimiter.equals("\n")) {
                this.gc.drawLine(lastX + pt * 2, y + pt * 2, lastX + pt * 2, underY - pt * 2);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 4, lastX + pt * 2, underY - pt * 2);
                this.gc.drawLine(lastX + pt * 4, underY - pt * 4, lastX + pt * 2, underY - pt * 2);
            } else if (this.lineDelimiter.equals("\r\n")) {
                this.gc.drawLine(lastX + pt * 5, y + pt * 2, lastX + pt * 5, underY - pt * 3);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 3, lastX + pt * 5, underY - pt * 3);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 3, lastX + pt * 2, underY - pt * 5);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 3, lastX + pt * 2, underY - pt * 1);
            } else {
                this.gc.drawLine(lastX + pt * 0, underY - pt * 4, lastX + pt * 6, underY - pt * 4);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 4, lastX + pt * 2, underY - pt * 6);
                this.gc.drawLine(lastX + pt * 0, underY - pt * 4, lastX + pt * 2, underY - pt * 2);
            }
            this.gc.setForeground(this.originColor);
        }

        void drawTab(int x, int y, int lineHeight) {
            int pt = lineHeight / 8;
            int leftX = x + 1;
            this.gc.setForeground(this.tabColor);
            this.gc.drawLine(leftX + pt * 0, y + pt * 4, leftX + pt * 2, y + pt * 2);
            this.gc.drawLine(leftX + pt * 4, y + pt * 4, leftX + pt * 2, y + pt * 2);
            this.gc.setForeground(this.originColor);
        }

        void drawFullWidthSpace(int x, int y, int lineHeight, int spaceWidth) {
            int rightX = x + spaceWidth - 1;
            int pt = lineHeight / 8;
            int underY = y + lineHeight - 1;
            this.gc.setForeground(this.fullWidthSpaceColor);
            this.gc.drawLine(x + pt * 2, y + pt * 2, rightX - pt * 2, y + pt * 2);
            this.gc.drawLine(x + pt * 2, underY - pt * 2, rightX - pt * 2, underY - pt * 2);
            this.gc.drawLine(x + pt * 2, y + pt * 2, x + pt * 2, underY - pt * 2);
            this.gc.drawLine(rightX - pt * 2, y + pt * 2, rightX - pt * 2, underY - pt * 2);
            this.gc.setForeground(this.originColor);
        }

        void drawHalfWidthSpace(int x, int y, int lineHeight, int spaceWidth) {
            int rightX = x + spaceWidth - 1;
            int pt = lineHeight / 8;
            int underY = y + lineHeight - 1;
            int x1 = x + pt * 1;
            int x2 = rightX - pt * 1;
            if (x1 >= x2 - 1) {
                x1 = x + 1;
                x2 = rightX - 1;
            }
            this.gc.setForeground(this.halfWidthSpaceColor);
            this.gc.drawLine(x1, underY - pt * 2, x2, underY - pt * 2);
            this.gc.drawLine(x1, underY - pt * 4, x1, underY - pt * 2);
            this.gc.drawLine(x2, underY - pt * 4, x2, underY - pt * 2);
            this.gc.setForeground(this.originColor);
        }
    }

    static class JStyleProperties
    extends Properties {
        static /* synthetic */ Class class$0;

        JStyleProperties() {
            try {
                File pluginsDir = this.getPluginsDirectory(new File("."));
                Object[] files = pluginsDir.listFiles();
                Arrays.sort(files);
                List<Object> fileList = Arrays.asList(files);
                Collections.reverse(fileList);
                Iterator<Object> it = fileList.iterator();
                while (it.hasNext()) {
                    File propFile;
                    File f = (File)it.next();
                    if (!f.isDirectory() || !f.getName().startsWith("org.eclipse.swt.win32_") || !(propFile = new File(f, "jstyle.properties")).exists()) continue;
                    this.load(new FileInputStream(propFile));
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        File getPluginsDirectory(File dir) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isDirectory()) {
                    if (f.getName().equals("plugins")) {
                        return f;
                    }
                    File result = this.getPluginsDirectory(f);
                    if (result != null) {
                        return result;
                    }
                }
                ++i;
            }
            return null;
        }

        boolean is(String key) {
            return this.getProperty(key, "true").toLowerCase().equals("true");
        }

        int getColorId(String key) {
            try {
                String fieldName = this.getProperty(key);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.swt.SWT");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Field field = clazz.getField(fieldName);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.swt.SWT");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return field.getInt(clazz2);
            }
            catch (Exception e) {
                return 15;
            }
        }
    }
}

