/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    int background = -1;
    int foreground = -1;
    int font = -1;
    int imageIndent;
    int[] cellBackground;
    int[] cellForeground;
    int[] cellFont;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.imageIndent = 0;
        this.grayed = false;
        this.checked = false;
        this.font = -1;
        this.foreground = -1;
        this.background = -1;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    public Color getBackground() {
        this.checkWidget();
        int pixel = this.background == -1 ? this.parent.getBackgroundPixel() : this.background;
        return Color.win32_new(this.display, pixel);
    }

    public Color getBackground(int index) {
        this.checkWidget();
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        int pixel = this.cellBackground != null ? this.cellBackground[index] : -1;
        return pixel == -1 ? this.getBackground() : Color.win32_new(this.display, pixel);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int hwnd = this.parent.handle;
        int hwndHeader = OS.SendMessage(hwnd, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (index < 0 || index >= count) {
            return new Rectangle(0, 0, 0, 0);
        }
        int gridWidth = this.parent.getLinesVisible() ? this.parent.getGridLineWidth() : 0;
        RECT rect = new RECT();
        rect.top = index;
        rect.left = 2;
        OS.SendMessage(hwnd, 4152, itemIndex, rect);
        if (index == 0) {
            RECT iconRect = new RECT();
            iconRect.left = 1;
            OS.SendMessage(hwnd, 4152, itemIndex, iconRect);
            rect.left = iconRect.left - gridWidth;
        }
        int width = Math.max(0, rect.right - rect.left - gridWidth);
        int height = Math.max(0, rect.bottom - rect.top - gridWidth);
        if ((OS.COMCTL32_MAJOR << 16 | OS.COMCTL32_MINOR) >= 327760) {
            rect.top -= gridWidth;
        }
        return new Rectangle(rect.left + gridWidth, rect.top + gridWidth, width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font == -1 ? this.parent.getFont() : Font.win32_new(this.display, this.font);
    }

    public Font getFont(int index) {
        this.checkWidget();
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        int hFont = this.cellFont != null ? this.cellFont[index] : this.font;
        return hFont == -1 ? this.getFont() : Font.win32_new(this.display, hFont);
    }

    public Color getForeground() {
        this.checkWidget();
        int pixel = this.foreground == -1 ? this.parent.getForegroundPixel() : this.foreground;
        return Color.win32_new(this.display, pixel);
    }

    public Color getForeground(int index) {
        this.checkWidget();
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        int pixel = this.cellForeground != null ? this.cellForeground[index] : -1;
        return pixel == -1 ? this.getForeground() : Color.win32_new(this.display, pixel);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (index == 0) {
            return super.getImage();
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        int itemIndex = this.parent.indexOf(this);
        if (itemIndex == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int hwnd = this.parent.handle;
        int hwndHeader = OS.SendMessage(hwnd, 4127, 0, 0);
        int count = OS.SendMessage(hwndHeader, 4608, 0, 0);
        if (index < 0 || index >= count) {
            return new Rectangle(0, 0, 0, 0);
        }
        int gridWidth = this.parent.getLinesVisible() ? this.parent.getGridLineWidth() : 0;
        RECT rect = new RECT();
        rect.top = index;
        rect.left = 1;
        OS.SendMessage(hwnd, 4152, itemIndex, rect);
        if (index == 0) {
            rect.left -= gridWidth;
        }
        int width = Math.max(0, rect.right - rect.left - gridWidth);
        int height = Math.max(0, rect.bottom - rect.top - gridWidth);
        if (index != 0) {
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 2;
            lvItem.iItem = itemIndex;
            lvItem.iSubItem = index;
            OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem);
            if (lvItem.iImage < 0) {
                width = 0;
            }
        }
        if ((OS.COMCTL32_MAJOR << 16 | OS.COMCTL32_MINOR) >= 327760) {
            rect.top -= gridWidth;
        }
        return new Rectangle(rect.left + gridWidth, rect.top + gridWidth, width, height);
    }

    public int getImageIndent() {
        this.checkWidget();
        return this.imageIndent;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText(int index) {
        this.checkWidget();
        if (index == 0) {
            return super.getText();
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return "";
    }

    void redraw(int column, boolean drawText, boolean drawImage) {
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.parent.ignoreRedraw || this.parent.drawCount != 0) {
            return;
        }
        int hwnd = this.parent.handle;
        if (OS.IsWindowVisible(hwnd)) {
            RECT rect = new RECT();
            int index = this.parent.indexOf(this);
            if (column == -1) {
                OS.SendMessage(hwnd, 4117, index, index);
            } else {
                if (drawText) {
                    rect.left |= 2;
                }
                if (drawImage) {
                    rect.left |= 1;
                }
                if (column == 0) {
                    if (OS.SendMessage(hwnd, 4110, index, rect) != 0) {
                        OS.InvalidateRect(hwnd, rect, true);
                    }
                } else {
                    rect.top = column;
                    if (OS.SendMessage(hwnd, 4152, index, rect) != 0) {
                        if (drawText && !drawImage && this.images != null) {
                            RECT iconRect = new RECT();
                            iconRect.left = 1;
                            iconRect.top = column;
                            if (OS.SendMessage(hwnd, 4152, index, iconRect) != 0) {
                                boolean fixWidth = true;
                                if (column != 0) {
                                    LVITEM lvItem = new LVITEM();
                                    lvItem.mask = 2;
                                    lvItem.iItem = index;
                                    lvItem.iSubItem = column;
                                    OS.SendMessage(hwnd, OS.LVM_GETITEM, 0, lvItem);
                                    if (lvItem.iImage < 0) {
                                        fixWidth = false;
                                    }
                                }
                                if (fixWidth) {
                                    rect.left = iconRect.right;
                                }
                            }
                        }
                        OS.InvalidateRect(hwnd, rect, true);
                    }
                }
            }
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.strings = null;
        this.images = null;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        this.redraw(-1, true, true);
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[count];
            int i = 0;
            while (i < count) {
                this.cellBackground[i] = -1;
                ++i;
            }
        }
        if (this.cellBackground[index] == pixel) {
            return;
        }
        this.cellBackground[index] = pixel;
        this.redraw(index, true, true);
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.setChecked(checked, false);
    }

    void setChecked(boolean checked, boolean notify) {
        this.checked = checked;
        if (notify) {
            Event event = new Event();
            event.item = this;
            event.detail = 32;
            this.parent.postEvent(13, event);
        }
        this.redraw(-1, true, true);
    }

    public void setFont(Font font) {
        int itemIndex;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int hFont = -1;
        if (font != null) {
            this.parent.customDraw = true;
            hFont = font.handle;
        }
        if (this.font == hFont) {
            return;
        }
        this.font = hFont;
        if ((this.parent.style & 0x10000000) == 0 && this.cached && (itemIndex = this.parent.indexOf(this)) != -1) {
            int hwnd = this.parent.handle;
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 1;
            lvItem.iItem = itemIndex;
            lvItem.pszText = -1;
            OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
            this.cached = false;
        }
        this.parent.setScrollWidth(this, false);
        this.redraw(-1, true, true);
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int hFont = -1;
        if (font != null) {
            this.parent.customDraw = true;
            hFont = font.handle;
        }
        if (this.cellFont == null) {
            this.cellFont = new int[count];
            int i = 0;
            while (i < count) {
                this.cellFont[i] = -1;
                ++i;
            }
        }
        if (this.cellFont[index] == hFont) {
            return;
        }
        this.cellFont[index] = hFont;
        if (index == 0) {
            int itemIndex;
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (itemIndex = this.parent.indexOf(this)) != -1) {
                int hwnd = this.parent.handle;
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 1;
                lvItem.iItem = itemIndex;
                lvItem.pszText = -1;
                OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(index, true, true);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        this.redraw(-1, true, true);
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        int pixel = -1;
        if (color != null) {
            this.parent.customDraw = true;
            pixel = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[count];
            int i = 0;
            while (i < count) {
                this.cellForeground[i] = -1;
                ++i;
            }
        }
        if (this.cellForeground[index] == pixel) {
            return;
        }
        this.cellForeground[index] = pixel;
        this.redraw(index, true, true);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        this.redraw(-1, true, true);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (index == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            super.setImage(image);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.images == null && index != 0) {
            this.images = new Image[count];
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[index])) {
                return;
            }
            this.images[index] = image;
        }
        this.parent.imageIndex(image);
        if (index == 0) {
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(index, false, true);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        int index;
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        if (this.imageIndent == indent) {
            return;
        }
        this.imageIndent = indent;
        if ((this.parent.style & 0x10000000) == 0 && (index = this.parent.indexOf(this)) != -1) {
            int hwnd = this.parent.handle;
            LVITEM lvItem = new LVITEM();
            lvItem.mask = 16;
            lvItem.iItem = index;
            lvItem.iIndent = indent;
            OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
        }
        this.parent.setScrollWidth(this, false);
        this.redraw(-1, true, true);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.strings == null && index != 0) {
            this.strings = new String[count];
        }
        if (this.strings != null) {
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        if (index == 0) {
            int itemIndex;
            if ((this.parent.style & 0x10000000) == 0 && this.cached && (itemIndex = this.parent.indexOf(this)) != -1) {
                int hwnd = this.parent.handle;
                LVITEM lvItem = new LVITEM();
                lvItem.mask = 1;
                lvItem.iItem = itemIndex;
                lvItem.pszText = -1;
                OS.SendMessage(hwnd, OS.LVM_SETITEM, 0, lvItem);
                this.cached = false;
            }
            this.parent.setScrollWidth(this, false);
        }
        this.redraw(index, true, false);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

