/*
 * Copyright(c) 2005- C/pHeR.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.jstyle;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * Class used to initialize default preference values.
 */
public class JStyleInitializer extends AbstractPreferenceInitializer {

	/*
	 * (non-Javadoc)
	 * @see AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		
		IPreferenceStore store = JStylePlugin.getDefault().getPreferenceStore();
		
		store.setDefault(JStyleConstants.P_LINE_BREAK +
				JStyleConstants.SUFFIX_SHOW, true);
		store.setDefault(JStyleConstants.P_TAB +
				JStyleConstants.SUFFIX_SHOW, true);
		store.setDefault(JStyleConstants.P_FULL_WIDTH_SPACE +
				JStyleConstants.SUFFIX_SHOW, true);
		store.setDefault(JStyleConstants.P_HALF_WIDTH_SPACE +
				JStyleConstants.SUFFIX_SHOW, false);

		store.setDefault(JStyleConstants.P_LINE_BREAK +
				JStyleConstants.SUFFIX_COLOR, JStyleConstants.DEFAULT_RGB_STRING);
		store.setDefault(JStyleConstants.P_TAB +
				JStyleConstants.SUFFIX_COLOR, JStyleConstants.DEFAULT_RGB_STRING);
		store.setDefault(JStyleConstants.P_FULL_WIDTH_SPACE +
				JStyleConstants.SUFFIX_COLOR, JStyleConstants.DEFAULT_RGB_STRING);
		store.setDefault(JStyleConstants.P_HALF_WIDTH_SPACE +
				JStyleConstants.SUFFIX_COLOR, JStyleConstants.DEFAULT_RGB_STRING);
		
		store.setDefault(JStyleConstants.P_FORCE_MONOSPACE, true);
	}
}
