/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_DIGITSUBSTITUTE;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        int[] ppv = new int[1];
        OS.OleInitialize(0);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0, 1, IID_IMLangFontLink2, ppv) == 0) {
            this.mLangFontLink2 = ppv[0];
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void breakRun(StyleItem run) {
        if (run.psla != 0) {
            return;
        }
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        int hHeap = OS.GetProcessHeap();
        run.psla = OS.HeapAlloc(hHeap, 8, SCRIPT_LOGATTR.sizeof * chars.length);
        if (run.psla == 0) {
            SWT.error(2);
        }
        OS.ScriptBreak(chars, chars.length, run.analysis, run.psla);
    }

    void checkItem(int hDC, StyleItem item) {
        if (item.fallbackFont != 0) {
            LOGFONT logFont;
            LOGFONT lOGFONT = logFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            if (OS.GetObject(item.fallbackFont, LOGFONT.sizeof, logFont) == 0) {
                item.free();
                OS.SelectObject(hDC, this.getItemFont(item));
                this.shape(hDC, item);
            }
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gc) {
        if (this.runs != null) {
            return;
        }
        int hDC = gc != null ? gc.handle : this.device.internal_new_GC(null);
        int srcHdc = OS.CreateCompatibleDC(hDC);
        this.allRuns = this.itemize();
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            StyleItem run = this.allRuns[i];
            int hFont = this.getItemFont(run);
            OS.SelectObject(srcHdc, this.getItemFont(run));
            this.shape(srcHdc, run);
            if (!GC.JStyleSWTBridge.forceMonospace || this.font == null || this.font.handle == hFont) continue;
            this.forceMonospace(srcHdc, run);
        }
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int lineWidth = this.indent;
        int lineStart = 0;
        int lineCount = 1;
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            StyleItem run = this.allRuns[i];
            if (run.length == 1) {
                char ch = this.segmentsText.charAt(run.start);
                switch (ch) {
                    case '\t': {
                        int tabX;
                        int lastTabWidth;
                        int j;
                        run.tab = true;
                        if (this.tabs == null) break;
                        int tabsLength = this.tabs.length;
                        for (j = 0; j < tabsLength; ++j) {
                            if (this.tabs[j] <= lineWidth) continue;
                            run.width = this.tabs[j] - lineWidth;
                            break;
                        }
                        if (j != tabsLength) break;
                        int n = lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                        if (lastTabWidth <= 0) break;
                        for (tabX = this.tabs[tabsLength - 1]; tabX <= lineWidth; tabX += lastTabWidth) {
                        }
                        run.width = tabX - lineWidth;
                        break;
                    }
                    case '\n': {
                        run.lineBreak = true;
                        break;
                    }
                    case '\r': {
                        run.lineBreak = true;
                        StyleItem next = this.allRuns[i + 1];
                        if (next.length == 0 || this.segmentsText.charAt(next.start) != '\n') break;
                        ++run.length;
                        next.free();
                        ++i;
                        break;
                    }
                }
            }
            if (this.wrapWidth != -1 && lineWidth + run.width > this.wrapWidth && !run.tab) {
                int start = 0;
                int[] piDx = new int[run.length];
                if (run.style != null && run.style.metrics != null) {
                    piDx[0] = run.width;
                } else {
                    OS.ScriptGetLogicalWidths(run.analysis, run.length, run.glyphCount, run.advances, run.clusters, run.visAttrs, piDx);
                }
                int width = 0;
                int maxWidth = this.wrapWidth - lineWidth;
                while (width + piDx[start] < maxWidth) {
                    width += piDx[start++];
                }
                int firstStart = start;
                int firstIndice = i;
                while (i >= lineStart) {
                    this.breakRun(run);
                    while (start >= 0) {
                        OS.MoveMemory(logAttr, run.psla + start * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                        if (logAttr.fSoftBreak || logAttr.fWhiteSpace) break;
                        --start;
                    }
                    if (start == 0 && i != lineStart && !run.tab && logAttr.fSoftBreak && !logAttr.fWhiteSpace) {
                        OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        short langID = properties.langid;
                        StyleItem pRun = this.allRuns[i - 1];
                        OS.MoveMemory(properties, this.device.scripts[pRun.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (properties.langid == langID || langID == 0 || properties.langid == 0) {
                            this.breakRun(pRun);
                            OS.MoveMemory(logAttr, pRun.psla + (pRun.length - 1) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                            if (!logAttr.fWhiteSpace) {
                                start = -1;
                            }
                        }
                    }
                    if (start >= 0 || i == lineStart) break;
                    run = this.allRuns[--i];
                    start = run.length - 1;
                }
                if (start == 0 && i != lineStart && !run.tab) {
                    run = this.allRuns[--i];
                } else if (start <= 0 && i == lineStart) {
                    i = firstIndice;
                    run = this.allRuns[i];
                    start = Math.max(1, firstStart);
                }
                this.breakRun(run);
                while (start < run.length) {
                    OS.MoveMemory(logAttr, run.psla + start * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                    if (!logAttr.fWhiteSpace) break;
                    ++start;
                }
                if (0 < start && start < run.length) {
                    StyleItem newRun = new StyleItem();
                    newRun.start = run.start + start;
                    newRun.length = run.length - start;
                    newRun.style = run.style;
                    newRun.analysis = run.analysis;
                    run.free();
                    run.length = start;
                    OS.SelectObject(srcHdc, this.getItemFont(run));
                    this.shape(srcHdc, run);
                    OS.SelectObject(srcHdc, this.getItemFont(newRun));
                    this.shape(srcHdc, newRun);
                    if (GC.JStyleSWTBridge.forceMonospace) {
                        this.forceMonospace(srcHdc, run);
                        this.forceMonospace(srcHdc, newRun);
                    }
                    StyleItem[] newAllRuns = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, newAllRuns, 0, i + 1);
                    System.arraycopy(this.allRuns, i + 1, newAllRuns, i + 2, this.allRuns.length - i - 1);
                    this.allRuns = newAllRuns;
                    this.allRuns[i + 1] = newRun;
                }
                if (i != this.allRuns.length - 2) {
                    run.lineBreak = true;
                    run.softBreak = true;
                }
            }
            lineWidth += run.width;
            if (!run.lineBreak) continue;
            lineStart = i + 1;
            lineWidth = run.softBreak ? 0 : this.indent;
            ++lineCount;
        }
        lineWidth = 0;
        this.runs = new StyleItem[lineCount][];
        this.lineOffset = new int[lineCount + 1];
        this.lineY = new int[lineCount + 1];
        this.lineWidth = new int[lineCount];
        int lineRunCount = 0;
        int line = 0;
        int ascent = Math.max(0, this.ascent);
        int descent = Math.max(0, this.descent);
        StyleItem[] lineRuns = new StyleItem[this.allRuns.length];
        for (int i = 0; i < this.allRuns.length; ++i) {
            int j;
            StyleItem run = this.allRuns[i];
            lineRuns[lineRunCount++] = run;
            lineWidth += run.width;
            ascent = Math.max(ascent, run.ascent);
            descent = Math.max(descent, run.descent);
            if (!run.lineBreak && i != this.allRuns.length - 1) continue;
            if (lineRunCount == 1 && i == this.allRuns.length - 1) {
                TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.SelectObject(srcHdc, this.getItemFont(run));
                OS.GetTextMetrics(srcHdc, lptm);
                run.ascent = lptm.tmAscent;
                run.descent = lptm.tmDescent;
                ascent = Math.max(ascent, run.ascent);
                descent = Math.max(descent, run.descent);
            }
            this.runs[line] = new StyleItem[lineRunCount];
            System.arraycopy(lineRuns, 0, this.runs[line], 0, lineRunCount);
            if (this.justify && this.wrapWidth != -1 && run.softBreak && lineWidth > 0) {
                if (line == 0) {
                    lineWidth += this.indent;
                } else {
                    StyleItem[] previousLine = this.runs[line - 1];
                    StyleItem previousRun = previousLine[previousLine.length - 1];
                    if (previousRun.lineBreak && !previousRun.softBreak) {
                        lineWidth += this.indent;
                    }
                }
                int hHeap = OS.GetProcessHeap();
                int newLineWidth = 0;
                for (j = 0; j < this.runs[line].length; ++j) {
                    StyleItem item = this.runs[line][j];
                    int iDx = item.width * this.wrapWidth / lineWidth;
                    if (iDx != item.width) {
                        item.justify = OS.HeapAlloc(hHeap, 8, item.glyphCount * 4);
                        if (item.justify == 0) {
                            SWT.error(2);
                        }
                        OS.ScriptJustify(item.visAttrs, item.advances, item.glyphCount, iDx - item.width, 2, item.justify);
                        item.width = iDx;
                    }
                    newLineWidth += item.width;
                }
                lineWidth = newLineWidth;
            }
            this.lineWidth[line] = lineWidth;
            StyleItem lastRun = this.runs[line][lineRunCount - 1];
            int lastOffset = lastRun.start + lastRun.length;
            this.runs[line] = this.reorder(this.runs[line], i == this.allRuns.length - 1);
            lastRun = this.runs[line][lineRunCount - 1];
            if (run.softBreak && run != lastRun) {
                run.lineBreak = false;
                run.softBreak = false;
                lastRun.lineBreak = true;
                lastRun.softBreak = true;
            }
            lineWidth = this.getLineIndent(line);
            for (j = 0; j < this.runs[line].length; ++j) {
                this.runs[line][j].x = lineWidth;
                lineWidth += this.runs[line][j].width;
            }
            this.lineY[++line] = this.lineY[line - 1] + ascent + descent + this.lineSpacing;
            this.lineOffset[line] = lastOffset;
            lineWidth = 0;
            lineRunCount = 0;
            ascent = Math.max(0, this.ascent);
            descent = Math.max(0, this.descent);
        }
        if (srcHdc != 0) {
            OS.DeleteDC(srcHdc);
        }
        if (gc == null) {
            this.device.internal_dispose_GC(hDC, null);
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.mLangFontLink2 != 0) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0;
        }
        OS.OleUninitialize();
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        boolean hasSelection;
        int length;
        this.checkLayout();
        this.computeRuns(gc);
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        GC.ControlCharRenderer ccRender = gc.getControlCharRenderer();
        ccRender.init(gc, this.device);
        if (ccRender.isDrawLineBreak() && this.runs.length > 0 && this.lineY.length > 1) {
            int drawX = x;
            StyleItem[] lineRuns = this.runs[0];
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.length == 0) continue;
                drawX += run.width;
            }
            int lineHeight = this.lineY[1] - this.lineY[0];
            ccRender.drawLineBreak(drawX, y, lineHeight);
        }
        if ((length = this.text.length()) == 0 && flags == 0) {
            return;
        }
        int hdc = gc.handle;
        Rectangle clip = gc.getClipping();
        GCData data = gc.data;
        int gdipGraphics = data.gdipGraphics;
        int foreground = data.foreground;
        int alpha = data.alpha;
        boolean gdip = gdipGraphics != 0 && (alpha != 255 || data.foregroundPattern != null);
        int clipRgn = 0;
        float[] lpXform = null;
        Rect gdipRect = new Rect();
        if (gdipGraphics != 0 && !gdip) {
            int matrix = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (matrix == 0) {
                SWT.error(2);
            }
            Gdip.Graphics_GetTransform(gdipGraphics, matrix);
            int identity = gc.identity();
            Gdip.Matrix_Invert(identity);
            Gdip.Matrix_Multiply(matrix, identity, 1);
            Gdip.Matrix_delete(identity);
            if (!Gdip.Matrix_IsIdentity(matrix)) {
                lpXform = new float[6];
                Gdip.Matrix_GetElements(matrix, lpXform);
            }
            Gdip.Matrix_delete(matrix);
            if ((data.style & 0x8000000) != 0 && lpXform != null) {
                gdip = true;
                lpXform = null;
            } else {
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
                int rgn = Gdip.Region_new();
                Gdip.Graphics_GetClip(gdipGraphics, rgn);
                if (!Gdip.Region_IsInfinite(rgn, gdipGraphics)) {
                    clipRgn = Gdip.Region_GetHRGN(rgn, gdipGraphics);
                }
                Gdip.Region_delete(rgn);
                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
                hdc = Gdip.Graphics_GetHDC(gdipGraphics);
            }
        }
        int foregroundBrush = 0;
        int state = 0;
        if (gdip) {
            gc.checkGC(1);
            foregroundBrush = gc.getFgBrush();
        } else {
            state = OS.SaveDC(hdc);
            if ((data.style & 0x8000000) != 0) {
                OS.SetLayout(hdc, OS.GetLayout(hdc) | 1);
            }
            if (lpXform != null) {
                OS.SetGraphicsMode(hdc, 2);
                OS.SetWorldTransform(hdc, lpXform);
            }
            if (clipRgn != 0) {
                OS.SelectClipRgn(hdc, clipRgn);
                OS.DeleteObject(clipRgn);
            }
        }
        boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        if (hasSelection || (flags & 0x100000) != 0) {
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
        }
        RECT rect = new RECT();
        int selBrush = 0;
        int selPen = 0;
        int selBrushFg = 0;
        if (hasSelection || (flags & 0x100000) != 0) {
            if (gdip) {
                int bg = selectionBackground.handle;
                int argb = (alpha & 0xFF) << 24 | bg >> 16 & 0xFF | bg & 0xFF00 | (bg & 0xFF) << 16;
                int color = Gdip.Color_new(argb);
                selBrush = Gdip.SolidBrush_new(color);
                Gdip.Color_delete(color);
                int fg = selectionForeground.handle;
                argb = (alpha & 0xFF) << 24 | fg >> 16 & 0xFF | fg & 0xFF00 | (fg & 0xFF) << 16;
                color = Gdip.Color_new(argb);
                selBrushFg = Gdip.SolidBrush_new(color);
                selPen = Gdip.Pen_new(selBrushFg, 1.0f);
                Gdip.Color_delete(color);
            } else {
                selBrush = OS.CreateSolidBrush(selectionBackground.handle);
                selPen = OS.CreatePen(0, 1, selectionForeground.handle);
            }
        }
        int offset = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        OS.SetBkMode(hdc, 1);
        block11: for (int line = 0; line < this.runs.length; ++line) {
            int drawX = x + this.getLineIndent(line);
            int drawY = y + this.lineY[line];
            StyleItem[] lineRuns = this.runs[line];
            int lineHeight = this.lineY[line + 1] - this.lineY[line];
            if (flags != 0 && (hasSelection || (flags & 0x100000) != 0)) {
                boolean extents = false;
                if (line == this.runs.length - 1 && (flags & 0x100000) != 0) {
                    extents = true;
                } else {
                    StyleItem run = lineRuns[lineRuns.length - 1];
                    if (run.lineBreak && !run.softBreak) {
                        if (selectionStart <= run.start && run.start <= selectionEnd) {
                            extents = true;
                        }
                    } else {
                        int endOffset = run.start + run.length - 1;
                        if (selectionStart <= endOffset && endOffset < selectionEnd && (flags & 0x10000) != 0) {
                            extents = true;
                        }
                    }
                }
                if (extents) {
                    int width = (flags & 0x10000) != 0 ? (OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF) : (lineHeight - this.lineSpacing) / 3;
                    if (gdip) {
                        Gdip.Graphics_FillRectangle(gdipGraphics, selBrush, drawX + this.lineWidth[line], drawY, width, lineHeight - this.lineSpacing);
                    } else {
                        OS.SelectObject(hdc, selBrush);
                        OS.PatBlt(hdc, drawX + this.lineWidth[line], drawY, width, lineHeight - this.lineSpacing, 15728673);
                    }
                }
            }
            if (drawX > clip.x + clip.width || drawX + this.lineWidth[line] < clip.x) continue;
            int baseline = Math.max(0, this.ascent);
            for (int i = 0; i < lineRuns.length; ++i) {
                baseline = Math.max(baseline, lineRuns[i].ascent);
            }
            int alignmentX = drawX;
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.length == 0) continue;
                if (drawX > clip.x + clip.width) break;
                if (drawX + run.width >= clip.x && (!run.lineBreak || run.softBreak)) {
                    boolean fullSelection;
                    int end = run.start + run.length - 1;
                    boolean bl2 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                    if (fullSelection) {
                        if (gdip) {
                            Gdip.Graphics_FillRectangle(gdipGraphics, selBrush, drawX, drawY, run.width, lineHeight - this.lineSpacing);
                        } else {
                            OS.SelectObject(hdc, selBrush);
                            OS.PatBlt(hdc, drawX, drawY, run.width, lineHeight - this.lineSpacing, 15728673);
                        }
                    } else {
                        boolean partialSelection;
                        if (run.style != null && run.style.background != null) {
                            int bg = run.style.background.handle;
                            int drawRunY = drawY + (baseline - run.ascent);
                            if (gdip) {
                                int argb = (alpha & 0xFF) << 24 | bg >> 16 & 0xFF | bg & 0xFF00 | (bg & 0xFF) << 16;
                                int color = Gdip.Color_new(argb);
                                int brush = Gdip.SolidBrush_new(color);
                                Gdip.Graphics_FillRectangle(gdipGraphics, brush, drawX, drawRunY, run.width, run.ascent + run.descent);
                                Gdip.Color_delete(color);
                                Gdip.SolidBrush_delete(brush);
                            } else {
                                int hBrush = OS.CreateSolidBrush(bg);
                                int oldBrush = OS.SelectObject(hdc, hBrush);
                                OS.PatBlt(hdc, drawX, drawRunY, run.width, run.ascent + run.descent, 15728673);
                                OS.SelectObject(hdc, oldBrush);
                                OS.DeleteObject(hBrush);
                            }
                        }
                        boolean bl3 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                        if (partialSelection) {
                            int selStart = Math.max(selectionStart, run.start) - run.start;
                            int selEnd = Math.min(selectionEnd, end) - run.start;
                            int cChars = run.length;
                            int gGlyphs = run.glyphCount;
                            int[] piX = new int[1];
                            int advances = run.justify != 0 ? run.justify : run.advances;
                            OS.ScriptCPtoX(selStart, false, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                            int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                            rect.left = drawX + runX;
                            rect.top = drawY;
                            OS.ScriptCPtoX(selEnd, true, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                            runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                            rect.right = drawX + runX;
                            rect.bottom = drawY + lineHeight - this.lineSpacing;
                            if (gdip) {
                                Gdip.Graphics_FillRectangle(gdipGraphics, selBrush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
                            } else {
                                OS.SelectObject(hdc, selBrush);
                                OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
                            }
                        }
                    }
                }
                drawX += run.width;
            }
            drawX = alignmentX;
            boolean endsWithLineBreak = false;
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.length == 0) continue;
                if (drawX > clip.x + clip.width) continue block11;
                if (drawX + run.width >= clip.x) {
                    boolean fullSelection;
                    int end = run.start + run.length - 1;
                    boolean bl4 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                    if (!(run.tab || run.lineBreak && !run.softBreak || run.style != null && run.style.metrics != null)) {
                        int spaceWidth;
                        int k;
                        int leftX;
                        char c;
                        boolean partialSelection = hasSelection && !fullSelection && selectionStart <= end && run.start <= selectionEnd;
                        this.checkItem(hdc, run);
                        OS.SelectObject(hdc, this.getItemFont(run));
                        int drawRunY = drawY + (baseline - run.ascent);
                        if (partialSelection) {
                            int selStart = Math.max(selectionStart, run.start) - run.start;
                            int selEnd = Math.min(selectionEnd, end) - run.start;
                            int cChars = run.length;
                            int gGlyphs = run.glyphCount;
                            int[] piX = new int[1];
                            int advances = run.justify != 0 ? run.justify : run.advances;
                            OS.ScriptCPtoX(selStart, false, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                            int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                            rect.left = drawX + runX;
                            rect.top = drawY;
                            OS.ScriptCPtoX(selEnd, true, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                            runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                            rect.right = drawX + runX;
                            rect.bottom = drawY + lineHeight;
                        }
                        if (gdip) {
                            OS.BeginPath(hdc);
                            OS.ScriptTextOut(hdc, run.psc, drawX, drawRunY, 0, null, run.analysis, 0, 0, run.glyphs, run.glyphCount, run.advances, run.justify, run.goffsets);
                            OS.EndPath(hdc);
                            int count = OS.GetPath(hdc, null, null, 0);
                            int[] points = new int[count * 2];
                            byte[] types = new byte[count];
                            OS.GetPath(hdc, points, types, count);
                            for (int typeIndex = 0; typeIndex < types.length; ++typeIndex) {
                                int newType = 0;
                                int type = types[typeIndex] & 0xFF;
                                switch (type & 0xFFFFFFFE) {
                                    case 6: {
                                        newType = 0;
                                        break;
                                    }
                                    case 2: {
                                        newType = 1;
                                        break;
                                    }
                                    case 4: {
                                        newType = 3;
                                    }
                                }
                                if ((type & 1) != 0) {
                                    newType |= 0x80;
                                }
                                types[typeIndex] = (byte)newType;
                            }
                            int path = Gdip.GraphicsPath_new(points, types, count, 0);
                            if (path == 0) {
                                SWT.error(2);
                            }
                            int brush = foregroundBrush;
                            if (fullSelection) {
                                brush = selBrushFg;
                            } else if (run.style != null && run.style.foreground != null) {
                                int fg = run.style.foreground.handle;
                                int argb = (alpha & 0xFF) << 24 | fg >> 16 & 0xFF | fg & 0xFF00 | (fg & 0xFF) << 16;
                                int color = Gdip.Color_new(argb);
                                brush = Gdip.SolidBrush_new(color);
                                Gdip.Color_delete(color);
                            }
                            int gstate = 0;
                            if (partialSelection) {
                                gdipRect.X = rect.left;
                                gdipRect.Y = rect.top;
                                gdipRect.Width = rect.right - rect.left;
                                gdipRect.Height = rect.bottom - rect.top;
                                gstate = Gdip.Graphics_Save(gdipGraphics);
                                Gdip.Graphics_SetClip(gdipGraphics, gdipRect, 4);
                            }
                            int antialias = Gdip.Graphics_GetSmoothingMode(gdipGraphics);
                            int textAntialias = 0;
                            int mode = Gdip.Graphics_GetTextRenderingHint(data.gdipGraphics);
                            switch (mode) {
                                case 0: {
                                    textAntialias = 4;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    textAntialias = 3;
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    textAntialias = 4;
                                }
                            }
                            Gdip.Graphics_SetSmoothingMode(gdipGraphics, textAntialias);
                            int gstate2 = 0;
                            if ((data.style & 0x8000000) != 0) {
                                gstate2 = Gdip.Graphics_Save(gdipGraphics);
                                Gdip.Graphics_ScaleTransform(gdipGraphics, -1.0f, 1.0f, 0);
                                Gdip.Graphics_TranslateTransform(gdipGraphics, -2 * drawX - run.width, 0.0f, 0);
                            }
                            Gdip.Graphics_FillPath(gdipGraphics, brush, path);
                            if ((data.style & 0x8000000) != 0) {
                                Gdip.Graphics_Restore(gdipGraphics, gstate2);
                            }
                            Gdip.Graphics_SetSmoothingMode(gdipGraphics, antialias);
                            if (run.style != null && (run.style.underline || run.style.strikeout)) {
                                int newPen = hasSelection ? selPen : Gdip.Pen_new(brush, 1.0f);
                                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
                                if (run.style.underline) {
                                    int underlineY = drawY + baseline + 1 - run.style.rise;
                                    Gdip.Graphics_DrawLine(gdipGraphics, newPen, drawX, underlineY, drawX + run.width, underlineY);
                                }
                                if (run.style.strikeout) {
                                    int strikeoutY = drawRunY + run.leading + (run.ascent - run.style.rise) / 2;
                                    Gdip.Graphics_DrawLine(gdipGraphics, newPen, drawX, strikeoutY, drawX + run.width, strikeoutY);
                                }
                                if (newPen != selPen) {
                                    Gdip.Pen_delete(newPen);
                                }
                                Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
                            }
                            if (partialSelection) {
                                Gdip.Graphics_Restore(gdipGraphics, gstate);
                                gstate = Gdip.Graphics_Save(gdipGraphics);
                                Gdip.Graphics_SetClip(gdipGraphics, gdipRect, 1);
                                Gdip.Graphics_SetSmoothingMode(gdipGraphics, textAntialias);
                                Gdip.Graphics_FillPath(gdipGraphics, selBrushFg, path);
                                Gdip.Graphics_SetSmoothingMode(gdipGraphics, antialias);
                                if (run.style != null && (run.style.underline || run.style.strikeout)) {
                                    Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 3);
                                    if (run.style.underline) {
                                        int underlineY = drawY + baseline + 1 - run.style.rise;
                                        Gdip.Graphics_DrawLine(gdipGraphics, selPen, rect.left, underlineY, rect.right, underlineY);
                                    }
                                    if (run.style.strikeout) {
                                        int strikeoutY = drawRunY + run.leading + (run.ascent - run.style.rise) / 2;
                                        Gdip.Graphics_DrawLine(gdipGraphics, selPen, rect.left, strikeoutY, rect.right, strikeoutY);
                                    }
                                    Gdip.Graphics_SetPixelOffsetMode(gdipGraphics, 4);
                                }
                                Gdip.Graphics_Restore(gdipGraphics, gstate);
                            }
                            Gdip.GraphicsPath_delete(path);
                            if (brush != selBrushFg && brush != foregroundBrush) {
                                Gdip.SolidBrush_delete(brush);
                            }
                        } else {
                            int fg = foreground;
                            if (fullSelection) {
                                fg = selectionForeground.handle;
                            } else if (run.style != null && run.style.foreground != null) {
                                fg = run.style.foreground.handle;
                            }
                            OS.SetTextColor(hdc, fg);
                            OS.ScriptTextOut(hdc, run.psc, drawX + offset, drawRunY, 0, null, run.analysis, 0, 0, run.glyphs, run.glyphCount, run.advances, run.justify, run.goffsets);
                            if (run.style != null && (run.style.underline || run.style.strikeout)) {
                                int newPen = hasSelection && fg == selectionForeground.handle ? selPen : OS.CreatePen(0, 1, fg);
                                int oldPen = OS.SelectObject(hdc, newPen);
                                if (run.style.underline) {
                                    int underlineY = drawY + baseline + 1 - run.style.rise;
                                    OS.MoveToEx(hdc, drawX, underlineY, 0);
                                    OS.LineTo(hdc, drawX + run.width, underlineY);
                                }
                                if (run.style.strikeout) {
                                    int strikeoutY = drawRunY + run.leading + (run.ascent - run.style.rise) / 2;
                                    OS.MoveToEx(hdc, drawX, strikeoutY, 0);
                                    OS.LineTo(hdc, drawX + run.width, strikeoutY);
                                }
                                OS.SelectObject(hdc, oldPen);
                                if (!hasSelection || fg != selectionForeground.handle) {
                                    OS.DeleteObject(newPen);
                                }
                            }
                            if (partialSelection && fg != selectionForeground.handle) {
                                OS.SetTextColor(hdc, selectionForeground.handle);
                                OS.ScriptTextOut(hdc, run.psc, drawX + offset, drawRunY, 4, rect, run.analysis, 0, 0, run.glyphs, run.glyphCount, run.advances, run.justify, run.goffsets);
                                if (run.style != null && (run.style.underline || run.style.strikeout)) {
                                    int oldPen = OS.SelectObject(hdc, selPen);
                                    if (run.style.underline) {
                                        int underlineY = drawY + baseline + 1 - run.style.rise;
                                        OS.MoveToEx(hdc, rect.left, underlineY, 0);
                                        OS.LineTo(hdc, rect.right, underlineY);
                                    }
                                    if (run.style.strikeout) {
                                        int strikeoutY = drawRunY + run.leading + (run.ascent - run.style.rise) / 2;
                                        OS.MoveToEx(hdc, rect.left, strikeoutY, 0);
                                        OS.LineTo(hdc, rect.right, strikeoutY);
                                    }
                                    OS.SelectObject(hdc, oldPen);
                                }
                            }
                        }
                        if (ccRender.isDrawFullWidthSpace()) {
                            String runText = this.segmentsText.substring(run.start, run.start + run.length);
                            int fullSpace = 12288;
                            if (runText.indexOf(12288) != -1) {
                                int[] charWidths = new int[run.length];
                                OS.ScriptGetLogicalWidths(run.analysis, run.length, run.glyphCount, run.advances, run.clusters, run.visAttrs, charWidths);
                                char[] chars = runText.toCharArray();
                                for (int j = 0; j < chars.length; ++j) {
                                    c = chars[j];
                                    if (c != '\u3000') continue;
                                    leftX = drawX;
                                    for (k = 0; k < j; ++k) {
                                        leftX += charWidths[k];
                                    }
                                    spaceWidth = charWidths[j];
                                    ccRender.drawFullWidthSpace(leftX, drawY, lineHeight, spaceWidth);
                                }
                            }
                        }
                        if (ccRender.isDrawHalfWidthSpace()) {
                            String runText = this.segmentsText.substring(run.start, run.start + run.length);
                            int halfSpace = 32;
                            if (runText.indexOf(32) != -1) {
                                int[] charWidths = new int[run.length];
                                OS.ScriptGetLogicalWidths(run.analysis, run.length, run.glyphCount, run.advances, run.clusters, run.visAttrs, charWidths);
                                char[] chars = runText.toCharArray();
                                for (int j = 0; j < chars.length; ++j) {
                                    c = chars[j];
                                    if (c != ' ') continue;
                                    leftX = drawX;
                                    for (k = 0; k < j; ++k) {
                                        leftX += charWidths[k];
                                    }
                                    spaceWidth = charWidths[j];
                                    ccRender.drawHalfWidthSpace(leftX, drawY, lineHeight, spaceWidth);
                                }
                            }
                        }
                    } else if (run.tab && ccRender.isDrawTab()) {
                        ccRender.drawTab(drawX, drawY, lineHeight);
                    }
                }
                endsWithLineBreak = run.lineBreak && !run.softBreak;
                drawX += run.width;
            }
        }
        if (gdip) {
            if (selBrush != 0) {
                Gdip.SolidBrush_delete(selBrush);
            }
            if (selBrushFg != 0) {
                Gdip.SolidBrush_delete(selBrushFg);
            }
            if (selPen != 0) {
                Gdip.Pen_delete(selPen);
            }
        } else {
            OS.RestoreDC(hdc, state);
            if (gdipGraphics != 0) {
                Gdip.Graphics_ReleaseHDC(gdipGraphics, hdc);
            }
            if (selBrush != 0) {
                OS.DeleteObject(selBrush);
            }
            if (selPen != 0) {
                OS.DeleteObject(selPen);
            }
        }
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        for (int i = 0; i < this.allRuns.length; ++i) {
            StyleItem run = this.allRuns[i];
            run.free();
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int width = 0;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        } else {
            for (int line = 0; line < this.runs.length; ++line) {
                width = Math.max(width, this.lineWidth[line] + this.getLineIndent(line));
            }
        }
        return new Rectangle(0, 0, width, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        int left = Integer.MAX_VALUE;
        int right = 0;
        int top = Integer.MAX_VALUE;
        int bottom = 0;
        boolean isRTL = (this.orientation & 0x4000000) != 0;
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            int lineIndex;
            int advances;
            int[] piX;
            GlyphMetrics metrics;
            int cx;
            StyleItem run = this.allRuns[i];
            int runEnd = run.start + run.length;
            if (runEnd <= start) continue;
            if (run.start > end) break;
            int runLead = run.x;
            int runTrail = run.x + run.width;
            if (run.start <= start && start < runEnd) {
                cx = 0;
                if (run.style != null && run.style.metrics != null) {
                    metrics = run.style.metrics;
                    cx = metrics.width * (start - run.start);
                } else if (!run.tab) {
                    piX = new int[1];
                    advances = run.justify != 0 ? run.justify : run.advances;
                    OS.ScriptCPtoX(start - run.start, false, run.length, run.glyphCount, run.clusters, run.visAttrs, advances, run.analysis, piX);
                    int n = cx = isRTL ? run.width - piX[0] : piX[0];
                }
                if (run.analysis.fRTL ^ isRTL) {
                    runTrail = run.x + cx;
                } else {
                    runLead = run.x + cx;
                }
            }
            if (run.start <= end && end < runEnd) {
                cx = run.width;
                if (run.style != null && run.style.metrics != null) {
                    metrics = run.style.metrics;
                    cx = metrics.width * (end - run.start + 1);
                } else if (!run.tab) {
                    piX = new int[1];
                    advances = run.justify != 0 ? run.justify : run.advances;
                    OS.ScriptCPtoX(end - run.start, true, run.length, run.glyphCount, run.clusters, run.visAttrs, advances, run.analysis, piX);
                    int n = cx = isRTL ? run.width - piX[0] : piX[0];
                }
                if (run.analysis.fRTL ^ isRTL) {
                    runLead = run.x + cx;
                } else {
                    runTrail = run.x + cx;
                }
            }
            for (lineIndex = 0; lineIndex < this.runs.length && this.lineOffset[lineIndex + 1] <= run.start; ++lineIndex) {
            }
            left = Math.min(left, runLead);
            right = Math.max(right, runTrail);
            top = Math.min(top, this.lineY[lineIndex]);
            bottom = Math.max(bottom, this.lineY[lineIndex + 1] - this.lineSpacing);
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    int getItemFont(StyleItem item) {
        if (item.fallbackFont != 0) {
            return item.fallbackFont;
        }
        if (item.style != null && item.style.font != null) {
            return item.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        for (int i = 1; i < this.allRuns.length; ++i) {
            if (this.allRuns[i].start <= offset) continue;
            return this.allRuns[i - 1].analysis.s.uBidiLevel;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > lineIndex || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int x = this.getLineIndent(lineIndex);
        int y = this.lineY[lineIndex];
        int width = this.lineWidth[lineIndex];
        int height = this.lineY[lineIndex + 1] - y - this.lineSpacing;
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int lineIndex) {
        int lineIndent = 0;
        if (lineIndex == 0) {
            lineIndent = this.indent;
        } else {
            StyleItem[] previousLine = this.runs[lineIndex - 1];
            StyleItem previousRun = previousLine[previousLine.length - 1];
            if (previousRun.lineBreak && !previousRun.softBreak) {
                lineIndent = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean partialLine = true;
            if (this.justify) {
                StyleItem[] lineRun = this.runs[lineIndex];
                if (lineRun[lineRun.length - 1].softBreak) {
                    partialLine = false;
                }
            }
            if (partialLine) {
                int lineWidth = this.lineWidth[lineIndex] + lineIndent;
                switch (this.alignment) {
                    case 0x1000000: {
                        lineIndent += (this.wrapWidth - lineWidth) / 2;
                        break;
                    }
                    case 131072: {
                        lineIndent += this.wrapWidth - lineWidth;
                    }
                }
            }
        }
        return lineIndent;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        for (int line = 0; line < this.runs.length; ++line) {
            if (this.lineOffset[line + 1] <= offset) continue;
            return line;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > lineIndex || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int hDC = this.device.internal_new_GC(null);
        int srcHdc = OS.CreateCompatibleDC(hDC);
        TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.SelectObject(srcHdc, this.font != null ? this.font.handle : this.device.systemFont);
        OS.GetTextMetrics(srcHdc, lptm);
        OS.DeleteDC(srcHdc);
        this.device.internal_dispose_GC(hDC, null);
        int ascent = Math.max(lptm.tmAscent, this.ascent);
        int descent = Math.max(lptm.tmDescent, this.descent);
        int leading = lptm.tmInternalLeading;
        if (this.text.length() != 0) {
            StyleItem[] lineRuns = this.runs[lineIndex];
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.ascent > ascent) {
                    ascent = run.ascent;
                    leading = run.leading;
                }
                descent = Math.max(descent, run.descent);
            }
        }
        lptm.tmAscent = ascent;
        lptm.tmDescent = descent;
        lptm.tmHeight = ascent + descent;
        lptm.tmInternalLeading = leading;
        lptm.tmAveCharWidth = 0;
        return FontMetrics.win32_new(lptm);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] offsets = new int[this.lineOffset.length];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = this.untranslateOffset(this.lineOffset[i]);
        }
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        int line;
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        for (line = 0; line < this.runs.length && this.lineOffset[line + 1] <= offset; ++line) {
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        Point result = null;
        if (offset == length) {
            result = new Point(this.lineWidth[line], this.lineY[line]);
        } else {
            int width = 0;
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                int end = run.start + run.length;
                if (run.start <= offset && offset < end) {
                    if (run.style != null && run.style.metrics != null) {
                        GlyphMetrics metrics = run.style.metrics;
                        result = new Point(width += metrics.width * (offset - run.start + (trailing ? 1 : 0)), this.lineY[line]);
                        break;
                    }
                    if (run.tab) {
                        if (trailing || offset == length) {
                            width += run.width;
                        }
                        result = new Point(width, this.lineY[line]);
                        break;
                    }
                    int runOffset = offset - run.start;
                    int cChars = run.length;
                    int gGlyphs = run.glyphCount;
                    int[] piX = new int[1];
                    int advances = run.justify != 0 ? run.justify : run.advances;
                    OS.ScriptCPtoX(runOffset, trailing, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                    if ((this.orientation & 0x4000000) != 0) {
                        result = new Point(width + (run.width - piX[0]), this.lineY[line]);
                        break;
                    }
                    result = new Point(width + piX[0], this.lineY[line]);
                    break;
                }
                width += run.width;
            }
        }
        if (result == null) {
            result = new Point(0, 0);
        }
        result.x += this.getLineIndent(line);
        return result;
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int i = forward ? 0 : this.allRuns.length - 1;
        offset = this.validadeOffset(offset, step);
        do {
            boolean isComplex;
            StyleItem run = this.allRuns[i];
            if (run.start > offset || offset >= run.start + run.length) continue;
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (run.tab) {
                return this.untranslateOffset(run.start);
            }
            OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl = isComplex = properties.fNeedsCaretInfo || properties.fNeedsWordBreaking;
            if (isComplex) {
                this.breakRun(run);
            }
            while (run.start <= offset && offset < run.start + run.length) {
                if (isComplex) {
                    OS.MoveMemory(logAttr, run.psla + (offset - run.start) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                }
                switch (movement) {
                    case 2: {
                        if (properties.fNeedsCaretInfo) {
                            if (logAttr.fInvalid || !logAttr.fCharStop) break;
                            return this.untranslateOffset(offset);
                        }
                        return this.untranslateOffset(offset);
                    }
                    case 4: 
                    case 16: {
                        boolean previousLetterOrDigit;
                        boolean letterOrDigit;
                        if (!(properties.fNeedsWordBreaking ? !logAttr.fInvalid && logAttr.fWordStop : offset > 0 && ((letterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset))) != (previousLetterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset - 1))) || !letterOrDigit) && !Compatibility.isWhitespace(this.segmentsText.charAt(offset)))) break;
                        return this.untranslateOffset(offset);
                    }
                    case 8: {
                        if (offset <= 0) break;
                        boolean isLetterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset));
                        boolean previousLetterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset - 1));
                        if (isLetterOrDigit || !previousLetterOrDigit) break;
                        return this.untranslateOffset(offset);
                    }
                }
                offset = this.validadeOffset(offset, step);
            }
        } while (0 <= (i += step) && i < this.allRuns.length - 1 && 0 <= offset && offset < length);
        return forward ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        int line;
        this.checkLayout();
        this.computeRuns(null);
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        int lineCount = this.runs.length;
        for (line = 0; line < lineCount && this.lineY[line + 1] <= y; ++line) {
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        if ((x -= this.getLineIndent(line)) >= this.lineWidth[line]) {
            x = this.lineWidth[line] - 1;
        }
        if (x < 0) {
            x = 0;
        }
        int width = 0;
        for (int i = 0; i < lineRuns.length; ++i) {
            StyleItem run = lineRuns[i];
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (width + run.width > x) {
                int xRun = x - width;
                if (run.style != null && run.style.metrics != null) {
                    GlyphMetrics metrics = run.style.metrics;
                    if (metrics.width > 0) {
                        if (trailing != null) {
                            trailing[0] = xRun % metrics.width < metrics.width / 2 ? 0 : 1;
                        }
                        return this.untranslateOffset(run.start + xRun / metrics.width);
                    }
                }
                if (run.tab) {
                    if (trailing != null) {
                        trailing[0] = x < width + run.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(run.start);
                }
                int cChars = run.length;
                int cGlyphs = run.glyphCount;
                int[] piCP = new int[1];
                int[] piTrailing = new int[1];
                if ((this.orientation & 0x4000000) != 0) {
                    xRun = run.width - xRun;
                }
                int advances = run.justify != 0 ? run.justify : run.advances;
                OS.ScriptXtoCP(xRun, cChars, cGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piCP, piTrailing);
                if (trailing != null) {
                    trailing[0] = piTrailing[0];
                }
                return this.untranslateOffset(run.start + piCP[0]);
            }
            width += run.width;
        }
        if (trailing != null) {
            trailing[0] = 0;
        }
        return this.untranslateOffset(this.lineOffset[line + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.styles.length * 2];
        int count = 0;
        for (int i = 0; i < this.styles.length - 1; ++i) {
            if (this.styles[i].style == null) continue;
            result[count++] = this.styles[i].start;
            result[count++] = this.styles[i + 1].start - 1;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        int separator;
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return this.text;
        }
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return this.text;
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int n = separator = this.orientation == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        if (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, Math.min(charCount + segmentCount, newChars.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (0 > offset || offset >= length) {
            SWT.error(6);
        }
        for (int i = 1; i < this.styles.length; ++i) {
            if (this.styles[i].start <= offset) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.styles.length];
        int count = 0;
        for (int i = 0; i < this.styles.length; ++i) {
            if (this.styles[i].style == null) continue;
            result[count++] = this.styles[i].style;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        int hHeap;
        int pItems;
        this.segmentsText = this.getSegmentsText();
        int length = this.segmentsText.length();
        SCRIPT_CONTROL scriptControl = new SCRIPT_CONTROL();
        SCRIPT_STATE scriptState = new SCRIPT_STATE();
        int MAX_ITEM = length + 1;
        if ((this.orientation & 0x4000000) != 0) {
            scriptState.uBidiLevel = 1;
            scriptState.fArabicNumContext = true;
            SCRIPT_DIGITSUBSTITUTE psds = new SCRIPT_DIGITSUBSTITUTE();
            OS.ScriptRecordDigitSubstitution(1024, psds);
            OS.ScriptApplyDigitSubstitution(psds, scriptControl, scriptState);
        }
        if ((pItems = OS.HeapAlloc(hHeap = OS.GetProcessHeap(), 8, MAX_ITEM * SCRIPT_ITEM.sizeof)) == 0) {
            SWT.error(2);
        }
        int[] pcItems = new int[1];
        char[] chars = new char[length];
        this.segmentsText.getChars(0, length, chars, 0);
        OS.ScriptItemize(chars, length, MAX_ITEM, scriptControl, scriptState, pItems, pcItems);
        StyleItem[] runs = this.merge(pItems, pcItems[0]);
        OS.HeapFree(hHeap, 0, pItems);
        return runs;
    }

    StyleItem[] merge(int items, int itemCount) {
        StyleItem item;
        int count = 0;
        int start = 0;
        int end = this.segmentsText.length();
        int itemIndex = 0;
        int styleIndex = 0;
        StyleItem[] runs = new StyleItem[itemCount + this.styles.length];
        SCRIPT_ITEM scriptItem = new SCRIPT_ITEM();
        boolean linkBefore = false;
        while (start < end) {
            item = new StyleItem();
            item.start = start;
            item.style = this.styles[styleIndex].style;
            runs[count++] = item;
            OS.MoveMemory(scriptItem, items + itemIndex * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
            item.analysis = scriptItem.a;
            if (linkBefore) {
                item.analysis.fLinkBefore = true;
                linkBefore = false;
            }
            scriptItem.a = new SCRIPT_ANALYSIS();
            OS.MoveMemory(scriptItem, items + (itemIndex + 1) * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
            int itemLimit = scriptItem.iCharPos;
            int styleLimit = this.translateOffset(this.styles[styleIndex + 1].start);
            if (styleLimit <= itemLimit) {
                ++styleIndex;
                start = styleLimit;
                if (start < itemLimit && 0 < start && start < end) {
                    char pChar = this.segmentsText.charAt(start - 1);
                    char tChar = this.segmentsText.charAt(start);
                    if (!Compatibility.isWhitespace(pChar) && !Compatibility.isWhitespace(tChar)) {
                        item.analysis.fLinkAfter = true;
                        linkBefore = true;
                    }
                }
            }
            if (itemLimit <= styleLimit) {
                ++itemIndex;
                start = itemLimit;
            }
            item.length = start - item.start;
        }
        item = new StyleItem();
        item.start = end;
        OS.MoveMemory(scriptItem, items + itemCount * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
        item.analysis = scriptItem.a;
        runs[count++] = item;
        if (runs.length != count) {
            StyleItem[] result = new StyleItem[count];
            System.arraycopy(runs, 0, result, 0, count);
            return result;
        }
        return runs;
    }

    StyleItem[] reorder(StyleItem[] runs, boolean terminate) {
        int i;
        int length = runs.length;
        if (length <= 1) {
            return runs;
        }
        byte[] bidiLevels = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bidiLevels[i2] = (byte)(runs[i2].analysis.s.uBidiLevel & 0x1F);
        }
        StyleItem lastRun = runs[length - 1];
        if (lastRun.lineBreak && !lastRun.softBreak) {
            bidiLevels[length - 1] = 0;
        }
        int[] log2vis = new int[length];
        OS.ScriptLayout(length, bidiLevels, null, log2vis);
        StyleItem[] result = new StyleItem[length];
        for (i = 0; i < length; ++i) {
            result[log2vis[i]] = runs[i];
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (terminate) {
                --length;
            }
            for (i = 0; i < length / 2; ++i) {
                StyleItem tmp = result[i];
                result[i] = result[length - i - 1];
                result[length - i - 1] = tmp;
            }
        }
        return result;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        this.freeRuns();
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.freeRuns();
        this.indent = indent;
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (this.justify == justify) {
            return;
        }
        this.freeRuns();
        this.justify = justify;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.freeRuns();
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i;
            for (i = 0; i < segments.length && this.segments[i] == segments[i]; ++i) {
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = spacing;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int modifyStart;
        int modifyEnd;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (0 <= high && high < this.styles.length) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        for (modifyEnd = modifyStart = high; modifyEnd < this.styles.length && this.styles[modifyEnd + 1].start <= end; ++modifyEnd) {
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                newStyles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                newStyles[modifyStart + 2] = item;
                System.arraycopy(this.styles, modifyEnd + 1, newStyles, modifyEnd + 3, this.styles.length - modifyEnd - 1);
                this.styles = newStyles;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        int newLength = this.styles.length + 1 - (modifyEnd - modifyStart - 1);
        StyleItem[] newStyles = new StyleItem[newLength];
        System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        newStyles[modifyStart + 1] = item;
        this.styles[modifyEnd].start = end + 1;
        System.arraycopy(this.styles, modifyEnd, newStyles, modifyStart + 2, this.styles.length - modifyEnd);
        this.styles = newStyles;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i;
            for (i = 0; i < tabs.length && this.tabs[i] == tabs[i]; ++i) {
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    boolean shape(int hdc, StyleItem run, char[] chars, int[] glyphCount, int maxGlyphs) {
        int hr = OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, glyphCount);
        run.glyphCount = glyphCount[0];
        if (hr != -2147220992) {
            int i;
            SCRIPT_FONTPROPERTIES fp = new SCRIPT_FONTPROPERTIES();
            fp.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(hdc, run.psc, fp);
            short[] glyphs = new short[glyphCount[0]];
            OS.MoveMemory(glyphs, run.glyphs, glyphs.length * 2);
            for (i = 0; i < glyphs.length && glyphs[i] != fp.wgDefault; ++i) {
            }
            if (i == glyphs.length) {
                return true;
            }
        }
        if (run.psc != 0) {
            OS.ScriptFreeCache(run.psc);
            glyphCount[0] = 0;
            OS.MoveMemory(run.psc, glyphCount, 4);
        }
        run.glyphCount = 0;
        return false;
    }

    void shape(int hdc, StyleItem run) {
        int[] buffer = new int[1];
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        int maxGlyphs = chars.length * 3 / 2 + 16;
        int hHeap = OS.GetProcessHeap();
        run.glyphs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run.glyphs == 0) {
            SWT.error(2);
        }
        run.clusters = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run.clusters == 0) {
            SWT.error(2);
        }
        run.visAttrs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run.visAttrs == 0) {
            SWT.error(2);
        }
        run.psc = OS.HeapAlloc(hHeap, 8, 4);
        if (run.psc == 0) {
            SWT.error(2);
        }
        if (!this.shape(hdc, run, chars, buffer, maxGlyphs) && this.mLangFontLink2 != 0) {
            int[] dwCodePages = new int[1];
            int[] cchCodePages = new int[1];
            OS.VtblCall(4, this.mLangFontLink2, chars, chars.length, 0, dwCodePages, cchCodePages);
            int[] hNewFont = new int[1];
            if (OS.VtblCall(10, this.mLangFontLink2, hdc, dwCodePages[0], (int)chars[0], hNewFont) == 0) {
                int hFont = OS.SelectObject(hdc, hNewFont[0]);
                if (this.shape(hdc, run, chars, buffer, maxGlyphs)) {
                    run.fallbackFont = hNewFont[0];
                } else {
                    OS.VtblCall(8, this.mLangFontLink2, hNewFont[0]);
                    OS.SelectObject(hdc, hFont);
                    SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
                    OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                    if (properties.fPrivateUseArea) {
                        run.analysis.fNoGlyphIndex = true;
                    }
                    OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, buffer);
                    run.glyphCount = buffer[0];
                }
            }
        }
        int[] abc = new int[3];
        run.advances = OS.HeapAlloc(hHeap, 8, run.glyphCount * 4);
        if (run.advances == 0) {
            SWT.error(2);
        }
        run.goffsets = OS.HeapAlloc(hHeap, 8, run.glyphCount * 8);
        if (run.goffsets == 0) {
            SWT.error(2);
        }
        OS.ScriptPlace(hdc, run.psc, run.glyphs, run.glyphCount, run.visAttrs, run.analysis, run.advances, run.goffsets, abc);
        if (run.style != null && run.style.metrics != null) {
            GlyphMetrics metrics = run.style.metrics;
            run.width = metrics.width * Math.max(1, run.glyphCount);
            run.ascent = metrics.ascent;
            run.descent = metrics.descent;
            run.leading = 0;
        } else {
            run.width = abc[0] + abc[1] + abc[2];
            TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(hdc, lptm);
            run.ascent = lptm.tmAscent;
            run.descent = lptm.tmDescent;
            run.leading = lptm.tmInternalLeading;
        }
        if (run.style != null) {
            run.ascent += run.style.rise;
            run.descent -= run.style.rise;
        }
    }

    int validadeOffset(int offset, int step) {
        offset += step;
        if (this.segments != null && this.segments.length > 2) {
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.translateOffset(this.segments[i]) - 1 != offset) continue;
                offset += step;
                break;
            }
        }
        return offset;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        for (int i = 0; i < nSegments && offset - i >= this.segments[i]; ++i) {
            ++offset;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        for (int i = 0; i < nSegments && offset > this.segments[i]; --offset, ++i) {
        }
        return offset;
    }

    void forceMonospace(int srcHdc, StyleItem run) {
        if (this.font == null) {
            return;
        }
        if (run.style == null) {
            return;
        }
        StyleItem dummyRun = new StyleItem();
        dummyRun.style = new TextStyle(this.font, run.style.foreground, run.style.background);
        dummyRun.analysis = run.analysis;
        dummyRun.start = run.start;
        dummyRun.length = run.length;
        OS.SelectObject(srcHdc, this.font.handle);
        this.shape(srcHdc, dummyRun);
        int temp = run.advances;
        run.advances = dummyRun.advances;
        dummyRun.advances = temp;
        temp = run.goffsets;
        run.goffsets = dummyRun.goffsets;
        dummyRun.goffsets = temp;
        run.width = dummyRun.width;
        dummyRun.free();
    }

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        int psc = 0;
        int glyphs;
        int glyphCount;
        int clusters;
        int visAttrs;
        int advances;
        int goffsets;
        int width;
        int ascent;
        int descent;
        int leading;
        int x;
        int justify;
        int psla;
        int fallbackFont;

        StyleItem() {
        }

        void free() {
            int hHeap = OS.GetProcessHeap();
            if (this.psc != 0) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(hHeap, 0, this.psc);
                this.psc = 0;
            }
            if (this.glyphs != 0) {
                OS.HeapFree(hHeap, 0, this.glyphs);
                this.glyphs = 0;
                this.glyphCount = 0;
            }
            if (this.clusters != 0) {
                OS.HeapFree(hHeap, 0, this.clusters);
                this.clusters = 0;
            }
            if (this.visAttrs != 0) {
                OS.HeapFree(hHeap, 0, this.visAttrs);
                this.visAttrs = 0;
            }
            if (this.advances != 0) {
                OS.HeapFree(hHeap, 0, this.advances);
                this.advances = 0;
            }
            if (this.goffsets != 0) {
                OS.HeapFree(hHeap, 0, this.goffsets);
                this.goffsets = 0;
            }
            if (this.justify != 0) {
                OS.HeapFree(hHeap, 0, this.justify);
                this.justify = 0;
            }
            if (this.psla != 0) {
                OS.HeapFree(hHeap, 0, this.psla);
                this.psla = 0;
            }
            if (this.fallbackFont != 0) {
                if (TextLayout.this.mLangFontLink2 != 0) {
                    OS.VtblCall(8, TextLayout.this.mLangFontLink2, this.fallbackFont);
                }
                this.fallbackFont = 0;
            }
            this.x = 0;
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

