/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.compass;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.metasearch.compass.entity.SearchableHit;
import jp.sourceforge.metasearch.ws.Hit;
import jp.sourceforge.metasearch.ws.Result;
import jp.sourceforge.webframe.util.Paginator;

/**
 * SearchResult
 *
 * @author Yomei Komiya
 *
 * @since 0.9.2
 * @version $Id: SearchResult.java 24 2009-05-06 04:25:57Z whitestar $
 */
public class SearchResult {

	/**
	 * Search Provider
	 */
	private String provider = "";

	/**
	 * Search Provider URL
	 */
	private String providerUrl = "";

	/**
	 * Query String
	 */
	private String query = "";

	/**
	 * Current Query for Search Refinement
	 */
	private String currentQuery = "";

	/**
	 * Total Hit Numbers
	 */
	private int totalNum = 0;

	/**
	 * Display Number per Page
	 */
	private int num = 10;

	/**
	 * Display Start Position
	 */
	private int start = 0;

	/**
	 * Search Time (millisecond)
	 */
	private long searchTime = 0;

	/**
	 * Document List
	 */
	private List list = null;


	public SearchResult() {
		super();
	}


	/**
	 * Constructor for Web Service's Result Type
	 *
	 * @param result Web Service's Result Type
	 */
	public SearchResult(Result result) {
		if (result != null) {

			this.provider = result.getProvider();
			this.providerUrl = result.getProviderUrl();
			this.query = result.getQuery();
			this.currentQuery = result.getCurrentQuery();
			this.totalNum = result.getTotalNum();
			this.num = result.getNum();
			this.start = result.getStart();
			this.searchTime = result.getSearchTime();

			List list = new ArrayList();
			Hit[] hits = result.getHits();
			if (hits != null) {
				for (int i = 0; i < hits.length; i++) {
					list.add(new SearchableHit(hits[i]));
				}
			}
			this.setList(list);
		}
	}


	public Paginator createPaginator() {
		Paginator paginator = new Paginator();

		paginator.setRecordOffset(this.getStart(), this.getNum());
		paginator.setRecordTotal(this.getTotalNum());

		return paginator;
	}


	public final String getProvider() {
		return provider;
	}


	public final void setProvider(String provider) {
		this.provider = provider;
	}


	public final String getProviderUrl() {
		return providerUrl;
	}


	public final void setProviderUrl(String providerUrl) {
		this.providerUrl = providerUrl;
	}


	public final String getQuery() {
		return query;
	}


	public final String getCurrentQuery() {
		return currentQuery;
	}


	public final void setCurrentQuery(String currentQuery) {
		this.currentQuery = currentQuery;
	}


	public final void setQuery(String query) {
		this.query = query;
	}


	public final int getNum() {
		return num;
	}


	public final void setNum(int num) {
		this.num = num;
	}


	public final List getList() {
		return list;
	}


	public final void setList(List list) {
		this.list = list;
	}


	public final int getStart() {
		return start;
	}


	public final void setStart(int start) {
		this.start = start;
	}


	public final int getTotalNum() {
		return totalNum;
	}


	public final void setTotalNum(int totalNum) {
		this.totalNum = totalNum;
	}


	public final long getSearchTime() {
		return searchTime;
	}


	public final void setSearchTime(long searchTime) {
		this.searchTime = searchTime;
	}

}
