/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.compass.gps;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.sourceforge.metasearch.compass.CompassContext;
import jp.sourceforge.metasearch.compass.IndexFailedException;

/* for Compass 0.9.x */ 
import org.compass.gps.CompassGps;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.impl.SingleCompassGps;
/* for Compass 0.8.x 
import org.compassframework.gps.CompassGps;
import org.compassframework.gps.CompassGpsDevice;
import org.compassframework.gps.impl.SingleCompassGps;
*/

/**
 * CompassGpsBean
 * Compass GPS Utility
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id: CompassGpsBean.java 5 2007-06-28 13:28:30Z whitestar $
 */
public class CompassGpsBean {

	/**
	 * Index last update date
	 */
	static private Date indexLastUpdate = null;
	
	/**
	 * Context Object for Compass
	 */
	private CompassContext context = null;
	
	/**
	 * Compass GPS Device List
	 * injected by Spring
	 */
	private List gpsDevices = new ArrayList();
	
	
	public static Date getIndexLastUpdate() {
		return indexLastUpdate;
	}


	public void setContext(CompassContext context) {
		this.context = context;
	}

	
	public void setGpsDevices(List gpsDevices) {
		this.gpsDevices = gpsDevices;
	}


	/**
	 * Make Index
	 * 
	 * @throws IndexFailedException 
	 */
	public void index() throws IndexFailedException {
		CompassGps gps = null;

		try {
			gps = new SingleCompassGps(this.context.getCompass());
			for (Iterator ite = this.gpsDevices.iterator(); ite.hasNext(); ) {
				CompassGpsDevice gpsDevice = (CompassGpsDevice)ite.next();
				gps.addGpsDevice(gpsDevice);
			}

			gps.start();
			gps.index();
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new IndexFailedException(e);
		}
		finally {
			if (gps != null) {
				gps.stop();
			}
		}
		
		indexLastUpdate = new Date();
	}
	
}
