/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006,2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.metasearch.scheduling;

import jp.sourceforge.metasearch.compass.IndexFailedException;
import jp.sourceforge.metasearch.compass.gps.CompassGpsBean;

import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

/**
 * IndexJob
 * Scheduling Index Job
 *
 * @author Yomei Komiya
 *
 * $Id: IndexJob.java 5 2007-06-28 13:28:30Z whitestar $
 */
public class IndexJob extends QuartzJobBean {

	/**
	 * log4j logger
	 */
	static Logger logger = Logger.getLogger(IndexJob.class);

	
	/**
	 * CompassGpsBean object is injected by Spring
	 * ref. WEB-INF/spring/schedulingContext.xml
	 */
	private CompassGpsBean compassGps = null;


	public void setCompassGps(CompassGpsBean compassGps) {
		this.compassGps = compassGps;
	}

	
	protected void executeInternal(JobExecutionContext context)
			throws JobExecutionException {
		
		try {
			StopWatch stopwatch = new StopWatch();
			stopwatch.reset();
			
			stopwatch.start();
			this.compassGps.index();
			stopwatch.stop();
			
			logger.info("Scheduled index job finished. Total index time: ["
					+ stopwatch.getTime() + " ms]");
		}
		catch (IndexFailedException ife) {
			logger.error(ife);
			ife.printStackTrace();
		}
		finally {
		}
	}

}
